/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.draw.font;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.stb.STBTTVertex;
import org.lwjgl.stb.STBTruetype;
import org.lwjgl.system.MemoryStack;
import org.openrndr.draw.font.FaceStbTt;
import org.openrndr.draw.font.Glyph;
import org.openrndr.shape.ContourBuilder;
import org.openrndr.shape.IntRectangle;
import org.openrndr.shape.IntRectangleKt;
import org.openrndr.shape.Rectangle;
import org.openrndr.shape.RectangleKt;
import org.openrndr.shape.Shape;
import org.openrndr.shape.ShapeBuilderKt;
import org.openrndr.shape.ShapeContour;
import org.openrndr.shape.Winding;
import org.openrndr.utils.buffer.MPPBuffer;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000f\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J(\u0010\u0017\u001a\u00020\u00182\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u0016H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/openrndr/draw/font/GlyphStbTt;", "Lorg/openrndr/draw/font/Glyph;", "face", "Lorg/openrndr/draw/font/FaceStbTt;", "character", "", "glyphIndex", "", "<init>", "(Lorg/openrndr/draw/font/FaceStbTt;CI)V", "shape", "Lorg/openrndr/shape/Shape;", "size", "", "advanceWidth", "leftSideBearing", "topSideBearing", "bounds", "Lorg/openrndr/shape/Rectangle;", "bitmapBounds", "Lorg/openrndr/shape/IntRectangle;", "subpixel", "", "rasterize", "", "bitmap", "Lorg/openrndr/utils/buffer/MPPBuffer;", "stride", "openrndr-gl3"})
@SourceDebugExtension(value={"SMAP\nFontDriverStbTt.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FontDriverStbTt.kt\norg/openrndr/draw/font/GlyphStbTt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,251:1\n1557#2:252\n1628#2,3:253\n1557#2:256\n1628#2,3:257\n*S KotlinDebug\n*F\n+ 1 FontDriverStbTt.kt\norg/openrndr/draw/font/GlyphStbTt\n*L\n126#1:252\n126#1:253,3\n128#1:256\n128#1:257,3\n*E\n"})
public final class GlyphStbTt
implements Glyph {
    @NotNull
    private final FaceStbTt face;
    private final char character;
    private final int glyphIndex;

    public GlyphStbTt(@NotNull FaceStbTt face, char character, int glyphIndex) {
        Intrinsics.checkNotNullParameter(face, "face");
        this.face = face;
        this.character = character;
        this.glyphIndex = glyphIndex;
    }

    @Override
    @NotNull
    public Shape shape(double size) {
        Shape shape;
        STBTTVertex.Buffer buffer = STBTruetype.stbtt_GetCodepointShape(this.face.getFontInfo(), this.character);
        if (buffer == null) {
            return Shape.Companion.getEMPTY();
        }
        STBTTVertex.Buffer shapeBuffer = buffer;
        double scale = this.face.scaleForSize$openrndr_gl3(size);
        List<ShapeContour> shapeContours = ShapeBuilderKt.contours(arg_0 -> GlyphStbTt.shape$lambda$1(shapeBuffer, scale, arg_0));
        if (!((Collection)shapeContours).isEmpty()) {
            List list;
            if (CollectionsKt.first(shapeContours).getWinding() == Winding.COUNTER_CLOCKWISE) {
                $this$map$iv = shapeContours;
                $i$f$map = false;
                Iterable iterable = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    ShapeContour shapeContour = (ShapeContour)item$iv$iv;
                    var16_14 = destination$iv$iv;
                    boolean bl = false;
                    var16_14.add(it.getReversed().close());
                }
                list = (List)destination$iv$iv;
            } else {
                $this$map$iv = shapeContours;
                $i$f$map = false;
                $this$mapTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    it = (ShapeContour)item$iv$iv;
                    var16_14 = destination$iv$iv;
                    boolean bl = false;
                    var16_14.add(it.close());
                }
                list = (List)destination$iv$iv;
            }
            List list2 = list;
            shape = new Shape(list2);
        } else {
            shape = Shape.Companion.getEMPTY();
        }
        return shape;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double advanceWidth(double size) {
        AutoCloseable autoCloseable = MemoryStack.stackPush();
        Throwable throwable = null;
        try {
            MemoryStack stack = (MemoryStack)autoCloseable;
            boolean bl = false;
            IntBuffer pAdvanceWidth = stack.mallocInt(1);
            STBTruetype.stbtt_GetGlyphHMetrics(this.face.getFontInfo(), this.glyphIndex, pAdvanceWidth, null);
            double d = (double)pAdvanceWidth.get(0) * this.face.scaleForSize$openrndr_gl3(size);
            return d;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally(autoCloseable, throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double leftSideBearing(double size) {
        AutoCloseable autoCloseable = MemoryStack.stackPush();
        Throwable throwable = null;
        try {
            MemoryStack stack = (MemoryStack)autoCloseable;
            boolean bl = false;
            IntBuffer pLeftSideBearing = stack.mallocInt(1);
            STBTruetype.stbtt_GetGlyphHMetrics(this.face.getFontInfo(), this.glyphIndex, null, pLeftSideBearing);
            double d = (double)pLeftSideBearing.get(0) * this.face.scaleForSize$openrndr_gl3(size);
            return d;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally(autoCloseable, throwable);
        }
    }

    @Override
    public double topSideBearing(double size) {
        return 0.0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Rectangle bounds(double size) {
        double scale = this.face.scaleForSize$openrndr_gl3(size);
        AutoCloseable autoCloseable = MemoryStack.stackPush();
        Throwable throwable = null;
        try {
            MemoryStack stack = (MemoryStack)autoCloseable;
            boolean bl = false;
            IntBuffer px0 = stack.mallocInt(1);
            IntBuffer px1 = stack.mallocInt(1);
            IntBuffer py0 = stack.mallocInt(1);
            IntBuffer py1 = stack.mallocInt(1);
            STBTruetype.stbtt_GetGlyphBox(this.face.getFontInfo(), this.glyphIndex, px0, py0, px1, py1);
            double x0 = (double)px0.get() * scale;
            double y0 = (double)py0.get() * scale;
            double x1 = (double)px1.get() * scale;
            double y1 = (double)py1.get() * scale;
            Rectangle rectangle = RectangleKt.Rectangle(x0, -y0, x1 - x0, -(y1 - y0)).normalized();
            return rectangle;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally(autoCloseable, throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public IntRectangle bitmapBounds(double size, boolean subpixel) {
        float scale = (float)this.face.scaleForSize$openrndr_gl3(size);
        AutoCloseable autoCloseable = MemoryStack.stackPush();
        Throwable throwable = null;
        try {
            MemoryStack stack = (MemoryStack)autoCloseable;
            boolean bl = false;
            IntBuffer px0 = stack.mallocInt(1);
            IntBuffer px1 = stack.mallocInt(1);
            IntBuffer py0 = stack.mallocInt(1);
            IntBuffer py1 = stack.mallocInt(1);
            if (subpixel) {
                STBTruetype.stbtt_GetGlyphBitmapBoxSubpixel(this.face.getFontInfo(), this.glyphIndex, scale, scale, 0.0f, 0.0f, px0, py0, px1, py1);
            } else {
                STBTruetype.stbtt_GetGlyphBitmapBox(this.face.getFontInfo(), this.glyphIndex, scale, scale, px0, py0, px1, py1);
            }
            int x0 = px0.get();
            int y0 = py0.get();
            int x1 = px1.get();
            int y1 = py1.get();
            IntRectangle intRectangle = IntRectangleKt.IntRectangle(x0, y0, x1 - x0, y1 - y0);
            return intRectangle;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally(autoCloseable, throwable);
        }
    }

    @Override
    public void rasterize(double size, @NotNull MPPBuffer bitmap, int stride, boolean subpixel) {
        Intrinsics.checkNotNullParameter(bitmap, "bitmap");
        ByteBuffer bitmapBuffer = bitmap.getByteBuffer();
        float scale = (float)this.face.scaleForSize$openrndr_gl3(size);
        IntRectangle bounds = this.bitmapBounds(size, subpixel);
        STBTruetype.stbtt_MakeGlyphBitmapSubpixel(this.face.getFontInfo(), bitmapBuffer, bounds.width(), bounds.height(), stride, scale, scale, 0.0f, 0.0f, this.glyphIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Unit shape$lambda$1(STBTTVertex.Buffer $shapeBuffer, double $scale, ContourBuilder $this$contours) {
        Intrinsics.checkNotNullParameter($shapeBuffer, "$shapeBuffer");
        Intrinsics.checkNotNullParameter($this$contours, "$this$contours");
        AutoCloseable autoCloseable = $shapeBuffer;
        Throwable throwable = null;
        try {
            STBTTVertex.Buffer shape = (STBTTVertex.Buffer)autoCloseable;
            boolean bl = false;
            int n = shape.remaining();
            for (int i = 0; i < n; ++i) {
                STBTTVertex v = (STBTTVertex)shape.get();
                byte by = v.type();
                if (by == 1) {
                    $this$contours.moveTo((double)v.x() * $scale, (double)v.y() * -$scale);
                    continue;
                }
                if (by == 2) {
                    $this$contours.lineTo((double)v.x() * $scale, (double)v.y() * -$scale);
                    continue;
                }
                if (by == 3) {
                    $this$contours.curveTo((double)v.cx() * $scale, (double)v.cy() * -$scale, (double)v.x() * $scale, (double)v.y() * -$scale);
                    continue;
                }
                if (by == 4) {
                    $this$contours.curveTo((double)v.cx() * $scale, (double)v.cy() * -$scale, (double)v.cx1() * $scale, (double)v.cy1() * -$scale, (double)v.x() * $scale, (double)v.y() * -$scale);
                    continue;
                }
                throw new IllegalStateException(("unsupported vertex type: " + v.type()).toString());
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally(autoCloseable, throwable);
        }
        return Unit.INSTANCE;
    }
}

