/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.events;

import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.openrndr.events.EventJVM;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\u001b\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010%\u001a\u00020\u001cH\u0002J\u0016\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0013\u0010&\u001a\u00020\u001c2\u0006\u0010'\u001a\u00028\u0000\u00a2\u0006\u0002\u0010(J\u0006\u0010)\u001a\u00020\u001cJ&\u0010*\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u001c0\u001b2\u0012\u0010+\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u001c0\u001bJ \u0010*\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u001c0\u001b2\f\u0010+\u001a\b\u0012\u0004\u0012\u00028\u00000\u0000J\u001a\u0010,\u001a\u00020\u001c2\u0012\u0010+\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u001c0\u001bJ\u001a\u0010-\u001a\u00020\u001c2\u0012\u0010+\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u001c0\u001bJ\u0014\u0010-\u001a\u00020\u001c2\f\u0010+\u001a\b\u0012\u0004\u0012\u00028\u00000\u0000R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u0018\u0010\u000f\u001a\n \u0011*\u0004\u0018\u00010\u00100\u0010X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0012R\u001e\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0013\u001a\u00020\u0014@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00028\u00000\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R#\u0010\u001a\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u001c0\u001b0\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR \u0010\u001f\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u001c0\u001b0 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010!\u001a\u00020\"8F\u00a2\u0006\u0006\u001a\u0004\b#\u0010$\u00a8\u0006."}, d2={"Lorg/openrndr/events/Event;", "T", "", "name", "", "postpone", "", "<init>", "(Ljava/lang/String;Z)V", "getName", "()Ljava/lang/String;", "getPostpone", "()Z", "setPostpone", "(Z)V", "lastTriggered", "Ljava/time/Instant;", "kotlin.jvm.PlatformType", "Ljava/time/Instant;", "value", "", "triggerCount", "getTriggerCount", "()J", "messages", "", "listeners", "Lkotlin/Function1;", "", "getListeners", "()Ljava/util/List;", "oneShotListeners", "Ljava/util/concurrent/CopyOnWriteArrayList;", "timeSinceLastTrigger", "Ljava/time/Duration;", "getTimeSinceLastTrigger", "()Ljava/time/Duration;", "internalTrigger", "trigger", "message", "(Ljava/lang/Object;)V", "deliver", "listen", "listener", "cancel", "listenOnce", "openrndr-event"})
@SourceDebugExtension(value={"SMAP\nEvent.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Event.kt\norg/openrndr/events/Event\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,162:1\n1863#2,2:163\n1863#2,2:165\n1863#2:167\n1863#2,2:168\n1863#2,2:170\n1864#2:172\n*S KotlinDebug\n*F\n+ 1 Event.kt\norg/openrndr/events/Event\n*L\n61#1:163,2\n73#1:165,2\n109#1:167\n110#1:168,2\n122#1:170,2\n109#1:172\n*E\n"})
public final class Event<T> {
    @NotNull
    private final String name;
    private boolean postpone;
    private Instant lastTriggered;
    private long triggerCount;
    @NotNull
    private final List<T> messages;
    @NotNull
    private final List<Function1<T, Unit>> listeners;
    @NotNull
    private final CopyOnWriteArrayList<Function1<T, Unit>> oneShotListeners;

    public Event(@NotNull String name, boolean postpone) {
        Intrinsics.checkNotNullParameter(name, "name");
        this.name = name;
        this.postpone = postpone;
        this.lastTriggered = Instant.ofEpochMilli(0L);
        this.messages = new ArrayList();
        this.listeners = new CopyOnWriteArrayList();
        this.oneShotListeners = new CopyOnWriteArrayList();
    }

    public /* synthetic */ Event(String string, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = "<unnamed-event>";
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        this(string, bl);
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    public final boolean getPostpone() {
        return this.postpone;
    }

    public final void setPostpone(boolean bl) {
        this.postpone = bl;
    }

    public final long getTriggerCount() {
        return this.triggerCount;
    }

    @NotNull
    public final List<Function1<T, Unit>> getListeners() {
        return this.listeners;
    }

    @NotNull
    public final Duration getTimeSinceLastTrigger() {
        Duration duration = Duration.between(this.lastTriggered, Instant.now());
        Intrinsics.checkNotNullExpressionValue(duration, "between(...)");
        return duration;
    }

    private final void internalTrigger() {
        long l = this.triggerCount;
        this.triggerCount = l + 1L;
        this.lastTriggered = Instant.now();
    }

    @Deprecated(message="use the postpone property directly")
    @NotNull
    public final Event<T> postpone(boolean postpone) {
        this.postpone = postpone;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void trigger(T message) {
        this.internalTrigger();
        if (!this.postpone) {
            Function1 listener;
            Iterable $this$forEach$iv = this.listeners;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                listener = (Function1)element$iv;
                boolean bl = false;
                try {
                    listener.invoke(message);
                }
                catch (Throwable e) {
                    EventJVM.access$getLogger$p().error(() -> Event.trigger$lambda$1$lambda$0(this, e));
                    if (!EventJVM.access$getIgnoreExceptions()) {
                        throw e;
                    }
                    e.printStackTrace();
                }
            }
            $this$forEach$iv = this.oneShotListeners;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                listener = (Function1)element$iv;
                boolean bl = false;
                try {
                    listener.invoke(message);
                }
                catch (Throwable e) {
                    EventJVM.access$getLogger$p().error(() -> Event.trigger$lambda$3$lambda$2(this, e));
                    if (!EventJVM.access$getIgnoreExceptions()) {
                        throw e;
                    }
                    e.printStackTrace();
                }
            }
            this.oneShotListeners.clear();
        } else if (this.listeners.size() > 0 || this.oneShotListeners.size() > 0) {
            List<T> list = this.messages;
            synchronized (list) {
                boolean bl = false;
                boolean bl2 = this.messages.add(message);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void deliver() {
        if (this.postpone) {
            List<T> list = this.messages;
            synchronized (list) {
                boolean bl = false;
                if (this.messages.size() > 0) {
                    List copy = new ArrayList();
                    copy.addAll((Collection)this.messages);
                    this.messages.clear();
                    Iterable $this$forEach$iv = copy;
                    boolean $i$f$forEach = false;
                    Iterator iterator2 = $this$forEach$iv.iterator();
                    while (iterator2.hasNext()) {
                        Function1 l;
                        Object element$iv;
                        Object m = element$iv = iterator2.next();
                        boolean bl2 = false;
                        Iterable $this$forEach$iv2 = this.listeners;
                        boolean $i$f$forEach2 = false;
                        for (Object element$iv2 : $this$forEach$iv2) {
                            l = (Function1)element$iv2;
                            boolean bl3 = false;
                            try {
                                l.invoke(m);
                            }
                            catch (Exception e) {
                                EventJVM.access$getLogger$p().error(() -> Event.deliver$lambda$10$lambda$9$lambda$6$lambda$5(this, e));
                                if (!EventJVM.access$getIgnoreExceptions()) {
                                    throw e;
                                }
                                e.printStackTrace();
                            }
                        }
                        $this$forEach$iv2 = this.oneShotListeners;
                        $i$f$forEach2 = false;
                        for (Object element$iv2 : $this$forEach$iv2) {
                            l = (Function1)element$iv2;
                            boolean bl4 = false;
                            try {
                                l.invoke(m);
                            }
                            catch (Exception e) {
                                EventJVM.access$getLogger$p().error(() -> Event.deliver$lambda$10$lambda$9$lambda$8$lambda$7(this, e));
                                if (!EventJVM.access$getIgnoreExceptions()) {
                                    throw e;
                                }
                                e.printStackTrace();
                            }
                        }
                        this.oneShotListeners.clear();
                    }
                }
                Unit unit = Unit.INSTANCE;
            }
        }
    }

    @NotNull
    public final Function1<T, Unit> listen(@NotNull Function1<? super T, Unit> listener) {
        Intrinsics.checkNotNullParameter(listener, "listener");
        this.listeners.add(listener);
        return listener;
    }

    @NotNull
    public final Function1<T, Unit> listen(@NotNull Event<T> listener) {
        Intrinsics.checkNotNullParameter(listener, "listener");
        Function1<Object, Unit> listenFunction = arg_0 -> Event.listen$lambda$11(listener, arg_0);
        this.listeners.add(listenFunction);
        return listenFunction;
    }

    public final void cancel(@NotNull Function1<? super T, Unit> listener) {
        Intrinsics.checkNotNullParameter(listener, "listener");
        this.listeners.remove(listener);
    }

    public final void listenOnce(@NotNull Function1<? super T, Unit> listener) {
        Intrinsics.checkNotNullParameter(listener, "listener");
        this.oneShotListeners.add(listener);
    }

    public final void listenOnce(@NotNull Event<T> listener) {
        Intrinsics.checkNotNullParameter(listener, "listener");
        this.oneShotListeners.add(arg_0 -> Event.listenOnce$lambda$12(listener, arg_0));
    }

    private static final Object trigger$lambda$1$lambda$0(Event this$0, Throwable $e) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($e, "$e");
        return "Exception thrown in listener ('" + this$0.name + "'): " + $e.getClass().getSimpleName() + "; '" + $e.getMessage() + "'";
    }

    private static final Object trigger$lambda$3$lambda$2(Event this$0, Throwable $e) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($e, "$e");
        return "Exception thrown in one-shot listener ('" + this$0.name + "'): " + $e.getClass().getSimpleName() + "; '" + $e.getMessage() + "'";
    }

    private static final Object deliver$lambda$10$lambda$9$lambda$6$lambda$5(Event this$0, Exception $e) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($e, "$e");
        return "Exception thrown in listener ('" + this$0.name + "'): " + $e.getClass().getSimpleName() + "; '" + $e.getMessage() + "'";
    }

    private static final Object deliver$lambda$10$lambda$9$lambda$8$lambda$7(Event this$0, Exception $e) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($e, "$e");
        return "Exception thrown in one-shot listener ('" + this$0.name + "'): " + $e.getClass().getSimpleName() + "; '" + $e.getMessage() + "'";
    }

    private static final Unit listen$lambda$11(Event $listener, Object m) {
        Intrinsics.checkNotNullParameter($listener, "$listener");
        $listener.trigger(m);
        return Unit.INSTANCE;
    }

    private static final Unit listenOnce$lambda$12(Event $listener, Object v1) {
        Intrinsics.checkNotNullParameter($listener, "$listener");
        $listener.trigger(v1);
        return Unit.INSTANCE;
    }

    public Event() {
        this(null, false, 3, null);
    }
}

