/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.extensions;

import io.github.oshai.kotlinlogging.KLogger;
import io.github.oshai.kotlinlogging.KotlinLogging;
import java.io.File;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ReplaceWith;
import kotlin.Unit;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference0Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openrndr.AssetMetadata;
import org.openrndr.Extension;
import org.openrndr.KeyEvent;
import org.openrndr.ProduceAssetsEvent;
import org.openrndr.Program;
import org.openrndr.RequestAssetsEvent;
import org.openrndr.color.ColorRGBa;
import org.openrndr.draw.BufferMultisample;
import org.openrndr.draw.ColorBuffer;
import org.openrndr.draw.ColorBufferKt;
import org.openrndr.draw.Drawer;
import org.openrndr.draw.MagnifyingFilter;
import org.openrndr.draw.RenderTarget;
import org.openrndr.draw.RenderTargetBuilder;
import org.openrndr.draw.RenderTargetKt;
import org.openrndr.events.Event;
import org.openrndr.extensions.CreateScreenshot;
import org.openrndr.extensions.ScreenshotEvent;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010Z\u001a\u00020[2\u0006\u0010\\\u001a\u00020NH\u0016J\u0006\u0010]\u001a\u00020[J\u0018\u0010_\u001a\u00020[2\u0006\u0010`\u001a\u00020a2\u0006\u0010\\\u001a\u00020NH\u0016J\u0018\u0010b\u001a\u00020[2\u0006\u0010`\u001a\u00020a2\u0006\u0010\\\u001a\u00020NH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u001a\u0010\r\u001a\u00020\u000eX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001e\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0019\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R5\u0010\u001b\u001a\u0004\u0018\u00010\u00142\b\u0010\u001a\u001a\u0004\u0018\u00010\u00148F@FX\u0087\u008e\u0002\u00a2\u0006\u0018\u0012\u0004\b\u001c\u0010\u0003\u001a\u0004\b\u001f\u0010\u0016\"\u0004\b \u0010\u0018*\u0004\b\u001d\u0010\u001eR\u001a\u0010!\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010\u0010\"\u0004\b#\u0010\u0012R\u001c\u0010$\u001a\u0004\u0018\u00010%X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010'\"\u0004\b(\u0010)R\u001a\u0010*\u001a\u00020+X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010-\"\u0004\b.\u0010/R\u001a\u00100\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b1\u0010\u0010\"\u0004\b2\u0010\u0012R\u001a\u00103\u001a\u000204X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b5\u00106\"\u0004\b7\u00108R\u001c\u00109\u001a\u0004\u0018\u000104X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b:\u00106\"\u0004\b;\u00108R$\u0010=\u001a\u00020\u000e2\u0006\u0010<\u001a\u00020\u000e@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b>\u0010\u0010\"\u0004\b?\u0010\u0012R\u001c\u0010@\u001a\u0004\u0018\u000104X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bA\u00106\"\u0004\bB\u00108R\u001a\u0010C\u001a\u00020DX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bE\u0010F\"\u0004\bG\u0010HR\u0010\u0010I\u001a\u0004\u0018\u00010JX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010K\u001a\u0004\u0018\u00010LX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010M\u001a\u0004\u0018\u00010NX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010O\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bP\u0010\u0010\"\u0004\bQ\u0010\u0012R\u001a\u0010R\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bS\u0010\u0010\"\u0004\bT\u0010\u0012R\u001a\u0010U\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bV\u0010\u0010\"\u0004\bW\u0010\u0012R\u0010\u0010X\u001a\u0004\u0018\u00010YX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010^\u001a\u0004\u0018\u000104X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006c"}, d2={"Lorg/openrndr/extensions/Screenshots;", "Lorg/openrndr/Extension;", "<init>", "()V", "logger", "Lio/github/oshai/kotlinlogging/KLogger;", "beforeScreenshot", "Lorg/openrndr/events/Event;", "Lorg/openrndr/extensions/ScreenshotEvent;", "getBeforeScreenshot", "()Lorg/openrndr/events/Event;", "afterScreenshot", "getAfterScreenshot", "enabled", "", "getEnabled", "()Z", "setEnabled", "(Z)V", "contentScale", "", "getContentScale", "()Ljava/lang/Double;", "setContentScale", "(Ljava/lang/Double;)V", "Ljava/lang/Double;", "<set-?>", "scale", "getScale$annotations", "getScale$delegate", "(Lorg/openrndr/extensions/Screenshots;)Ljava/lang/Object;", "getScale", "setScale", "async", "getAsync", "setAsync", "multisample", "Lorg/openrndr/draw/BufferMultisample;", "getMultisample", "()Lorg/openrndr/draw/BufferMultisample;", "setMultisample", "(Lorg/openrndr/draw/BufferMultisample;)V", "delayFrames", "", "getDelayFrames", "()I", "setDelayFrames", "(I)V", "quitAfterScreenshot", "getQuitAfterScreenshot", "setQuitAfterScreenshot", "key", "", "getKey", "()Ljava/lang/String;", "setKey", "(Ljava/lang/String;)V", "folder", "getFolder", "setFolder", "value", "captureEveryFrame", "getCaptureEveryFrame", "setCaptureEveryFrame", "name", "getName", "setName", "createScreenshot", "Lorg/openrndr/extensions/CreateScreenshot;", "getCreateScreenshot$openrndr_extensions", "()Lorg/openrndr/extensions/CreateScreenshot;", "setCreateScreenshot$openrndr_extensions", "(Lorg/openrndr/extensions/CreateScreenshot;)V", "target", "Lorg/openrndr/draw/RenderTarget;", "resolved", "Lorg/openrndr/draw/ColorBuffer;", "programRef", "Lorg/openrndr/Program;", "screenshotTriggersRequestAssetsEvent", "getScreenshotTriggersRequestAssetsEvent", "setScreenshotTriggersRequestAssetsEvent", "listenToProduceAssetsEvent", "getListenToProduceAssetsEvent", "setListenToProduceAssetsEvent", "listenToKeyDownEvent", "getListenToKeyDownEvent", "setListenToKeyDownEvent", "assetMetaData", "Lorg/openrndr/AssetMetadata;", "setup", "", "program", "trigger", "filename", "beforeDraw", "drawer", "Lorg/openrndr/draw/Drawer;", "afterDraw", "openrndr-extensions"})
public class Screenshots
implements Extension {
    @NotNull
    private final KLogger logger = KotlinLogging.INSTANCE.logger(Screenshots::logger$lambda$0);
    @NotNull
    private final Event<ScreenshotEvent> beforeScreenshot = new Event("before-screenshot", false);
    @NotNull
    private final Event<ScreenshotEvent> afterScreenshot = new Event("after-screenshot", false);
    private boolean enabled = true;
    @Nullable
    private Double contentScale;
    private boolean async = true;
    @Nullable
    private BufferMultisample multisample;
    private int delayFrames;
    private boolean quitAfterScreenshot;
    @NotNull
    private String key = "space";
    @Nullable
    private String folder = "screenshots";
    private boolean captureEveryFrame;
    @Nullable
    private String name;
    @NotNull
    private CreateScreenshot createScreenshot = CreateScreenshot.None.INSTANCE;
    @Nullable
    private RenderTarget target;
    @Nullable
    private ColorBuffer resolved;
    @Nullable
    private Program programRef;
    private boolean screenshotTriggersRequestAssetsEvent = true;
    private boolean listenToProduceAssetsEvent = true;
    private boolean listenToKeyDownEvent = true;
    @Nullable
    private AssetMetadata assetMetaData;
    @Nullable
    private String filename;

    @NotNull
    public final Event<ScreenshotEvent> getBeforeScreenshot() {
        return this.beforeScreenshot;
    }

    @NotNull
    public final Event<ScreenshotEvent> getAfterScreenshot() {
        return this.afterScreenshot;
    }

    @Override
    public boolean getEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    @Nullable
    public final Double getContentScale() {
        return this.contentScale;
    }

    public final void setContentScale(@Nullable Double d) {
        this.contentScale = d;
    }

    @Nullable
    public final Double getScale() {
        return this.contentScale;
    }

    public final void setScale(@Nullable Double d) {
        this.contentScale = d;
    }

    @Deprecated(message="use contentScale", replaceWith=@ReplaceWith(expression="contentScale", imports={}))
    public static /* synthetic */ void getScale$annotations() {
    }

    private static Object getScale$delegate(Screenshots screenshots) {
        return Reflection.mutableProperty0(new MutablePropertyReference0Impl((Object)screenshots, Screenshots.class, "contentScale", "getContentScale()Ljava/lang/Double;", 0));
    }

    public final boolean getAsync() {
        return this.async;
    }

    public final void setAsync(boolean bl) {
        this.async = bl;
    }

    @Nullable
    public final BufferMultisample getMultisample() {
        return this.multisample;
    }

    public final void setMultisample(@Nullable BufferMultisample bufferMultisample) {
        this.multisample = bufferMultisample;
    }

    public final int getDelayFrames() {
        return this.delayFrames;
    }

    public final void setDelayFrames(int n) {
        this.delayFrames = n;
    }

    public final boolean getQuitAfterScreenshot() {
        return this.quitAfterScreenshot;
    }

    public final void setQuitAfterScreenshot(boolean bl) {
        this.quitAfterScreenshot = bl;
    }

    @NotNull
    public final String getKey() {
        return this.key;
    }

    public final void setKey(@NotNull String string) {
        Intrinsics.checkNotNullParameter(string, "<set-?>");
        this.key = string;
    }

    @Nullable
    public final String getFolder() {
        return this.folder;
    }

    public final void setFolder(@Nullable String string) {
        this.folder = string;
    }

    public final boolean getCaptureEveryFrame() {
        return this.captureEveryFrame;
    }

    public final void setCaptureEveryFrame(boolean value2) {
        this.captureEveryFrame = value2;
        if (value2) {
            this.createScreenshot = CreateScreenshot.AutoNamed.INSTANCE;
        }
    }

    @Nullable
    public final String getName() {
        return this.name;
    }

    public final void setName(@Nullable String string) {
        this.name = string;
    }

    @NotNull
    public final CreateScreenshot getCreateScreenshot$openrndr_extensions() {
        return this.createScreenshot;
    }

    public final void setCreateScreenshot$openrndr_extensions(@NotNull CreateScreenshot createScreenshot) {
        Intrinsics.checkNotNullParameter(createScreenshot, "<set-?>");
        this.createScreenshot = createScreenshot;
    }

    public final boolean getScreenshotTriggersRequestAssetsEvent() {
        return this.screenshotTriggersRequestAssetsEvent;
    }

    public final void setScreenshotTriggersRequestAssetsEvent(boolean bl) {
        this.screenshotTriggersRequestAssetsEvent = bl;
    }

    public final boolean getListenToProduceAssetsEvent() {
        return this.listenToProduceAssetsEvent;
    }

    public final void setListenToProduceAssetsEvent(boolean bl) {
        this.listenToProduceAssetsEvent = bl;
    }

    public final boolean getListenToKeyDownEvent() {
        return this.listenToKeyDownEvent;
    }

    public final void setListenToKeyDownEvent(boolean bl) {
        this.listenToKeyDownEvent = bl;
    }

    @Override
    public void setup(@NotNull Program program2) {
        Intrinsics.checkNotNullParameter(program2, "program");
        this.programRef = program2;
        if (this.multisample == null) {
            this.multisample = program2.getWindow().getMultisample().bufferEquivalent();
        }
        if (this.contentScale == null) {
            this.contentScale = program2.getWindow().getContentScale();
        }
        if (this.listenToProduceAssetsEvent) {
            program2.getProduceAssets().listen(arg_0 -> Screenshots.setup$lambda$1(this, arg_0));
        }
        if (this.listenToKeyDownEvent) {
            program2.getKeyboard().getKeyDown().listen(arg_0 -> Screenshots.setup$lambda$2(this, program2, arg_0));
        }
    }

    public final void trigger() {
        block2: {
            Object object;
            CharSequence charSequence = this.name;
            if (charSequence == null || StringsKt.isBlank(charSequence)) {
                v0 = CreateScreenshot.AutoNamed.INSTANCE;
            } else {
                String string = this.name;
                Intrinsics.checkNotNull(string);
                v0 = this.createScreenshot = (CreateScreenshot)new CreateScreenshot.Named(string);
            }
            if ((object = this.programRef) == null || (object = object.getWindow()) == null) break block2;
            object.requestDraw();
        }
    }

    @Override
    public void beforeDraw(@NotNull Drawer drawer, @NotNull Program program2) {
        block15: {
            Intrinsics.checkNotNullParameter(drawer, "drawer");
            Intrinsics.checkNotNullParameter(program2, "program");
            if (Intrinsics.areEqual(this.createScreenshot, CreateScreenshot.None.INSTANCE)) break block15;
            int n = this.delayFrames;
            this.delayFrames = n + -1;
            if (n <= 0) {
                Object it;
                String string;
                ColorBuffer colorBuffer;
                int width = RenderTarget.Companion.getActive().getWidth();
                int height = RenderTarget.Companion.getActive().getHeight();
                Double d = this.contentScale;
                Intrinsics.checkNotNull(d);
                double d2 = d;
                BufferMultisample bufferMultisample = this.multisample;
                Intrinsics.checkNotNull(bufferMultisample);
                this.target = RenderTargetKt.renderTarget$default(width, height, d2, bufferMultisample, null, Screenshots::beforeDraw$lambda$3, 16, null);
                BufferMultisample bufferMultisample2 = this.multisample;
                Intrinsics.checkNotNull(bufferMultisample2);
                BufferMultisample bufferMultisample3 = bufferMultisample2;
                if (Intrinsics.areEqual(bufferMultisample3, BufferMultisample.Disabled.INSTANCE)) {
                    colorBuffer = null;
                } else if (bufferMultisample3 instanceof BufferMultisample.SampleCount) {
                    Double d3 = this.contentScale;
                    Intrinsics.checkNotNull(d3);
                    colorBuffer = ColorBufferKt.colorBuffer$default(width, height, d3, null, null, null, 0, null, 248, null);
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                this.resolved = colorBuffer;
                RenderTarget renderTarget = this.target;
                if (renderTarget != null) {
                    renderTarget.bind();
                }
                CreateScreenshot cs = this.createScreenshot;
                if (Intrinsics.areEqual(cs, CreateScreenshot.None.INSTANCE)) {
                    throw new IllegalStateException("");
                }
                if (Intrinsics.areEqual(cs, CreateScreenshot.AutoNamed.INSTANCE)) {
                    String string2 = this.folder;
                    if (string2 == null) {
                        string2 = ".";
                    }
                    File parent = new File(string2);
                    AssetMetadata assetMetadata = this.assetMetaData;
                    if (assetMetadata == null) {
                        assetMetadata = program2.getAssetMetadata().invoke();
                    }
                    String string3 = new File(parent, assetMetadata.assetBaseName() + ".png").toString();
                    Intrinsics.checkNotNullExpressionValue(string3, "toString(...)");
                    String fn = string3;
                    CharSequence charSequence = this.name;
                    string = charSequence == null || StringsKt.isBlank(charSequence) ? fn : this.name;
                } else if (cs instanceof CreateScreenshot.Named) {
                    string = ((CreateScreenshot.Named)cs).getName();
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                String string4 = this.filename = string;
                if (string4 != null) {
                    it = string4;
                    boolean bl = false;
                    this.beforeScreenshot.trigger(new ScreenshotEvent(StringsKt.dropLast((String)it, 4)));
                }
                ColorRGBa colorRGBa = program2.getBackgroundColor();
                if (colorRGBa != null) {
                    it = colorRGBa;
                    boolean bl = false;
                    drawer.clear((ColorRGBa)it);
                }
            }
        }
    }

    @Override
    public void afterDraw(@NotNull Drawer drawer, @NotNull Program program2) {
        block13: {
            Intrinsics.checkNotNullParameter(drawer, "drawer");
            Intrinsics.checkNotNullParameter(program2, "program");
            String string = this.filename;
            if (string == null) break block13;
            String fn = string;
            boolean bl = false;
            this.filename = null;
            File targetFile = new File(fn);
            drawer.setShadeStyle(null);
            RenderTarget renderTarget = this.target;
            if (renderTarget != null) {
                renderTarget.unbind();
            }
            RenderTarget renderTarget2 = this.target;
            if (renderTarget2 != null) {
                File file;
                RenderTarget it = renderTarget2;
                boolean bl2 = false;
                drawer.defaults();
                File file2 = targetFile.getParentFile();
                if (file2 != null) {
                    File file3 = file2;
                    boolean bl3 = false;
                    if (!file3.exists()) {
                        file3.mkdirs();
                    }
                }
                ColorBuffer resolved = this.resolved;
                if (resolved == null) {
                    ColorBuffer.saveToFile$default(it.colorBuffer(0), targetFile, null, this.async, 2, null);
                    drawer.image(it.colorBuffer(0), it.colorBuffer(0).getBounds(), drawer.getBounds());
                } else {
                    RenderTarget renderTarget3 = this.target;
                    if (renderTarget3 != null) {
                        RenderTarget rt = renderTarget3;
                        boolean bl4 = false;
                        rt.colorBuffer(0).copyTo(resolved, 0, 0, MagnifyingFilter.NEAREST);
                        ColorBuffer.saveToFile$default(resolved, targetFile, null, this.async, 2, null);
                        drawer.image(resolved, resolved.getBounds(), drawer.getBounds());
                    }
                }
                try {
                    file = FilesKt.relativeTo(targetFile, new File("."));
                }
                catch (IllegalArgumentException e) {
                    file = targetFile;
                }
                File savedTo = file;
                this.logger.info(() -> Screenshots.afterDraw$lambda$11$lambda$9$lambda$8(savedTo));
                this.afterScreenshot.trigger(new ScreenshotEvent(StringsKt.dropLast(fn, 4)));
            }
            RenderTarget renderTarget4 = this.target;
            if (renderTarget4 != null) {
                renderTarget4.destroy();
            }
            ColorBuffer colorBuffer = this.resolved;
            if (colorBuffer != null) {
                colorBuffer.destroy();
            }
            if (!this.captureEveryFrame) {
                this.createScreenshot = CreateScreenshot.None.INSTANCE;
            }
            if (this.quitAfterScreenshot) {
                this.logger.info(Screenshots::afterDraw$lambda$11$lambda$10);
                program2.getApplication().exit();
            }
        }
    }

    @Override
    public void shutdown(@NotNull Program program2) {
        Extension.DefaultImpls.shutdown(this, program2);
    }

    private static final Unit logger$lambda$0() {
        return Unit.INSTANCE;
    }

    private static final Unit setup$lambda$1(Screenshots this$0, ProduceAssetsEvent it) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter(it, "it");
        this$0.assetMetaData = it.assetMetadata();
        this$0.trigger();
        return Unit.INSTANCE;
    }

    private static final Unit setup$lambda$2(Screenshots this$0, Program $program, KeyEvent it) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($program, "$program");
        Intrinsics.checkNotNullParameter(it, "it");
        if (!it.getPropagationCancelled() && Intrinsics.areEqual(it.getName(), this$0.key)) {
            if (this$0.screenshotTriggersRequestAssetsEvent) {
                $program.getRequestAssets().trigger(new RequestAssetsEvent(this$0, $program));
            } else {
                this$0.trigger();
            }
        }
        return Unit.INSTANCE;
    }

    private static final Unit beforeDraw$lambda$3(RenderTargetBuilder $this$renderTarget) {
        Intrinsics.checkNotNullParameter($this$renderTarget, "$this$renderTarget");
        RenderTargetBuilder.colorBuffer$default($this$renderTarget, null, null, 3, null);
        RenderTargetBuilder.depthBuffer$default($this$renderTarget, null, 1, null);
        return Unit.INSTANCE;
    }

    private static final Object afterDraw$lambda$11$lambda$9$lambda$8(File $savedTo) {
        Intrinsics.checkNotNullParameter($savedTo, "$savedTo");
        return "screenshot saved to: '" + $savedTo + "'";
    }

    private static final Object afterDraw$lambda$11$lambda$10() {
        return "quitting after after taking screenshot";
    }
}

