/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.extra.color.phrases;

import kotlin.Metadata;
import org.jetbrains.annotations.NotNull;
import org.openrndr.extra.shaderphrases.ShaderPhrase;
import org.openrndr.extra.shaderphrases.ShaderPhraseBook;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000f\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u0011\u0010\n\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0007R\u0011\u0010\f\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u0007R\u0011\u0010\u000e\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0007R\u0011\u0010\u0010\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0007R\u0011\u0010\u0012\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0007\u00a8\u0006\u0014"}, d2={"Lorg/openrndr/extra/color/phrases/ColorPhraseBook;", "Lorg/openrndr/extra/shaderphrases/ShaderPhraseBook;", "<init>", "()V", "phraseAtan2", "Lorg/openrndr/extra/shaderphrases/ShaderPhrase;", "getPhraseAtan2", "()Lorg/openrndr/extra/shaderphrases/ShaderPhrase;", "phraseLinearRgbToOKLab", "getPhraseLinearRgbToOKLab", "oklabToLinearRgb", "getOklabToLinearRgb", "phraseLabToLch", "getPhraseLabToLch", "phraseLchToLab", "getPhraseLchToLab", "linearRgbToSRgb", "getLinearRgbToSRgb", "phraseSRgbToLinearRgb", "getPhraseSRgbToLinearRgb", "orx-color"})
public final class ColorPhraseBook
extends ShaderPhraseBook {
    @NotNull
    public static final ColorPhraseBook INSTANCE = new ColorPhraseBook();
    @NotNull
    private static final ShaderPhrase phraseAtan2 = new ShaderPhrase("float atan2(in float y, in float x) {\n   bool s = (abs(x) > abs(y));\n   return mix(PI/2.0 - atan(x,y), atan(y,x), float(s));\n}");
    @NotNull
    private static final ShaderPhrase phraseLinearRgbToOKLab = new ShaderPhrase("vec4 linear_rgb_to_oklab(vec4 c) {\n   c.rgb = max(vec3(0.0), c.rgb);\n   const mat3 kCONEtoLMS = mat3(\n       0.4122214708,  0.2119034982,  0.0883024619,\n       0.5363325363,  0.6806995451,  0.2817188376,\n       0.0514459929,  0.1073969566,  0.6299787005);\n\n   const mat3 kRot = mat3(\n       0.2104542553,  1.9779984951,  0.0259040371,\n       0.7936177850, -2.4285922050,  0.7827717662,\n       -0.0040720468,  0.4505937099, -0.8086757660);\n   vec3 lms = pow(kCONEtoLMS * c.rgb, vec3(1.0/3.0));\n   vec4 res = vec4((kRot) * lms, c.a);\n   return res;\n}");
    @NotNull
    private static final ShaderPhrase oklabToLinearRgb = new ShaderPhrase("vec4 oklab_to_linear_rgb(vec4 lab) {\n   const mat3 kLMStoCONE = mat3(\n       1.0,            1.0,           1.0,\n       0.3963377774,  -0.1055613458, -0.0894841775,\n       0.2158037573,  -0.0638541728,  -1.2914855480);\n   const mat3 kRot = mat3(\n       4.0767416621, -1.2684380046, -0.0041960863,\n       -3.3077115913,  2.6097574011,  -0.7034186147,\n       0.2309699292, -0.3413193965, 1.7076147010);\n   vec3 lms = kLMStoCONE * lab.rgb;\n   lms = lms * lms * lms;\n   vec4 res = vec4(kRot * lms,lab.a);\n   return res;\n}");
    @NotNull
    private static final ShaderPhrase phraseLabToLch = new ShaderPhrase("vec4 lab_to_lch(vec4 lab) {\n   float r = length(lab.yz);\n   float h = atan2(lab[2], lab[1]);\n   return vec4(lab[0], c, h, lab.a);\n}");
    @NotNull
    private static final ShaderPhrase phraseLchToLab = new ShaderPhrase("vec4 lch_to_lab(vec4 lch) {\n   float a = lch[1] * cos(lch[2]);\n   float b = lch[1] * sin(lch[2]);\n   return vec4(lab[0], a, b, lab.a);\n}");
    @NotNull
    private static final ShaderPhrase linearRgbToSRgb = new ShaderPhrase("vec4 linear_rgb_to_srgb(vec4 c) {\n   const float t = 0.00313066844250063;\n   return vec4(\n       c.r <= t ? c.r * 12.92 : 1.055 * pow(c.r, 1.0 / 2.4) - 0.055,\n       c.g <= t ? c.g * 12.92 : 1.055 * pow(c.g, 1.0 / 2.4) - 0.055,\n       c.b <= t ? c.b * 12.92 : 1.055 * pow(c.b, 1.0 / 2.4) - 0.055,\n       c.a);\n}");
    @NotNull
    private static final ShaderPhrase phraseSRgbToLinearRgb = new ShaderPhrase("vec4 srgb_to_linear_rgb(vec4 c) {\n   const float t = 0.0404482362771082;\n   return vec4(\n       c.r <= t ? c.r / 12.92 : pow( (c.r + 0.055) / 1.055, 2.4),\n       c.g <= t ? c.g / 12.92 : pow( (c.g + 0.055) / 1.055, 2.4),\n       c.b <= t ? c.b / 12.92 : pow( (c.b + 0.055) / 1.055, 2.4),\n       c.a);\n}");

    private ColorPhraseBook() {
        super("color");
    }

    @NotNull
    public final ShaderPhrase getPhraseAtan2() {
        return phraseAtan2;
    }

    @NotNull
    public final ShaderPhrase getPhraseLinearRgbToOKLab() {
        return phraseLinearRgbToOKLab;
    }

    @NotNull
    public final ShaderPhrase getOklabToLinearRgb() {
        return oklabToLinearRgb;
    }

    @NotNull
    public final ShaderPhrase getPhraseLabToLch() {
        return phraseLabToLch;
    }

    @NotNull
    public final ShaderPhrase getPhraseLchToLab() {
        return phraseLchToLab;
    }

    @NotNull
    public final ShaderPhrase getLinearRgbToSRgb() {
        return linearRgbToSRgb;
    }

    @NotNull
    public final ShaderPhrase getPhraseSRgbToLinearRgb() {
        return phraseSRgbToLinearRgb;
    }
}

