/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.extra.color.spaces;

import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.internal.PluginExceptionsKt;
import kotlinx.serialization.internal.SerializationConstructorMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openrndr.color.AlgebraicColor;
import org.openrndr.color.ColorLCHUVa;
import org.openrndr.color.ColorModel;
import org.openrndr.color.ColorRGBa;
import org.openrndr.color.HueShiftableColor;
import org.openrndr.color.LuminosityColor;
import org.openrndr.color.SaturatableColor;
import org.openrndr.color.ShadableColor;
import org.openrndr.extra.color.spaces.ColorHSLUVa$;
import org.openrndr.extra.color.spaces.ColorHSLUVaKt;
import org.openrndr.extra.color.spaces.ColorXSLUVa;
import org.openrndr.math.Vector4;

@Serializable
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0087\b\u0018\u0000 A2\b\u0012\u0004\u0012\u00020\u00000\u00012\b\u0012\u0004\u0012\u00020\u00000\u00022\b\u0012\u0004\u0012\u00020\u00000\u00032\b\u0012\u0004\u0012\u00020\u00000\u00042\b\u0012\u0004\u0012\u00020\u00000\u00052\b\u0012\u0004\u0012\u00020\u00000\u00062\u00020\u0007:\u0002@AB)\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u0012\u0006\u0010\u000b\u001a\u00020\t\u0012\b\b\u0002\u0010\f\u001a\u00020\t\u00a2\u0006\u0004\b\r\u0010\u000eB;\b\u0010\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u0012\u0006\u0010\u000b\u001a\u00020\t\u0012\u0006\u0010\f\u001a\u00020\t\u0012\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012\u00a2\u0006\u0004\b\r\u0010\u0013J\u0006\u0010\u0015\u001a\u00020\u0016J\u0006\u0010\u0017\u001a\u00020\u0018J\u0010\u0010\u001a\u001a\u00020\u00002\u0006\u0010\u0019\u001a\u00020\tH\u0016J\u0010\u0010\u001b\u001a\u00020\u00002\u0006\u0010\u001c\u001a\u00020\tH\u0016J\u0010\u0010\u001e\u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020\tH\u0016J\b\u0010\u001f\u001a\u00020 H\u0016J\u0010\u0010!\u001a\u00020\u00002\u0006\u0010\u001c\u001a\u00020\tH\u0016J\u0011\u0010\"\u001a\u00020\u00002\u0006\u0010#\u001a\u00020\u0000H\u0096\u0002J\u0011\u0010$\u001a\u00020\u00002\u0006\u0010#\u001a\u00020\u0000H\u0096\u0002J\u0011\u0010%\u001a\u00020\u00002\u0006\u0010&\u001a\u00020\tH\u0096\u0002J\u0018\u0010'\u001a\u00020\u00002\u0006\u0010(\u001a\u00020\u00002\u0006\u0010\u001c\u001a\u00020\tH\u0016J\b\u0010)\u001a\u00020*H\u0016J\u0010\u0010,\u001a\u00020\u00002\u0006\u0010+\u001a\u00020\tH\u0016J\t\u0010-\u001a\u00020\tH\u00c6\u0003J\t\u0010.\u001a\u00020\tH\u00c6\u0003J\t\u0010/\u001a\u00020\tH\u00c6\u0003J\t\u00100\u001a\u00020\tH\u00c6\u0003J1\u00101\u001a\u00020\u00002\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\t2\b\b\u0002\u0010\u000b\u001a\u00020\t2\b\b\u0002\u0010\f\u001a\u00020\tH\u00c6\u0001J\u0013\u00102\u001a\u0002032\b\u0010(\u001a\u0004\u0018\u000104H\u00d6\u0003J\t\u00105\u001a\u00020\u0010H\u00d6\u0001J\t\u00106\u001a\u000207H\u00d6\u0001J%\u00108\u001a\u0002092\u0006\u0010:\u001a\u00020\u00002\u0006\u0010;\u001a\u00020<2\u0006\u0010=\u001a\u00020>H\u0001\u00a2\u0006\u0002\b?R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0014R\u0011\u0010\n\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0014R\u0011\u0010\u000b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0014R\u0014\u0010\f\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0014R\u0014\u0010\u0019\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0014R\u0014\u0010\u001d\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u0014R\u0014\u0010+\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b+\u0010\u0014\u00a8\u0006B"}, d2={"Lorg/openrndr/extra/color/spaces/ColorHSLUVa;", "Lorg/openrndr/color/ColorModel;", "Lorg/openrndr/color/HueShiftableColor;", "Lorg/openrndr/color/SaturatableColor;", "Lorg/openrndr/color/ShadableColor;", "Lorg/openrndr/color/LuminosityColor;", "Lorg/openrndr/color/AlgebraicColor;", "Ljava/lang/Record;", "h", "", "s", "l", "alpha", "<init>", "(DDDD)V", "seen0", "", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(IDDDDLkotlinx/serialization/internal/SerializationConstructorMarker;)V", "()D", "toLCHUVa", "Lorg/openrndr/color/ColorLCHUVa;", "toXSLUVa", "Lorg/openrndr/extra/color/spaces/ColorXSLUVa;", "hue", "withHue", "shade", "factor", "saturation", "withSaturation", "toRGBa", "Lorg/openrndr/color/ColorRGBa;", "opacify", "minus", "right", "plus", "times", "scale", "mix", "other", "toVector4", "Lorg/openrndr/math/Vector4;", "luminosity", "withLuminosity", "component1", "component2", "component3", "component4", "copy", "equals", "", "", "hashCode", "toString", "", "write$Self", "", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "write$Self$orx_color", "$serializer", "Companion", "orx-color"})
public final class ColorHSLUVa
extends Record
implements ColorModel<ColorHSLUVa>,
HueShiftableColor<ColorHSLUVa>,
SaturatableColor<ColorHSLUVa>,
ShadableColor<ColorHSLUVa>,
LuminosityColor<ColorHSLUVa>,
AlgebraicColor<ColorHSLUVa> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final double h;
    private final double s;
    private final double l;
    private final double alpha;

    public ColorHSLUVa(double h, double s, double l, double alpha) {
        this.h = h;
        this.s = s;
        this.l = l;
        this.alpha = alpha;
    }

    public /* synthetic */ ColorHSLUVa(double d, double d2, double d3, double d4, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            d4 = 1.0;
        }
        this(d, d2, d3, d4);
    }

    public final double h() {
        return this.h;
    }

    public final double s() {
        return this.s;
    }

    public final double l() {
        return this.l;
    }

    public double alpha() {
        return this.alpha;
    }

    @NotNull
    public final ColorLCHUVa toLCHUVa() {
        double l100 = this.l * 100.0;
        double s100 = this.s * 100.0;
        if (l100 > 99.9999999) {
            new ColorLCHUVa(100.0, 0.0, this.h, this.alpha(), null, 16, null);
        }
        if (l100 < 1.0E-8) {
            new ColorLCHUVa(0.0, 0.0, this.h, this.alpha(), null, 16, null);
        }
        double max100 = ColorHSLUVaKt.access$maxChromaForLH(l100, this.h);
        double c2 = max100 / (double)100 * s100;
        return new ColorLCHUVa(l100, c2, this.h, this.alpha(), null, 16, null);
    }

    @NotNull
    public final ColorXSLUVa toXSLUVa() {
        return new ColorXSLUVa(ColorHSLUVaKt.hueToX(this.h), this.s, this.l, this.alpha());
    }

    public double hue() {
        return this.h;
    }

    @Override
    @NotNull
    public ColorHSLUVa withHue(double hue) {
        return ColorHSLUVa.copy$default(this, hue, 0.0, 0.0, 0.0, 14, null);
    }

    @Override
    @NotNull
    public ColorHSLUVa shade(double factor) {
        return ColorHSLUVa.copy$default(this, 0.0, 0.0, this.l * factor, 0.0, 11, null);
    }

    public double saturation() {
        return this.s;
    }

    @Override
    @NotNull
    public ColorHSLUVa withSaturation(double saturation) {
        return ColorHSLUVa.copy$default(this, 0.0, saturation, 0.0, 0.0, 13, null);
    }

    @Override
    @NotNull
    public ColorRGBa toRGBa() {
        return this.toLCHUVa().toRGBa();
    }

    @Override
    @NotNull
    public ColorHSLUVa opacify(double factor) {
        return ColorHSLUVa.copy$default(this, 0.0, 0.0, 0.0, this.alpha() * factor, 7, null);
    }

    @Override
    @NotNull
    public ColorHSLUVa minus(@NotNull ColorHSLUVa right) {
        Intrinsics.checkNotNullParameter(right, "right");
        return this.copy(this.h - right.h, this.s - right.s, this.l - right.l, this.alpha() - right.alpha());
    }

    @Override
    @NotNull
    public ColorHSLUVa plus(@NotNull ColorHSLUVa right) {
        Intrinsics.checkNotNullParameter(right, "right");
        return this.copy(this.h + right.h, this.s + right.s, this.l + right.l, this.alpha() + right.alpha());
    }

    @Override
    @NotNull
    public ColorHSLUVa times(double scale) {
        return this.copy(this.h * scale, this.s * scale, this.l * scale, this.alpha() * scale);
    }

    @Override
    @NotNull
    public ColorHSLUVa mix(@NotNull ColorHSLUVa other, double factor) {
        Intrinsics.checkNotNullParameter(other, "other");
        return ColorHSLUVaKt.mix(this, other, factor);
    }

    @Override
    @NotNull
    public Vector4 toVector4() {
        return new Vector4(this.h, this.s, this.l, this.alpha());
    }

    public double luminosity() {
        return this.l;
    }

    @Override
    @NotNull
    public ColorHSLUVa withLuminosity(double luminosity) {
        return ColorHSLUVa.copy$default(this, 0.0, 0.0, luminosity, 0.0, 11, null);
    }

    public final double component1() {
        return this.h;
    }

    public final double component2() {
        return this.s;
    }

    public final double component3() {
        return this.l;
    }

    public final double component4() {
        return this.alpha;
    }

    @NotNull
    public final ColorHSLUVa copy(double h, double s, double l, double alpha) {
        return new ColorHSLUVa(h, s, l, alpha);
    }

    public static /* synthetic */ ColorHSLUVa copy$default(ColorHSLUVa colorHSLUVa, double d, double d2, double d3, double d4, int n, Object object) {
        if ((n & 1) != 0) {
            d = colorHSLUVa.h;
        }
        if ((n & 2) != 0) {
            d2 = colorHSLUVa.s;
        }
        if ((n & 4) != 0) {
            d3 = colorHSLUVa.l;
        }
        if ((n & 8) != 0) {
            d4 = colorHSLUVa.alpha;
        }
        return colorHSLUVa.copy(d, d2, d3, d4);
    }

    @Override
    @NotNull
    public String toString() {
        return "ColorHSLUVa(h=" + this.h + ", s=" + this.s + ", l=" + this.l + ", alpha=" + this.alpha + ")";
    }

    @Override
    public int hashCode() {
        int result2 = Double.hashCode(this.h);
        result2 = result2 * 31 + Double.hashCode(this.s);
        result2 = result2 * 31 + Double.hashCode(this.l);
        result2 = result2 * 31 + Double.hashCode(this.alpha);
        return result2;
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ColorHSLUVa)) {
            return false;
        }
        ColorHSLUVa colorHSLUVa = (ColorHSLUVa)other;
        if (Double.compare(this.h, colorHSLUVa.h) != 0) {
            return false;
        }
        if (Double.compare(this.s, colorHSLUVa.s) != 0) {
            return false;
        }
        if (Double.compare(this.l, colorHSLUVa.l) != 0) {
            return false;
        }
        return Double.compare(this.alpha, colorHSLUVa.alpha) == 0;
    }

    @Override
    @NotNull
    public ColorHSLUVa shiftHue(double shiftInDegrees) {
        return HueShiftableColor.DefaultImpls.shiftHue(this, shiftInDegrees);
    }

    @Override
    @NotNull
    public ColorHSLUVa mixHue(double hue, double factor) {
        return HueShiftableColor.DefaultImpls.mixHue(this, hue, factor);
    }

    @Override
    @NotNull
    public ColorHSLUVa saturate(double factor) {
        return SaturatableColor.DefaultImpls.saturate(this, factor);
    }

    @Override
    @NotNull
    public ColorHSLUVa mixSaturation(double saturation, double factor) {
        return SaturatableColor.DefaultImpls.mixSaturation(this, saturation, factor);
    }

    @Override
    @NotNull
    public ColorHSLUVa shadeLuminosity(double factor) {
        return LuminosityColor.DefaultImpls.shadeLuminosity(this, factor);
    }

    @Override
    @NotNull
    public ColorHSLUVa mixLuminosity(double luminosity, double factor) {
        return LuminosityColor.DefaultImpls.mixLuminosity(this, luminosity, factor);
    }

    @Override
    @NotNull
    public ColorHSLUVa div(double scale) {
        return AlgebraicColor.DefaultImpls.div(this, scale);
    }

    @JvmStatic
    public static final /* synthetic */ void write$Self$orx_color(ColorHSLUVa self, CompositeEncoder output, SerialDescriptor serialDesc) {
        output.encodeDoubleElement(serialDesc, 0, self.h);
        output.encodeDoubleElement(serialDesc, 1, self.s);
        output.encodeDoubleElement(serialDesc, 2, self.l);
        if (output.shouldEncodeElementDefault(serialDesc, 3) ? true : Double.compare(self.alpha(), 1.0) != 0) {
            output.encodeDoubleElement(serialDesc, 3, self.alpha());
        }
    }

    public /* synthetic */ ColorHSLUVa(int seen0, double h, double s, double l, double alpha, SerializationConstructorMarker serializationConstructorMarker) {
        if (7 != (7 & seen0)) {
            PluginExceptionsKt.throwMissingFieldException(seen0, 7, $serializer.INSTANCE.getDescriptor());
        }
        this.h = h;
        this.s = s;
        this.l = l;
        this.alpha = (seen0 & 8) == 0 ? 1.0 : alpha;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a8\u0006\u0007"}, d2={"Lorg/openrndr/extra/color/spaces/ColorHSLUVa$Companion;", "", "<init>", "()V", "serializer", "Lkotlinx/serialization/KSerializer;", "Lorg/openrndr/extra/color/spaces/ColorHSLUVa;", "orx-color"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final KSerializer<ColorHSLUVa> serializer() {
            return $serializer.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

