/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.extra.color.spaces;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.openrndr.color.ColorLCHUVa;
import org.openrndr.color.ColorRGBa;
import org.openrndr.extra.color.spaces.ColorHSLUVa;
import org.openrndr.extra.color.spaces.Length;
import org.openrndr.math.MappingKt;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u00008\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0013\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00020\b2\u0006\u0010\t\u001a\u00020\u0005H\u0002\u001a\u0018\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\u0002H\u0002\u001a\u0010\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u0002H\u0002\u001a\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u0002H\u0002\u001a\u0010\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u0005H\u0000\u001a\u0018\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u0005H\u0002\u001a\u001e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u0005\u001a0\u0010\u001c\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u001d\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\u00052\u0006\u0010\u001f\u001a\u00020\u00052\u0006\u0010 \u001a\u00020\u0005H\u0000\u001a\u000e\u0010!\u001a\u00020\u00052\u0006\u0010\"\u001a\u00020\u0005\u001a\n\u0010#\u001a\u00020\u0018*\u00020$\u001a\n\u0010#\u001a\u00020\u0018*\u00020%\"\u0016\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0003\"\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"m", "", "", "[[D", "kappa", "", "epsilon", "getBounds", "", "L", "intersectLineLine", "lineA", "lineB", "distanceFromPole", "point", "lengthOfRayUntilIntersect", "Lorg/openrndr/extra/color/spaces/Length;", "theta", "line", "maxSafeChromaForL", "L100", "maxChromaForLH", "H", "mix", "Lorg/openrndr/extra/color/spaces/ColorHSLUVa;", "left", "right", "x", "map", "a", "b", "c", "d", "hueToX", "hue", "toHSLUVa", "Lorg/openrndr/color/ColorLCHUVa;", "Lorg/openrndr/color/ColorRGBa;", "orx-color"})
public final class ColorHSLUVaKt {
    @NotNull
    private static final double[][] m;
    private static final double kappa = 903.2962962;
    private static final double epsilon = 0.0088564516;

    private static final List<double[]> getBounds(double L) {
        ArrayList<double[]> result2 = new ArrayList<double[]>();
        double sub1 = Math.pow(L + (double)16, 3.0) / (double)1560896;
        double sub2 = sub1 > 0.0088564516 ? sub1 : L / 903.2962962;
        for (int c2 = 0; c2 < 3; ++c2) {
            double m1 = m[c2][0];
            double m2 = m[c2][1];
            double m3 = m[c2][2];
            for (int t = 0; t < 2; ++t) {
                double top1 = ((double)284517 * m1 - (double)94839 * m3) * sub2;
                double top2 = ((double)838422 * m3 + (double)769860 * m2 + (double)731718 * m1) * L * sub2 - (double)(769860 * t) * L;
                double bottom = ((double)632260 * m3 - (double)126452 * m2) * sub2 + (double)(126452 * t);
                double[] dArray = new double[]{top1 / bottom, top2 / bottom};
                result2.add(dArray);
            }
        }
        return result2;
    }

    private static final double intersectLineLine(double[] lineA, double[] lineB) {
        return (lineA[1] - lineB[1]) / (lineB[0] - lineA[0]);
    }

    private static final double distanceFromPole(double[] point) {
        return Math.sqrt(Math.pow(point[0], 2.0) + Math.pow(point[1], 2.0));
    }

    private static final Length lengthOfRayUntilIntersect(double theta, double[] line) {
        double length = line[1] / (Math.sin(theta) - line[0] * Math.cos(theta));
        return new Length(length);
    }

    public static final double maxSafeChromaForL(double L100) {
        List<double[]> bounds = ColorHSLUVaKt.getBounds(L100);
        double min = Double.MAX_VALUE;
        for (int i = 0; i < 2; ++i) {
            double m1 = bounds.get(i)[0];
            double b1 = bounds.get(i)[1];
            double[] dArray = new double[]{m1, b1};
            double[] line = dArray;
            double[] dArray2 = new double[]{(double)-1 / m1, 0.0};
            double x = ColorHSLUVaKt.intersectLineLine(line, dArray2);
            double[] dArray3 = new double[]{x, b1 + x * m1};
            double length = ColorHSLUVaKt.distanceFromPole(dArray3);
            min = Math.min(min, length);
        }
        return min;
    }

    private static final double maxChromaForLH(double L100, double H) {
        double hrad = H / (double)360 * Math.PI * (double)2;
        List<double[]> bounds = ColorHSLUVaKt.getBounds(L100);
        double min = Double.MAX_VALUE;
        for (double[] bound : bounds) {
            Length length = ColorHSLUVaKt.lengthOfRayUntilIntersect(hrad, bound);
            if (!length.getGreaterEqualZero()) continue;
            min = Math.min(min, length.getLength());
        }
        return min;
    }

    @NotNull
    public static final ColorHSLUVa mix(@NotNull ColorHSLUVa left, @NotNull ColorHSLUVa right, double x) {
        Intrinsics.checkNotNullParameter(left, "left");
        Intrinsics.checkNotNullParameter(right, "right");
        double sx = RangesKt.coerceIn(x, 0.0, 1.0);
        return new ColorHSLUVa(MappingKt.mixAngle(left.h(), right.h(), sx), (1.0 - sx) * left.s() + sx * right.s(), (1.0 - sx) * left.l() + sx * right.l(), (1.0 - sx) * left.alpha() + sx * right.alpha());
    }

    public static final double map(double x, double a, double b, double c2, double d) {
        return (x - a) / (b - a) * (d - c2) + c2;
    }

    public static final double hueToX(double hue) {
        double h;
        double d = hue;
        double d2 = 360.0;
        double d3 = d % d2;
        double d4 = !(d3 == 0.0) && !(Math.signum(d3) == Math.signum(d2)) ? d3 + d2 : (h = d3);
        return 0.0 <= h && h < 35.0 ? MappingKt.doubleMap$default(h, 0.0, 35.0, 0.0, 60.0, false, 16, null) : (35.0 <= h && h < 60.0 ? MappingKt.doubleMap$default(h, 35.0, 60.0, 60.0, 120.0, false, 16, null) : (60.0 <= h && h < 135.0 ? MappingKt.doubleMap$default(h, 60.0, 135.0, 120.0, 180.0, false, 16, null) : (135.0 <= h && h < 225.0 ? MappingKt.doubleMap$default(h, 135.0, 225.0, 180.0, 240.0, false, 16, null) : (225.0 <= h && h < 275.0 ? MappingKt.doubleMap$default(h, 225.0, 275.0, 240.0, 300.0, false, 16, null) : MappingKt.doubleMap$default(h, 275.0, 360.0, 300.0, 360.0, false, 16, null)))));
    }

    @NotNull
    public static final ColorHSLUVa toHSLUVa(@NotNull ColorLCHUVa $this$toHSLUVa) {
        Intrinsics.checkNotNullParameter($this$toHSLUVa, "<this>");
        double l100 = $this$toHSLUVa.getL();
        if (l100 > 99.99999) {
            return new ColorHSLUVa($this$toHSLUVa.getH(), 0.0, 1.0, 0.0, 8, null);
        }
        if ($this$toHSLUVa.getL() < 1.0E-6) {
            return new ColorHSLUVa($this$toHSLUVa.getH(), 0.0, 0.0, 0.0, 8, null);
        }
        double max100 = ColorHSLUVaKt.maxChromaForLH(l100, $this$toHSLUVa.getH());
        double c100 = $this$toHSLUVa.getC();
        double s1 = c100 / max100;
        return new ColorHSLUVa($this$toHSLUVa.getH(), s1, l100 / 100.0, $this$toHSLUVa.getAlpha());
    }

    @NotNull
    public static final ColorHSLUVa toHSLUVa(@NotNull ColorRGBa $this$toHSLUVa) {
        Intrinsics.checkNotNullParameter($this$toHSLUVa, "<this>");
        return ColorHSLUVaKt.toHSLUVa(ColorRGBa.toLCHUVa$default($this$toHSLUVa, null, 1, null));
    }

    public static final /* synthetic */ double access$maxChromaForLH(double L100, double H) {
        return ColorHSLUVaKt.maxChromaForLH(L100, H);
    }

    static {
        double[][] dArrayArray = new double[3][];
        double[] dArray = new double[]{3.240969941904521, -1.537383177570093, -0.498610760293};
        dArrayArray[0] = dArray;
        dArray = new double[]{-0.96924363628087, 1.87596750150772, 0.041555057407175};
        dArrayArray[1] = dArray;
        dArray = new double[]{0.055630079696993, -0.20397695888897, 1.056971514242878};
        dArrayArray[2] = dArray;
        m = dArrayArray;
    }
}

