/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.extra.color.spaces;

import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.internal.PluginExceptionsKt;
import kotlinx.serialization.internal.SerializationConstructorMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openrndr.color.AlgebraicColor;
import org.openrndr.color.ColorModel;
import org.openrndr.color.ColorRGBa;
import org.openrndr.color.Linearity;
import org.openrndr.color.LuminosityColor;
import org.openrndr.color.ShadableColor;
import org.openrndr.extra.color.spaces.ColorOKLABa$;
import org.openrndr.extra.color.spaces.ColorOKLCHa;
import org.openrndr.math.Vector4;

@Serializable
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0087\b\u0018\u0000 72\b\u0012\u0004\u0012\u00020\u00000\u00012\b\u0012\u0004\u0012\u00020\u00000\u00022\b\u0012\u0004\u0012\u00020\u00000\u00032\b\u0012\u0004\u0012\u00020\u00000\u00042\u00020\u0005:\u000278B)\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\u0007\u0012\b\b\u0002\u0010\n\u001a\u00020\u0007\u00a2\u0006\u0004\b\u000b\u0010\fB;\b\u0010\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\u0007\u0012\u0006\u0010\n\u001a\u00020\u0007\u0012\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010\u00a2\u0006\u0004\b\u000b\u0010\u0011J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\u0006\u0010\u0015\u001a\u00020\u0016J\u0010\u0010\u0017\u001a\u00020\u00002\u0006\u0010\u0018\u001a\u00020\u0007H\u0016J\u0010\u0010\u0019\u001a\u00020\u00002\u0006\u0010\u0018\u001a\u00020\u0007H\u0016J\u0011\u0010\u001a\u001a\u00020\u00002\u0006\u0010\u001b\u001a\u00020\u0000H\u0096\u0002J\u0011\u0010\u001c\u001a\u00020\u00002\u0006\u0010\u001b\u001a\u00020\u0000H\u0096\u0002J\u0011\u0010\u001d\u001a\u00020\u00002\u0006\u0010\u001e\u001a\u00020\u0007H\u0096\u0002J\b\u0010\u001f\u001a\u00020 H\u0016J\u0010\u0010\"\u001a\u00020\u00002\u0006\u0010!\u001a\u00020\u0007H\u0016J\t\u0010#\u001a\u00020\u0007H\u00c6\u0003J\t\u0010$\u001a\u00020\u0007H\u00c6\u0003J\t\u0010%\u001a\u00020\u0007H\u00c6\u0003J\t\u0010&\u001a\u00020\u0007H\u00c6\u0003J1\u0010'\u001a\u00020\u00002\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u00072\b\b\u0002\u0010\t\u001a\u00020\u00072\b\b\u0002\u0010\n\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010(\u001a\u00020)2\b\u0010*\u001a\u0004\u0018\u00010+H\u00d6\u0003J\t\u0010,\u001a\u00020\u000eH\u00d6\u0001J\t\u0010-\u001a\u00020.H\u00d6\u0001J%\u0010/\u001a\u0002002\u0006\u00101\u001a\u00020\u00002\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u000205H\u0001\u00a2\u0006\u0002\b6R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0012R\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0012R\u0011\u0010\t\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0012R\u0014\u0010\n\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0012R\u0014\u0010!\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\u0012\u00a8\u00069"}, d2={"Lorg/openrndr/extra/color/spaces/ColorOKLABa;", "Lorg/openrndr/color/ColorModel;", "Lorg/openrndr/color/ShadableColor;", "Lorg/openrndr/color/LuminosityColor;", "Lorg/openrndr/color/AlgebraicColor;", "Ljava/lang/Record;", "l", "", "a", "b", "alpha", "<init>", "(DDDD)V", "seen0", "", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(IDDDDLkotlinx/serialization/internal/SerializationConstructorMarker;)V", "()D", "toRGBa", "Lorg/openrndr/color/ColorRGBa;", "toOKLCHa", "Lorg/openrndr/extra/color/spaces/ColorOKLCHa;", "shade", "factor", "opacify", "minus", "right", "plus", "times", "scale", "toVector4", "Lorg/openrndr/math/Vector4;", "luminosity", "withLuminosity", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "", "hashCode", "toString", "", "write$Self", "", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "write$Self$orx_color", "Companion", "$serializer", "orx-color"})
public final class ColorOKLABa
extends Record
implements ColorModel<ColorOKLABa>,
ShadableColor<ColorOKLABa>,
LuminosityColor<ColorOKLABa>,
AlgebraicColor<ColorOKLABa> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final double l;
    private final double a;
    private final double b;
    private final double alpha;

    public ColorOKLABa(double l, double a, double b, double alpha) {
        this.l = l;
        this.a = a;
        this.b = b;
        this.alpha = alpha;
    }

    public /* synthetic */ ColorOKLABa(double d, double d2, double d3, double d4, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            d4 = 1.0;
        }
        this(d, d2, d3, d4);
    }

    public final double l() {
        return this.l;
    }

    public final double a() {
        return this.a;
    }

    public final double b() {
        return this.b;
    }

    public double alpha() {
        return this.alpha;
    }

    @Override
    @NotNull
    public ColorRGBa toRGBa() {
        double lnl = this.l + 0.3963377774 * this.a + 0.2158037573 * this.b;
        double mnl = this.l - 0.1055613458 * this.a - 0.0638541728 * this.b;
        double snl = this.l - 0.0894841775 * this.a - 1.291485548 * this.b;
        double l = lnl * lnl * lnl;
        double m = mnl * mnl * mnl;
        double s = snl * snl * snl;
        return new ColorRGBa(4.0767416621 * l - 3.3077115913 * m + 0.2309699292 * s, -1.2684380046 * l + 2.6097574011 * m - 0.3413193965 * s, -0.0041960863 * l - 0.7034186147 * m + 1.707614701 * s, this.alpha(), Linearity.LINEAR);
    }

    @NotNull
    public final ColorOKLCHa toOKLCHa() {
        return ColorOKLCHa.Companion.fromColorOKLABa(this);
    }

    @Override
    @NotNull
    public ColorOKLABa shade(double factor) {
        return new ColorOKLABa(this.l * factor, this.a, this.b, this.alpha());
    }

    @Override
    @NotNull
    public ColorOKLABa opacify(double factor) {
        return new ColorOKLABa(this.l, this.a, this.b, this.alpha() * factor);
    }

    @Override
    @NotNull
    public ColorOKLABa minus(@NotNull ColorOKLABa right) {
        Intrinsics.checkNotNullParameter(right, "right");
        return new ColorOKLABa(this.l - right.l, this.a - right.a, this.b - right.b, this.alpha() - right.alpha());
    }

    @Override
    @NotNull
    public ColorOKLABa plus(@NotNull ColorOKLABa right) {
        Intrinsics.checkNotNullParameter(right, "right");
        return new ColorOKLABa(this.l + right.l, this.a + right.a, this.b + right.b, this.alpha() + right.alpha());
    }

    @Override
    @NotNull
    public ColorOKLABa times(double scale) {
        return new ColorOKLABa(this.l * scale, this.a * scale, this.b * scale, this.alpha() * scale);
    }

    @Override
    @NotNull
    public Vector4 toVector4() {
        return new Vector4(this.l, this.a, this.b, this.alpha());
    }

    public double luminosity() {
        return this.l * 100.0;
    }

    @Override
    @NotNull
    public ColorOKLABa withLuminosity(double luminosity) {
        return ColorOKLABa.copy$default(this, luminosity / 100.0, 0.0, 0.0, 0.0, 14, null);
    }

    public final double component1() {
        return this.l;
    }

    public final double component2() {
        return this.a;
    }

    public final double component3() {
        return this.b;
    }

    public final double component4() {
        return this.alpha;
    }

    @NotNull
    public final ColorOKLABa copy(double l, double a, double b, double alpha) {
        return new ColorOKLABa(l, a, b, alpha);
    }

    public static /* synthetic */ ColorOKLABa copy$default(ColorOKLABa colorOKLABa, double d, double d2, double d3, double d4, int n, Object object) {
        if ((n & 1) != 0) {
            d = colorOKLABa.l;
        }
        if ((n & 2) != 0) {
            d2 = colorOKLABa.a;
        }
        if ((n & 4) != 0) {
            d3 = colorOKLABa.b;
        }
        if ((n & 8) != 0) {
            d4 = colorOKLABa.alpha;
        }
        return colorOKLABa.copy(d, d2, d3, d4);
    }

    @Override
    @NotNull
    public String toString() {
        return "ColorOKLABa(l=" + this.l + ", a=" + this.a + ", b=" + this.b + ", alpha=" + this.alpha + ")";
    }

    @Override
    public int hashCode() {
        int result2 = Double.hashCode(this.l);
        result2 = result2 * 31 + Double.hashCode(this.a);
        result2 = result2 * 31 + Double.hashCode(this.b);
        result2 = result2 * 31 + Double.hashCode(this.alpha);
        return result2;
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ColorOKLABa)) {
            return false;
        }
        ColorOKLABa colorOKLABa = (ColorOKLABa)other;
        if (Double.compare(this.l, colorOKLABa.l) != 0) {
            return false;
        }
        if (Double.compare(this.a, colorOKLABa.a) != 0) {
            return false;
        }
        if (Double.compare(this.b, colorOKLABa.b) != 0) {
            return false;
        }
        return Double.compare(this.alpha, colorOKLABa.alpha) == 0;
    }

    @Override
    @NotNull
    public ColorOKLABa shadeLuminosity(double factor) {
        return LuminosityColor.DefaultImpls.shadeLuminosity(this, factor);
    }

    @Override
    @NotNull
    public ColorOKLABa mixLuminosity(double luminosity, double factor) {
        return LuminosityColor.DefaultImpls.mixLuminosity(this, luminosity, factor);
    }

    @Override
    @NotNull
    public ColorOKLABa div(double scale) {
        return AlgebraicColor.DefaultImpls.div(this, scale);
    }

    @Override
    @NotNull
    public ColorOKLABa mix(@NotNull ColorOKLABa other, double factor) {
        return (ColorOKLABa)AlgebraicColor.DefaultImpls.mix(this, (AlgebraicColor)other, factor);
    }

    @JvmStatic
    public static final /* synthetic */ void write$Self$orx_color(ColorOKLABa self, CompositeEncoder output, SerialDescriptor serialDesc) {
        output.encodeDoubleElement(serialDesc, 0, self.l);
        output.encodeDoubleElement(serialDesc, 1, self.a);
        output.encodeDoubleElement(serialDesc, 2, self.b);
        if (output.shouldEncodeElementDefault(serialDesc, 3) ? true : Double.compare(self.alpha(), 1.0) != 0) {
            output.encodeDoubleElement(serialDesc, 3, self.alpha());
        }
    }

    public /* synthetic */ ColorOKLABa(int seen0, double l, double a, double b, double alpha, SerializationConstructorMarker serializationConstructorMarker) {
        if (7 != (7 & seen0)) {
            PluginExceptionsKt.throwMissingFieldException(seen0, 7, $serializer.INSTANCE.getDescriptor());
        }
        this.l = l;
        this.a = a;
        this.b = b;
        this.alpha = (seen0 & 8) == 0 ? 1.0 : alpha;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\t\u00a8\u0006\n"}, d2={"Lorg/openrndr/extra/color/spaces/ColorOKLABa$Companion;", "", "<init>", "()V", "fromRGBa", "Lorg/openrndr/extra/color/spaces/ColorOKLABa;", "rgba", "Lorg/openrndr/color/ColorRGBa;", "serializer", "Lkotlinx/serialization/KSerializer;", "orx-color"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ColorOKLABa fromRGBa(@NotNull ColorRGBa rgba) {
            Intrinsics.checkNotNullParameter(rgba, "rgba");
            ColorRGBa c2 = rgba.toLinear();
            double l = 0.4122214708 * c2.getR() + 0.5363325363 * c2.getG() + 0.0514459929 * c2.getB();
            double m = 0.2119034982 * c2.getR() + 0.6806995451 * c2.getG() + 0.1073969566 * c2.getB();
            double s = 0.0883024619 * c2.getR() + 0.2817188376 * c2.getG() + 0.6299787005 * c2.getB();
            double lnl = Math.pow(Math.abs(l), 0.3333333333333333) * Math.signum(l);
            double mnl = Math.pow(Math.abs(m), 0.3333333333333333) * Math.signum(m);
            double snl = Math.pow(Math.abs(s), 0.3333333333333333) * Math.signum(s);
            double L = 0.2104542553 * lnl + 0.793617785 * mnl - 0.0040720468 * snl;
            double a = 1.9779984951 * lnl - 2.428592205 * mnl + 0.4505937099 * snl;
            double b = 0.0259040371 * lnl + 0.7827717662 * mnl - 0.808675766 * snl;
            return new ColorOKLABa(L, a, b, c2.getAlpha());
        }

        @NotNull
        public final KSerializer<ColorOKLABa> serializer() {
            return $serializer.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

