/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.extra.color.spaces;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openrndr.color.ColorRGBa;
import org.openrndr.extra.color.spaces.ColorOKLABa;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u0012\n\u0000\n\u0002\u0010\u0006\n\u0002\b\t\n\u0002\u0010\u0013\n\u0002\b\f\u001a(\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0001H\u0000\u001a\u000e\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\u0001\u001a\u000e\u0010\b\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\u0001\u001a\u0018\u0010\t\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0001H\u0000\u001a\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0001H\u0000\u001a$\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00012\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000bH\u0000\u001a\u0016\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u00012\u0006\u0010\u0010\u001a\u00020\u0001\u001a\u001e\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u00012\u0006\u0010\u0010\u001a\u00020\u0001\u001a:\u0010\u0013\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00012\u0006\u0010\u0014\u001a\u00020\u00012\u0006\u0010\u0015\u001a\u00020\u00012\u0006\u0010\u0016\u001a\u00020\u00012\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000b\u00a8\u0006\u0017"}, d2={"max", "", "a", "b", "c", "d", "toe", "x", "toeInv", "compute_max_saturation", "find_cusp", "", "get_ST_max", "cusp", "get_ST_mid", "a_", "b_", "get_Cs", "L", "find_gamut_intersection", "L1", "C1", "L0", "orx-color"})
public final class OKHelpersKt {
    public static final double max(double a, double b, double c2, double d) {
        return Math.max(Math.max(a, b), Math.max(c2, d));
    }

    public static final double toe(double x) {
        double k1 = 0.206;
        double k2 = 0.03;
        double k3 = (1.0 + k1) / (1.0 + k2);
        double d = (k3 * x - k1) * (k3 * x - k1) + (double)4 * k2 * k3 * x;
        return 0.5 * (k3 * x - k1 + Math.sqrt(RangesKt.coerceAtLeast(d, 0.0)));
    }

    public static final double toeInv(double x) {
        double k1 = 0.206;
        double k2 = 0.03;
        double k3 = (1.0 + k1) / (1.0 + k2);
        return (x * x + k1 * x) / (k3 * (x + k2));
    }

    public static final double compute_max_saturation(double a, double b) {
        double k0 = 0.0;
        double k1 = 0.0;
        double k2 = 0.0;
        double k3 = 0.0;
        double k4 = 0.0;
        double wl = 0.0;
        double wm = 0.0;
        double ws = 0.0;
        if (-1.88170328 * a - 0.80936493 * b > 1.0) {
            k0 = 1.19086277;
            k1 = 1.76576728;
            k2 = 0.59662641;
            k3 = 0.75515197;
            k4 = 0.56771245;
            wl = 4.0767416621;
            wm = -3.3077115913;
            ws = 0.2309699292;
        } else if (1.81444104 * a - 1.19445276 * b > 1.0) {
            k0 = 0.73956515;
            k1 = -0.45954404;
            k2 = 0.08285427;
            k3 = 0.1254107;
            k4 = 0.14503204;
            wl = -1.2684380046;
            wm = 2.6097574011;
            ws = -0.3413193965;
        } else {
            k0 = 1.35733652;
            k1 = -0.00915799;
            k2 = -1.1513021;
            k3 = -0.50559606;
            k4 = 0.00692167;
            wl = -0.0041960863;
            wm = -0.7034186147;
            ws = 1.707614701;
        }
        double S = k0 + k1 * a + k2 * b + k3 * a * a + k4 * a * b;
        double k_l = 0.3963377774 * a + 0.2158037573 * b;
        double k_m = -0.1055613458 * a - 0.0638541728 * b;
        double k_s = -0.0894841775 * a - 1.291485548 * b;
        boolean bl = false;
        double l_ = 1.0 + S * k_l;
        double m_ = 1.0 + S * k_m;
        double s_ = 1.0 + S * k_s;
        double l = l_ * l_ * l_;
        double m = m_ * m_ * m_;
        double s = s_ * s_ * s_;
        double l_dS = (double)3 * k_l * l_ * l_;
        double m_dS = (double)3 * k_m * m_ * m_;
        double s_dS = (double)3 * k_s * s_ * s_;
        double l_dS2 = (double)6 * k_l * k_l * l_;
        double m_dS2 = (double)6 * k_m * k_m * m_;
        double s_dS2 = (double)6 * k_s * k_s * s_;
        double f = wl * l + wm * m + ws * s;
        double f1 = wl * l_dS + wm * m_dS + ws * s_dS;
        double f2 = wl * l_dS2 + wm * m_dS2 + ws * s_dS2;
        return S - f * f1 / (f1 * f1 - 0.5 * f * f2);
    }

    @NotNull
    public static final double[] find_cusp(double a, double b) {
        double S_cusp = OKHelpersKt.compute_max_saturation(a, b);
        ColorRGBa rgb_at_max = new ColorOKLABa(1.0, S_cusp * a, S_cusp * b, 0.0, 8, null).toRGBa().toLinear();
        double L_cusp = Math.pow(1.0 / Math.max(Math.max(rgb_at_max.getR(), rgb_at_max.getG()), rgb_at_max.getB()), 0.3333333333333333);
        double C_cusp = L_cusp * S_cusp;
        double[] dArray = new double[]{L_cusp, C_cusp};
        return dArray;
    }

    @NotNull
    public static final double[] get_ST_max(double a, double b, @Nullable double[] cusp) {
        double[] dArray = cusp;
        if (cusp == null) {
            dArray = OKHelpersKt.find_cusp(a, b);
        }
        double[] cusp2 = dArray;
        double L = cusp2[0];
        double C = cusp2[1];
        double[] dArray2 = new double[]{C / L, C / (1.0 - L)};
        return dArray2;
    }

    public static /* synthetic */ double[] get_ST_max$default(double d, double d2, double[] dArray, int n, Object object) {
        if ((n & 4) != 0) {
            dArray = null;
        }
        return OKHelpersKt.get_ST_max(d, d2, dArray);
    }

    @NotNull
    public static final double[] get_ST_mid(double a_, double b_) {
        double S = 0.11516993 + 1.0 / (7.4477897 + 4.1590124 * b_ + a_ * (-2.19557347 + 1.75198401 * b_ + a_ * (-2.13704948 - 10.02301043 * b_ + a_ * (-4.24894561 + 5.38770819 * b_ + 4.69891013 * a_))));
        double T = 0.11239642 + 1.0 / (1.6132032 - 0.68124379 * b_ + a_ * (0.40370612 + 0.90148123 * b_ + a_ * (-0.27087943 + 0.6122399 * b_ + a_ * (0.00299215 - 0.45399568 * b_ - 0.14661872 * a_))));
        double[] dArray = new double[]{S, T};
        return dArray;
    }

    @NotNull
    public static final double[] get_Cs(double L, double a_, double b_) {
        double[] cusp = OKHelpersKt.find_cusp(a_, b_);
        double C_max = OKHelpersKt.find_gamut_intersection(a_, b_, L, 1.0, L, cusp);
        double[] ST_max = OKHelpersKt.get_ST_max(a_, b_, cusp);
        double S_mid = 0.11516993 + 1.0 / (7.4477897 + 4.1590124 * b_ + a_ * (-2.19557347 + 1.75198401 * b_ + a_ * (-2.13704948 - 10.02301043 * b_ + a_ * (-4.24894561 + 5.38770819 * b_ + 4.69891013 * a_))));
        double T_mid = 0.11239642 + 1.0 / (1.6132032 - 0.68124379 * b_ + a_ * (0.40370612 + 0.90148123 * b_ + a_ * (-0.27087943 + 0.6122399 * b_ + a_ * (0.00299215 - 0.45399568 * b_ - 0.14661872 * a_))));
        double k = C_max / Math.min(L * ST_max[0], (1.0 - L) * ST_max[1]);
        double C_mid = 0.0;
        boolean bl = false;
        double C_a = L * S_mid;
        double C_b = (1.0 - L) * T_mid;
        C_mid = 0.9 * k * Math.sqrt(Math.sqrt(1.0 / (1.0 / (C_a * C_a * C_a * C_a) + 1.0 / (C_b * C_b * C_b * C_b))));
        double C_0 = 0.0;
        boolean bl2 = false;
        double C_a2 = L * 0.4;
        double C_b2 = (1.0 - L) * 0.8;
        C_0 = Math.sqrt(1.0 / (1.0 / (C_a2 * C_a2) + 1.0 / (C_b2 * C_b2)));
        double[] dArray = new double[]{C_0, C_mid, C_max};
        return dArray;
    }

    public static final double find_gamut_intersection(double a, double b, double L1, double C1, double L0, @Nullable double[] cusp) {
        double[] dArray = cusp;
        if (cusp == null) {
            dArray = OKHelpersKt.find_cusp(a, b);
        }
        double[] cusp2 = dArray;
        Ref.DoubleRef t = new Ref.DoubleRef();
        if ((L1 - L0) * cusp2[1] - (cusp2[0] - L0) * C1 <= 0.0) {
            t.element = cusp2[1] * L0 / (C1 * cusp2[0] + cusp2[1] * (L0 - L1));
        } else {
            t.element = cusp2[1] * (L0 - 1.0) / (C1 * (cusp2[0] - 1.0) + cusp2[1] * (L0 - L1));
            boolean bl = false;
            double dL = L1 - L0;
            double dC = C1;
            double k_l = 0.3963377774 * a + 0.2158037573 * b;
            double k_m = -0.1055613458 * a - 0.0638541728 * b;
            double k_s = -0.0894841775 * a - 1.291485548 * b;
            double l_dt = dL + dC * k_l;
            double m_dt = dL + dC * k_m;
            double s_dt = dL + dC * k_s;
            Function0<Unit> cfr_ignored_0 = () -> OKHelpersKt.find_gamut_intersection$lambda$4$lambda$3(L0, t, L1, C1, k_l, k_m, k_s, l_dt, m_dt, s_dt);
        }
        return t.element;
    }

    public static /* synthetic */ double find_gamut_intersection$default(double d, double d2, double d3, double d4, double d5, double[] dArray, int n, Object object) {
        if ((n & 0x20) != 0) {
            dArray = null;
        }
        return OKHelpersKt.find_gamut_intersection(d, d2, d3, d4, d5, dArray);
    }

    private static final Unit find_gamut_intersection$lambda$4$lambda$3(double $L0, Ref.DoubleRef $t, double $L1, double $C1, double $k_l, double $k_m, double $k_s, double $l_dt, double $m_dt, double $s_dt) {
        Intrinsics.checkNotNullParameter($t, "$t");
        double L = $L0 * (1.0 - $t.element) + $t.element * $L1;
        double C = $t.element * $C1;
        double l_ = L + C * $k_l;
        double m_ = L + C * $k_m;
        double s_ = L + C * $k_s;
        double l = l_ * l_ * l_;
        double m = m_ * m_ * m_;
        double s = s_ * s_ * s_;
        double ldt = (double)3 * $l_dt * l_ * l_;
        double mdt = (double)3 * $m_dt * m_ * m_;
        double sdt = (double)3 * $s_dt * s_ * s_;
        double ldt2 = (double)6 * $l_dt * $l_dt * l_;
        double mdt2 = (double)6 * $m_dt * $m_dt * m_;
        double sdt2 = (double)6 * $s_dt * $s_dt * s_;
        double r = 4.0767416621 * l - 3.3077115913 * m + 0.2309699292 * s - 1.0;
        double r1 = 4.0767416621 * ldt - 3.3077115913 * mdt + 0.2309699292 * sdt;
        double r2 = 4.0767416621 * ldt2 - 3.3077115913 * mdt2 + 0.2309699292 * sdt2;
        double u_r = r1 / (r1 * r1 - 0.5 * r * r2);
        double t_r = -r * u_r;
        double g = -1.2684380046 * l + 2.6097574011 * m - 0.3413193965 * s - 1.0;
        double g1 = -1.2684380046 * ldt + 2.6097574011 * mdt - 0.3413193965 * sdt;
        double g2 = -1.2684380046 * ldt2 + 2.6097574011 * mdt2 - 0.3413193965 * sdt2;
        double u_g = g1 / (g1 * g1 - 0.5 * g * g2);
        double t_g = -g * u_g;
        double b = -0.0041960863 * l - 0.7034186147 * m + 1.707614701 * s - 1.0;
        double b1 = -0.0041960863 * ldt - 0.7034186147 * mdt + 1.707614701 * sdt;
        double b2 = -0.0041960863 * ldt2 - 0.7034186147 * mdt2 + 1.707614701 * sdt2;
        double u_b = b1 / (b1 * b1 - 0.5 * b * b2);
        double t_b = -b * u_b;
        t_r = u_r >= 0.0 ? t_r : 1000000.0;
        t_g = u_g >= 0.0 ? t_g : 1000000.0;
        t_b = u_b >= 0.0 ? t_b : 1000000.0;
        $t.element += Math.min(t_r, Math.min(t_g, t_b));
        return Unit.INSTANCE;
    }
}

