/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.extra.color.tools;

import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.openrndr.color.ChromaColor;
import org.openrndr.color.ColorRGBa;
import org.openrndr.color.ConvertibleToColorRGBa;
import org.openrndr.extra.color.tools.ColorRGBaExtensionsKt;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\"\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a>\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u00012\b\b\u0002\u0010\u0005\u001a\u00020\u00012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\b0\u0007H\u0002\u001a#\u0010\t\u001a\u00020\u0001\"\u0012\b\u0000\u0010\n*\b\u0012\u0004\u0012\u0002H\n0\u000b*\u00020\f*\u0002H\n\u00a2\u0006\u0002\u0010\r\u001a#\u0010\u000e\u001a\u0002H\n\"\u0012\b\u0000\u0010\n*\b\u0012\u0004\u0012\u0002H\n0\u000b*\u00020\f*\u0002H\n\u00a2\u0006\u0002\u0010\u000f\u00a8\u0006\u0010"}, d2={"binarySearchMax", "", "min", "max", "start", "threshold", "f", "Lkotlin/Function1;", "", "findMaxChroma", "T", "Lorg/openrndr/color/ChromaColor;", "Lorg/openrndr/color/ConvertibleToColorRGBa;", "(Lorg/openrndr/color/ChromaColor;)D", "clipChroma", "(Lorg/openrndr/color/ChromaColor;)Lorg/openrndr/color/ChromaColor;", "orx-color"})
public final class ChromaColorExtensionsKt {
    private static final double binarySearchMax(double min, double max, double start, double threshold, Function1<? super Double, Boolean> f) {
        double low = min;
        double high = max;
        double best = min;
        double mid = start;
        while (low <= high) {
            boolean res = f.invoke((Double)mid);
            if (res) {
                best = mid;
                low = mid;
            } else {
                high = mid;
            }
            if (high - low < threshold) {
                return best;
            }
            mid = (low + high) / 2.0;
        }
        return best;
    }

    static /* synthetic */ double binarySearchMax$default(double d, double d2, double d3, double d4, Function1 function1, int n, Object object) {
        if ((n & 8) != 0) {
            d4 = 1.0E-5;
        }
        return ChromaColorExtensionsKt.binarySearchMax(d, d2, d3, d4, function1);
    }

    public static final <T extends ChromaColor<T> & ConvertibleToColorRGBa> double findMaxChroma(@NotNull T $this$findMaxChroma) {
        Intrinsics.checkNotNullParameter($this$findMaxChroma, "<this>");
        return ChromaColorExtensionsKt.binarySearchMax(0.0, 200.0, $this$findMaxChroma.getChroma(), 1.0E-5, arg_0 -> ChromaColorExtensionsKt.findMaxChroma$lambda$0($this$findMaxChroma, arg_0));
    }

    @NotNull
    public static final <T extends ChromaColor<T> & ConvertibleToColorRGBa> T clipChroma(@NotNull T $this$clipChroma) {
        Intrinsics.checkNotNullParameter($this$clipChroma, "<this>");
        double maxChroma = ChromaColorExtensionsKt.findMaxChroma($this$clipChroma);
        return (T)((ChromaColor)$this$clipChroma.withChroma(maxChroma));
    }

    private static final boolean findMaxChroma$lambda$0(ChromaColor $this_findMaxChroma, double it) {
        Intrinsics.checkNotNullParameter($this_findMaxChroma, "$this_findMaxChroma");
        ColorRGBa c2 = ((ConvertibleToColorRGBa)$this_findMaxChroma.withChroma(it)).toRGBa();
        return !ColorRGBaExtensionsKt.isOutOfGamut(c2);
    }
}

