/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.extra.compositor;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.openrndr.draw.ColorBuffer;
import org.openrndr.draw.ColorBufferKt;
import org.openrndr.draw.ColorType;
import org.openrndr.extra.compositor.ColorBufferCacheKey;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0017\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u0012\u001a\u00020\fH\u0086\u0002J\u0006\u0010\u0013\u001a\u00020\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR#\u0010\n\u001a\u0014\u0012\u0004\u0012\u00020\f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0015"}, d2={"Lorg/openrndr/extra/compositor/ColorBufferCache;", "", "width", "", "height", "<init>", "(II)V", "getWidth", "()I", "getHeight", "cache", "", "Lorg/openrndr/extra/compositor/ColorBufferCacheKey;", "", "Lorg/openrndr/draw/ColorBuffer;", "getCache", "()Ljava/util/Map;", "get", "key", "destroy", "", "orx-compositor"})
@SourceDebugExtension(value={"SMAP\nCompositor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Compositor.kt\norg/openrndr/extra/compositor/ColorBufferCache\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,383:1\n381#2,7:384\n216#3:391\n217#3:394\n1863#4,2:392\n*S KotlinDebug\n*F\n+ 1 Compositor.kt\norg/openrndr/extra/compositor/ColorBufferCache\n*L\n334#1:384,7\n343#1:391\n343#1:394\n344#1:392,2\n*E\n"})
public final class ColorBufferCache {
    private final int width;
    private final int height;
    @NotNull
    private final Map<ColorBufferCacheKey, List<ColorBuffer>> cache;

    public ColorBufferCache(int width, int height) {
        this.width = width;
        this.height = height;
        this.cache = new LinkedHashMap();
    }

    public final int getWidth() {
        return this.width;
    }

    public final int getHeight() {
        return this.height;
    }

    @NotNull
    public final Map<ColorBufferCacheKey, List<ColorBuffer>> getCache() {
        return this.cache;
    }

    @NotNull
    public final List<ColorBuffer> get(@NotNull ColorBufferCacheKey key) {
        List<ColorBuffer> list;
        Intrinsics.checkNotNullParameter(key, "key");
        Map<ColorBufferCacheKey, List<ColorBuffer>> $this$getOrPut$iv = this.cache;
        boolean $i$f$getOrPut = false;
        List<ColorBuffer> value$iv = $this$getOrPut$iv.get(key);
        if (value$iv == null) {
            boolean bl = false;
            ColorBuffer[] colorBufferArray = new ColorBuffer[2];
            int n = this.width;
            int n2 = this.height;
            ColorType colorType = key.colorType();
            double d = key.contentScale();
            colorBufferArray[0] = ColorBufferKt.colorBuffer$default(n, n2, d, null, colorType, null, 0, null, 232, null);
            n = this.width;
            n2 = this.height;
            colorType = key.colorType();
            d = key.contentScale();
            colorBufferArray[1] = ColorBufferKt.colorBuffer$default(n, n2, d, null, colorType, null, 0, null, 232, null);
            List<ColorBuffer> answer$iv = CollectionsKt.listOf(colorBufferArray);
            $this$getOrPut$iv.put(key, answer$iv);
            list = answer$iv;
        } else {
            list = value$iv;
        }
        return list;
    }

    public final void destroy() {
        Map<ColorBufferCacheKey, List<ColorBuffer>> $this$forEach$iv = this.cache;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<ColorBufferCacheKey, List<ColorBuffer>>> iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<ColorBufferCacheKey, List<ColorBuffer>> element$iv;
            Map.Entry<ColorBufferCacheKey, List<ColorBuffer>> it = element$iv = iterator2.next();
            boolean bl = false;
            Iterable $this$forEach$iv2 = it.getValue();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                ColorBuffer cb = (ColorBuffer)element$iv2;
                boolean bl2 = false;
                cb.destroy();
            }
        }
    }
}

