/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.extra.expressions.typed;

import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openrndr.math.Matrix44;
import org.openrndr.math.Vector2;
import org.openrndr.math.Vector2Kt;
import org.openrndr.math.Vector3;
import org.openrndr.math.Vector3Kt;
import org.openrndr.math.Vector4;
import org.openrndr.math.Vector4Kt;
import org.openrndr.math.transforms.TransformsKt;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000@\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003H\u0000\u001a\u0018\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u0003H\u0000\u001a\u0018\u0010\b\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u0003H\u0000\u001a\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u0003H\u0000\u001a\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u0003H\u0000\u001a\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u0003H\u0000\u001aN\u0010\u000f\u001a\u0016\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u0011\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u00102\u0006\u0010\u0012\u001a\u00020\u00132(\u0010\u0014\u001a$\u0012\u0004\u0012\u00020\u0013\u0012\u001a\u0012\u0018\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0017j\u0002`\u00160\u0015H\u0000\u00a8\u0006\u0018"}, d2={"rotate", "Lorg/openrndr/math/Matrix44;", "axis", "", "angleInDegrees", "min", "x", "y", "max", "vec2", "Lorg/openrndr/math/Vector2;", "vec3", "Lorg/openrndr/math/Vector3;", "vec4", "Lorg/openrndr/math/Vector4;", "dispatchFunction2", "Lkotlin/Function1;", "", "name", "", "functions", "", "Lorg/openrndr/extra/expressions/typed/TypedFunction2;", "Lkotlin/Function2;", "orx-expression-evaluator-typed"})
@SourceDebugExtension(value={"SMAP\nFunction2.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Function2.kt\norg/openrndr/extra/expressions/typed/Function2Kt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,86:1\n1#2:87\n*E\n"})
public final class Function2Kt {
    @NotNull
    public static final Matrix44 rotate(@NotNull Object axis, @NotNull Object angleInDegrees) {
        Vector3 vector3;
        Intrinsics.checkNotNullParameter(axis, "axis");
        Intrinsics.checkNotNullParameter(angleInDegrees, "angleInDegrees");
        if (!(angleInDegrees instanceof Double)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        Object object = axis;
        if (object instanceof Vector2) {
            vector3 = ((Vector2)axis).xy0();
        } else if (object instanceof Vector3) {
            vector3 = (Vector3)axis;
        } else {
            throw new IllegalStateException("unsupported axis argument".toString());
        }
        Vector3 axis2 = vector3;
        return TransformsKt.rotate(Matrix44.Companion, axis2, ((Number)angleInDegrees).doubleValue());
    }

    @NotNull
    public static final Object min(@NotNull Object x, @NotNull Object y) {
        Object object;
        Intrinsics.checkNotNullParameter(x, "x");
        Intrinsics.checkNotNullParameter(y, "y");
        if (x instanceof Double && y instanceof Double) {
            object = Math.min(((Number)x).doubleValue(), ((Number)y).doubleValue());
        } else if (x instanceof Vector2 && y instanceof Vector2) {
            object = Vector2Kt.min((Vector2)x, (Vector2)y);
        } else if (x instanceof Vector3 && y instanceof Vector3) {
            object = Vector3Kt.min((Vector3)x, (Vector3)y);
        } else if (x instanceof Vector4 && y instanceof Vector4) {
            object = Vector4Kt.min((Vector4)x, (Vector4)y);
        } else {
            throw new IllegalStateException("unsupported arguments".toString());
        }
        return object;
    }

    @NotNull
    public static final Object max(@NotNull Object x, @NotNull Object y) {
        Object object;
        Intrinsics.checkNotNullParameter(x, "x");
        Intrinsics.checkNotNullParameter(y, "y");
        if (x instanceof Double && y instanceof Double) {
            object = Math.max(((Number)x).doubleValue(), ((Number)y).doubleValue());
        } else if (x instanceof Vector2 && y instanceof Vector2) {
            object = Vector2Kt.max((Vector2)x, (Vector2)y);
        } else if (x instanceof Vector3 && y instanceof Vector3) {
            object = Vector3Kt.max((Vector3)x, (Vector3)y);
        } else if (x instanceof Vector4 && y instanceof Vector4) {
            object = Vector4Kt.max((Vector4)x, (Vector4)y);
        } else {
            throw new IllegalStateException("unsupported arguments".toString());
        }
        return object;
    }

    @NotNull
    public static final Vector2 vec2(@NotNull Object x, @NotNull Object y) {
        Intrinsics.checkNotNullParameter(x, "x");
        Intrinsics.checkNotNullParameter(y, "y");
        if (!(x instanceof Double)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (!(y instanceof Double)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        return new Vector2(((Number)x).doubleValue(), ((Number)y).doubleValue());
    }

    @NotNull
    public static final Vector3 vec3(@NotNull Object x, @NotNull Object y) {
        Vector3 vector3;
        Intrinsics.checkNotNullParameter(x, "x");
        Intrinsics.checkNotNullParameter(y, "y");
        if (x instanceof Double && y instanceof Vector2) {
            vector3 = new Vector3(((Number)x).doubleValue(), ((Vector2)y).x(), ((Vector2)y).y());
        } else if (x instanceof Vector2 && y instanceof Double) {
            vector3 = new Vector3(((Vector2)x).x(), ((Vector2)x).y(), ((Number)y).doubleValue());
        } else {
            throw new IllegalStateException(("unsupported arguments, '" + x + "' (" + Reflection.getOrCreateKotlinClass(x.getClass()) + ") '" + y + "' (" + Reflection.getOrCreateKotlinClass(y.getClass())).toString());
        }
        return vector3;
    }

    @NotNull
    public static final Vector4 vec4(@NotNull Object x, @NotNull Object y) {
        Vector4 vector4;
        Intrinsics.checkNotNullParameter(x, "x");
        Intrinsics.checkNotNullParameter(y, "y");
        if (x instanceof Double && y instanceof Vector3) {
            vector4 = new Vector4(((Number)x).doubleValue(), ((Vector3)y).x(), ((Vector3)y).y(), ((Vector3)y).z());
        } else if (x instanceof Vector2 && y instanceof Vector2) {
            vector4 = new Vector4(((Vector2)x).x(), ((Vector2)x).y(), ((Vector2)y).x(), ((Vector2)y).y());
        } else if (x instanceof Vector3 && y instanceof Double) {
            vector4 = new Vector4(((Vector3)x).x(), ((Vector3)x).y(), ((Vector3)x).z(), ((Number)y).doubleValue());
        } else {
            throw new IllegalStateException(("unsupported arguments, '" + x + "' (" + Reflection.getOrCreateKotlinClass(x.getClass()) + ") '" + y + "' (" + Reflection.getOrCreateKotlinClass(y.getClass())).toString());
        }
        return vector4;
    }

    @Nullable
    public static final Function1<Object[], Object> dispatchFunction2(@NotNull String name, @NotNull Map<String, ? extends Function2<Object, Object, ? extends Object>> functions) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(functions, "functions");
        return switch (name) {
            case "min" -> Function2Kt::dispatchFunction2$lambda$0;
            case "max" -> Function2Kt::dispatchFunction2$lambda$1;
            case "vec2" -> Function2Kt::dispatchFunction2$lambda$2;
            case "vec3" -> Function2Kt::dispatchFunction2$lambda$3;
            case "rotate" -> Function2Kt::dispatchFunction2$lambda$4;
            default -> {
                Function2<Object, Object, ? extends Object> v1 = functions.get(name);
                if (v1 != null) {
                    Function2<Object, Object, ? extends Object> it = v1;
                    boolean $i$a$-let-Function2Kt$dispatchFunction2$6 = false;
                    yield arg_0 -> Function2Kt.dispatchFunction2$lambda$6$lambda$5(it, arg_0);
                }
                yield null;
            }
        };
    }

    private static final Object dispatchFunction2$lambda$0(Object[] x) {
        Intrinsics.checkNotNullParameter(x, "x");
        return Function2Kt.min(x[0], x[1]);
    }

    private static final Object dispatchFunction2$lambda$1(Object[] x) {
        Intrinsics.checkNotNullParameter(x, "x");
        return Function2Kt.max(x[0], x[1]);
    }

    private static final Vector2 dispatchFunction2$lambda$2(Object[] x) {
        Intrinsics.checkNotNullParameter(x, "x");
        return Function2Kt.vec2(x[0], x[1]);
    }

    private static final Vector3 dispatchFunction2$lambda$3(Object[] x) {
        Intrinsics.checkNotNullParameter(x, "x");
        return Function2Kt.vec3(x[0], x[1]);
    }

    private static final Matrix44 dispatchFunction2$lambda$4(Object[] x) {
        Intrinsics.checkNotNullParameter(x, "x");
        return Function2Kt.rotate(x[0], x[1]);
    }

    private static final Object dispatchFunction2$lambda$6$lambda$5(Function2 $it, Object[] x) {
        Intrinsics.checkNotNullParameter($it, "$it");
        Intrinsics.checkNotNullParameter(x, "x");
        return $it.invoke(x[0], x[1]);
    }
}

