/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.extra.fcurve;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.openrndr.extra.fcurve.FCurve;
import org.openrndr.extra.fcurve.FCurveBuilder;
import org.openrndr.extra.fcurve.RootsKt;
import org.openrndr.math.EuclideanVector;
import org.openrndr.math.Vector2;
import org.openrndr.shape.Segment2D;
import org.openrndr.shape.Segment2DKt;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u00008\n\u0000\n\u0002\u0010\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0004\u001a\u0014\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0001H\u0002\u001a\u0014\u0010\u0004\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0001H\u0002\u001a\u0014\u0010\u0005\u001a\u00020\u0002*\u00020\u00022\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u001a\u001f\u0010\b\u001a\u00020\t2\u0017\u0010\n\u001a\u0013\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000b\u00a2\u0006\u0002\b\u000e\u001a\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u0011\u001a\u0016\u0010\u0013\u001a\u00020\t2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0002\u001a\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u0011\u00a8\u0006\u0015"}, d2={"tForX", "", "Lorg/openrndr/shape/Segment2D;", "x", "yForX", "scaleTangents", "axis", "Lorg/openrndr/math/Vector2;", "fcurve", "Lorg/openrndr/extra/fcurve/FCurve;", "builder", "Lkotlin/Function1;", "Lorg/openrndr/extra/fcurve/FCurveBuilder;", "", "Lkotlin/ExtensionFunctionType;", "fCurveCommands", "", "", "d", "evaluateFCurveCommands", "parts", "orx-fcurve"})
@SourceDebugExtension(value={"SMAP\nFCurve.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FCurve.kt\norg/openrndr/extra/fcurve/FCurveKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,534:1\n774#2:535\n865#2,2:536\n*S KotlinDebug\n*F\n+ 1 FCurve.kt\norg/openrndr/extra/fcurve/FCurveKt\n*L\n393#1:535\n393#1:536,2\n*E\n"})
public final class FCurveKt {
    private static final double tForX(Segment2D $this$tForX, double x) {
        if (x == $this$tForX.getStart().x()) {
            return 0.0;
        }
        if (x == $this$tForX.getEnd().x()) {
            return 1.0;
        }
        if ($this$tForX.getLinear()) {
            return (x - $this$tForX.getStart().x()) / ($this$tForX.getEnd().x() - $this$tForX.getStart().x());
        }
        Segment2D cb = $this$tForX.getCubic();
        double a = cb.getStart().x() - x;
        double b = cb.getControl().get(0).x() - x;
        double c2 = cb.getControl().get(1).x() - x;
        double d = cb.getEnd().x() - x;
        Double d2 = CollectionsKt.firstOrNull(RootsKt.getCubicRoots(a, b, c2, d));
        double t = d2 != null ? d2 : 0.0;
        return t;
    }

    private static final double yForX(Segment2D $this$yForX, double x) {
        double t = FCurveKt.tForX($this$yForX, x);
        return $this$yForX.position(t).y();
    }

    @NotNull
    public static final Segment2D scaleTangents(@NotNull Segment2D $this$scaleTangents, @NotNull Vector2 axis) {
        Intrinsics.checkNotNullParameter($this$scaleTangents, "<this>");
        Intrinsics.checkNotNullParameter(axis, "axis");
        if ($this$scaleTangents.getLinear()) {
            return $this$scaleTangents;
        }
        Segment2D c2 = $this$scaleTangents.getCubic();
        double width = $this$scaleTangents.getEnd().distanceTo($this$scaleTangents.getStart());
        Vector2 d = c2.getEnd().minus(c2.getStart());
        Vector2 cd0 = (Vector2)c2.getControl().get(0).minus(c2.getStart()).projectedOn((EuclideanVector)axis);
        double cd0a = cd0.dot(axis);
        Vector2 cd1 = (Vector2)c2.getControl().get(1).minus(c2.getEnd()).projectedOn((EuclideanVector)axis.unaryMinus());
        double cd1a = cd1.dot(axis.unaryMinus());
        double handleWidth = cd0.length() + cd1.length();
        double r = width / handleWidth;
        Vector2 it = handleWidth > width ? c2.getControl().get(0).minus(c2.getStart()).times(r).plus(c2.getStart()) : c2.getControl().get(0);
        boolean bl = false;
        Vector2 c0 = cd0a <= 0.0 ? ((Vector2)it.minus(c2.getStart()).projectedOn((EuclideanVector)Vector2.perpendicular$default(axis, null, 1, null))).plus(c2.getStart()) : it;
        Vector2 it2 = handleWidth > width ? c2.getControl().get(1).minus(c2.getEnd()).times(r).plus(c2.getEnd()) : c2.getControl().get(1);
        boolean bl2 = false;
        Vector2 c1 = cd1a <= 0.0 ? ((Vector2)it2.minus(c2.getEnd()).projectedOn((EuclideanVector)Vector2.perpendicular$default(axis.unaryMinus(), null, 1, null))).plus(c2.getEnd()) : it2;
        Vector2[] vector2Array = new Vector2[]{c0, c1};
        return Segment2D.copy$default($this$scaleTangents, null, CollectionsKt.listOf(vector2Array), null, false, 13, null);
    }

    public static /* synthetic */ Segment2D scaleTangents$default(Segment2D segment2D, Vector2 vector2, int n, Object object) {
        if ((n & 1) != 0) {
            vector2 = Vector2.Companion.getUNIT_X();
        }
        return FCurveKt.scaleTangents(segment2D, vector2);
    }

    @NotNull
    public static final FCurve fcurve(@NotNull Function1<? super FCurveBuilder, Unit> builder) {
        Intrinsics.checkNotNullParameter(builder, "builder");
        FCurveBuilder fb = new FCurveBuilder();
        builder.invoke(fb);
        return fb.build();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<String> fCurveCommands(@NotNull String d) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(d, "d");
        String svgCommands = "mMlLqQsStTcChH";
        String number = "0-9.\\-E%";
        CharSequence charSequence = d;
        Regex regex = new Regex("(?:[\t ,]|\r?\n)+|(?<=[" + svgCommands + "])(?=[" + number + "])|(?<=[" + number + "])(?=[" + svgCommands + "])");
        int n = 0;
        Iterable $this$filter$iv = regex.split(charSequence, n);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            boolean bl2 = !StringsKt.isBlank(it);
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private static final FCurve evaluateFCurveCommands(List<String> parts) {
        List mparts = CollectionsKt.toMutableList(CollectionsKt.reversed((Iterable)parts));
        return FCurveKt.fcurve(arg_0 -> FCurveKt.evaluateFCurveCommands$lambda$16(mparts, parts, arg_0));
    }

    @NotNull
    public static final FCurve fcurve(@NotNull String d) {
        Intrinsics.checkNotNullParameter(d, "d");
        Double constantExpression = StringsKt.toDoubleOrNull(d);
        if (constantExpression != null) {
            return new FCurve(CollectionsKt.listOf(Segment2DKt.Segment2D$default(new Vector2(0.0, constantExpression), new Vector2(0.0, constantExpression), false, 4, null)));
        }
        return FCurveKt.evaluateFCurveCommands(FCurveKt.fCurveCommands(d));
    }

    private static final String evaluateFCurveCommands$popToken(List<String> mparts) {
        return CollectionsKt.removeLast(mparts);
    }

    private static final double evaluateFCurveCommands$popNumber(List<String> mparts) {
        Double d = StringsKt.toDoubleOrNull(CollectionsKt.removeLast(mparts));
        if (d == null) {
            throw new IllegalStateException("not a number".toString());
        }
        return d;
    }

    private static final double evaluateFCurveCommands$numberOrFactorOf(String $this$evaluateFCurveCommands_u24numberOrFactorOf, Function1<? super Double, Double> percentageOf) {
        double d;
        if (StringsKt.endsWith$default($this$evaluateFCurveCommands_u24numberOrFactorOf, "%", false, 2, null)) {
            Double d2 = StringsKt.toDoubleOrNull(StringsKt.dropLast($this$evaluateFCurveCommands_u24numberOrFactorOf, 1));
            if (d2 == null) {
                throw new IllegalStateException(("'" + $this$evaluateFCurveCommands_u24numberOrFactorOf + "' is not a percentage").toString());
            }
            double f = d2 / 100.0;
            d = ((Number)percentageOf.invoke((Double)f)).doubleValue();
        } else {
            Double d3 = StringsKt.toDoubleOrNull($this$evaluateFCurveCommands_u24numberOrFactorOf);
            if (d3 != null) {
                d = d3;
            } else {
                throw new IllegalStateException(("'" + $this$evaluateFCurveCommands_u24numberOrFactorOf + "' is not a number").toString());
            }
        }
        return d;
    }

    private static final double evaluateFCurveCommands$numberOrPercentageOf$lambda$3(Function0 $percentageOf, double f) {
        Intrinsics.checkNotNullParameter($percentageOf, "$percentageOf");
        return f * ((Number)$percentageOf.invoke()).doubleValue();
    }

    private static final double evaluateFCurveCommands$numberOrPercentageOf(String $this$evaluateFCurveCommands_u24numberOrPercentageOf, Function0<Double> percentageOf) {
        return FCurveKt.evaluateFCurveCommands$numberOrFactorOf($this$evaluateFCurveCommands_u24numberOrPercentageOf, arg_0 -> FCurveKt.evaluateFCurveCommands$numberOrPercentageOf$lambda$3(percentageOf, arg_0));
    }

    private static final double evaluateFCurveCommands$popNumberOrPercentageOf(List<String> mparts, Function0<Double> percentageOf) {
        return FCurveKt.evaluateFCurveCommands$numberOrPercentageOf(CollectionsKt.removeLast(mparts), percentageOf);
    }

    private static final double evaluateFCurveCommands$lambda$16$dx(FCurveBuilder $this_fcurve) {
        Segment2D segment2D = CollectionsKt.lastOrNull($this_fcurve.getSegments());
        if (segment2D == null) {
            segment2D = Segment2DKt.Segment2D$default(Vector2.Companion.getZERO(), Vector2.Companion.getZERO(), false, 4, null);
        }
        Segment2D lastSegment = segment2D;
        return lastSegment.getEnd().x() - lastSegment.getStart().x();
    }

    private static final double evaluateFCurveCommands$lambda$16$lambda$4(FCurveBuilder $this_fcurve) {
        Intrinsics.checkNotNullParameter($this_fcurve, "$this_fcurve");
        return $this_fcurve.getCursor().y();
    }

    private static final double evaluateFCurveCommands$lambda$16$lambda$5(double $x) {
        return $x;
    }

    private static final double evaluateFCurveCommands$lambda$16$lambda$6(boolean $relative, double $y, FCurveBuilder $this_fcurve, double factor) {
        Intrinsics.checkNotNullParameter($this_fcurve, "$this_fcurve");
        return $relative ? $y * factor : $this_fcurve.getCursor().y() * RangesKt.coerceAtLeast(1.0 - factor, 0.0) + $y * factor;
    }

    private static final double evaluateFCurveCommands$lambda$16$lambda$7(double $x) {
        return $x;
    }

    private static final double evaluateFCurveCommands$lambda$16$lambda$8(boolean $relative, double $y, FCurveBuilder $this_fcurve, double factor) {
        Intrinsics.checkNotNullParameter($this_fcurve, "$this_fcurve");
        return $relative ? $y * factor : $this_fcurve.getCursor().y() * RangesKt.coerceAtLeast(1.0 - factor, 0.0) + $y * factor;
    }

    private static final double evaluateFCurveCommands$lambda$16$lambda$9(FCurveBuilder $this_fcurve) {
        Intrinsics.checkNotNullParameter($this_fcurve, "$this_fcurve");
        return FCurveKt.evaluateFCurveCommands$lambda$16$dx($this_fcurve);
    }

    private static final double evaluateFCurveCommands$lambda$16$lambda$10(FCurveBuilder $this_fcurve) {
        Intrinsics.checkNotNullParameter($this_fcurve, "$this_fcurve");
        return $this_fcurve.getCursor().y();
    }

    private static final double evaluateFCurveCommands$lambda$16$lambda$11(double $x) {
        return $x;
    }

    private static final double evaluateFCurveCommands$lambda$16$lambda$12(boolean $relative, double $y, FCurveBuilder $this_fcurve, double factor) {
        Intrinsics.checkNotNullParameter($this_fcurve, "$this_fcurve");
        return $relative ? $y * factor : $this_fcurve.getCursor().y() * RangesKt.coerceAtLeast(1.0 - factor, 0.0) + $y * factor;
    }

    private static final double evaluateFCurveCommands$lambda$16$lambda$13(FCurveBuilder $this_fcurve) {
        Intrinsics.checkNotNullParameter($this_fcurve, "$this_fcurve");
        return FCurveKt.evaluateFCurveCommands$lambda$16$dx($this_fcurve);
    }

    private static final double evaluateFCurveCommands$lambda$16$lambda$14(double $x) {
        return $x;
    }

    private static final double evaluateFCurveCommands$lambda$16$lambda$15(double $y) {
        return $y;
    }

    private static final Unit evaluateFCurveCommands$lambda$16(List $mparts, List $parts, FCurveBuilder $this$fcurve) {
        Intrinsics.checkNotNullParameter($mparts, "$mparts");
        Intrinsics.checkNotNullParameter($parts, "$parts");
        Intrinsics.checkNotNullParameter($this$fcurve, "$this$fcurve");
        block25: while (!((Collection)$mparts).isEmpty()) {
            String command2;
            switch (command2 = (String)CollectionsKt.removeLast($mparts)) {
                case "m": 
                case "M": {
                    boolean isRelative = Character.isLowerCase(StringsKt.first(command2));
                    $this$fcurve.moveTo(FCurveKt.evaluateFCurveCommands$popNumberOrPercentageOf($mparts, () -> FCurveKt.evaluateFCurveCommands$lambda$16$lambda$4($this$fcurve)), isRelative);
                    continue block25;
                }
                case "l": 
                case "L": {
                    boolean isRelative = Character.isLowerCase(StringsKt.first(command2));
                    double x = FCurveKt.evaluateFCurveCommands$popNumber($mparts);
                    double y = FCurveKt.evaluateFCurveCommands$popNumber($mparts);
                    $this$fcurve.lineTo(x, y, isRelative);
                    continue block25;
                }
                case "c": 
                case "C": {
                    boolean relative = Character.isLowerCase(StringsKt.first(command2));
                    String tcx0 = FCurveKt.evaluateFCurveCommands$popToken($mparts);
                    String tcy0 = FCurveKt.evaluateFCurveCommands$popToken($mparts);
                    String tcx1 = FCurveKt.evaluateFCurveCommands$popToken($mparts);
                    String tcy1 = FCurveKt.evaluateFCurveCommands$popToken($mparts);
                    double x = FCurveKt.evaluateFCurveCommands$popNumber($mparts);
                    double y = FCurveKt.evaluateFCurveCommands$popNumber($mparts);
                    double x0 = FCurveKt.evaluateFCurveCommands$numberOrPercentageOf(tcx0, () -> FCurveKt.evaluateFCurveCommands$lambda$16$lambda$5(x));
                    double y0 = FCurveKt.evaluateFCurveCommands$numberOrFactorOf(tcy0, arg_0 -> FCurveKt.evaluateFCurveCommands$lambda$16$lambda$6(relative, y, $this$fcurve, arg_0));
                    double x1 = FCurveKt.evaluateFCurveCommands$numberOrPercentageOf(tcx1, () -> FCurveKt.evaluateFCurveCommands$lambda$16$lambda$7(x));
                    double y1 = FCurveKt.evaluateFCurveCommands$numberOrFactorOf(tcy1, arg_0 -> FCurveKt.evaluateFCurveCommands$lambda$16$lambda$8(relative, y, $this$fcurve, arg_0));
                    $this$fcurve.curveTo(x0, y0, x1, y1, x, y, relative);
                    continue block25;
                }
                case "q": 
                case "Q": {
                    boolean relative = Character.isLowerCase(StringsKt.first(command2));
                    String tcx0 = FCurveKt.evaluateFCurveCommands$popToken($mparts);
                    String tcy0 = FCurveKt.evaluateFCurveCommands$popToken($mparts);
                    double x = FCurveKt.evaluateFCurveCommands$popNumberOrPercentageOf($mparts, () -> FCurveKt.evaluateFCurveCommands$lambda$16$lambda$9($this$fcurve));
                    double y = FCurveKt.evaluateFCurveCommands$popNumberOrPercentageOf($mparts, () -> FCurveKt.evaluateFCurveCommands$lambda$16$lambda$10($this$fcurve));
                    double x0 = FCurveKt.evaluateFCurveCommands$numberOrPercentageOf(tcx0, () -> FCurveKt.evaluateFCurveCommands$lambda$16$lambda$11(x));
                    double y0 = FCurveKt.evaluateFCurveCommands$numberOrFactorOf(tcy0, arg_0 -> FCurveKt.evaluateFCurveCommands$lambda$16$lambda$12(relative, y, $this$fcurve, arg_0));
                    $this$fcurve.curveTo(x0, y0, x, y, relative);
                    continue block25;
                }
                case "h": 
                case "H": {
                    boolean isRelative = Character.isLowerCase(StringsKt.first(command2));
                    $this$fcurve.hold(FCurveKt.evaluateFCurveCommands$popNumberOrPercentageOf($mparts, () -> FCurveKt.evaluateFCurveCommands$lambda$16$lambda$13($this$fcurve)), isRelative);
                    continue block25;
                }
                case "s": 
                case "S": {
                    boolean relative = Character.isLowerCase(StringsKt.first(command2));
                    String tcx0 = FCurveKt.evaluateFCurveCommands$popToken($mparts);
                    String tcy0 = FCurveKt.evaluateFCurveCommands$popToken($mparts);
                    double x = FCurveKt.evaluateFCurveCommands$popNumber($mparts);
                    double y = FCurveKt.evaluateFCurveCommands$popNumber($mparts);
                    double x1 = FCurveKt.evaluateFCurveCommands$numberOrPercentageOf(tcx0, () -> FCurveKt.evaluateFCurveCommands$lambda$16$lambda$14(x));
                    double y1 = FCurveKt.evaluateFCurveCommands$numberOrPercentageOf(tcy0, () -> FCurveKt.evaluateFCurveCommands$lambda$16$lambda$15(y));
                    $this$fcurve.continueTo(x1, y1, x, y, relative);
                    continue block25;
                }
                case "t": 
                case "T": {
                    boolean isRelative = Character.isLowerCase(StringsKt.first(command2));
                    double x = FCurveKt.evaluateFCurveCommands$popNumber($mparts);
                    double y = FCurveKt.evaluateFCurveCommands$popNumber($mparts);
                    $this$fcurve.continueTo(x, y, isRelative);
                    continue block25;
                }
            }
            throw new IllegalStateException(("unknown command: " + command2 + " in " + $parts).toString());
        }
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ double access$yForX(Segment2D $receiver, double x) {
        return FCurveKt.yForX($receiver, x);
    }
}

