/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.extra.fcurve;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u0018\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\b\u0005\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u0010\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0003H\u0002\u001a\"\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\u00032\b\b\u0002\u0010\t\u001a\u00020\u0003H\u0000\u001a.\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00030\u000b2\u0006\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u0003H\u0000\u00a8\u0006\u0010"}, d2={"accept", "", "t", "", "cuberoot", "v", "approximately", "a", "b", "epsilon", "getCubicRoots", "", "pa", "pb", "pc", "pd", "orx-fcurve"})
@SourceDebugExtension(value={"SMAP\nRoots.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Roots.kt\norg/openrndr/extra/fcurve/RootsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,117:1\n774#2:118\n865#2,2:119\n774#2:121\n865#2,2:122\n774#2:124\n865#2,2:125\n774#2:127\n865#2,2:128\n774#2:130\n865#2,2:131\n*S KotlinDebug\n*F\n+ 1 Roots.kt\norg/openrndr/extra/fcurve/RootsKt\n*L\n60#1:118\n60#1:119,2\n65#1:121\n65#1:122,2\n100#1:124\n100#1:125,2\n108#1:127\n108#1:128,2\n116#1:130\n116#1:131,2\n*E\n"})
public final class RootsKt {
    private static final boolean accept(double t) {
        return 0.0 <= t ? t <= 1.0 : false;
    }

    private static final double cuberoot(double v) {
        if (v < 0.0) {
            return -Math.pow(-v, 0.3333333333333333);
        }
        return Math.pow(v, 0.3333333333333333);
    }

    public static final boolean approximately(double a, double b, double epsilon) {
        return Math.abs(a - b) < epsilon;
    }

    public static /* synthetic */ boolean approximately$default(double d, double d2, double d3, int n, Object object) {
        if ((n & 4) != 0) {
            d3 = 1.0E-8;
        }
        return RootsKt.approximately(d, d2, d3);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<Double> getCubicRoots(double pa, double pb, double pc, double pd) {
        void $this$filterTo$iv$iv;
        double a = (double)3 * pa - (double)6 * pb + (double)3 * pc;
        double b = (double)-3 * pa + (double)3 * pb;
        double c2 = pa;
        double d = -pa + (double)3 * pb - (double)3 * pc + pd;
        if (RootsKt.approximately$default(d, 0.0, 0.0, 4, null)) {
            void $this$filterTo$iv$iv2;
            if (RootsKt.approximately$default(a, 0.0, 0.0, 4, null)) {
                void $this$filterTo$iv$iv3;
                if (RootsKt.approximately$default(b, 0.0, 0.0, 4, null)) {
                    return CollectionsKt.emptyList();
                }
                Iterable $this$filter$iv = CollectionsKt.listOf(-c2 / b);
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv3) {
                    double p0 = ((Number)element$iv$iv).doubleValue();
                    boolean bl = false;
                    if (!RootsKt.accept(p0)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                return (List)destination$iv$iv;
            }
            double q = Math.sqrt(b * b - (double)4 * a * c2);
            double twoA = (double)2 * a;
            Double[] $i$f$filterTo = new Double[]{(q - b) / twoA, (-b - q) / twoA};
            Iterable $this$filter$iv = CollectionsKt.listOf($i$f$filterTo);
            boolean $i$f$filter = false;
            Iterable element$iv$iv = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo2 = false;
            for (Object element$iv$iv2 : $this$filterTo$iv$iv2) {
                double p0 = ((Number)element$iv$iv2).doubleValue();
                boolean bl = false;
                if (!RootsKt.accept(p0)) continue;
                destination$iv$iv.add(element$iv$iv2);
            }
            return (List)destination$iv$iv;
        }
        double p = ((double)3 * (b /= d) - (a /= d) * a) / (double)3;
        double p3 = p / (double)3;
        double q = ((double)2 * a * a * a - (double)9 * a * b + (double)27 * (c2 /= d)) / (double)27;
        double q2 = q / (double)2;
        double discriminant = q2 * q2 + p3 * p3 * p3;
        double u1 = 0.0;
        double v1 = 0.0;
        double root1 = 0.0;
        double root2 = 0.0;
        double root3 = 0.0;
        if (discriminant < 0.0) {
            void $this$filterTo$iv$iv4;
            double mp3 = -p / (double)3;
            double mp33 = mp3 * mp3 * mp3;
            double r = Math.sqrt(mp33);
            double t = -q / ((double)2 * r);
            double cosphi = t < -1.0 ? -1.0 : (t > 1.0 ? 1.0 : t);
            double phi = Math.acos(cosphi);
            double crtr = RootsKt.cuberoot(r);
            double t1 = (double)2 * crtr;
            root1 = t1 * Math.cos(phi / (double)3) - a / (double)3;
            root2 = t1 * Math.cos((phi + Math.PI * 2) / (double)3) - a / (double)3;
            root3 = t1 * Math.cos((phi + Math.PI * 4) / (double)3) - a / (double)3;
            Double[] doubleArray = new Double[]{root1, root2, root3};
            Iterable $this$filter$iv = CollectionsKt.listOf(doubleArray);
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv4) {
                double p0 = ((Number)element$iv$iv).doubleValue();
                boolean bl = false;
                if (!RootsKt.accept(p0)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            return (List)destination$iv$iv;
        }
        if (discriminant == 0.0) {
            void $this$filterTo$iv$iv5;
            u1 = q2 < 0.0 ? RootsKt.cuberoot(-q2) : -RootsKt.cuberoot(q2);
            root1 = (double)2 * u1 - a / (double)3;
            root2 = -u1 - a / (double)3;
            Double[] mp3 = new Double[]{root1, root2};
            Iterable $this$filter$iv = CollectionsKt.listOf(mp3);
            boolean $i$f$filter = false;
            Iterable mp33 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv5) {
                double p0 = ((Number)element$iv$iv).doubleValue();
                boolean bl = false;
                if (!RootsKt.accept(p0)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            return (List)destination$iv$iv;
        }
        double sd = Math.sqrt(discriminant);
        u1 = RootsKt.cuberoot(sd - q2);
        v1 = RootsKt.cuberoot(sd + q2);
        root1 = u1 - v1 - a / (double)3;
        Iterable $this$filter$iv = CollectionsKt.listOf(root1);
        boolean $i$f$filter = false;
        Iterable $i$f$filterTo = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo3 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            double p0 = ((Number)element$iv$iv).doubleValue();
            boolean bl = false;
            if (!RootsKt.accept(p0)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }
}

