/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.extra.fft;

import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.openrndr.extra.fft.IdentityWindow;
import org.openrndr.extra.fft.WindowFunction;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0014\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u000f\n\u0002\u0010\u0015\n\u0002\b\u000e\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u000bH\u0002J\u0010\u0010\u0017\u001a\u00020\u00182\b\b\u0002\u0010\u0019\u001a\u00020\u001aJ\u0018\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\u001d2\b\b\u0002\u0010\u0019\u001a\u00020\u001aJ\u000e\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u0016\u001a\u00020\u0003J\u000e\u0010\u001f\u001a\u00020\u001d2\u0006\u0010\u0016\u001a\u00020\u0003J\u0016\u0010 \u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u00032\u0006\u0010!\u001a\u00020\u0018J\u0016\u0010\"\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u001c\u001a\u00020\u001dJ\b\u0010#\u001a\u00020\u0014H\u0002J\u0010\u0010$\u001a\u00020\u00142\u0006\u0010%\u001a\u00020\u000bH\u0002J\u000e\u0010&\u001a\u00020\u00142\u0006\u0010'\u001a\u00020\u000bJ\u0016\u0010&\u001a\u00020\u00142\u0006\u0010'\u001a\u00020\u000b2\u0006\u0010(\u001a\u00020\u0003J\u0016\u0010&\u001a\u00020\u00142\u0006\u0010)\u001a\u00020\u000b2\u0006\u0010*\u001a\u00020\u000bJ\u000e\u0010+\u001a\u00020\u00142\u0006\u0010'\u001a\u00020\u000bJ\b\u00102\u001a\u00020-H\u0002J\u0018\u00103\u001a\u00020\u00142\u0006\u0010%\u001a\u00020\u000b2\u0006\u0010(\u001a\u00020\u0003H\u0002J\b\u00104\u001a\u00020\u0014H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\r\"\u0004\b\u0012\u0010\u000fR\u001b\u0010,\u001a\u00020-8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b0\u00101\u001a\u0004\b.\u0010/R\u001b\u00105\u001a\u00020\u000b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b7\u00101\u001a\u0004\b6\u0010\rR\u001b\u00108\u001a\u00020\u000b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b:\u00101\u001a\u0004\b9\u0010\r\u00a8\u0006;"}, d2={"Lorg/openrndr/extra/fft/FFT;", "", "size", "", "windowFunction", "Lorg/openrndr/extra/fft/WindowFunction;", "<init>", "(ILorg/openrndr/extra/fft/WindowFunction;)V", "getSize", "()I", "real", "", "getReal", "()[F", "setReal", "([F)V", "imag", "getImag", "setImag", "setComplex", "", "r", "i", "magnitudeSum", "", "includeDC", "", "scaleAll", "sr", "", "magnitude", "phase", "shiftPhase", "shift", "scaleBand", "fft", "doWindow", "samples", "forward", "buffer", "startAt", "buffReal", "buffImag", "inverse", "reverse", "", "getReverse", "()[I", "reverse$delegate", "Lkotlin/Lazy;", "buildReverseTable", "bitReverseSamples", "bitReverseComplex", "sin", "getSin", "sin$delegate", "cos", "getCos", "cos$delegate", "orx-fft"})
public final class FFT {
    private final int size;
    @NotNull
    private final WindowFunction windowFunction;
    @NotNull
    private float[] real;
    @NotNull
    private float[] imag;
    @NotNull
    private final Lazy reverse$delegate;
    @NotNull
    private final Lazy sin$delegate;
    @NotNull
    private final Lazy cos$delegate;

    public FFT(int size, @NotNull WindowFunction windowFunction) {
        Intrinsics.checkNotNullParameter(windowFunction, "windowFunction");
        this.size = size;
        this.windowFunction = windowFunction;
        this.real = new float[this.size];
        this.imag = new float[this.size];
        this.reverse$delegate = LazyKt.lazy(() -> FFT.reverse_delegate$lambda$0(this));
        this.sin$delegate = LazyKt.lazy(() -> FFT.sin_delegate$lambda$1(this));
        this.cos$delegate = LazyKt.lazy(() -> FFT.cos_delegate$lambda$2(this));
    }

    public /* synthetic */ FFT(int n, WindowFunction windowFunction, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            windowFunction = new IdentityWindow();
        }
        this(n, windowFunction);
    }

    public final int getSize() {
        return this.size;
    }

    @NotNull
    public final float[] getReal() {
        return this.real;
    }

    public final void setReal(@NotNull float[] fArray) {
        Intrinsics.checkNotNullParameter(fArray, "<set-?>");
        this.real = fArray;
    }

    @NotNull
    public final float[] getImag() {
        return this.imag;
    }

    public final void setImag(@NotNull float[] fArray) {
        Intrinsics.checkNotNullParameter(fArray, "<set-?>");
        this.imag = fArray;
    }

    private final void setComplex(float[] r, float[] i) {
        if (this.real.length != r.length && this.imag.length != i.length) {
            throw new IllegalStateException("FourierTransform.setComplex: the two arrays must be the same length as their member counterparts.".toString());
        }
        ArraysKt.copyInto$default(r, this.real, 0, 0, 0, 14, null);
        ArraysKt.copyInto$default(i, this.imag, 0, 0, 0, 14, null);
    }

    public final double magnitudeSum(boolean includeDC) {
        int n;
        double sum = 0.0;
        int i = includeDC ? 0 : 1;
        if (i <= (n = this.size / 2)) {
            while (true) {
                sum += (double)this.magnitude(i);
                if (i == n) break;
                ++i;
            }
        }
        return sum;
    }

    public static /* synthetic */ double magnitudeSum$default(FFT fFT, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return fFT.magnitudeSum(bl);
    }

    public final void scaleAll(float sr, boolean includeDC) {
        int n;
        int i = includeDC ? 0 : 1;
        if (i <= (n = this.size / 2)) {
            while (true) {
                this.scaleBand(i, sr);
                if (i == n) break;
                ++i;
            }
        }
    }

    public static /* synthetic */ void scaleAll$default(FFT fFT, float f, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        fFT.scaleAll(f, bl);
    }

    public final float magnitude(int i) {
        return (float)Math.sqrt(this.real[i] * this.real[i] + this.imag[i] * this.imag[i]);
    }

    public final float phase(int i) {
        return (float)Math.atan2(this.imag[i], this.real[i]);
    }

    public final void shiftPhase(int i, double shift) {
        float m = this.magnitude(i);
        float phase = this.phase(i);
        this.real[i] = (float)(Math.cos((double)phase + shift) * (double)m);
        this.imag[i] = (float)(Math.sin((double)phase + shift) * (double)m);
        if (i != 0 && i != this.size / 2) {
            this.real[this.size - i] = this.real[i];
            this.imag[this.size - i] = -this.imag[i];
        }
    }

    public final void scaleBand(int i, float sr) {
        if (sr < 0.0f) {
            throw new IllegalStateException("Can't scale a frequency band by a negative value.".toString());
        }
        float[] fArray = this.real;
        fArray[i] = fArray[i] * sr;
        fArray = this.imag;
        fArray[i] = fArray[i] * sr;
        if (i != 0 && i != this.size / 2) {
            this.real[this.size - i] = this.real[i];
            this.imag[this.size - i] = -this.imag[i];
        }
    }

    private final void fft() {
        for (int halfSize = 1; halfSize < this.real.length; halfSize *= 2) {
            float phaseShiftStepR = this.getCos()[halfSize];
            float phaseShiftStepI = this.getSin()[halfSize];
            float currentPhaseShiftR = 1.0f;
            float currentPhaseShiftI = 0.0f;
            int n = halfSize;
            for (int fftStep = 0; fftStep < n; ++fftStep) {
                for (int i = fftStep; i < this.real.length; i += 2 * halfSize) {
                    int off = i + halfSize;
                    float tr = currentPhaseShiftR * this.real[off] - currentPhaseShiftI * this.imag[off];
                    float ti = currentPhaseShiftR * this.imag[off] + currentPhaseShiftI * this.real[off];
                    this.real[off] = this.real[i] - tr;
                    this.imag[off] = this.imag[i] - ti;
                    float[] fArray = this.real;
                    int n2 = i;
                    fArray[n2] = fArray[n2] + tr;
                    fArray = this.imag;
                    n2 = i;
                    fArray[n2] = fArray[n2] + ti;
                }
                float tmpR = currentPhaseShiftR;
                currentPhaseShiftR = tmpR * phaseShiftStepR - currentPhaseShiftI * phaseShiftStepI;
                currentPhaseShiftI = tmpR * phaseShiftStepI + currentPhaseShiftI * phaseShiftStepR;
            }
        }
    }

    private final void doWindow(float[] samples) {
        this.windowFunction.apply(samples);
    }

    public final void forward(@NotNull float[] buffer) {
        Intrinsics.checkNotNullParameter(buffer, "buffer");
        if (buffer.length != this.size) {
            throw new IllegalStateException("FFT.forward: The length of the passed sample buffer must be equal to timeSize().".toString());
        }
        this.doWindow(buffer);
        this.bitReverseSamples(buffer, 0);
        this.fft();
    }

    public final void forward(@NotNull float[] buffer, int startAt) {
        Intrinsics.checkNotNullParameter(buffer, "buffer");
        if (buffer.length - startAt < this.size) {
            throw new IllegalStateException(("FourierTransform.forward: not enough samples in the buffer between " + startAt + " and " + buffer.length + " to perform a transform.").toString());
        }
        this.windowFunction.apply(buffer, startAt, this.size);
        this.bitReverseSamples(buffer, startAt);
        this.fft();
    }

    public final void forward(@NotNull float[] buffReal, @NotNull float[] buffImag) {
        Intrinsics.checkNotNullParameter(buffReal, "buffReal");
        Intrinsics.checkNotNullParameter(buffImag, "buffImag");
        if (buffReal.length != this.size || buffImag.length != this.size) {
            throw new IllegalStateException("FFT.forward: The length of the passed buffers must be equal to timeSize().".toString());
        }
        this.setComplex(buffReal, buffImag);
        this.bitReverseComplex();
        this.fft();
    }

    public final void inverse(@NotNull float[] buffer) {
        Intrinsics.checkNotNullParameter(buffer, "buffer");
        if (buffer.length > this.real.length) {
            throw new IllegalStateException("FFT.inverse: the passed array's length must equal FFT.timeSize().".toString());
        }
        int i = 0;
        int n = this.size;
        while (i < n) {
            float[] fArray = this.imag;
            int n2 = i++;
            fArray[n2] = fArray[n2] * -1.0f;
        }
        this.bitReverseComplex();
        this.fft();
        n = buffer.length;
        for (i = 0; i < n; ++i) {
            buffer[i] = this.real[i] / (float)this.real.length;
        }
    }

    private final int[] getReverse() {
        Lazy lazy = this.reverse$delegate;
        return (int[])lazy.getValue();
    }

    private final int[] buildReverseTable() {
        int[] reverse = new int[this.size];
        reverse[0] = 0;
        int limit = 1;
        int bit = this.size / 2;
        while (limit < this.size) {
            int n = limit;
            for (int i = 0; i < n; ++i) {
                reverse[i + limit] = reverse[i] + bit;
            }
            limit <<= 1;
            bit >>= 1;
        }
        return reverse;
    }

    private final void bitReverseSamples(float[] samples, int startAt) {
        int n = this.size;
        for (int i = 0; i < n; ++i) {
            this.real[i] = samples[startAt + this.getReverse()[i]];
            this.imag[i] = 0.0f;
        }
    }

    private final void bitReverseComplex() {
        float[] revReal = new float[this.real.length];
        float[] revImag = new float[this.imag.length];
        int n = this.real.length;
        for (int i = 0; i < n; ++i) {
            revReal[i] = this.real[this.getReverse()[i]];
            revImag[i] = this.imag[this.getReverse()[i]];
        }
        this.real = revReal;
        this.imag = revImag;
    }

    private final float[] getSin() {
        Lazy lazy = this.sin$delegate;
        return (float[])lazy.getValue();
    }

    private final float[] getCos() {
        Lazy lazy = this.cos$delegate;
        return (float[])lazy.getValue();
    }

    private static final int[] reverse_delegate$lambda$0(FFT this$0) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        return this$0.buildReverseTable();
    }

    private static final float[] sin_delegate$lambda$1(FFT this$0) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        int n = 0;
        int n2 = this$0.size;
        float[] fArray = new float[n2];
        while (n < n2) {
            int n3 = n++;
            fArray[n3] = (float)Math.sin((float)(-Math.PI) / (float)n3);
        }
        return fArray;
    }

    private static final float[] cos_delegate$lambda$2(FFT this$0) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        int n = 0;
        int n2 = this$0.size;
        float[] fArray = new float[n2];
        while (n < n2) {
            int n3 = n++;
            fArray[n3] = (float)Math.cos((float)(-Math.PI) / (float)n3);
        }
        return fArray;
    }
}

