/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.extra.fx.blur;

import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openrndr.draw.ColorBuffer;
import org.openrndr.draw.ColorBufferKt;
import org.openrndr.draw.ColorFormat;
import org.openrndr.draw.ColorType;
import org.openrndr.draw.Filter1to1;
import org.openrndr.extra.fx.FilterToolsKt;
import org.openrndr.extra.parameters.Description;
import org.openrndr.extra.parameters.DoubleParameter;
import org.openrndr.extra.parameters.IntParameter;
import org.openrndr.math.Vector2;
import org.openrndr.shape.Rectangle;

@Description(title="Box-blur")
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u0006\n\u0002\b\r\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001:\u0001'B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J3\u0010\u001f\u001a\u00020 2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u001e0\"2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u001e0\"2\b\u0010$\u001a\u0004\u0018\u00010%H\u0016\u00a2\u0006\u0002\u0010&R1\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u00058F@FX\u0087\u008e\u0002\u00a2\u0006\u0018\n\u0004\b\f\u0010\r\u0012\u0004\b\u0007\u0010\u0003\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR1\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0004\u001a\u00020\u000e8F@FX\u0087\u008e\u0002\u00a2\u0006\u0018\n\u0004\b\u0015\u0010\r\u0012\u0004\b\u0010\u0010\u0003\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R1\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0004\u001a\u00020\u000e8F@FX\u0087\u008e\u0002\u00a2\u0006\u0018\n\u0004\b\u001a\u0010\r\u0012\u0004\b\u0017\u0010\u0003\u001a\u0004\b\u0018\u0010\u0012\"\u0004\b\u0019\u0010\u0014R\u001a\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u001e0\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lorg/openrndr/extra/fx/blur/BoxBlur;", "Lorg/openrndr/draw/Filter1to1;", "<init>", "()V", "<set-?>", "", "window", "getWindow$annotations", "getWindow", "()I", "setWindow", "(I)V", "window$delegate", "Ljava/util/Map;", "", "spread", "getSpread$annotations", "getSpread", "()D", "setSpread", "(D)V", "spread$delegate", "gain", "getGain$annotations", "getGain", "setGain", "gain$delegate", "intermediateCache", "", "Lorg/openrndr/extra/fx/blur/BoxBlur$ColorBufferDescription;", "Lorg/openrndr/draw/ColorBuffer;", "apply", "", "source", "", "target", "clip", "Lorg/openrndr/shape/Rectangle;", "([Lorg/openrndr/draw/ColorBuffer;[Lorg/openrndr/draw/ColorBuffer;Lorg/openrndr/shape/Rectangle;)V", "ColorBufferDescription", "orx-fx"})
@SourceDebugExtension(value={"SMAP\nBoxBlur.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BoxBlur.kt\norg/openrndr/extra/fx/blur/BoxBlur\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,65:1\n381#2,7:66\n*S KotlinDebug\n*F\n+ 1 BoxBlur.kt\norg/openrndr/extra/fx/blur/BoxBlur\n*L\n51#1:66,7\n*E\n"})
public final class BoxBlur
extends Filter1to1 {
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final Map window$delegate = this.getParameters();
    @NotNull
    private final Map spread$delegate = this.getParameters();
    @NotNull
    private final Map gain$delegate = this.getParameters();
    @NotNull
    private Map<ColorBufferDescription, ColorBuffer> intermediateCache = new LinkedHashMap();

    public BoxBlur() {
        super(FilterToolsKt.mppFilterShader("#ifdef OR_IN_OUT\nin vec2 v_texCoord0;\n#else\nvarying vec2 v_texCoord0;\n#endif\n\nuniform sampler2D tex0;\nuniform vec2 textureSize0;\nuniform vec2 blurDirection;\n\nuniform int window;\nuniform float sigma;\nuniform float gain;\nuniform vec4 subtract;\nuniform float spread;\n\nuniform bool wrapX;\nuniform bool wrapY;\n\n\n#ifndef OR_GL_FRAGCOLOR\nout vec4 o_color;\n#endif\n\nvec2 wrap(vec2 uv) {\n    vec2 res = uv;\n    if (wrapX) {\n        res.x = mod(res.x, 1.0);\n    }\n    if (wrapY) {\n        res.y = mod(res.y, 1.0);\n    }\n    return res;\n\n}\nvoid main() {\n    vec2 s = textureSize0;\n    s = vec2(1.0 / s.x, 1.0 / s.y);\n\n    #ifndef OR_WEBGL1\n    int w = window;\n    int WS = -window;\n    int WE = window;\n    #else\n    int w = 3;\n    #define WS -3\n    #define WE 3\n    #endif\n\n    vec4 sum = vec4(0.0, 0.0, 0.0, 0.0);\n    float weight = 0.0;\n    for (int x = WS; x<= WE; ++x) {\n        float lw = 1.0;\n        #ifndef OR_GL_TEXTURE2D\n        sum += texture(tex0, wrap(v_texCoord0 + float(x) * blurDirection * s * spread));\n        #else\n        sum += texture2D(tex0, wrap(v_texCoord0 + float(x) * blurDirection * s * spread));\n        #endif\n\n        weight += lw;\n    }\n\n    vec4 result = (sum / weight) * gain;\n    #ifdef OR_GL_FRAGCOLOR\n    gl_FragColor = result;\n    #else\n    o_color = result;\n    #endif\n}", "box-blur"), null, 2, null);
        this.setWindow(5);
        this.setSpread(1.0);
        this.setGain(1.0);
    }

    public final int getWindow() {
        Map map2 = this.window$delegate;
        return ((Number)MapsKt.getOrImplicitDefaultNullable(map2, $$delegatedProperties[0].getName())).intValue();
    }

    public final void setWindow(int n) {
        Map map2 = this.window$delegate;
        KProperty<Object> kProperty = $$delegatedProperties[0];
        Integer n2 = n;
        map2.put(kProperty.getName(), n2);
    }

    @IntParameter(label="window size", low=1, high=25)
    public static /* synthetic */ void getWindow$annotations() {
    }

    public final double getSpread() {
        Map map2 = this.spread$delegate;
        return ((Number)MapsKt.getOrImplicitDefaultNullable(map2, $$delegatedProperties[1].getName())).doubleValue();
    }

    public final void setSpread(double d) {
        Map map2 = this.spread$delegate;
        KProperty<Object> kProperty = $$delegatedProperties[1];
        Double d2 = d;
        map2.put(kProperty.getName(), d2);
    }

    @DoubleParameter(label="kernel spread", low=1.0, high=4.0)
    public static /* synthetic */ void getSpread$annotations() {
    }

    public final double getGain() {
        Map map2 = this.gain$delegate;
        return ((Number)MapsKt.getOrImplicitDefaultNullable(map2, $$delegatedProperties[2].getName())).doubleValue();
    }

    public final void setGain(double d) {
        Map map2 = this.gain$delegate;
        KProperty<Object> kProperty = $$delegatedProperties[2];
        Double d2 = d;
        map2.put(kProperty.getName(), d2);
    }

    @DoubleParameter(label="gain", low=0.0, high=4.0)
    public static /* synthetic */ void getGain$annotations() {
    }

    @Override
    public void apply(@NotNull ColorBuffer[] source, @NotNull ColorBuffer[] target, @Nullable Rectangle clip) {
        ColorBuffer colorBuffer;
        Intrinsics.checkNotNullParameter(source, "source");
        Intrinsics.checkNotNullParameter(target, "target");
        ColorBufferDescription intermediateDescription = new ColorBufferDescription(target[0].getWidth(), target[0].getHeight(), target[0].getContentScale(), target[0].getFormat(), target[0].getType());
        Map<ColorBufferDescription, ColorBuffer> $this$getOrPut$iv = this.intermediateCache;
        boolean $i$f$getOrPut = false;
        ColorBuffer value$iv = $this$getOrPut$iv.get(intermediateDescription);
        if (value$iv == null) {
            boolean bl = false;
            ColorBuffer answer$iv = ColorBufferKt.colorBuffer$default(target[0].getWidth(), target[0].getHeight(), target[0].getContentScale(), target[0].getFormat(), target[0].getType(), null, 0, null, 224, null);
            $this$getOrPut$iv.put(intermediateDescription, answer$iv);
            colorBuffer = answer$iv;
        } else {
            colorBuffer = value$iv;
        }
        ColorBuffer intermediate = colorBuffer;
        this.getParameters().put("wrapX", false);
        this.getParameters().put("wrapY", false);
        ColorBuffer it = intermediate;
        boolean bl = false;
        this.getParameters().put("blurDirection", new Vector2(1.0, 0.0));
        ColorBuffer[] colorBufferArray = new ColorBuffer[]{it};
        super.apply(source, colorBufferArray, clip);
        this.getParameters().put("blurDirection", new Vector2(0.0, 1.0));
        colorBufferArray = new ColorBuffer[]{it};
        super.apply(colorBufferArray, target, clip);
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.mutableProperty1(new MutablePropertyReference1Impl(BoxBlur.class, "window", "getWindow()I", 0)), Reflection.mutableProperty1(new MutablePropertyReference1Impl(BoxBlur.class, "spread", "getSpread()D", 0)), Reflection.mutableProperty1(new MutablePropertyReference1Impl(BoxBlur.class, "gain", "getGain()D", 0))};
        $$delegatedProperties = kPropertyArray;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\bH\u00c6\u0003J\t\u0010\u001a\u001a\u00020\nH\u00c6\u0003J;\u0010\u001b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\nH\u00c6\u0001J\u0013\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001f\u001a\u00020\u0003H\u00d6\u0001J\t\u0010 \u001a\u00020!H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\""}, d2={"Lorg/openrndr/extra/fx/blur/BoxBlur$ColorBufferDescription;", "", "width", "", "height", "contentScale", "", "format", "Lorg/openrndr/draw/ColorFormat;", "type", "Lorg/openrndr/draw/ColorType;", "<init>", "(IIDLorg/openrndr/draw/ColorFormat;Lorg/openrndr/draw/ColorType;)V", "getWidth", "()I", "getHeight", "getContentScale", "()D", "getFormat", "()Lorg/openrndr/draw/ColorFormat;", "getType", "()Lorg/openrndr/draw/ColorType;", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "hashCode", "toString", "", "orx-fx"})
    public static final class ColorBufferDescription {
        private final int width;
        private final int height;
        private final double contentScale;
        @NotNull
        private final ColorFormat format;
        @NotNull
        private final ColorType type;

        public ColorBufferDescription(int width, int height, double contentScale, @NotNull ColorFormat format, @NotNull ColorType type) {
            Intrinsics.checkNotNullParameter((Object)format, "format");
            Intrinsics.checkNotNullParameter((Object)type, "type");
            this.width = width;
            this.height = height;
            this.contentScale = contentScale;
            this.format = format;
            this.type = type;
        }

        public final int getWidth() {
            return this.width;
        }

        public final int getHeight() {
            return this.height;
        }

        public final double getContentScale() {
            return this.contentScale;
        }

        @NotNull
        public final ColorFormat getFormat() {
            return this.format;
        }

        @NotNull
        public final ColorType getType() {
            return this.type;
        }

        public final int component1() {
            return this.width;
        }

        public final int component2() {
            return this.height;
        }

        public final double component3() {
            return this.contentScale;
        }

        @NotNull
        public final ColorFormat component4() {
            return this.format;
        }

        @NotNull
        public final ColorType component5() {
            return this.type;
        }

        @NotNull
        public final ColorBufferDescription copy(int width, int height, double contentScale, @NotNull ColorFormat format, @NotNull ColorType type) {
            Intrinsics.checkNotNullParameter((Object)format, "format");
            Intrinsics.checkNotNullParameter((Object)type, "type");
            return new ColorBufferDescription(width, height, contentScale, format, type);
        }

        public static /* synthetic */ ColorBufferDescription copy$default(ColorBufferDescription colorBufferDescription, int n, int n2, double d, ColorFormat colorFormat, ColorType colorType, int n3, Object object) {
            if ((n3 & 1) != 0) {
                n = colorBufferDescription.width;
            }
            if ((n3 & 2) != 0) {
                n2 = colorBufferDescription.height;
            }
            if ((n3 & 4) != 0) {
                d = colorBufferDescription.contentScale;
            }
            if ((n3 & 8) != 0) {
                colorFormat = colorBufferDescription.format;
            }
            if ((n3 & 0x10) != 0) {
                colorType = colorBufferDescription.type;
            }
            return colorBufferDescription.copy(n, n2, d, colorFormat, colorType);
        }

        @NotNull
        public String toString() {
            return "ColorBufferDescription(width=" + this.width + ", height=" + this.height + ", contentScale=" + this.contentScale + ", format=" + this.format + ", type=" + this.type + ")";
        }

        public int hashCode() {
            int result2 = Integer.hashCode(this.width);
            result2 = result2 * 31 + Integer.hashCode(this.height);
            result2 = result2 * 31 + Double.hashCode(this.contentScale);
            result2 = result2 * 31 + this.format.hashCode();
            result2 = result2 * 31 + this.type.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ColorBufferDescription)) {
                return false;
            }
            ColorBufferDescription colorBufferDescription = (ColorBufferDescription)other;
            if (this.width != colorBufferDescription.width) {
                return false;
            }
            if (this.height != colorBufferDescription.height) {
                return false;
            }
            if (Double.compare(this.contentScale, colorBufferDescription.contentScale) != 0) {
                return false;
            }
            if (this.format != colorBufferDescription.format) {
                return false;
            }
            return this.type == colorBufferDescription.type;
        }
    }
}

