/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.extra.fx.blur;

import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.openrndr.draw.Filter1to1;
import org.openrndr.extra.fx.FilterToolsKt;
import org.openrndr.extra.parameters.Description;
import org.openrndr.extra.parameters.DoubleParameter;
import org.openrndr.extra.parameters.IntParameter;

@Description(title="Hash blur")
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0006\n\u0002\b\u000b\n\u0002\u0010\b\n\u0002\b\r\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R+\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u00058B@BX\u0082\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u000b\u0010\f\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR1\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0004\u001a\u00020\r8F@FX\u0087\u008e\u0002\u00a2\u0006\u0018\n\u0004\b\u0014\u0010\f\u0012\u0004\b\u000f\u0010\u0003\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R+\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0004\u001a\u00020\r8F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u0018\u0010\f\u001a\u0004\b\u0016\u0010\u0011\"\u0004\b\u0017\u0010\u0013R1\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u0004\u001a\u00020\u00198F@FX\u0087\u008e\u0002\u00a2\u0006\u0018\n\u0004\b \u0010\f\u0012\u0004\b\u001b\u0010\u0003\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR1\u0010!\u001a\u00020\r2\u0006\u0010\u0004\u001a\u00020\r8F@FX\u0087\u008e\u0002\u00a2\u0006\u0018\n\u0004\b%\u0010\f\u0012\u0004\b\"\u0010\u0003\u001a\u0004\b#\u0010\u0011\"\u0004\b$\u0010\u0013\u00a8\u0006&"}, d2={"Lorg/openrndr/extra/fx/blur/HashBlur;", "Lorg/openrndr/draw/Filter1to1;", "<init>", "()V", "<set-?>", "", "dynamic", "getDynamic", "()Z", "setDynamic", "(Z)V", "dynamic$delegate", "Ljava/util/Map;", "", "radius", "getRadius$annotations", "getRadius", "()D", "setRadius", "(D)V", "radius$delegate", "time", "getTime", "setTime", "time$delegate", "", "samples", "getSamples$annotations", "getSamples", "()I", "setSamples", "(I)V", "samples$delegate", "gain", "getGain$annotations", "getGain", "setGain", "gain$delegate", "orx-fx"})
public final class HashBlur
extends Filter1to1 {
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final Map dynamic$delegate = this.getParameters();
    @NotNull
    private final Map radius$delegate = this.getParameters();
    @NotNull
    private final Map time$delegate = this.getParameters();
    @NotNull
    private final Map samples$delegate = this.getParameters();
    @NotNull
    private final Map gain$delegate = this.getParameters();

    public HashBlur() {
        super(FilterToolsKt.mppFilterShader("// based on Hashed blur by David Hoskins.\n// License Creative Commons Attribution-NonCommercial-ShareAlike 3.0 Unported License.\n\n#ifdef OR_IN_OUT\nin vec2 v_texCoord0;\n#else\nvarying vec2 v_texCoord0;\n#endif\n\nuniform sampler2D tex0;\nuniform sampler2D tex1;\nuniform vec2 textureSize0;\nuniform float radius;\nuniform float time;\nuniform int samples;\nuniform float gain;\nuniform bool dynamic;\n\n#ifndef OR_GL_FRAGCOLOR\nout vec4 o_color;\n#endif\n\n#define TAU 6.28318530718\n\n//-------------------------------------------------------------------------------------------\n#define HASHSCALE 443.8975\nvec2 hash22(vec2 p) {\n\tvec3 p3 = fract(vec3(p.xyx) * HASHSCALE);\n\tp3 += dot(p3, p3.yzx+19.19);\n\treturn fract(vec2((p3.x + p3.y)*p3.z, (p3.x+p3.z)*p3.y));\n}\n\nvec2 sampleTexture(inout vec2 r) {\n\tr = fract(r * vec2(33.3983, 43.4427));\n\t//return r-.5;\n\treturn sqrt(r.x+.001) * vec2(sin(r.y * TAU), cos(r.y * TAU))*.5; // <<=== circular sampling.\n}\n\n\n//-------------------------------------------------------------------------------------------\nvec4 blur(vec2 uv, float radius) {\n\tfloat r = radius;\n\tif (dynamic) {\n\t\tr *= texture(tex1, uv).r;\n\t}\n\n\tvec2 circle = vec2(r) * (vec2(1.0) / textureSize0);\n\tvec2 random = hash22(uv + vec2(time));\n\n\tvec4 acc = vec4(0.0);\n\n\tfor (int i = 0; i < samples; i++) {\n\t\tacc += texture(tex0, uv + circle * sampleTexture(random));\n\t}\n\treturn acc / float(samples);\n}\n\n//-------------------------------------------------------------------------------------------\nvoid main() {\n\tvec2 uv = v_texCoord0;\n\tfloat radiusSqr = pow(radius, 2.0);\n\n\tvec4 result = blur(uv, radiusSqr);\n\tresult.rgb *= gain;\n\n\t#ifdef OR_GL_FRAGCOLOR\n\tgl_FragColor = result;\n\t#else\n\to_color = result;\n\t#endif\n}", "hash-blur"), null, 2, null);
        this.setDynamic(false);
        this.setRadius(5.0);
        this.setTime(0.0);
        this.setSamples(30);
        this.setGain(1.0);
    }

    private final boolean getDynamic() {
        Map map2 = this.dynamic$delegate;
        return (Boolean)MapsKt.getOrImplicitDefaultNullable(map2, $$delegatedProperties[0].getName());
    }

    private final void setDynamic(boolean bl) {
        Map map2 = this.dynamic$delegate;
        KProperty<Object> kProperty = $$delegatedProperties[0];
        Boolean bl2 = bl;
        map2.put(kProperty.getName(), bl2);
    }

    public final double getRadius() {
        Map map2 = this.radius$delegate;
        return ((Number)MapsKt.getOrImplicitDefaultNullable(map2, $$delegatedProperties[1].getName())).doubleValue();
    }

    public final void setRadius(double d) {
        Map map2 = this.radius$delegate;
        KProperty<Object> kProperty = $$delegatedProperties[1];
        Double d2 = d;
        map2.put(kProperty.getName(), d2);
    }

    @DoubleParameter(label="blur radius", low=1.0, high=25.0)
    public static /* synthetic */ void getRadius$annotations() {
    }

    public final double getTime() {
        Map map2 = this.time$delegate;
        return ((Number)MapsKt.getOrImplicitDefaultNullable(map2, $$delegatedProperties[2].getName())).doubleValue();
    }

    public final void setTime(double d) {
        Map map2 = this.time$delegate;
        KProperty<Object> kProperty = $$delegatedProperties[2];
        Double d2 = d;
        map2.put(kProperty.getName(), d2);
    }

    public final int getSamples() {
        Map map2 = this.samples$delegate;
        return ((Number)MapsKt.getOrImplicitDefaultNullable(map2, $$delegatedProperties[3].getName())).intValue();
    }

    public final void setSamples(int n) {
        Map map2 = this.samples$delegate;
        KProperty<Object> kProperty = $$delegatedProperties[3];
        Integer n2 = n;
        map2.put(kProperty.getName(), n2);
    }

    @IntParameter(label="number of samples", low=1, high=100)
    public static /* synthetic */ void getSamples$annotations() {
    }

    public final double getGain() {
        Map map2 = this.gain$delegate;
        return ((Number)MapsKt.getOrImplicitDefaultNullable(map2, $$delegatedProperties[4].getName())).doubleValue();
    }

    public final void setGain(double d) {
        Map map2 = this.gain$delegate;
        KProperty<Object> kProperty = $$delegatedProperties[4];
        Double d2 = d;
        map2.put(kProperty.getName(), d2);
    }

    @DoubleParameter(label="image gain", low=0.0, high=2.0)
    public static /* synthetic */ void getGain$annotations() {
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.mutableProperty1(new MutablePropertyReference1Impl(HashBlur.class, "dynamic", "getDynamic()Z", 0)), Reflection.mutableProperty1(new MutablePropertyReference1Impl(HashBlur.class, "radius", "getRadius()D", 0)), Reflection.mutableProperty1(new MutablePropertyReference1Impl(HashBlur.class, "time", "getTime()D", 0)), Reflection.mutableProperty1(new MutablePropertyReference1Impl(HashBlur.class, "samples", "getSamples()I", 0)), Reflection.mutableProperty1(new MutablePropertyReference1Impl(HashBlur.class, "gain", "getGain()D", 0))};
        $$delegatedProperties = kPropertyArray;
    }
}

