/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.extra.fx.blur;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openrndr.draw.ColorBuffer;
import org.openrndr.draw.ColorBufferKt;
import org.openrndr.draw.ColorType;
import org.openrndr.draw.Filter;
import org.openrndr.draw.Filter1to1;
import org.openrndr.extra.fx.FilterToolsKt;
import org.openrndr.extra.fx.blur.BloomCombine;
import org.openrndr.extra.fx.blur.BloomDownscale;
import org.openrndr.extra.fx.blur.BloomUpscale;
import org.openrndr.extra.parameters.BooleanParameter;
import org.openrndr.extra.parameters.Description;
import org.openrndr.extra.parameters.DoubleParameter;
import org.openrndr.filter.color.ColorFiltersKt;
import org.openrndr.filter.color.Linearize;
import org.openrndr.shape.Rectangle;

@Description(title="MipBloom")
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\u0017\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003B\u000f\u0012\u0006\u0010\u0004\u001a\u00028\u0000\u00a2\u0006\u0004\b\u0005\u0010\u0006J3\u0010G\u001a\u00020H2\f\u0010I\u001a\b\u0012\u0004\u0012\u0002010J2\f\u0010K\u001a\b\u0012\u0004\u0012\u0002010J2\b\u0010L\u001a\u0004\u0018\u00010MH\u0016\u00a2\u0006\u0002\u0010NR\u0013\u0010\u0004\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\t\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR$\u0010\u0010\u001a\u00020\u00118\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R$\u0010\u0018\u001a\u00020\u00118\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u0019\u0010\u0013\u001a\u0004\b\u001a\u0010\u0015\"\u0004\b\u001b\u0010\u0017R$\u0010\u001c\u001a\u00020\u00118\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u001d\u0010\u0013\u001a\u0004\b\u001e\u0010\u0015\"\u0004\b\u001f\u0010\u0017R$\u0010 \u001a\u00020\u00118\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b!\u0010\u0013\u001a\u0004\b\"\u0010\u0015\"\u0004\b#\u0010\u0017R$\u0010$\u001a\u00020\u00118\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b%\u0010\u0013\u001a\u0004\b&\u0010\u0015\"\u0004\b'\u0010\u0017R$\u0010(\u001a\u00020)8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b*\u0010\u0013\u001a\u0004\b+\u0010,\"\u0004\b-\u0010.R \u0010/\u001a\b\u0012\u0004\u0012\u00020100X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b2\u00103\"\u0004\b4\u00105R\u001c\u00106\u001a\u0004\u0018\u000101X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b7\u00108\"\u0004\b9\u0010:R\u0011\u0010;\u001a\u00020<\u00a2\u0006\b\n\u0000\u001a\u0004\b=\u0010>R\u0011\u0010?\u001a\u00020@\u00a2\u0006\b\n\u0000\u001a\u0004\bA\u0010BR\u0011\u0010C\u001a\u00020D\u00a2\u0006\b\n\u0000\u001a\u0004\bE\u0010F\u00a8\u0006O"}, d2={"Lorg/openrndr/extra/fx/blur/MipBloom;", "T", "Lorg/openrndr/draw/Filter;", "Lorg/openrndr/draw/Filter1to1;", "blur", "<init>", "(Lorg/openrndr/draw/Filter;)V", "getBlur", "()Lorg/openrndr/draw/Filter;", "Lorg/openrndr/draw/Filter;", "passes", "", "getPasses", "()I", "setPasses", "(I)V", "shape", "", "getShape$annotations", "()V", "getShape", "()D", "setShape", "(D)V", "gain", "getGain$annotations", "getGain", "setGain", "pregain", "getPregain$annotations", "getPregain", "setPregain", "noiseGain", "getNoiseGain$annotations", "getNoiseGain", "setNoiseGain", "noiseSeed", "getNoiseSeed$annotations", "getNoiseSeed", "setNoiseSeed", "sRGB", "", "getSRGB$annotations", "getSRGB", "()Z", "setSRGB", "(Z)V", "intermediates", "", "Lorg/openrndr/draw/ColorBuffer;", "getIntermediates", "()Ljava/util/List;", "setIntermediates", "(Ljava/util/List;)V", "sourceCopy", "getSourceCopy", "()Lorg/openrndr/draw/ColorBuffer;", "setSourceCopy", "(Lorg/openrndr/draw/ColorBuffer;)V", "upscale", "Lorg/openrndr/extra/fx/blur/BloomUpscale;", "getUpscale", "()Lorg/openrndr/extra/fx/blur/BloomUpscale;", "downScale", "Lorg/openrndr/extra/fx/blur/BloomDownscale;", "getDownScale", "()Lorg/openrndr/extra/fx/blur/BloomDownscale;", "combine", "Lorg/openrndr/extra/fx/blur/BloomCombine;", "getCombine", "()Lorg/openrndr/extra/fx/blur/BloomCombine;", "apply", "", "source", "", "target", "clip", "Lorg/openrndr/shape/Rectangle;", "([Lorg/openrndr/draw/ColorBuffer;[Lorg/openrndr/draw/ColorBuffer;Lorg/openrndr/shape/Rectangle;)V", "orx-fx"})
@SourceDebugExtension(value={"SMAP\nMipBloom.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MipBloom.kt\norg/openrndr/extra/fx/blur/MipBloom\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,176:1\n1863#2,2:177\n37#3,2:179\n*S KotlinDebug\n*F\n+ 1 MipBloom.kt\norg/openrndr/extra/fx/blur/MipBloom\n*L\n97#1:177,2\n124#1:179,2\n*E\n"})
public class MipBloom<T extends Filter>
extends Filter1to1 {
    @NotNull
    private final T blur;
    private int passes;
    private double shape;
    private double gain;
    private double pregain;
    private double noiseGain;
    private double noiseSeed;
    private boolean sRGB;
    @NotNull
    private List<ColorBuffer> intermediates;
    @Nullable
    private ColorBuffer sourceCopy;
    @NotNull
    private final BloomUpscale upscale;
    @NotNull
    private final BloomDownscale downScale;
    @NotNull
    private final BloomCombine combine;

    public MipBloom(@NotNull T blur) {
        Intrinsics.checkNotNullParameter(blur, "blur");
        super(FilterToolsKt.mppFilterShader("out vec4 o_output;\nin vec2 v_texCoord0;\n\nuniform sampler2D tex0;\nuniform sampler2D tex1;\n\nuniform float gain;\nuniform float pregain;\nuniform vec4 bias;\n\nvoid main() {\n\to_output = texture(tex0, v_texCoord0) * pregain +  texture(tex1, v_texCoord0)*gain;\n\to_output.a = clamp(o_output.a, 0.0, 1.0);\n}", "bloom-combine"), null, 2, null);
        this.blur = blur;
        this.passes = 6;
        this.shape = 1.0;
        this.gain = 1.0;
        this.pregain = 1.0;
        this.noiseGain = 0.25;
        this.sRGB = true;
        this.intermediates = new ArrayList();
        this.upscale = new BloomUpscale();
        this.downScale = new BloomDownscale();
        this.combine = new BloomCombine();
    }

    @NotNull
    public final T getBlur() {
        return this.blur;
    }

    public final int getPasses() {
        return this.passes;
    }

    public final void setPasses(int n) {
        this.passes = n;
    }

    public final double getShape() {
        return this.shape;
    }

    public final void setShape(double d) {
        this.shape = d;
    }

    @DoubleParameter(label="shape", low=0.0, high=4.0)
    public static /* synthetic */ void getShape$annotations() {
    }

    public final double getGain() {
        return this.gain;
    }

    public final void setGain(double d) {
        this.gain = d;
    }

    @DoubleParameter(label="gain", low=0.0, high=4.0)
    public static /* synthetic */ void getGain$annotations() {
    }

    public final double getPregain() {
        return this.pregain;
    }

    public final void setPregain(double d) {
        this.pregain = d;
    }

    @DoubleParameter(label="pregain", low=0.0, high=4.0)
    public static /* synthetic */ void getPregain$annotations() {
    }

    public final double getNoiseGain() {
        return this.noiseGain;
    }

    public final void setNoiseGain(double d) {
        this.noiseGain = d;
    }

    @DoubleParameter(label="noise gain", low=0.0, high=1.0)
    public static /* synthetic */ void getNoiseGain$annotations() {
    }

    public final double getNoiseSeed() {
        return this.noiseSeed;
    }

    public final void setNoiseSeed(double d) {
        this.noiseSeed = d;
    }

    @DoubleParameter(label="noise seed", low=0.0, high=1000.0)
    public static /* synthetic */ void getNoiseSeed$annotations() {
    }

    public final boolean getSRGB() {
        return this.sRGB;
    }

    public final void setSRGB(boolean bl) {
        this.sRGB = bl;
    }

    @BooleanParameter(label="sRGB")
    public static /* synthetic */ void getSRGB$annotations() {
    }

    @NotNull
    public final List<ColorBuffer> getIntermediates() {
        return this.intermediates;
    }

    public final void setIntermediates(@NotNull List<ColorBuffer> list) {
        Intrinsics.checkNotNullParameter(list, "<set-?>");
        this.intermediates = list;
    }

    @Nullable
    public final ColorBuffer getSourceCopy() {
        return this.sourceCopy;
    }

    public final void setSourceCopy(@Nullable ColorBuffer colorBuffer) {
        this.sourceCopy = colorBuffer;
    }

    @NotNull
    public final BloomUpscale getUpscale() {
        return this.upscale;
    }

    @NotNull
    public final BloomDownscale getDownScale() {
        return this.downScale;
    }

    @NotNull
    public final BloomCombine getCombine() {
        return this.combine;
    }

    @Override
    public void apply(@NotNull ColorBuffer[] source, @NotNull ColorBuffer[] target, @Nullable Rectangle clip) {
        int $i$f$forEach;
        ColorBuffer colorBuffer;
        Intrinsics.checkNotNullParameter(source, "source");
        Intrinsics.checkNotNullParameter(target, "target");
        if (!(clip == null)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        ColorBuffer colorBuffer2 = this.sourceCopy;
        if (colorBuffer2 != null) {
            ColorBuffer it = colorBuffer2;
            boolean bl = false;
            if (!ColorBufferKt.isEquivalentTo$default(it, source[0], false, false, false, false, true, false, false, 222, null)) {
                it.destroy();
                this.sourceCopy = null;
            }
        }
        if (this.sourceCopy == null) {
            this.sourceCopy = ColorBufferKt.createEquivalent$default(source[0], 0, 0, 0.0, null, ColorType.FLOAT16, null, 0, 111, null);
        }
        ColorBuffer colorBuffer3 = source[0];
        ColorBuffer colorBuffer4 = this.sourceCopy;
        Intrinsics.checkNotNull(colorBuffer4);
        ColorBuffer.copyTo$default(colorBuffer3, colorBuffer4, 0, 0, null, 14, null);
        this.upscale.setShape(this.shape);
        if (this.intermediates.size() != this.passes || !((Collection)this.intermediates).isEmpty() && !ColorBufferKt.isEquivalentTo$default(colorBuffer = this.intermediates.get(0), target[0], false, false, false, true, true, false, false, 206, null)) {
            Iterable $this$forEach$iv = this.intermediates;
            $i$f$forEach = 0;
            for (Object element$iv : $this$forEach$iv) {
                ColorBuffer it = (ColorBuffer)element$iv;
                boolean bl = false;
                it.destroy();
            }
            this.intermediates.clear();
            $i$f$forEach = this.passes;
            for (int pass = 0; pass < $i$f$forEach; ++pass) {
                int tdiv = 1 << pass + 1;
                ColorBuffer cb = ColorBufferKt.colorBuffer$default(target[0].getWidth() / tdiv, target[0].getHeight() / tdiv, 0.0, null, ColorType.FLOAT16, null, 0, null, 236, null);
                this.intermediates.add(cb);
            }
        }
        if (this.sRGB) {
            Linearize linearize = ColorFiltersKt.getLinearize();
            ColorBuffer colorBuffer5 = this.sourceCopy;
            Intrinsics.checkNotNull(colorBuffer5);
            ColorBuffer colorBuffer6 = this.sourceCopy;
            Intrinsics.checkNotNull(colorBuffer6);
            linearize.apply(colorBuffer5, colorBuffer6, clip);
        }
        this.upscale.setNoiseGain(this.noiseGain);
        this.upscale.setNoiseSeed(this.noiseSeed);
        ColorBuffer colorBuffer7 = this.sourceCopy;
        Intrinsics.checkNotNull(colorBuffer7);
        this.downScale.apply(colorBuffer7, this.intermediates.get(0), clip);
        ((Filter)this.blur).apply(this.intermediates.get(0), this.intermediates.get(0), clip);
        $i$f$forEach = this.passes;
        for (int pass = 1; pass < $i$f$forEach; ++pass) {
            this.downScale.apply(this.intermediates.get(pass - 1), this.intermediates.get(pass), clip);
            ((Filter)this.blur).apply(this.intermediates.get(pass), this.intermediates.get(pass), clip);
        }
        Collection $this$toTypedArray$iv = this.intermediates;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        ColorBuffer[] colorBufferArray = new ColorBuffer[]{target[0]};
        this.upscale.apply(thisCollection$iv.toArray(new ColorBuffer[0]), colorBufferArray, clip);
        this.combine.setGain(this.gain);
        this.combine.setPregain(this.pregain);
        colorBufferArray = new ColorBuffer[2];
        Intrinsics.checkNotNull(this.sourceCopy);
        colorBufferArray[1] = target[0];
        this.combine.apply(colorBufferArray, target, clip);
        if (this.sRGB) {
            ColorFiltersKt.getDelinearize().apply(target[0], target[0], clip);
        }
    }
}

