/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.extra.fx.color;

import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.openrndr.draw.Filter1to1;
import org.openrndr.extra.fx.FilterToolsKt;
import org.openrndr.extra.parameters.BooleanParameter;
import org.openrndr.extra.parameters.Description;
import org.openrndr.extra.parameters.DoubleParameter;

@Description(title="Color correction")
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b!\n\u0002\u0010\u000b\n\u0002\b\b\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R1\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u00058F@FX\u0087\u008e\u0002\u00a2\u0006\u0018\n\u0004\b\f\u0010\r\u0012\u0004\b\u0007\u0010\u0003\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR1\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u00058F@FX\u0087\u008e\u0002\u00a2\u0006\u0018\n\u0004\b\u0012\u0010\r\u0012\u0004\b\u000f\u0010\u0003\u001a\u0004\b\u0010\u0010\t\"\u0004\b\u0011\u0010\u000bR1\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u00058F@FX\u0087\u008e\u0002\u00a2\u0006\u0018\n\u0004\b\u0017\u0010\r\u0012\u0004\b\u0014\u0010\u0003\u001a\u0004\b\u0015\u0010\t\"\u0004\b\u0016\u0010\u000bR1\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u00058F@FX\u0087\u008e\u0002\u00a2\u0006\u0018\n\u0004\b\u001c\u0010\r\u0012\u0004\b\u0019\u0010\u0003\u001a\u0004\b\u001a\u0010\t\"\u0004\b\u001b\u0010\u000bR1\u0010\u001d\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u00058F@FX\u0087\u008e\u0002\u00a2\u0006\u0018\n\u0004\b!\u0010\r\u0012\u0004\b\u001e\u0010\u0003\u001a\u0004\b\u001f\u0010\t\"\u0004\b \u0010\u000bR1\u0010\"\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u00058F@FX\u0087\u008e\u0002\u00a2\u0006\u0018\n\u0004\b&\u0010\r\u0012\u0004\b#\u0010\u0003\u001a\u0004\b$\u0010\t\"\u0004\b%\u0010\u000bR1\u0010(\u001a\u00020'2\u0006\u0010\u0004\u001a\u00020'8F@FX\u0087\u008e\u0002\u00a2\u0006\u0018\n\u0004\b.\u0010\r\u0012\u0004\b)\u0010\u0003\u001a\u0004\b*\u0010+\"\u0004\b,\u0010-\u00a8\u0006/"}, d2={"Lorg/openrndr/extra/fx/color/ColorCorrection;", "Lorg/openrndr/draw/Filter1to1;", "<init>", "()V", "<set-?>", "", "brightness", "getBrightness$annotations", "getBrightness", "()D", "setBrightness", "(D)V", "brightness$delegate", "Ljava/util/Map;", "contrast", "getContrast$annotations", "getContrast", "setContrast", "contrast$delegate", "saturation", "getSaturation$annotations", "getSaturation", "setSaturation", "saturation$delegate", "hueShift", "getHueShift$annotations", "getHueShift", "setHueShift", "hueShift$delegate", "gamma", "getGamma$annotations", "getGamma", "setGamma", "gamma$delegate", "opacity", "getOpacity$annotations", "getOpacity", "setOpacity", "opacity$delegate", "", "clamped", "getClamped$annotations", "getClamped", "()Z", "setClamped", "(Z)V", "clamped$delegate", "orx-fx"})
public final class ColorCorrection
extends Filter1to1 {
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final Map brightness$delegate = this.getParameters();
    @NotNull
    private final Map contrast$delegate = this.getParameters();
    @NotNull
    private final Map saturation$delegate = this.getParameters();
    @NotNull
    private final Map hueShift$delegate = this.getParameters();
    @NotNull
    private final Map gamma$delegate = this.getParameters();
    @NotNull
    private final Map opacity$delegate = this.getParameters();
    @NotNull
    private final Map clamped$delegate = this.getParameters();

    public ColorCorrection() {
        super(FilterToolsKt.mppFilterShader("/* based on \"Brightness, contrast, saturation\" by WojtaZam: https://www.shadertoy.com/view/XdcXzn */\nuniform float brightness;\nuniform float saturation;\nuniform float contrast;\nuniform float hueShift;\nuniform float gamma;\nuniform float opacity;\nuniform bool clamped;\n\nuniform sampler2D tex0;\nin vec2 v_texCoord0;\nout vec4 o_color;\n\nmat4 brightnessMatrix(float brightness) {\n    return mat4(1, 0, 0, 0,\n    0, 1, 0, 0,\n    0, 0, 1, 0,\n    brightness, brightness, brightness, 1);\n}\n\nmat4 contrastMatrix(float contrast) {\n    float t = (1.0 - contrast) / 2.0;\n    return mat4(contrast, 0, 0, 0,\n    0, contrast, 0, 0,\n    0, 0, contrast, 0,\n    t, t, t, 1 );\n}\n\nmat4 saturationMatrix(float saturation) {\n    vec3 luminance = vec3(0.3086, 0.6094, 0.0820);\n    float oneMinusSat = 1.0 - saturation;\n    vec3 red = vec3(luminance.x * oneMinusSat);\n    red += vec3(saturation, 0, 0);\n\n    vec3 green = vec3(luminance.y * oneMinusSat);\n    green += vec3(0, saturation, 0);\n\n    vec3 blue = vec3(luminance.z * oneMinusSat);\n    blue += vec3(0, 0, saturation);\n\n    return mat4(red, 0,\n        green, 0,\n        blue, 0,\n        0, 0, 0, 1 );\n}\n\n// from starea's https://www.shadertoy.com/view/MdjBRy, which in turn remixed it from mAlk's https://www.shadertoy.com/view/MsjXRt\nvec3 shiftHue(in vec3 col, in float Shift) {\n    vec3 P = vec3(0.55735) * dot(vec3(0.55735), col);\n    vec3 U = col - P;\n    vec3 V = cross(vec3(0.55735), U);\n    col = U * cos(Shift * 6.2832) + V * sin(Shift * 6.2832) + P;\n    return col;\n}\n\nvoid main() {\n    vec4 color = texture(tex0, v_texCoord0);\n    vec4 nc = (color.a == 0.0) ? vec4(0.0) : vec4(color.rgb / color.a, color.a);\n    nc.rgb = pow(nc.rgb, vec3(gamma));\n    nc.rgb = shiftHue(nc.rgb, (hueShift/360.0));\n    vec4 cc = brightnessMatrix(brightness) * contrastMatrix((contrast + 1.0)) * saturationMatrix(saturation + 1.0) * nc;\n    if(clamped) {\n        o_color = clamp(vec4(cc.rgb, 1.0) * color.a * opacity, 0.0, 1.0);\n    } else {\n        o_color = vec4(cc.rgb, 1.0) * color.a * opacity;\n    }\n}", "color-correction"), null, 2, null);
        this.setContrast(0.0);
        this.setBrightness(0.0);
        this.setSaturation(0.0);
        this.setHueShift(0.0);
        this.setGamma(1.0);
        this.setOpacity(1.0);
        this.setClamped(true);
    }

    public final double getBrightness() {
        Map map2 = this.brightness$delegate;
        return ((Number)MapsKt.getOrImplicitDefaultNullable(map2, $$delegatedProperties[0].getName())).doubleValue();
    }

    public final void setBrightness(double d) {
        Map map2 = this.brightness$delegate;
        KProperty<Object> kProperty = $$delegatedProperties[0];
        Double d2 = d;
        map2.put(kProperty.getName(), d2);
    }

    @DoubleParameter(label="brightness", low=-1.0, high=1.0, order=0)
    public static /* synthetic */ void getBrightness$annotations() {
    }

    public final double getContrast() {
        Map map2 = this.contrast$delegate;
        return ((Number)MapsKt.getOrImplicitDefaultNullable(map2, $$delegatedProperties[1].getName())).doubleValue();
    }

    public final void setContrast(double d) {
        Map map2 = this.contrast$delegate;
        KProperty<Object> kProperty = $$delegatedProperties[1];
        Double d2 = d;
        map2.put(kProperty.getName(), d2);
    }

    @DoubleParameter(label="contrast", low=-1.0, high=1.0, order=1)
    public static /* synthetic */ void getContrast$annotations() {
    }

    public final double getSaturation() {
        Map map2 = this.saturation$delegate;
        return ((Number)MapsKt.getOrImplicitDefaultNullable(map2, $$delegatedProperties[2].getName())).doubleValue();
    }

    public final void setSaturation(double d) {
        Map map2 = this.saturation$delegate;
        KProperty<Object> kProperty = $$delegatedProperties[2];
        Double d2 = d;
        map2.put(kProperty.getName(), d2);
    }

    @DoubleParameter(label="saturation", low=-1.0, high=1.0, order=2)
    public static /* synthetic */ void getSaturation$annotations() {
    }

    public final double getHueShift() {
        Map map2 = this.hueShift$delegate;
        return ((Number)MapsKt.getOrImplicitDefaultNullable(map2, $$delegatedProperties[3].getName())).doubleValue();
    }

    public final void setHueShift(double d) {
        Map map2 = this.hueShift$delegate;
        KProperty<Object> kProperty = $$delegatedProperties[3];
        Double d2 = d;
        map2.put(kProperty.getName(), d2);
    }

    @DoubleParameter(label="hue shift", low=-180.0, high=180.0, order=3)
    public static /* synthetic */ void getHueShift$annotations() {
    }

    public final double getGamma() {
        Map map2 = this.gamma$delegate;
        return ((Number)MapsKt.getOrImplicitDefaultNullable(map2, $$delegatedProperties[4].getName())).doubleValue();
    }

    public final void setGamma(double d) {
        Map map2 = this.gamma$delegate;
        KProperty<Object> kProperty = $$delegatedProperties[4];
        Double d2 = d;
        map2.put(kProperty.getName(), d2);
    }

    @DoubleParameter(label="gamma", low=0.0, high=5.0, order=4)
    public static /* synthetic */ void getGamma$annotations() {
    }

    public final double getOpacity() {
        Map map2 = this.opacity$delegate;
        return ((Number)MapsKt.getOrImplicitDefaultNullable(map2, $$delegatedProperties[5].getName())).doubleValue();
    }

    public final void setOpacity(double d) {
        Map map2 = this.opacity$delegate;
        KProperty<Object> kProperty = $$delegatedProperties[5];
        Double d2 = d;
        map2.put(kProperty.getName(), d2);
    }

    @DoubleParameter(label="opacity", low=0.0, high=1.0, order=5)
    public static /* synthetic */ void getOpacity$annotations() {
    }

    public final boolean getClamped() {
        Map map2 = this.clamped$delegate;
        return (Boolean)MapsKt.getOrImplicitDefaultNullable(map2, $$delegatedProperties[6].getName());
    }

    public final void setClamped(boolean bl) {
        Map map2 = this.clamped$delegate;
        KProperty<Object> kProperty = $$delegatedProperties[6];
        Boolean bl2 = bl;
        map2.put(kProperty.getName(), bl2);
    }

    @BooleanParameter(label="clamp", order=6)
    public static /* synthetic */ void getClamped$annotations() {
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.mutableProperty1(new MutablePropertyReference1Impl(ColorCorrection.class, "brightness", "getBrightness()D", 0)), Reflection.mutableProperty1(new MutablePropertyReference1Impl(ColorCorrection.class, "contrast", "getContrast()D", 0)), Reflection.mutableProperty1(new MutablePropertyReference1Impl(ColorCorrection.class, "saturation", "getSaturation()D", 0)), Reflection.mutableProperty1(new MutablePropertyReference1Impl(ColorCorrection.class, "hueShift", "getHueShift()D", 0)), Reflection.mutableProperty1(new MutablePropertyReference1Impl(ColorCorrection.class, "gamma", "getGamma()D", 0)), Reflection.mutableProperty1(new MutablePropertyReference1Impl(ColorCorrection.class, "opacity", "getOpacity()D", 0)), Reflection.mutableProperty1(new MutablePropertyReference1Impl(ColorCorrection.class, "clamped", "getClamped()Z", 0))};
        $$delegatedProperties = kPropertyArray;
    }
}

