/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.extra.fx.color;

import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.openrndr.draw.Filter1to1;
import org.openrndr.extra.fx.FilterToolsKt;
import org.openrndr.extra.parameters.Description;
import org.openrndr.extra.parameters.DoubleParameter;

@Description(title="Pal TV Effect")
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0018\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R1\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u00058F@FX\u0087\u008e\u0002\u00a2\u0006\u0018\n\u0004\b\f\u0010\r\u0012\u0004\b\u0007\u0010\u0003\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR1\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u00058F@FX\u0087\u008e\u0002\u00a2\u0006\u0018\n\u0004\b\u0012\u0010\r\u0012\u0004\b\u000f\u0010\u0003\u001a\u0004\b\u0010\u0010\t\"\u0004\b\u0011\u0010\u000bR1\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u00058F@FX\u0087\u008e\u0002\u00a2\u0006\u0018\n\u0004\b\u0017\u0010\r\u0012\u0004\b\u0014\u0010\u0003\u001a\u0004\b\u0015\u0010\t\"\u0004\b\u0016\u0010\u000bR1\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u00058F@FX\u0087\u008e\u0002\u00a2\u0006\u0018\n\u0004\b\u001c\u0010\r\u0012\u0004\b\u0019\u0010\u0003\u001a\u0004\b\u001a\u0010\t\"\u0004\b\u001b\u0010\u000b\u00a8\u0006\u001d"}, d2={"Lorg/openrndr/extra/fx/color/Pal;", "Lorg/openrndr/draw/Filter1to1;", "<init>", "()V", "<set-?>", "", "amount", "getAmount$annotations", "getAmount", "()D", "setAmount", "(D)V", "amount$delegate", "Ljava/util/Map;", "pixelation", "getPixelation$annotations", "getPixelation", "setPixelation", "pixelation$delegate", "filter_gain", "getFilter_gain$annotations", "getFilter_gain", "setFilter_gain", "filter_gain$delegate", "filter_invgain", "getFilter_invgain$annotations", "getFilter_invgain", "setFilter_invgain", "filter_invgain$delegate", "orx-fx"})
public final class Pal
extends Filter1to1 {
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final Map amount$delegate = this.getParameters();
    @NotNull
    private final Map pixelation$delegate = this.getParameters();
    @NotNull
    private final Map filter_gain$delegate = this.getParameters();
    @NotNull
    private final Map filter_invgain$delegate = this.getParameters();

    public Pal() {
        super(FilterToolsKt.mppFilterShader("// based on https://github.com/svofski/CRT\n\nin vec2 v_texCoord0;\nuniform sampler2D tex0; // input\nuniform float amount;\nuniform float pixelation;\nout vec4 o_color;\n\n// Implementation by Evan Wallace (glfx.js)\n\nuniform float filter_gain; // 1.0 is kind of normal\nuniform float filter_invgain; // 1.6 is normal\n\n#define PI          3.14159265358\n#define FSC         4433618.75\n#define FLINE       15625\n#define VISIBLELINES 312\n\n#define RGB_to_YIQ  mat3x3( 0.299 , 0.595716 , 0.211456 ,   0.587    , -0.274453 , -0.522591 ,      0.114    , -0.321263 , 0.311135 )\n#define YIQ_to_RGB  mat3x3( 1.0   , 1.0      , 1.0      ,   0.9563   , -0.2721   , -1.1070   ,      0.6210   , -0.6474   , 1.7046   )\n\n#define RGB_to_YUV  mat3x3( 0.299 , -0.14713 , 0.615    ,   0.587    , -0.28886  , -0.514991 ,      0.114    , 0.436     , -0.10001 )\n#define YUV_to_RGB  mat3x3( 1.0   , 1.0      , 1.0      ,   0.0      , -0.39465  , 2.03211   ,      1.13983  , -0.58060  , 0.0      )\n\n#define fetch(ofs,center,invx) texture(tex0, vec2((ofs) * (invx) + center.x, center.y))\n\n#define FIRTAPS 20\nconst float FIR[FIRTAPS] = float[FIRTAPS] (-0.008030271,0.003107906,0.016841352,0.032545161,0.049360136,0.066256720,0.082120150,0.095848433,0.106453014,0.113151423,0.115441842,0.113151423,0.106453014,0.095848433,0.082120150,0.066256720,0.049360136,0.032545161,0.016841352,0.003107906);\n\n//#define FIR_GAIN 2.0\n//#define FIR_INVGAIN 1.02\n#define FIR_GAIN filter_gain\n#define FIR_INVGAIN filter_invgain\n\nfloat width_ratio;\nfloat height_ratio;\nfloat altv;\nfloat invx;\n\n\nfloat modulated(vec2 xy, float sinwt, float coswt) {\n    vec3 rgb = fetch(0.0, xy, invx).xyz;\n    vec3 yuv = RGB_to_YUV * rgb;\n\n    // scanline modulation hack\n    // yuv.x *= 0.8 + 0.2 * sin(xy.y*2.0*3.1415*200.0);\n\n    return clamp(yuv.x + yuv.y * sinwt + yuv.z * coswt, 0.0, 1.0);\n}\n\nvec2 modem_uv(vec2 xy, int ofs) {\n    float t = (xy.x + float(ofs) * invx) * float(textureSize(tex0, 0).x);\n    float wt = t * 2.0 * PI / width_ratio;\n\n    float sinwt = sin(wt);\n    float coswt = cos(wt + altv);\n\n    vec3 rgb = fetch(float(ofs), xy, invx).xyz;\n    vec3 yuv = RGB_to_YUV * rgb;\n    float signal = clamp(yuv.x + yuv.y * sinwt + yuv.z * coswt, 0.0, 1.0);\n\n    return vec2(signal * sinwt, signal * coswt);\n}\n\n\nvec3 shadow_mask(vec2 pos){\n    const mat2 rot = mat2(0.707,0.707,-0.707,0.707);\n    vec3 offset = vec3( 0. , 1./3. , 2./3. );\n    vec2 spos = pos * rot * vec2(200.0);\n    vec3 ret = vec3(1);\n    ret.r = length( fract( spos + vec2(offset.r) ) -.5);\n    ret.g = length( fract( spos + vec2(offset.g) ) -.5);\n    ret.b = length( fract( spos + vec2(offset.b) ) -.5);\n    return clamp( 1.5-ret*2.5 , 0.0, 1.0 );\n}\n\n//\n//void mainmaskImage(out vec4 fragColor, in vec2 fragCoord ){\n//    vec2 xy = fragCoord.st / iResolution.xy;\n//\n//    fragColor.rgb = shadow_mask( fragCoord.st/ iResolution.y ) * texture(iChannel0, xy).rgb;\n//\n//\n//    if ( fragCoord.y  > iResolution.y*.5 ) {\n//        fragColor = texture(iChannel0, xy);\n//    }\n//}\n\n\nvoid main() {\n    // vec2 xy = fragCoord.st / iResolution.xy;\n    vec2 xy = v_texCoord0;\n    width_ratio = float(textureSize(tex0, 0).x) / (float(FSC) / float(FLINE));\n    height_ratio = float(textureSize(tex0, 0).y) / float(VISIBLELINES);\n    altv = mod(floor(xy.y * float(VISIBLELINES) + 0.5), 2.0) * PI;\n    invx = 0.25 / (float(FSC)/float(FLINE)); // equals 4 samples per Fsc period\n\n    // lowpass U/V at baseband\n    vec2 filtered = vec2(0.0, 0.0);\n    for (int i = 0; i < FIRTAPS; i++) {\n        vec2 uv = modem_uv(xy, i - FIRTAPS/2);\n        filtered += FIR_GAIN * uv * FIR[i];\n    }\n\n    float t = xy.x * float(textureSize(tex0, 0).x);\n    float wt = t * 2.0 * PI / width_ratio;\n\n    float sinwt = sin(wt);\n    float coswt = cos(wt + altv);\n\n    float luma = modulated(xy, sinwt, coswt) - FIR_INVGAIN * (filtered.x * sinwt + filtered.y * coswt);\n    vec3 yuv_result = vec3(luma, filtered.x, filtered.y);\n\n    vec3 rgbmask = shadow_mask( xy * vec2(1.0, float(textureSize(tex0,0).x) / float(textureSize(tex0,0).y)) ); // needs anisotropy like: fragCoord.st/ iResolution.y );\n    rgbmask = vec3(1.0,1.0,1.0) * (1.0-pixelation) + rgbmask * pixelation;\n    o_color =  texture(tex0,xy) * (1.0-amount) + amount * vec4(rgbmask * ( YUV_to_RGB * yuv_result ), 1.0);\n\n//    if (xy.y>0.5) {\n//        o_color = texture(tex0, xy);\n//    }\n}", "pal"), null, 2, null);
        this.setAmount(1.0);
        this.setPixelation(0.0);
        this.setFilter_gain(1.0);
        this.setFilter_invgain(1.6);
    }

    public final double getAmount() {
        Map map2 = this.amount$delegate;
        return ((Number)MapsKt.getOrImplicitDefaultNullable(map2, $$delegatedProperties[0].getName())).doubleValue();
    }

    public final void setAmount(double d) {
        Map map2 = this.amount$delegate;
        KProperty<Object> kProperty = $$delegatedProperties[0];
        Double d2 = d;
        map2.put(kProperty.getName(), d2);
    }

    @DoubleParameter(label="amount", low=0.0, high=1.0)
    public static /* synthetic */ void getAmount$annotations() {
    }

    public final double getPixelation() {
        Map map2 = this.pixelation$delegate;
        return ((Number)MapsKt.getOrImplicitDefaultNullable(map2, $$delegatedProperties[1].getName())).doubleValue();
    }

    public final void setPixelation(double d) {
        Map map2 = this.pixelation$delegate;
        KProperty<Object> kProperty = $$delegatedProperties[1];
        Double d2 = d;
        map2.put(kProperty.getName(), d2);
    }

    @DoubleParameter(label="pixelation", low=0.0, high=1.0)
    public static /* synthetic */ void getPixelation$annotations() {
    }

    public final double getFilter_gain() {
        Map map2 = this.filter_gain$delegate;
        return ((Number)MapsKt.getOrImplicitDefaultNullable(map2, $$delegatedProperties[2].getName())).doubleValue();
    }

    public final void setFilter_gain(double d) {
        Map map2 = this.filter_gain$delegate;
        KProperty<Object> kProperty = $$delegatedProperties[2];
        Double d2 = d;
        map2.put(kProperty.getName(), d2);
    }

    @DoubleParameter(label="filter_gain", low=0.0, high=10.0)
    public static /* synthetic */ void getFilter_gain$annotations() {
    }

    public final double getFilter_invgain() {
        Map map2 = this.filter_invgain$delegate;
        return ((Number)MapsKt.getOrImplicitDefaultNullable(map2, $$delegatedProperties[3].getName())).doubleValue();
    }

    public final void setFilter_invgain(double d) {
        Map map2 = this.filter_invgain$delegate;
        KProperty<Object> kProperty = $$delegatedProperties[3];
        Double d2 = d;
        map2.put(kProperty.getName(), d2);
    }

    @DoubleParameter(label="filter_invgain", low=0.0, high=10.0)
    public static /* synthetic */ void getFilter_invgain$annotations() {
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.mutableProperty1(new MutablePropertyReference1Impl(Pal.class, "amount", "getAmount()D", 0)), Reflection.mutableProperty1(new MutablePropertyReference1Impl(Pal.class, "pixelation", "getPixelation()D", 0)), Reflection.mutableProperty1(new MutablePropertyReference1Impl(Pal.class, "filter_gain", "getFilter_gain()D", 0)), Reflection.mutableProperty1(new MutablePropertyReference1Impl(Pal.class, "filter_invgain", "getFilter_invgain()D", 0))};
        $$delegatedProperties = kPropertyArray;
    }
}

