/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.extra.fx.patterns;

import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.openrndr.color.ColorRGBa;
import org.openrndr.draw.Filter1to1;
import org.openrndr.extra.fx.FilterToolsKt;
import org.openrndr.extra.parameters.Description;
import org.openrndr.extra.parameters.DoubleParameter;

@Description(title="Checkers pattern")
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0006\n\u0002\b\r\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R+\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u00058F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u000b\u0010\f\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR+\u0010\r\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u00058F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u0010\u0010\f\u001a\u0004\b\u000e\u0010\b\"\u0004\b\u000f\u0010\nR1\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0004\u001a\u00020\u00118F@FX\u0087\u008e\u0002\u00a2\u0006\u0018\n\u0004\b\u0018\u0010\f\u0012\u0004\b\u0013\u0010\u0003\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R1\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u0004\u001a\u00020\u00118F@FX\u0087\u008e\u0002\u00a2\u0006\u0018\n\u0004\b\u001d\u0010\f\u0012\u0004\b\u001a\u0010\u0003\u001a\u0004\b\u001b\u0010\u0015\"\u0004\b\u001c\u0010\u0017\u00a8\u0006\u001e"}, d2={"Lorg/openrndr/extra/fx/patterns/Checkers;", "Lorg/openrndr/draw/Filter1to1;", "<init>", "()V", "<set-?>", "Lorg/openrndr/color/ColorRGBa;", "background", "getBackground", "()Lorg/openrndr/color/ColorRGBa;", "setBackground", "(Lorg/openrndr/color/ColorRGBa;)V", "background$delegate", "Ljava/util/Map;", "foreground", "getForeground", "setForeground", "foreground$delegate", "", "size", "getSize$annotations", "getSize", "()D", "setSize", "(D)V", "size$delegate", "opacity", "getOpacity$annotations", "getOpacity", "setOpacity", "opacity$delegate", "orx-fx"})
public final class Checkers
extends Filter1to1 {
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final Map background$delegate = this.getParameters();
    @NotNull
    private final Map foreground$delegate = this.getParameters();
    @NotNull
    private final Map size$delegate = this.getParameters();
    @NotNull
    private final Map opacity$delegate = this.getParameters();

    public Checkers() {
        super(FilterToolsKt.mppFilterShader("#ifdef OR_IN_OUT\nin vec2 v_texCoord0;\n#else\nvarying vec2 v_texCoord0;\n#endif\n\nuniform vec4 foreground;\nuniform vec4 background;\nuniform vec2 targetSize;\nuniform float size;\nuniform float opacity;\n\n#ifndef OR_GL_FRAGCOLOR\nout vec4 o_color;\n#endif\n\nvoid main() {\n    float r = targetSize.x / targetSize.y;\n    vec2 uv = v_texCoord0 - vec2(0.5);\n    uv.x *= r;\n\n    vec2 cell = (uv / size);\n    ivec2 cellIndex = ivec2(floor(cell));\n    vec2 cellUV = cell - vec2(cellIndex);\n\n    int c = (cellIndex.x + cellIndex.y) % 2;\n    vec2 w = fwidth(cell);\n\n    vec4 ca;\n    vec4 cb;\n    if (c == 0) {\n        ca = background;\n        cb = foreground;\n    } else {\n        ca = foreground;\n        cb = background;\n    }\n    float s = w.x;\n    float fx = smoothstep(s, 0.0, cellUV.x) + smoothstep(1.0 - s, 1.0, cellUV.x);\n    float fy = smoothstep(s, 0.0, cellUV.y) + smoothstep(1.0 - s, 1.0, cellUV.y);\n\n    vec4 result = mix(ca, cb, min(0.5, fx * 0.5 + fy * 0.5)) * opacity;\n\n    #ifndef OR_GL_FRAGCOLOR\n    o_color = result;\n    #else\n    gl_FragCoord = result;\n    #endif\n}", "checkers"), null, 2, null);
        this.setSize(0.015625);
        this.setOpacity(1.0);
        this.setForeground(ColorRGBa.Companion.getWHITE().shade(0.9));
        this.setBackground(ColorRGBa.Companion.getWHITE().shade(0.8));
    }

    @NotNull
    public final ColorRGBa getBackground() {
        Map map2 = this.background$delegate;
        return (ColorRGBa)MapsKt.getOrImplicitDefaultNullable(map2, $$delegatedProperties[0].getName());
    }

    public final void setBackground(@NotNull ColorRGBa colorRGBa) {
        Intrinsics.checkNotNullParameter(colorRGBa, "<set-?>");
        Map map2 = this.background$delegate;
        map2.put($$delegatedProperties[0].getName(), colorRGBa);
    }

    @NotNull
    public final ColorRGBa getForeground() {
        Map map2 = this.foreground$delegate;
        return (ColorRGBa)MapsKt.getOrImplicitDefaultNullable(map2, $$delegatedProperties[1].getName());
    }

    public final void setForeground(@NotNull ColorRGBa colorRGBa) {
        Intrinsics.checkNotNullParameter(colorRGBa, "<set-?>");
        Map map2 = this.foreground$delegate;
        map2.put($$delegatedProperties[1].getName(), colorRGBa);
    }

    public final double getSize() {
        Map map2 = this.size$delegate;
        return ((Number)MapsKt.getOrImplicitDefaultNullable(map2, $$delegatedProperties[2].getName())).doubleValue();
    }

    public final void setSize(double d) {
        Map map2 = this.size$delegate;
        KProperty<Object> kProperty = $$delegatedProperties[2];
        Double d2 = d;
        map2.put(kProperty.getName(), d2);
    }

    @DoubleParameter(label="size", low=0.0, high=1.0)
    public static /* synthetic */ void getSize$annotations() {
    }

    public final double getOpacity() {
        Map map2 = this.opacity$delegate;
        return ((Number)MapsKt.getOrImplicitDefaultNullable(map2, $$delegatedProperties[3].getName())).doubleValue();
    }

    public final void setOpacity(double d) {
        Map map2 = this.opacity$delegate;
        KProperty<Object> kProperty = $$delegatedProperties[3];
        Double d2 = d;
        map2.put(kProperty.getName(), d2);
    }

    @DoubleParameter(label="opacity", low=0.0, high=1.0)
    public static /* synthetic */ void getOpacity$annotations() {
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.mutableProperty1(new MutablePropertyReference1Impl(Checkers.class, "background", "getBackground()Lorg/openrndr/color/ColorRGBa;", 0)), Reflection.mutableProperty1(new MutablePropertyReference1Impl(Checkers.class, "foreground", "getForeground()Lorg/openrndr/color/ColorRGBa;", 0)), Reflection.mutableProperty1(new MutablePropertyReference1Impl(Checkers.class, "size", "getSize()D", 0)), Reflection.mutableProperty1(new MutablePropertyReference1Impl(Checkers.class, "opacity", "getOpacity()D", 0))};
        $$delegatedProperties = kPropertyArray;
    }
}

