/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.extra.imageFit;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.openrndr.draw.ColorBuffer;
import org.openrndr.draw.Drawer;
import org.openrndr.extra.imageFit.FitMethod;
import org.openrndr.math.Matrix44;
import org.openrndr.math.Vector2;
import org.openrndr.math.transforms.TransformBuilder;
import org.openrndr.math.transforms.TransformBuilderKt;
import org.openrndr.shape.Rectangle;
import org.openrndr.shape.RectangleKt;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u001a@\u0010\u0000\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0004\u001a\u00020\u00022\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u00062\b\b\u0002\u0010\b\u001a\u00020\t\u001a0\u0010\n\u001a\u00020\u000b*\u00020\u00022\u0006\u0010\u0004\u001a\u00020\u00022\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u00062\b\b\u0002\u0010\b\u001a\u00020\t\u001ad\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u0001*\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\u0010\u001a\u00020\u00062\b\b\u0002\u0010\u0011\u001a\u00020\u00062\b\b\u0002\u0010\u0012\u001a\u00020\u00062\b\b\u0002\u0010\u0013\u001a\u00020\u00062\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u00062\b\b\u0002\u0010\b\u001a\u00020\t\u001aF\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u0001*\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\u0014\u001a\u00020\u00022\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u00062\b\b\u0002\u0010\b\u001a\u00020\t\u00a8\u0006\u0015"}, d2={"fitRectangle", "Lkotlin/Pair;", "Lorg/openrndr/shape/Rectangle;", "src", "dest", "horizontalPosition", "", "verticalPosition", "fitMethod", "Lorg/openrndr/extra/imageFit/FitMethod;", "fit", "Lorg/openrndr/math/Matrix44;", "imageFit", "Lorg/openrndr/draw/Drawer;", "img", "Lorg/openrndr/draw/ColorBuffer;", "x", "y", "width", "height", "bounds", "orx-image-fit"})
public final class ImageFitKt {
    @NotNull
    public static final Pair<Rectangle, Rectangle> fitRectangle(@NotNull Rectangle src, @NotNull Rectangle dest, double horizontalPosition, double verticalPosition, @NotNull FitMethod fitMethod) {
        Intrinsics.checkNotNullParameter(src, "src");
        Intrinsics.checkNotNullParameter(dest, "dest");
        Intrinsics.checkNotNullParameter((Object)fitMethod, "fitMethod");
        Vector2 positionNorm = new Vector2(horizontalPosition, verticalPosition).times(0.5).plus(0.5);
        Vector2 vector2 = dest.dimensions().div(src.dimensions());
        double scaleX = vector2.component1();
        double scaleY = vector2.component2();
        return switch (WhenMappings.$EnumSwitchMapping$0[fitMethod.ordinal()]) {
            case 1 -> {
                Vector2 actualDimensions = dest.dimensions().div(Math.max(scaleX, scaleY));
                Rectangle actualSrc = new Rectangle(src.corner().plus(src.dimensions().minus(actualDimensions).times(positionNorm)), actualDimensions.x(), actualDimensions.y());
                yield new Pair<Rectangle, Rectangle>(actualSrc, dest);
            }
            case 2 -> {
                Vector2 actualDimensions = src.dimensions().times(Math.min(scaleX, scaleY));
                Rectangle actualDest = new Rectangle(dest.corner().plus(dest.dimensions().minus(actualDimensions).times(positionNorm)), actualDimensions.x(), actualDimensions.y());
                yield new Pair<Rectangle, Rectangle>(src, actualDest);
            }
            case 3 -> new Pair<Rectangle, Rectangle>(src, dest);
            case 4 -> {
                Rectangle actualSrc = new Rectangle(src.corner().plus(src.dimensions().minus(dest.dimensions()).times(positionNorm)), dest.width(), dest.height());
                yield new Pair<Rectangle, Rectangle>(actualSrc, dest);
            }
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    public static /* synthetic */ Pair fitRectangle$default(Rectangle rectangle, Rectangle rectangle2, double d, double d2, FitMethod fitMethod, int n, Object object) {
        if ((n & 4) != 0) {
            d = 0.0;
        }
        if ((n & 8) != 0) {
            d2 = 0.0;
        }
        if ((n & 0x10) != 0) {
            fitMethod = FitMethod.Cover;
        }
        return ImageFitKt.fitRectangle(rectangle, rectangle2, d, d2, fitMethod);
    }

    @NotNull
    public static final Matrix44 fit(@NotNull Rectangle $this$fit, @NotNull Rectangle dest, double horizontalPosition, double verticalPosition, @NotNull FitMethod fitMethod) {
        Intrinsics.checkNotNullParameter($this$fit, "<this>");
        Intrinsics.checkNotNullParameter(dest, "dest");
        Intrinsics.checkNotNullParameter((Object)fitMethod, "fitMethod");
        Pair<Rectangle, Rectangle> pair = ImageFitKt.fitRectangle($this$fit, dest, horizontalPosition, verticalPosition, fitMethod);
        Rectangle source = pair.component1();
        Rectangle target = pair.component2();
        return TransformBuilderKt.transform$default(null, arg_0 -> ImageFitKt.fit$lambda$0(target, source, arg_0), 1, null);
    }

    public static /* synthetic */ Matrix44 fit$default(Rectangle rectangle, Rectangle rectangle2, double d, double d2, FitMethod fitMethod, int n, Object object) {
        if ((n & 2) != 0) {
            d = 0.0;
        }
        if ((n & 4) != 0) {
            d2 = 0.0;
        }
        if ((n & 8) != 0) {
            fitMethod = FitMethod.Cover;
        }
        return ImageFitKt.fit(rectangle, rectangle2, d, d2, fitMethod);
    }

    @NotNull
    public static final Pair<Rectangle, Rectangle> imageFit(@NotNull Drawer $this$imageFit, @NotNull ColorBuffer img, double x, double y, double width, double height, double horizontalPosition, double verticalPosition, @NotNull FitMethod fitMethod) {
        Intrinsics.checkNotNullParameter($this$imageFit, "<this>");
        Intrinsics.checkNotNullParameter(img, "img");
        Intrinsics.checkNotNullParameter((Object)fitMethod, "fitMethod");
        return ImageFitKt.imageFit($this$imageFit, img, RectangleKt.Rectangle(x, y, width, height), horizontalPosition, verticalPosition, fitMethod);
    }

    public static /* synthetic */ Pair imageFit$default(Drawer drawer, ColorBuffer colorBuffer, double d, double d2, double d3, double d4, double d5, double d6, FitMethod fitMethod, int n, Object object) {
        if ((n & 2) != 0) {
            d = 0.0;
        }
        if ((n & 4) != 0) {
            d2 = 0.0;
        }
        if ((n & 8) != 0) {
            d3 = colorBuffer.getWidth();
        }
        if ((n & 0x10) != 0) {
            d4 = colorBuffer.getHeight();
        }
        if ((n & 0x20) != 0) {
            d5 = 0.0;
        }
        if ((n & 0x40) != 0) {
            d6 = 0.0;
        }
        if ((n & 0x80) != 0) {
            fitMethod = FitMethod.Cover;
        }
        return ImageFitKt.imageFit(drawer, colorBuffer, d, d2, d3, d4, d5, d6, fitMethod);
    }

    @NotNull
    public static final Pair<Rectangle, Rectangle> imageFit(@NotNull Drawer $this$imageFit, @NotNull ColorBuffer img, @NotNull Rectangle bounds, double horizontalPosition, double verticalPosition, @NotNull FitMethod fitMethod) {
        Intrinsics.checkNotNullParameter($this$imageFit, "<this>");
        Intrinsics.checkNotNullParameter(img, "img");
        Intrinsics.checkNotNullParameter(bounds, "bounds");
        Intrinsics.checkNotNullParameter((Object)fitMethod, "fitMethod");
        Pair<Rectangle, Rectangle> pair = ImageFitKt.fitRectangle(img.getBounds(), bounds, horizontalPosition, verticalPosition, fitMethod);
        Rectangle source = pair.component1();
        Rectangle target = pair.component2();
        $this$imageFit.image(img, source, target);
        return new Pair<Rectangle, Rectangle>(source, target);
    }

    public static /* synthetic */ Pair imageFit$default(Drawer drawer, ColorBuffer colorBuffer, Rectangle rectangle, double d, double d2, FitMethod fitMethod, int n, Object object) {
        if ((n & 2) != 0) {
            rectangle = colorBuffer.getBounds();
        }
        if ((n & 4) != 0) {
            d = 0.0;
        }
        if ((n & 8) != 0) {
            d2 = 0.0;
        }
        if ((n & 0x10) != 0) {
            fitMethod = FitMethod.Cover;
        }
        return ImageFitKt.imageFit(drawer, colorBuffer, rectangle, d, d2, fitMethod);
    }

    private static final Unit fit$lambda$0(Rectangle $target, Rectangle $source, TransformBuilder $this$transform) {
        Intrinsics.checkNotNullParameter($target, "$target");
        Intrinsics.checkNotNullParameter($source, "$source");
        Intrinsics.checkNotNullParameter($this$transform, "$this$transform");
        $this$transform.translate($target.corner());
        $this$transform.scale(Vector2.vector3$default($target.dimensions().div($source.dimensions()), 0.0, 0.0, 1.0, 3, null));
        $this$transform.translate($source.corner().unaryMinus());
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[FitMethod.values().length];
            try {
                nArray[FitMethod.Cover.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FitMethod.Contain.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FitMethod.Fill.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FitMethod.None.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

