/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.extra.integralimage;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openrndr.ResourceUrlKt;
import org.openrndr.draw.ColorBuffer;
import org.openrndr.draw.ColorBufferKt;
import org.openrndr.draw.ColorFormat;
import org.openrndr.draw.ColorType;
import org.openrndr.draw.Filter;
import org.openrndr.draw.FilterFunctions;
import org.openrndr.extra.fx.blend.Passthrough;
import org.openrndr.extra.integralimage.FastIntegralImageFilter;
import org.openrndr.math.Vector2;
import org.openrndr.shape.IntRectangleKt;
import org.openrndr.shape.Rectangle;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0016H\u0002J3\u0010\u0019\u001a\u00020\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00070\u001c2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00070\u001c2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0016\u00a2\u0006\u0002\u0010 R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001c\u0010\f\u001a\u0004\u0018\u00010\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\t\"\u0004\b\u000e\u0010\u000bR\u001c\u0010\u000f\u001a\u0004\u0018\u00010\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\t\"\u0004\b\u0011\u0010\u000bR\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lorg/openrndr/extra/integralimage/FastIntegralImage;", "Lorg/openrndr/draw/Filter;", "<init>", "()V", "passthrough", "Lorg/openrndr/extra/fx/blend/Passthrough;", "intermediate", "Lorg/openrndr/draw/ColorBuffer;", "getIntermediate", "()Lorg/openrndr/draw/ColorBuffer;", "setIntermediate", "(Lorg/openrndr/draw/ColorBuffer;)V", "sourceCropped", "getSourceCropped", "setSourceCropped", "targetPadded", "getTargetPadded", "setTargetPadded", "filter", "Lorg/openrndr/extra/integralimage/FastIntegralImageFilter;", "sampleCounts", "", "", "size", "sampleCountBase", "apply", "", "source", "", "target", "clip", "Lorg/openrndr/shape/Rectangle;", "([Lorg/openrndr/draw/ColorBuffer;[Lorg/openrndr/draw/ColorBuffer;Lorg/openrndr/shape/Rectangle;)V", "orx-integral-image"})
public final class FastIntegralImage
extends Filter {
    @NotNull
    private final Passthrough passthrough = new Passthrough();
    @Nullable
    private ColorBuffer intermediate;
    @Nullable
    private ColorBuffer sourceCropped;
    @Nullable
    private ColorBuffer targetPadded;
    @NotNull
    private final FastIntegralImageFilter filter = new FastIntegralImageFilter();

    public FastIntegralImage() {
        super(FilterFunctions.filterShaderFromUrl(ResourceUrlKt.resourceUrl$default("/shaders/gl3/integral-image.frag", null, 2, null)), null, 2, null);
    }

    @Nullable
    public final ColorBuffer getIntermediate() {
        return this.intermediate;
    }

    public final void setIntermediate(@Nullable ColorBuffer colorBuffer) {
        this.intermediate = colorBuffer;
    }

    @Nullable
    public final ColorBuffer getSourceCropped() {
        return this.sourceCropped;
    }

    public final void setSourceCropped(@Nullable ColorBuffer colorBuffer) {
        this.sourceCropped = colorBuffer;
    }

    @Nullable
    public final ColorBuffer getTargetPadded() {
        return this.targetPadded;
    }

    public final void setTargetPadded(@Nullable ColorBuffer colorBuffer) {
        this.targetPadded = colorBuffer;
    }

    private final List<Integer> sampleCounts(int size, int sampleCountBase) {
        List sampleCounts = new ArrayList();
        for (int remainder = size; remainder > 0; remainder /= sampleCountBase) {
            ((Collection)sampleCounts).add(remainder >= sampleCountBase ? sampleCountBase : remainder);
        }
        return sampleCounts;
    }

    @Override
    public void apply(@NotNull ColorBuffer[] source, @NotNull ColorBuffer[] target, @Nullable Rectangle clip) {
        int pass;
        ColorBuffer[] colorBufferArray;
        ColorBuffer[] colorBufferArray2;
        int recHeight;
        int recWidth;
        block20: {
            block22: {
                block21: {
                    Intrinsics.checkNotNullParameter(source, "source");
                    Intrinsics.checkNotNullParameter(target, "target");
                    if (!(clip == null)) {
                        String string = "Failed requirement.";
                        throw new IllegalArgumentException(string.toString());
                    }
                    if (!ColorBufferKt.isEquivalentTo$default(source[0], target[0], false, false, false, true, true, false, false, 206, null)) {
                        String string = "Failed requirement.";
                        throw new IllegalArgumentException(string.toString());
                    }
                    int npotx = (int)Math.ceil(MathKt.log((double)source[0].getEffectiveWidth(), 2.0));
                    int npoty = (int)Math.ceil(MathKt.log((double)source[0].getEffectiveHeight(), 2.0));
                    recWidth = 1 << npotx;
                    recHeight = 1 << npoty;
                    if (recWidth == source[0].getEffectiveWidth() && recHeight == source[0].getEffectiveHeight()) break block20;
                    ColorBuffer colorBuffer = this.sourceCropped;
                    boolean bl = colorBuffer != null ? colorBuffer.getEffectiveWidth() == recWidth : false;
                    if (!bl) break block21;
                    ColorBuffer colorBuffer2 = this.sourceCropped;
                    if (colorBuffer2 != null ? colorBuffer2.getEffectiveHeight() == recHeight : false) break block22;
                }
                ColorBuffer colorBuffer = this.sourceCropped;
                if (colorBuffer != null) {
                    colorBuffer.destroy();
                }
                ColorBuffer colorBuffer3 = this.targetPadded;
                if (colorBuffer3 != null) {
                    colorBuffer3.destroy();
                }
            }
            if (this.sourceCropped == null) {
                this.sourceCropped = ColorBufferKt.createEquivalent$default(source[0], recWidth, recHeight, 1.0, null, null, null, 0, 120, null);
                this.targetPadded = ColorBufferKt.createEquivalent$default(target[0], (int)((double)recWidth / target[0].getContentScale()), (int)((double)recHeight / target[0].getContentScale()), 1.0, null, null, null, 0, 120, null);
            }
            ColorBuffer colorBuffer = source[0];
            ColorBuffer colorBuffer4 = this.sourceCropped;
            Intrinsics.checkNotNull(colorBuffer4);
            ColorBuffer.copyTo$default(colorBuffer, colorBuffer4, 0, 0, IntRectangleKt.IntRectangle(0, 0, source[0].getEffectiveWidth(), source[0].getEffectiveHeight()), IntRectangleKt.IntRectangle(0, recHeight - source[0].getEffectiveHeight(), source[0].getEffectiveWidth(), source[0].getEffectiveHeight()), null, 38, null);
        }
        int sampleCountBase = 16;
        List<Integer> xSampleCounts = this.sampleCounts(recWidth, sampleCountBase);
        List<Integer> ySampleCounts = this.sampleCounts(recHeight, sampleCountBase);
        ColorBuffer li = this.intermediate;
        if (li == null || li.getEffectiveWidth() != recWidth || li.getEffectiveHeight() != recHeight) {
            ColorBuffer colorBuffer = this.intermediate;
            if (colorBuffer != null) {
                colorBuffer.destroy();
            }
            this.intermediate = ColorBufferKt.colorBuffer$default(recWidth, recHeight, 1.0, ColorFormat.RGBa, ColorType.FLOAT32, null, 0, null, 224, null);
        }
        ColorBuffer[][] colorBufferArrayArray = new ColorBuffer[2][];
        if (this.targetPadded == null) {
            colorBufferArray2 = target;
        } else {
            colorBufferArray = new ColorBuffer[1];
            Intrinsics.checkNotNull(this.targetPadded);
            colorBufferArray2 = colorBufferArray;
        }
        colorBufferArrayArray[0] = colorBufferArray2;
        colorBufferArray = new ColorBuffer[1];
        Intrinsics.checkNotNull(this.intermediate);
        colorBufferArrayArray[1] = colorBufferArray;
        ColorBuffer[][] targets = colorBufferArrayArray;
        int targetIndex = 0;
        this.filter.setSampleCountBase(sampleCountBase);
        this.filter.setPassDirection(Vector2.Companion.getUNIT_X());
        int n = ((Collection)xSampleCounts).size();
        for (pass = 0; pass < n; ++pass) {
            ColorBuffer[] colorBufferArray3;
            this.filter.setSampleCount(((Number)xSampleCounts.get(pass)).intValue());
            this.filter.setPassIndex(pass);
            Filter filter2 = this.filter;
            if (pass == 0) {
                if (this.sourceCropped == null) {
                    colorBufferArray3 = source;
                } else {
                    ColorBuffer[] colorBufferArray4 = new ColorBuffer[1];
                    Intrinsics.checkNotNull(this.sourceCropped);
                    colorBufferArray3 = colorBufferArray4;
                }
            } else {
                colorBufferArray3 = targets[targetIndex % 2];
            }
            Filter.apply$default(filter2, colorBufferArray3, targets[(targetIndex + 1) % 2], null, 4, null);
            ++targetIndex;
        }
        this.filter.setPassDirection(Vector2.Companion.getUNIT_Y());
        n = ((Collection)ySampleCounts).size();
        for (pass = 0; pass < n; ++pass) {
            this.filter.setSampleCount(((Number)ySampleCounts.get(pass)).intValue());
            this.filter.setPassIndex(pass);
            Filter.apply$default((Filter)this.filter, targets[targetIndex % 2], targets[(targetIndex + 1) % 2], null, 4, null);
            ++targetIndex;
        }
        if (targetIndex % 2 == 1) {
            Filter.apply$default((Filter)this.passthrough, targets[1], targets[0], null, 4, null);
        }
        if (this.targetPadded != null) {
            ColorBuffer colorBuffer = this.targetPadded;
            Intrinsics.checkNotNull(colorBuffer);
            ColorBuffer.copyTo$default(colorBuffer, target[0], 0, 0, IntRectangleKt.IntRectangle(0, recHeight - source[0].getEffectiveHeight(), source[0].getEffectiveWidth(), source[0].getEffectiveHeight()), IntRectangleKt.IntRectangle(0, 0, source[0].getEffectiveWidth(), source[0].getEffectiveHeight()), null, 38, null);
        }
    }
}

