/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.extra.marchingsquares;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.openrndr.math.IntVector2;
import org.openrndr.math.Vector2;
import org.openrndr.shape.LineSegment;
import org.openrndr.shape.Rectangle;
import org.openrndr.shape.ShapeContour;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u001a:\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0012\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00062\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a8\u0006\f"}, d2={"findContours", "", "Lorg/openrndr/shape/ShapeContour;", "f", "Lkotlin/Function1;", "Lorg/openrndr/math/Vector2;", "", "area", "Lorg/openrndr/shape/Rectangle;", "cellSize", "useInterpolation", "", "orx-marching-squares"})
@SourceDebugExtension(value={"SMAP\nMarchingSquares.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MarchingSquares.kt\norg/openrndr/extra/marchingsquares/MarchingSquaresKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,157:1\n295#2,2:158\n295#2,2:160\n381#3,7:162\n381#3,7:169\n*S KotlinDebug\n*F\n+ 1 MarchingSquares.kt\norg/openrndr/extra/marchingsquares/MarchingSquaresKt\n*L\n147#1:158,2\n149#1:160,2\n87#1:162,7\n88#1:169,7\n*E\n"})
public final class MarchingSquaresKt {
    @NotNull
    public static final List<ShapeContour> findContours(@NotNull Function1<? super Vector2, Double> f, @NotNull Rectangle area, double cellSize, boolean useInterpolation) {
        int n;
        Intrinsics.checkNotNullParameter(f, "f");
        Intrinsics.checkNotNullParameter(area, "area");
        List segments = new ArrayList();
        Map values2 = new LinkedHashMap();
        Map segmentsMap = new LinkedHashMap();
        int n2 = (int)(area.height() / cellSize);
        for (int y = 0; y < n2; ++y) {
            n = (int)(area.width() / cellSize);
            for (int x = 0; x < n; ++x) {
                values2.put(new IntVector2(x, y), f.invoke(new Vector2((double)x * cellSize + area.x(), (double)y * cellSize + area.y())));
            }
        }
        double zero2 = 0.0;
        n = (int)(area.height() / cellSize);
        for (int y = 0; y < n; ++y) {
            int n3 = (int)(area.width() / cellSize);
            block13: for (int x = 0; x < n3; ++x) {
                double d;
                double v10;
                double v00;
                if (x == 0 || y == 0) {
                    v0 = zero2;
                } else {
                    Double d2 = (Double)values2.get(new IntVector2(x, y));
                    v0 = v00 = d2 != null ? d2 : zero2;
                }
                if (y == 0) {
                    v2 = zero2;
                } else {
                    Double d3 = (Double)values2.get(new IntVector2(x + 1, y));
                    v2 = v10 = d3 != null ? d3 : zero2;
                }
                if (x == 0) {
                    d = zero2;
                } else {
                    Double d4 = (Double)values2.get(new IntVector2(x, y + 1));
                    d = d4 != null ? d4 : zero2;
                }
                double v01 = d;
                Double d5 = (Double)values2.get(new IntVector2(x + 1, y + 1));
                double v11 = d5 != null ? d5 : zero2;
                Vector2 p00 = new Vector2(x, y).times(cellSize).plus(area.corner());
                Vector2 p10 = new Vector2(x + 1, y).times(cellSize).plus(area.corner());
                Vector2 p01 = new Vector2(x, y + 1).times(cellSize).plus(area.corner());
                Vector2 p11 = new Vector2(x + 1, y + 1).times(cellSize).plus(area.corner());
                int index = (v00 >= 0.0 ? 1 : 0) + (v10 >= 0.0 ? 2 : 0) + (v01 >= 0.0 ? 4 : 0) + (v11 >= 0.0 ? 8 : 0);
                switch (index) {
                    case 0: 
                    case 15: {
                        continue block13;
                    }
                    case 1: 
                    case 14: {
                        MarchingSquaresKt.findContours$emitLine(segmentsMap, segments, useInterpolation, p00, p01, v00, v01, p00, p10, v00, v10);
                        continue block13;
                    }
                    case 2: 
                    case 13: {
                        MarchingSquaresKt.findContours$emitLine(segmentsMap, segments, useInterpolation, p00, p10, v00, v10, p10, p11, v10, v11);
                        continue block13;
                    }
                    case 3: 
                    case 12: {
                        MarchingSquaresKt.findContours$emitLine(segmentsMap, segments, useInterpolation, p00, p01, v00, v01, p10, p11, v10, v11);
                        continue block13;
                    }
                    case 4: 
                    case 11: {
                        MarchingSquaresKt.findContours$emitLine(segmentsMap, segments, useInterpolation, p00, p01, v00, v01, p01, p11, v01, v11);
                        continue block13;
                    }
                    case 5: 
                    case 10: {
                        MarchingSquaresKt.findContours$emitLine(segmentsMap, segments, useInterpolation, p00, p10, v00, v10, p01, p11, v01, v11);
                        continue block13;
                    }
                    case 6: 
                    case 9: {
                        MarchingSquaresKt.findContours$emitLine(segmentsMap, segments, useInterpolation, p00, p01, v00, v01, p00, p10, v00, v10);
                        MarchingSquaresKt.findContours$emitLine(segmentsMap, segments, useInterpolation, p01, p11, v01, v11, p10, p11, v10, v11);
                        continue block13;
                    }
                    case 7: 
                    case 8: {
                        MarchingSquaresKt.findContours$emitLine(segmentsMap, segments, useInterpolation, p01, p11, v01, v11, p10, p11, v10, v11);
                    }
                }
            }
        }
        Set processedSegments = new LinkedHashSet();
        List contours = new ArrayList();
        for (LineSegment segment : segments) {
            if (processedSegments.contains(segment)) continue;
            List collected = new ArrayList();
            LineSegment current = segment;
            boolean closed = true;
            Vector2 lastVertex = Vector2.Companion.getINFINITY();
            do {
                LineSegment lineSegment;
                LineSegment it;
                boolean $i$f$firstOrNull;
                Iterable $this$firstOrNull$iv;
                Intrinsics.checkNotNull(current);
                if (lastVertex.squaredDistanceTo(current.start()) > 1.0E-5) {
                    collected.add(current.start());
                }
                lastVertex = current.start();
                processedSegments.add(current);
                Object v = segmentsMap.get(current.start());
                Intrinsics.checkNotNull(v);
                if (((List)v).size() < 2) {
                    closed = false;
                }
                LineSegment hold = current;
                List list = (List)segmentsMap.get(current.start());
                if (list != null) {
                    Object v9;
                    block29: {
                        $this$firstOrNull$iv = list;
                        $i$f$firstOrNull = false;
                        for (Object element$iv : $this$firstOrNull$iv) {
                            it = (LineSegment)element$iv;
                            boolean bl = false;
                            if (!(!processedSegments.contains(it))) continue;
                            v9 = element$iv;
                            break block29;
                        }
                        v9 = null;
                    }
                    v10 = v9;
                } else {
                    v10 = current = null;
                }
                if (current != null) continue;
                List list2 = (List)segmentsMap.get(hold.end());
                if (list2 != null) {
                    Object v12;
                    block30: {
                        $this$firstOrNull$iv = list2;
                        $i$f$firstOrNull = false;
                        for (Object element$iv : $this$firstOrNull$iv) {
                            it = (LineSegment)element$iv;
                            boolean bl = false;
                            if (!(!processedSegments.contains(it))) continue;
                            v12 = element$iv;
                            break block30;
                        }
                        v12 = null;
                    }
                    lineSegment = v12;
                    continue;
                }
                lineSegment = current = null;
            } while (!Intrinsics.areEqual(current, segment) && current != null);
            contours.add(ShapeContour.Companion.fromPoints$default(ShapeContour.Companion, collected, closed, null, 4, null));
        }
        return contours;
    }

    public static /* synthetic */ List findContours$default(Function1 function1, Rectangle rectangle, double d, boolean bl, int n, Object object) {
        if ((n & 8) != 0) {
            bl = true;
        }
        return MarchingSquaresKt.findContours(function1, rectangle, d, bl);
    }

    private static final double findContours$blend(boolean $useInterpolation, double v1, double v2) {
        if ($useInterpolation) {
            double f2;
            if (!(v1 == v1 && v2 == v2)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            double f1 = Math.min(v1, v2);
            double v = -f1 / ((f2 = Math.max(v1, v2)) - f1);
            if (!(v == v)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            if (!(0.0 <= v ? v <= 1.0 : false)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            return f1 == v1 ? v : 1.0 - v;
        }
        return 0.5;
    }

    private static final void findContours$emitLine(Map<Vector2, List<LineSegment>> segmentsMap, List<LineSegment> segments, boolean $useInterpolation, Vector2 p00, Vector2 p01, double v00, double v01, Vector2 p10, Vector2 p11, double v10, double v11) {
        List list;
        List list2;
        double r0 = MarchingSquaresKt.findContours$blend($useInterpolation, v00, v01);
        double r1 = MarchingSquaresKt.findContours$blend($useInterpolation, v10, v11);
        Vector2 v0 = p00.mix(p01, r0);
        Vector2 v1 = p10.mix(p11, r1);
        LineSegment l0 = new LineSegment(v0, v1);
        Map<Vector2, List<LineSegment>> $this$getOrPut$iv = segmentsMap;
        boolean $i$f$getOrPut = false;
        List value$iv = $this$getOrPut$iv.get(v1);
        if (value$iv == null) {
            boolean bl = false;
            List answer$iv = new ArrayList();
            $this$getOrPut$iv.put(v1, answer$iv);
            list2 = answer$iv;
        } else {
            list2 = value$iv;
        }
        list2.add((LineSegment)l0);
        $this$getOrPut$iv = segmentsMap;
        $i$f$getOrPut = false;
        value$iv = $this$getOrPut$iv.get(v0);
        if (value$iv == null) {
            boolean bl = false;
            List answer$iv = new ArrayList();
            $this$getOrPut$iv.put(v0, answer$iv);
            list = answer$iv;
        } else {
            list = value$iv;
        }
        list.add((LineSegment)l0);
        segments.add(l0);
    }
}

