/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.extra.noise;

import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.openrndr.extra.noise.CubicNoise2DKt;
import org.openrndr.extra.noise.GradCoordKt;
import org.openrndr.extra.noise.InterpolationKt;
import org.openrndr.extra.noise.MathUtilsKt;
import org.openrndr.math.Vector2;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u001a\u001e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0001\u001a\u001e\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0001\u001a\u001e\u0010\u0007\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0001\u001a\u001e\u0010\b\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0001\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\n\u001a\u0016\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\n\u001a\u0016\u0010\u0007\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\n\u001a\u0016\u0010\b\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\n\u001a4\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u00012\u0014\b\u0002\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00010\u000e\"\u000e\u0010\u000b\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000\")\u0010\u000f\u001a\u001a\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00010\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\")\u0010\u0013\u001a\u001a\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00010\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0012\")\u0010\u0015\u001a\u001a\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00010\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0012\u00a8\u0006\u0017"}, d2={"cubic", "", "seed", "", "x", "y", "cubicLinear", "cubicQuintic", "cubicHermite", "position", "Lorg/openrndr/math/Vector2;", "CUBIC_2D_BOUNDING", "", "interpolator", "Lkotlin/Function1;", "cubicLinear2D", "Lkotlin/Function3;", "getCubicLinear2D", "()Lkotlin/jvm/functions/Function3;", "cubicQuintic2D", "getCubicQuintic2D", "cubicHermite2D", "getCubicHermite2D", "orx-noise"})
public final class CubicNoise2DKt {
    private static final float CUBIC_2D_BOUNDING = 0.44444445f;
    @NotNull
    private static final Function3<Integer, Double, Double, Double> cubicLinear2D = cubicLinear2D.1.INSTANCE;
    @NotNull
    private static final Function3<Integer, Double, Double, Double> cubicQuintic2D = cubicQuintic2D.1.INSTANCE;
    @NotNull
    private static final Function3<Integer, Double, Double, Double> cubicHermite2D = cubicHermite2D.1.INSTANCE;

    public static final double cubic(int seed, double x, double y) {
        return CubicNoise2DKt.cubic(seed, x, y, cubic.1.INSTANCE);
    }

    public static final double cubicLinear(int seed, double x, double y) {
        return CubicNoise2DKt.cubic(seed, x, y, cubicLinear.1.INSTANCE);
    }

    public static final double cubicQuintic(int seed, double x, double y) {
        return CubicNoise2DKt.cubic(seed, x, y, cubicQuintic.1.INSTANCE);
    }

    public static final double cubicHermite(int seed, double x, double y) {
        return CubicNoise2DKt.cubic(seed, x, y, cubicHermite.1.INSTANCE);
    }

    public static final double cubic(int seed, @NotNull Vector2 position) {
        Intrinsics.checkNotNullParameter(position, "position");
        return CubicNoise2DKt.cubic(seed, position.x(), position.y(), cubic.2.INSTANCE);
    }

    public static final double cubicLinear(int seed, @NotNull Vector2 position) {
        Intrinsics.checkNotNullParameter(position, "position");
        return CubicNoise2DKt.cubic(seed, position.x(), position.y(), cubicLinear.2.INSTANCE);
    }

    public static final double cubicQuintic(int seed, @NotNull Vector2 position) {
        Intrinsics.checkNotNullParameter(position, "position");
        return CubicNoise2DKt.cubic(seed, position.x(), position.y(), cubicQuintic.2.INSTANCE);
    }

    public static final double cubicHermite(int seed, @NotNull Vector2 position) {
        Intrinsics.checkNotNullParameter(position, "position");
        return CubicNoise2DKt.cubic(seed, position.x(), position.y(), cubicHermite.2.INSTANCE);
    }

    public static final double cubic(int seed, double x, double y, @NotNull Function1<? super Double, Double> interpolator) {
        Intrinsics.checkNotNullParameter(interpolator, "interpolator");
        int x1 = MathUtilsKt.fastFloor(x);
        int y1 = MathUtilsKt.fastFloor(y);
        int x0 = x1 - 1;
        int y0 = y1 - 1;
        int x2 = x1 + 1;
        int y2 = y1 + 1;
        int x3 = x1 + 2;
        int y3 = y1 + 2;
        double xs = ((Number)interpolator.invoke((Double)(x - (double)x1))).doubleValue();
        double ys = ((Number)interpolator.invoke((Double)(y - (double)y1))).doubleValue();
        return InterpolationKt.cubic(InterpolationKt.cubic(GradCoordKt.valCoord2D(seed, x0, y0), GradCoordKt.valCoord2D(seed, x1, y0), GradCoordKt.valCoord2D(seed, x2, y0), GradCoordKt.valCoord2D(seed, x3, y0), xs), InterpolationKt.cubic(GradCoordKt.valCoord2D(seed, x0, y1), GradCoordKt.valCoord2D(seed, x1, y1), GradCoordKt.valCoord2D(seed, x2, y1), GradCoordKt.valCoord2D(seed, x3, y1), xs), InterpolationKt.cubic(GradCoordKt.valCoord2D(seed, x0, y2), GradCoordKt.valCoord2D(seed, x1, y2), GradCoordKt.valCoord2D(seed, x2, y2), GradCoordKt.valCoord2D(seed, x3, y2), xs), InterpolationKt.cubic(GradCoordKt.valCoord2D(seed, x0, y3), GradCoordKt.valCoord2D(seed, x1, y3), GradCoordKt.valCoord2D(seed, x2, y3), GradCoordKt.valCoord2D(seed, x3, y3), xs), ys) * (double)0.44444445f;
    }

    public static /* synthetic */ double cubic$default(int n, double d, double d2, Function1 function1, int n2, Object object) {
        if ((n2 & 8) != 0) {
            function1 = cubic.3.INSTANCE;
        }
        return CubicNoise2DKt.cubic(n, d, d2, function1);
    }

    @NotNull
    public static final Function3<Integer, Double, Double, Double> getCubicLinear2D() {
        return cubicLinear2D;
    }

    @NotNull
    public static final Function3<Integer, Double, Double, Double> getCubicQuintic2D() {
        return cubicQuintic2D;
    }

    @NotNull
    public static final Function3<Integer, Double, Double, Double> getCubicHermite2D() {
        return cubicHermite2D;
    }
}

