/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.extra.noise;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.DoubleCompanionObject;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.RandomKt;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.openrndr.extra.noise.CubicNoise2DKt;
import org.openrndr.extra.noise.CubicNoise3DKt;
import org.openrndr.extra.noise.GaussianRandomKt;
import org.openrndr.extra.noise.PerlinNoise2DKt;
import org.openrndr.extra.noise.PerlinNoise3DKt;
import org.openrndr.extra.noise.RandomState;
import org.openrndr.extra.noise.SimplexNoise2DKt;
import org.openrndr.extra.noise.SimplexNoise3DKt;
import org.openrndr.extra.noise.SimplexNoise4DKt;
import org.openrndr.extra.noise.UniformRandomKt;
import org.openrndr.extra.noise.ValueNoise2DKt;
import org.openrndr.extra.noise.ValueNoise3DKt;
import org.openrndr.math.Vector2;
import org.openrndr.math.Vector3;
import org.openrndr.math.Vector4;
import org.openrndr.shape.Rectangle;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00a0\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002bcB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u0013H\u0002J\u0010\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\u0013H\u0002J\u0006\u0010\u001d\u001a\u00020\u001eJ\u0006\u0010\u001f\u001a\u00020\u001eJ\u0014\u0010 \u001a\u00020\u001e2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u001e0\"J\u0006\u0010#\u001a\u00020\u001eJ\u0006\u0010$\u001a\u00020\u001eJ\u001f\u0010%\u001a\u00020\u001e2\u0017\u0010!\u001a\u0013\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u001e0&\u00a2\u0006\u0002\b'J\u001a\u0010(\u001a\u00020\r2\b\b\u0002\u0010)\u001a\u00020\r2\b\b\u0002\u0010*\u001a\u00020\rJ\u0010\u0010+\u001a\u00020\r2\b\b\u0002\u0010*\u001a\u00020\rJ\u0010\u0010,\u001a\u00020\u000b2\b\b\u0002\u0010*\u001a\u00020\u000bJ\u001a\u0010-\u001a\u00020\u000b2\b\b\u0002\u0010)\u001a\u00020\u000b2\b\b\u0002\u0010*\u001a\u00020\u000bJ\u0010\u0010.\u001a\u00020\u000f2\b\b\u0002\u0010/\u001a\u00020\rJ\u001f\u00100\u001a\u0002H1\"\u0004\b\u0000\u001012\f\u00102\u001a\b\u0012\u0004\u0012\u0002H103\u00a2\u0006\u0002\u00104J-\u00100\u001a\u0002H1\"\u0004\b\u0000\u001012\f\u00102\u001a\b\u0012\u0004\u0012\u0002H1032\f\u00105\u001a\b\u0012\u0004\u0012\u0002H103\u00a2\u0006\u0002\u00106J8\u00100\u001a\b\u0012\u0004\u0012\u0002H107\"\u0004\b\u0000\u001012\f\u00102\u001a\b\u0012\u0004\u0012\u0002H1032\u000e\b\u0002\u00105\u001a\b\u0012\u0004\u0012\u0002H1032\u0006\u00108\u001a\u00020\u000bJ\u001a\u00109\u001a\u00020\r2\b\b\u0002\u0010:\u001a\u00020\r2\b\b\u0002\u0010;\u001a\u00020\rJ\u0016\u0010<\u001a\b\u0012\u0004\u0012\u00020\r0\"2\b\b\u0002\u0010=\u001a\u00020\rJ\u001a\u0010>\u001a\u00020?2\b\b\u0002\u0010)\u001a\u00020\r2\b\b\u0002\u0010*\u001a\u00020\rJ\u001a\u0010@\u001a\u00020A2\b\b\u0002\u0010)\u001a\u00020\r2\b\b\u0002\u0010*\u001a\u00020\rJ\u001a\u0010B\u001a\u00020C2\b\b\u0002\u0010)\u001a\u00020\r2\b\b\u0002\u0010*\u001a\u00020\rJ \u0010D\u001a\u00020\r2\u0006\u0010E\u001a\u00020\r2\u0006\u0010F\u001a\u00020\r2\b\b\u0002\u0010G\u001a\u00020HJ\u0018\u0010D\u001a\u00020\r2\u0006\u0010I\u001a\u00020?2\b\b\u0002\u0010G\u001a\u00020HJ(\u0010D\u001a\u00020\r2\u0006\u0010E\u001a\u00020\r2\u0006\u0010F\u001a\u00020\r2\u0006\u0010J\u001a\u00020\r2\b\b\u0002\u0010G\u001a\u00020HJ\u0018\u0010D\u001a\u00020\r2\u0006\u0010I\u001a\u00020A2\b\b\u0002\u0010G\u001a\u00020HJ \u0010\u0012\u001a\u00020\r2\u0006\u0010E\u001a\u00020\r2\u0006\u0010F\u001a\u00020\r2\b\b\u0002\u0010G\u001a\u00020HJ\u0018\u0010\u0012\u001a\u00020\r2\u0006\u0010I\u001a\u00020?2\b\b\u0002\u0010G\u001a\u00020HJ(\u0010\u0012\u001a\u00020\r2\u0006\u0010E\u001a\u00020\r2\u0006\u0010F\u001a\u00020\r2\u0006\u0010J\u001a\u00020\r2\b\b\u0002\u0010G\u001a\u00020HJ\u0018\u0010\u0012\u001a\u00020\r2\u0006\u0010I\u001a\u00020A2\b\b\u0002\u0010G\u001a\u00020HJ\u0016\u0010K\u001a\u00020\r2\u0006\u0010E\u001a\u00020\r2\u0006\u0010F\u001a\u00020\rJ\u000e\u0010K\u001a\u00020\r2\u0006\u0010I\u001a\u00020?J\u001e\u0010K\u001a\u00020\r2\u0006\u0010E\u001a\u00020\r2\u0006\u0010F\u001a\u00020\r2\u0006\u0010J\u001a\u00020\rJ\u000e\u0010K\u001a\u00020\r2\u0006\u0010I\u001a\u00020AJ&\u0010K\u001a\u00020\r2\u0006\u0010E\u001a\u00020\r2\u0006\u0010F\u001a\u00020\r2\u0006\u0010J\u001a\u00020\r2\u0006\u0010L\u001a\u00020\rJ\u000e\u0010K\u001a\u00020\r2\u0006\u0010I\u001a\u00020CJ^\u0010M\u001a\u00020\r2\u0006\u0010E\u001a\u00020\r2\u0006\u0010F\u001a\u00020\r2\u001e\u0010N\u001a\u001a\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r0O2\b\b\u0002\u0010G\u001a\u00020P2\b\b\u0002\u0010Q\u001a\u00020\u000b2\b\b\u0002\u0010R\u001a\u00020\r2\b\b\u0002\u0010S\u001a\u00020\rJV\u0010M\u001a\u00020\r2\u0006\u0010I\u001a\u00020?2\u001e\u0010N\u001a\u001a\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r0O2\b\b\u0002\u0010G\u001a\u00020P2\b\b\u0002\u0010Q\u001a\u00020\u000b2\b\b\u0002\u0010R\u001a\u00020\r2\b\b\u0002\u0010S\u001a\u00020\rJl\u0010M\u001a\u00020\r2\u0006\u0010E\u001a\u00020\r2\u0006\u0010F\u001a\u00020\r2\u0006\u0010J\u001a\u00020\r2$\u0010N\u001a \u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r0T2\b\b\u0002\u0010G\u001a\u00020P2\b\b\u0002\u0010Q\u001a\u00020\u000b2\b\b\u0002\u0010R\u001a\u00020\r2\b\b\u0002\u0010S\u001a\u00020\rJ\\\u0010M\u001a\u00020\r2\u0006\u0010I\u001a\u00020A2$\u0010N\u001a \u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r0T2\b\b\u0002\u0010G\u001a\u00020P2\b\b\u0002\u0010Q\u001a\u00020\u000b2\b\b\u0002\u0010R\u001a\u00020\r2\b\b\u0002\u0010S\u001a\u00020\rJ\u0016\u0010U\u001a\u00020\r2\u0006\u0010E\u001a\u00020\r2\u0006\u0010F\u001a\u00020\rJ\u000e\u0010U\u001a\u00020\r2\u0006\u0010I\u001a\u00020?J\u001e\u0010U\u001a\u00020\r2\u0006\u0010E\u001a\u00020\r2\u0006\u0010F\u001a\u00020\r2\u0006\u0010J\u001a\u00020\rJ\u000e\u0010U\u001a\u00020\r2\u0006\u0010I\u001a\u00020AJ$\u0010V\u001a\u00020\u00012\b\b\u0002\u0010W\u001a\u00020\r2\b\b\u0002\u0010X\u001a\u00020\r2\b\b\u0002\u00108\u001a\u00020\u000bJ$\u0010Y\u001a\u00020\u00012\b\b\u0002\u0010W\u001a\u00020\r2\b\b\u0002\u0010X\u001a\u00020\r2\b\b\u0002\u00108\u001a\u00020\u000bJ9\u0010Z\u001a\u0002H1\"\u0004\b\u0000\u001012\f\u0010[\u001a\b\u0012\u0004\u0012\u0002H1032\u0018\u0010\\\u001a\u0014\u0012\u0004\u0012\u00020\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0]0&\u00a2\u0006\u0002\u0010^J\u000e\u0010_\u001a\u00020?2\u0006\u0010`\u001a\u00020aR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0012\u001a\u00020\u0013@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018\u00a8\u0006d"}, d2={"Lorg/openrndr/extra/noise/Random;", "", "<init>", "()V", "rnd", "Lkotlin/random/Random;", "getRnd", "()Lkotlin/random/Random;", "setRnd", "(Lkotlin/random/Random;)V", "seedTracking", "", "nextGaussian", "", "hasNextGaussian", "", "state", "Lorg/openrndr/extra/noise/RandomState;", "value", "", "seed", "getSeed", "()Ljava/lang/String;", "setSeed", "(Ljava/lang/String;)V", "newRandomGenerator", "newSeed", "stringToInt", "str", "resetState", "", "randomizeSeed", "unseeded", "fn", "Lkotlin/Function0;", "push", "pop", "isolated", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "double", "min", "max", "double0", "int0", "int", "bool", "probability", "pick", "T", "coll", "", "(Ljava/util/Collection;)Ljava/lang/Object;", "compareAgainst", "(Ljava/util/Collection;Ljava/util/Collection;)Ljava/lang/Object;", "", "count", "gaussian", "mean", "standardDeviation", "pareto", "alpha", "vector2", "Lorg/openrndr/math/Vector2;", "vector3", "Lorg/openrndr/math/Vector3;", "vector4", "Lorg/openrndr/math/Vector4;", "perlin", "x", "y", "type", "Lorg/openrndr/extra/noise/Random$Noise;", "position", "z", "simplex", "w", "fbm", "noiseFun", "Lkotlin/Function3;", "Lorg/openrndr/extra/noise/Random$Fractal;", "octaves", "lacunarity", "gain", "Lkotlin/Function4;", "cubic", "ring2d", "innerRadius", "outerRadius", "ring3d", "roll", "elements", "distribution", "", "(Ljava/util/Collection;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "point", "rect", "Lorg/openrndr/shape/Rectangle;", "Fractal", "Noise", "orx-noise"})
@SourceDebugExtension(value={"SMAP\nRandom.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Random.kt\norg/openrndr/extra/noise/Random\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 Fractal.kt\norg/openrndr/extra/noise/FractalKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,386:1\n12869#2,3:387\n79#3,12:390\n371#3,12:402\n226#3,12:414\n73#3,18:426\n365#3,18:444\n220#3,18:462\n53#3,14:480\n345#3,14:494\n200#3,14:508\n47#3,20:522\n339#3,20:542\n194#3,20:562\n360#4,7:582\n*S KotlinDebug\n*F\n+ 1 Random.kt\norg/openrndr/extra/noise/Random\n*L\n49#1:387,3\n303#1:390,12\n304#1:402,12\n305#1:414,12\n315#1:426,18\n316#1:444,18\n317#1:462,18\n326#1:480,14\n327#1:494,14\n328#1:508,14\n338#1:522,20\n339#1:542,20\n340#1:562,20\n377#1:582,7\n*E\n"})
public final class Random {
    @NotNull
    public static final Random INSTANCE = new Random();
    @NotNull
    private static kotlin.random.Random rnd;
    private static int seedTracking;
    private static double nextGaussian;
    private static boolean hasNextGaussian;
    @NotNull
    private static RandomState state;
    @NotNull
    private static String seed;

    private Random() {
    }

    @NotNull
    public final kotlin.random.Random getRnd() {
        return rnd;
    }

    public final void setRnd(@NotNull kotlin.random.Random random) {
        Intrinsics.checkNotNullParameter(random, "<set-?>");
        rnd = random;
    }

    @NotNull
    public final String getSeed() {
        return seed;
    }

    public final void setSeed(@NotNull String value2) {
        Intrinsics.checkNotNullParameter(value2, "value");
        seed = value2;
        rnd = this.newRandomGenerator(value2);
    }

    private final kotlin.random.Random newRandomGenerator(String newSeed) {
        return RandomKt.Random(this.stringToInt(newSeed));
    }

    /*
     * WARNING - void declaration
     */
    private final int stringToInt(String str) {
        void $this$fold$iv;
        char[] cArray = str.toCharArray();
        Intrinsics.checkNotNullExpressionValue(cArray, "toCharArray(...)");
        char[] cArray2 = cArray;
        int initial$iv = 0;
        boolean $i$f$fold = false;
        int accumulator$iv = initial$iv;
        int n = ((void)$this$fold$iv).length;
        for (int i = 0; i < n; ++i) {
            void c2;
            void element$iv;
            void var9_9 = element$iv = $this$fold$iv[i];
            int i2 = accumulator$iv;
            boolean bl = false;
            accumulator$iv = i2 + c2;
        }
        return accumulator$iv;
    }

    public final void resetState() {
        rnd = this.newRandomGenerator(seed);
    }

    public final void randomizeSeed() {
        CharSequence charSequence = seed;
        Regex regex = new Regex("-\\d+");
        String string = "";
        String seedBase = regex.replace(charSequence, string);
        seedTracking = this.int0(999999);
        this.setSeed(seedBase + "-" + seedTracking);
    }

    public final void unseeded(@NotNull Function0<Unit> fn) {
        Intrinsics.checkNotNullParameter(fn, "fn");
        this.push();
        fn.invoke();
        this.pop();
    }

    public final void push() {
        state = new RandomState(seed, rnd);
        rnd = kotlin.random.Random.Default;
    }

    public final void pop() {
        this.resetState();
        this.setSeed(state.getSeed());
        rnd = state.getRng();
    }

    public final void isolated(@NotNull Function1<? super Random, Unit> fn) {
        Intrinsics.checkNotNullParameter(fn, "fn");
        kotlin.random.Random state = rnd;
        String currentSeed = seed;
        this.resetState();
        fn.invoke(this);
        this.setSeed(currentSeed);
        rnd = state;
    }

    public final double double(double min, double max) {
        return UniformRandomKt.uniform(DoubleCompanionObject.INSTANCE, min, max, rnd);
    }

    public static /* synthetic */ double double$default(Random random, double d, double d2, int n, Object object) {
        if ((n & 1) != 0) {
            d = -1.0;
        }
        if ((n & 2) != 0) {
            d2 = 1.0;
        }
        return random.double(d, d2);
    }

    public final double double0(double max) {
        return rnd.nextDouble(max);
    }

    public static /* synthetic */ double double0$default(Random random, double d, int n, Object object) {
        if ((n & 1) != 0) {
            d = 1.0;
        }
        return random.double0(d);
    }

    public final int int0(int max) {
        return rnd.nextInt(max);
    }

    public static /* synthetic */ int int0$default(Random random, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = Integer.MAX_VALUE;
        }
        return random.int0(n);
    }

    public final int int(int min, int max) {
        return rnd.nextInt(min, max);
    }

    public static /* synthetic */ int int$default(Random random, int n, int n2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n = 0;
        }
        if ((n3 & 2) != 0) {
            n2 = Integer.MAX_VALUE;
        }
        return random.int(n, n2);
    }

    public final boolean bool(double probability) {
        return rnd.nextDouble(1.0) < probability;
    }

    public static /* synthetic */ boolean bool$default(Random random, double d, int n, Object object) {
        if ((n & 1) != 0) {
            d = 0.5;
        }
        return random.bool(d);
    }

    public final <T> T pick(@NotNull Collection<? extends T> coll) {
        Intrinsics.checkNotNullParameter(coll, "coll");
        return CollectionsKt.first(Random.pick$default(this, coll, null, 1, 2, null));
    }

    public final <T> T pick(@NotNull Collection<? extends T> coll, @NotNull Collection<? extends T> compareAgainst) {
        Intrinsics.checkNotNullParameter(coll, "coll");
        Intrinsics.checkNotNullParameter(compareAgainst, "compareAgainst");
        return CollectionsKt.first(this.pick(coll, compareAgainst, 1));
    }

    @NotNull
    public final <T> List<T> pick(@NotNull Collection<? extends T> coll, @NotNull Collection<? extends T> compareAgainst, int count2) {
        Intrinsics.checkNotNullParameter(coll, "coll");
        Intrinsics.checkNotNullParameter(compareAgainst, "compareAgainst");
        List<T> list = CollectionsKt.toMutableList(coll);
        List picked = new ArrayList();
        if (coll.isEmpty()) {
            return list;
        }
        while (picked.size() < count2) {
            if (list.isEmpty()) {
                list = CollectionsKt.toMutableList(coll);
            }
            int index = this.int0(list.size());
            T newElem = list.get(index);
            while (compareAgainst.contains(newElem)) {
                index = this.int0(list.size());
                newElem = list.get(index);
            }
            picked.add(list.get(index));
            list.remove(index);
        }
        return picked;
    }

    public static /* synthetic */ List pick$default(Random random, Collection collection, Collection collection2, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            collection2 = CollectionsKt.emptyList();
        }
        return random.pick(collection, collection2, n);
    }

    public final double gaussian(double mean, double standardDeviation) {
        return GaussianRandomKt.gaussian(mean, standardDeviation, rnd);
    }

    public static /* synthetic */ double gaussian$default(Random random, double d, double d2, int n, Object object) {
        if ((n & 1) != 0) {
            d = 0.0;
        }
        if ((n & 2) != 0) {
            d2 = 1.0;
        }
        return random.gaussian(d, d2);
    }

    @NotNull
    public final Function0<Double> pareto(double alpha) {
        double invAlpha = 1.0 / Math.max(alpha, 0.0);
        return () -> Random.pareto$lambda$1(invAlpha);
    }

    public static /* synthetic */ Function0 pareto$default(Random random, double d, int n, Object object) {
        if ((n & 1) != 0) {
            d = 1.0;
        }
        return random.pareto(d);
    }

    @NotNull
    public final Vector2 vector2(double min, double max) {
        return UniformRandomKt.uniform(Vector2.Companion, min, max, rnd);
    }

    public static /* synthetic */ Vector2 vector2$default(Random random, double d, double d2, int n, Object object) {
        if ((n & 1) != 0) {
            d = -1.0;
        }
        if ((n & 2) != 0) {
            d2 = 1.0;
        }
        return random.vector2(d, d2);
    }

    @NotNull
    public final Vector3 vector3(double min, double max) {
        return UniformRandomKt.uniform(Vector3.Companion, min, max, rnd);
    }

    public static /* synthetic */ Vector3 vector3$default(Random random, double d, double d2, int n, Object object) {
        if ((n & 1) != 0) {
            d = -1.0;
        }
        if ((n & 2) != 0) {
            d2 = 1.0;
        }
        return random.vector3(d, d2);
    }

    @NotNull
    public final Vector4 vector4(double min, double max) {
        return UniformRandomKt.uniform(Vector4.Companion, min, max, rnd);
    }

    public static /* synthetic */ Vector4 vector4$default(Random random, double d, double d2, int n, Object object) {
        if ((n & 1) != 0) {
            d = -1.0;
        }
        if ((n & 2) != 0) {
            d2 = 1.0;
        }
        return random.vector4(d, d2);
    }

    public final double perlin(double x, double y, @NotNull Noise type) {
        Intrinsics.checkNotNullParameter((Object)type, "type");
        int sd = this.stringToInt(seed);
        return switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 1 -> PerlinNoise2DKt.perlinLinear(sd, x, y);
            case 2 -> PerlinNoise2DKt.perlinQuintic(sd, x, y);
            case 3 -> PerlinNoise2DKt.perlinHermite(sd, x, y);
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    public static /* synthetic */ double perlin$default(Random random, double d, double d2, Noise noise, int n, Object object) {
        if ((n & 4) != 0) {
            noise = Noise.LINEAR;
        }
        return random.perlin(d, d2, noise);
    }

    public final double perlin(@NotNull Vector2 position, @NotNull Noise type) {
        Intrinsics.checkNotNullParameter(position, "position");
        Intrinsics.checkNotNullParameter((Object)type, "type");
        int sd = this.stringToInt(seed);
        return switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 1 -> PerlinNoise2DKt.perlinLinear(sd, position);
            case 2 -> PerlinNoise2DKt.perlinQuintic(sd, position);
            case 3 -> PerlinNoise2DKt.perlinHermite(sd, position);
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    public static /* synthetic */ double perlin$default(Random random, Vector2 vector2, Noise noise, int n, Object object) {
        if ((n & 2) != 0) {
            noise = Noise.LINEAR;
        }
        return random.perlin(vector2, noise);
    }

    public final double perlin(double x, double y, double z, @NotNull Noise type) {
        Intrinsics.checkNotNullParameter((Object)type, "type");
        int sd = this.stringToInt(seed);
        return switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 1 -> PerlinNoise3DKt.perlinLinear(sd, x, y, z);
            case 2 -> PerlinNoise3DKt.perlinQuintic(sd, x, y, z);
            case 3 -> PerlinNoise3DKt.perlinHermite(sd, x, y, z);
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    public static /* synthetic */ double perlin$default(Random random, double d, double d2, double d3, Noise noise, int n, Object object) {
        if ((n & 8) != 0) {
            noise = Noise.LINEAR;
        }
        return random.perlin(d, d2, d3, noise);
    }

    public final double perlin(@NotNull Vector3 position, @NotNull Noise type) {
        Intrinsics.checkNotNullParameter(position, "position");
        Intrinsics.checkNotNullParameter((Object)type, "type");
        int sd = this.stringToInt(seed);
        return switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 1 -> PerlinNoise3DKt.perlinLinear(sd, position);
            case 2 -> PerlinNoise3DKt.perlinQuintic(sd, position);
            case 3 -> PerlinNoise3DKt.perlinHermite(sd, position);
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    public static /* synthetic */ double perlin$default(Random random, Vector3 vector3, Noise noise, int n, Object object) {
        if ((n & 2) != 0) {
            noise = Noise.LINEAR;
        }
        return random.perlin(vector3, noise);
    }

    public final double value(double x, double y, @NotNull Noise type) {
        Intrinsics.checkNotNullParameter((Object)type, "type");
        int sd = this.stringToInt(seed);
        return switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 1 -> ValueNoise2DKt.valueLinear(sd, x, y);
            case 2 -> ValueNoise2DKt.valueQuintic(sd, x, y);
            case 3 -> ValueNoise2DKt.valueHermite(sd, x, y);
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    public static /* synthetic */ double value$default(Random random, double d, double d2, Noise noise, int n, Object object) {
        if ((n & 4) != 0) {
            noise = Noise.LINEAR;
        }
        return random.value(d, d2, noise);
    }

    public final double value(@NotNull Vector2 position, @NotNull Noise type) {
        Intrinsics.checkNotNullParameter(position, "position");
        Intrinsics.checkNotNullParameter((Object)type, "type");
        int sd = this.stringToInt(seed);
        return switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 1 -> ValueNoise2DKt.valueLinear(sd, position);
            case 2 -> ValueNoise2DKt.valueQuintic(sd, position);
            case 3 -> ValueNoise2DKt.valueHermite(sd, position);
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    public static /* synthetic */ double value$default(Random random, Vector2 vector2, Noise noise, int n, Object object) {
        if ((n & 2) != 0) {
            noise = Noise.LINEAR;
        }
        return random.value(vector2, noise);
    }

    public final double value(double x, double y, double z, @NotNull Noise type) {
        Intrinsics.checkNotNullParameter((Object)type, "type");
        int sd = this.stringToInt(seed);
        return switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 1 -> ValueNoise3DKt.valueLinear(sd, x, y, z);
            case 2 -> ValueNoise3DKt.valueQuintic(sd, x, y, z);
            case 3 -> ValueNoise3DKt.valueHermite(sd, x, y, z);
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    public static /* synthetic */ double value$default(Random random, double d, double d2, double d3, Noise noise, int n, Object object) {
        if ((n & 8) != 0) {
            noise = Noise.LINEAR;
        }
        return random.value(d, d2, d3, noise);
    }

    public final double value(@NotNull Vector3 position, @NotNull Noise type) {
        Intrinsics.checkNotNullParameter(position, "position");
        Intrinsics.checkNotNullParameter((Object)type, "type");
        int sd = this.stringToInt(seed);
        return switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 1 -> ValueNoise3DKt.valueLinear(sd, position);
            case 2 -> ValueNoise3DKt.valueQuintic(sd, position);
            case 3 -> ValueNoise3DKt.valueHermite(sd, position);
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    public static /* synthetic */ double value$default(Random random, Vector3 vector3, Noise noise, int n, Object object) {
        if ((n & 2) != 0) {
            noise = Noise.LINEAR;
        }
        return random.value(vector3, noise);
    }

    public final double simplex(double x, double y) {
        return SimplexNoise2DKt.simplex(this.stringToInt(seed), x, y);
    }

    public final double simplex(@NotNull Vector2 position) {
        Intrinsics.checkNotNullParameter(position, "position");
        return SimplexNoise2DKt.simplex(this.stringToInt(seed), position);
    }

    public final double simplex(double x, double y, double z) {
        return SimplexNoise3DKt.simplex(this.stringToInt(seed), x, y, z);
    }

    public final double simplex(@NotNull Vector3 position) {
        Intrinsics.checkNotNullParameter(position, "position");
        return SimplexNoise3DKt.simplex(this.stringToInt(seed), position);
    }

    public final double simplex(double x, double y, double z, double w) {
        return SimplexNoise4DKt.simplex(this.stringToInt(seed), x, y, z, w);
    }

    public final double simplex(@NotNull Vector4 position) {
        Intrinsics.checkNotNullParameter(position, "position");
        return SimplexNoise4DKt.simplex(this.stringToInt(seed), position);
    }

    public final double fbm(double x, double y, @NotNull Function3<? super Integer, ? super Double, ? super Double, Double> noiseFun, @NotNull Fractal type, int octaves, double lacunarity, double gain) {
        Intrinsics.checkNotNullParameter(noiseFun, "noiseFun");
        Intrinsics.checkNotNullParameter((Object)type, "type");
        int s = this.stringToInt(seed);
        return switch (WhenMappings.$EnumSwitchMapping$1[type.ordinal()]) {
            case 1 -> {
                boolean $i$f$fbm = false;
                double sum$iv = ((Number)noiseFun.invoke((Integer)s, (Double)x, (Double)y)).doubleValue();
                double amp$iv = 1.0;
                double lx$iv = x;
                double ly$iv = y;
                for (int i$iv = 1; i$iv < octaves; ++i$iv) {
                    sum$iv += ((Number)noiseFun.invoke((Integer)(s + i$iv), (Double)(lx$iv *= lacunarity), (Double)(ly$iv *= lacunarity))).doubleValue() * (amp$iv *= gain);
                }
                yield sum$iv;
            }
            case 2 -> {
                boolean $i$f$rigid = false;
                double sum$iv = 1.0 - Math.abs(((Number)noiseFun.invoke((Integer)s, (Double)x, (Double)y)).doubleValue());
                double amp$iv = 1.0;
                double x$iv = x;
                double y$iv = y;
                for (int i$iv = 1; i$iv < octaves; ++i$iv) {
                    sum$iv -= (1.0 - Math.abs(((Number)noiseFun.invoke((Integer)(s + i$iv), (Double)(x$iv *= lacunarity), (Double)(y$iv *= lacunarity))).doubleValue())) * (amp$iv *= gain);
                }
                yield sum$iv;
            }
            case 3 -> {
                boolean $i$f$billow = false;
                double sum$iv = Math.abs(((Number)noiseFun.invoke((Integer)s, (Double)x, (Double)y)).doubleValue() * 2.0 - 1.0);
                double amp$iv = 1.0;
                double x$iv = x;
                double y$iv = y;
                for (int i$iv = 1; i$iv < octaves; ++i$iv) {
                    sum$iv += Math.abs(((Number)noiseFun.invoke((Integer)(s + i$iv), (Double)(x$iv *= lacunarity), (Double)(y$iv *= lacunarity))).doubleValue() * 2.0 - 1.0) * (amp$iv *= gain);
                }
                yield sum$iv;
            }
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    public static /* synthetic */ double fbm$default(Random random, double d, double d2, Function3 function3, Fractal fractal, int n, double d3, double d4, int n2, Object object) {
        if ((n2 & 8) != 0) {
            fractal = Fractal.FBM;
        }
        if ((n2 & 0x10) != 0) {
            n = 8;
        }
        if ((n2 & 0x20) != 0) {
            d3 = 0.5;
        }
        if ((n2 & 0x40) != 0) {
            d4 = 0.5;
        }
        return random.fbm(d, d2, function3, fractal, n, d3, d4);
    }

    public final double fbm(@NotNull Vector2 position, @NotNull Function3<? super Integer, ? super Double, ? super Double, Double> noiseFun, @NotNull Fractal type, int octaves, double lacunarity, double gain) {
        Intrinsics.checkNotNullParameter(position, "position");
        Intrinsics.checkNotNullParameter(noiseFun, "noiseFun");
        Intrinsics.checkNotNullParameter((Object)type, "type");
        int s = this.stringToInt(seed);
        return switch (WhenMappings.$EnumSwitchMapping$1[type.ordinal()]) {
            case 1 -> {
                void x$iv$iv;
                boolean $i$f$fbm = false;
                double var11_11 = position.x();
                double y$iv$iv = position.y();
                boolean $i$f$fbm = false;
                double sum$iv$iv = ((Number)noiseFun.invoke((Integer)s, (Double)((double)x$iv$iv), (Double)y$iv$iv)).doubleValue();
                double amp$iv$iv = 1.0;
                void lx$iv$iv = x$iv$iv;
                double ly$iv$iv = y$iv$iv;
                for (int i$iv$iv = 1; i$iv$iv < octaves; ++i$iv$iv) {
                    sum$iv$iv += ((Number)noiseFun.invoke((Integer)(s + i$iv$iv), (Double)((double)(lx$iv$iv *= lacunarity)), (Double)(ly$iv$iv *= lacunarity))).doubleValue() * (amp$iv$iv *= gain);
                }
                yield sum$iv$iv;
            }
            case 2 -> {
                boolean $i$f$rigid = false;
                double x$iv$iv = position.x();
                double y$iv$iv = position.y();
                boolean $i$f$rigid = false;
                double sum$iv$iv = 1.0 - Math.abs(((Number)noiseFun.invoke((Integer)s, (Double)x$iv$iv, (Double)y$iv$iv)).doubleValue());
                double amp$iv$iv = 1.0;
                double x$iv$iv = x$iv$iv;
                double y$iv$iv = y$iv$iv;
                for (int i$iv$iv = 1; i$iv$iv < octaves; ++i$iv$iv) {
                    sum$iv$iv -= (1.0 - Math.abs(((Number)noiseFun.invoke((Integer)(s + i$iv$iv), (Double)(x$iv$iv *= lacunarity), (Double)(y$iv$iv *= lacunarity))).doubleValue())) * (amp$iv$iv *= gain);
                }
                yield sum$iv$iv;
            }
            case 3 -> {
                boolean $i$f$billow = false;
                double x$iv$iv = position.x();
                double y$iv$iv = position.y();
                boolean $i$f$billow = false;
                double sum$iv$iv = Math.abs(((Number)noiseFun.invoke((Integer)s, (Double)x$iv$iv, (Double)y$iv$iv)).doubleValue() * 2.0 - 1.0);
                double amp$iv$iv = 1.0;
                double x$iv$iv = x$iv$iv;
                double y$iv$iv = y$iv$iv;
                for (int i$iv$iv = 1; i$iv$iv < octaves; ++i$iv$iv) {
                    sum$iv$iv += Math.abs(((Number)noiseFun.invoke((Integer)(s + i$iv$iv), (Double)(x$iv$iv *= lacunarity), (Double)(y$iv$iv *= lacunarity))).doubleValue() * 2.0 - 1.0) * (amp$iv$iv *= gain);
                }
                yield sum$iv$iv;
            }
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    public static /* synthetic */ double fbm$default(Random random, Vector2 vector2, Function3 function3, Fractal fractal, int n, double d, double d2, int n2, Object object) {
        if ((n2 & 4) != 0) {
            fractal = Fractal.FBM;
        }
        if ((n2 & 8) != 0) {
            n = 8;
        }
        if ((n2 & 0x10) != 0) {
            d = 0.5;
        }
        if ((n2 & 0x20) != 0) {
            d2 = 0.5;
        }
        return random.fbm(vector2, function3, fractal, n, d, d2);
    }

    public final double fbm(double x, double y, double z, @NotNull Function4<? super Integer, ? super Double, ? super Double, ? super Double, Double> noiseFun, @NotNull Fractal type, int octaves, double lacunarity, double gain) {
        Intrinsics.checkNotNullParameter(noiseFun, "noiseFun");
        Intrinsics.checkNotNullParameter((Object)type, "type");
        int s = this.stringToInt(seed);
        return switch (WhenMappings.$EnumSwitchMapping$1[type.ordinal()]) {
            case 1 -> {
                boolean $i$f$fbm = false;
                double sum$iv = ((Number)noiseFun.invoke((Integer)s, (Double)x, (Double)y, (Double)z)).doubleValue();
                double amp$iv = 1.0;
                double lx$iv = x;
                double ly$iv = y;
                double lz$iv = z;
                for (int i$iv = 1; i$iv < octaves; ++i$iv) {
                    sum$iv += ((Number)noiseFun.invoke((Integer)(s + i$iv), (Double)(lx$iv *= lacunarity), (Double)(ly$iv *= lacunarity), (Double)(lz$iv *= lacunarity))).doubleValue() * (amp$iv *= gain);
                }
                yield sum$iv;
            }
            case 2 -> {
                boolean $i$f$rigid = false;
                double sum$iv = 1.0 - Math.abs(((Number)noiseFun.invoke((Integer)s, (Double)x, (Double)y, (Double)z)).doubleValue());
                double amp$iv = 1.0;
                double x$iv = x;
                double y$iv = y;
                double z$iv = z;
                for (int i$iv = 1; i$iv < octaves; ++i$iv) {
                    sum$iv -= (1.0 - Math.abs(((Number)noiseFun.invoke((Integer)(s + i$iv), (Double)(x$iv *= lacunarity), (Double)(y$iv *= lacunarity), (Double)(z$iv *= lacunarity))).doubleValue())) * (amp$iv *= gain);
                }
                yield sum$iv;
            }
            case 3 -> {
                boolean $i$f$billow = false;
                double sum$iv = Math.abs(((Number)noiseFun.invoke((Integer)s, (Double)x, (Double)y, (Double)z)).doubleValue() * 2.0 - 1.0);
                double amp$iv = 1.0;
                double x$iv = x;
                double y$iv = y;
                double z$iv = z;
                for (int i$iv = 1; i$iv < octaves; ++i$iv) {
                    sum$iv += Math.abs(((Number)noiseFun.invoke((Integer)(s + i$iv), (Double)(x$iv *= lacunarity), (Double)(y$iv *= lacunarity), (Double)(z$iv *= lacunarity))).doubleValue() * 2.0 - 1.0) * (amp$iv *= gain);
                }
                yield sum$iv;
            }
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    public static /* synthetic */ double fbm$default(Random random, double d, double d2, double d3, Function4 function4, Fractal fractal, int n, double d4, double d5, int n2, Object object) {
        if ((n2 & 0x10) != 0) {
            fractal = Fractal.FBM;
        }
        if ((n2 & 0x20) != 0) {
            n = 8;
        }
        if ((n2 & 0x40) != 0) {
            d4 = 0.5;
        }
        if ((n2 & 0x80) != 0) {
            d5 = 0.5;
        }
        return random.fbm(d, d2, d3, function4, fractal, n, d4, d5);
    }

    public final double fbm(@NotNull Vector3 position, @NotNull Function4<? super Integer, ? super Double, ? super Double, ? super Double, Double> noiseFun, @NotNull Fractal type, int octaves, double lacunarity, double gain) {
        Intrinsics.checkNotNullParameter(position, "position");
        Intrinsics.checkNotNullParameter(noiseFun, "noiseFun");
        Intrinsics.checkNotNullParameter((Object)type, "type");
        int s = this.stringToInt(seed);
        return switch (WhenMappings.$EnumSwitchMapping$1[type.ordinal()]) {
            case 1 -> {
                void y$iv$iv;
                void x$iv$iv;
                boolean $i$f$fbm = false;
                double var11_11 = position.x();
                double var13_14 = position.y();
                double z$iv$iv = position.z();
                boolean $i$f$fbm = false;
                double sum$iv$iv = ((Number)noiseFun.invoke((Integer)s, (Double)((double)x$iv$iv), (Double)((double)y$iv$iv), (Double)z$iv$iv)).doubleValue();
                double amp$iv$iv = 1.0;
                void lx$iv$iv = x$iv$iv;
                void ly$iv$iv = y$iv$iv;
                double lz$iv$iv = z$iv$iv;
                for (int i$iv$iv = 1; i$iv$iv < octaves; ++i$iv$iv) {
                    sum$iv$iv += ((Number)noiseFun.invoke((Integer)(s + i$iv$iv), (Double)((double)(lx$iv$iv *= lacunarity)), (Double)((double)(ly$iv$iv *= lacunarity)), (Double)(lz$iv$iv *= lacunarity))).doubleValue() * (amp$iv$iv *= gain);
                }
                yield sum$iv$iv;
            }
            case 2 -> {
                boolean $i$f$rigid = false;
                double x$iv$iv = position.x();
                double y$iv$iv = position.y();
                double z$iv$iv = position.z();
                boolean $i$f$rigid = false;
                double sum$iv$iv = 1.0 - Math.abs(((Number)noiseFun.invoke((Integer)s, (Double)x$iv$iv, (Double)y$iv$iv, (Double)z$iv$iv)).doubleValue());
                double amp$iv$iv = 1.0;
                double x$iv$iv = x$iv$iv;
                double y$iv$iv = y$iv$iv;
                double z$iv$iv = z$iv$iv;
                for (int i$iv$iv = 1; i$iv$iv < octaves; ++i$iv$iv) {
                    sum$iv$iv -= (1.0 - Math.abs(((Number)noiseFun.invoke((Integer)(s + i$iv$iv), (Double)(x$iv$iv *= lacunarity), (Double)(y$iv$iv *= lacunarity), (Double)(z$iv$iv *= lacunarity))).doubleValue())) * (amp$iv$iv *= gain);
                }
                yield sum$iv$iv;
            }
            case 3 -> {
                boolean $i$f$billow = false;
                double x$iv$iv = position.x();
                double y$iv$iv = position.y();
                double z$iv$iv = position.z();
                boolean $i$f$billow = false;
                double sum$iv$iv = Math.abs(((Number)noiseFun.invoke((Integer)s, (Double)x$iv$iv, (Double)y$iv$iv, (Double)z$iv$iv)).doubleValue() * 2.0 - 1.0);
                double amp$iv$iv = 1.0;
                double x$iv$iv = x$iv$iv;
                double y$iv$iv = y$iv$iv;
                double z$iv$iv = z$iv$iv;
                for (int i$iv$iv = 1; i$iv$iv < octaves; ++i$iv$iv) {
                    sum$iv$iv += Math.abs(((Number)noiseFun.invoke((Integer)(s + i$iv$iv), (Double)(x$iv$iv *= lacunarity), (Double)(y$iv$iv *= lacunarity), (Double)(z$iv$iv *= lacunarity))).doubleValue() * 2.0 - 1.0) * (amp$iv$iv *= gain);
                }
                yield sum$iv$iv;
            }
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    public static /* synthetic */ double fbm$default(Random random, Vector3 vector3, Function4 function4, Fractal fractal, int n, double d, double d2, int n2, Object object) {
        if ((n2 & 4) != 0) {
            fractal = Fractal.FBM;
        }
        if ((n2 & 8) != 0) {
            n = 8;
        }
        if ((n2 & 0x10) != 0) {
            d = 0.5;
        }
        if ((n2 & 0x20) != 0) {
            d2 = 0.5;
        }
        return random.fbm(vector3, function4, fractal, n, d, d2);
    }

    public final double cubic(double x, double y) {
        return CubicNoise2DKt.cubic(this.stringToInt(seed), x, y);
    }

    public final double cubic(@NotNull Vector2 position) {
        Intrinsics.checkNotNullParameter(position, "position");
        return CubicNoise2DKt.cubic(this.stringToInt(seed), position);
    }

    public final double cubic(double x, double y, double z) {
        return CubicNoise3DKt.cubic(this.stringToInt(seed), x, y, z);
    }

    public final double cubic(@NotNull Vector3 position) {
        Intrinsics.checkNotNullParameter(position, "position");
        return CubicNoise3DKt.cubic(this.stringToInt(seed), position);
    }

    @NotNull
    public final Object ring2d(double innerRadius, double outerRadius, int count2) {
        return count2 == 1 ? UniformRandomKt.uniformRing(Vector2.Companion, innerRadius, outerRadius, rnd) : UniformRandomKt.uniformsRing(Vector2.Companion, count2, innerRadius, outerRadius, rnd);
    }

    public static /* synthetic */ Object ring2d$default(Random random, double d, double d2, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            d = 0.0;
        }
        if ((n2 & 2) != 0) {
            d2 = 1.0;
        }
        if ((n2 & 4) != 0) {
            n = 1;
        }
        return random.ring2d(d, d2, n);
    }

    @NotNull
    public final Object ring3d(double innerRadius, double outerRadius, int count2) {
        return count2 == 1 ? UniformRandomKt.uniformRing(Vector3.Companion, innerRadius, outerRadius, rnd) : UniformRandomKt.uniformsRing(Vector3.Companion, count2, innerRadius, outerRadius, rnd);
    }

    public static /* synthetic */ Object ring3d$default(Random random, double d, double d2, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            d = 0.0;
        }
        if ((n2 & 2) != 0) {
            d2 = 1.0;
        }
        if ((n2 & 4) != 0) {
            n = 1;
        }
        return random.ring3d(d, d2, n);
    }

    public final <T> T roll(@NotNull Collection<? extends T> elements, @NotNull Function1<? super Integer, ? extends List<Double>> distribution) {
        Object t;
        int index;
        block3: {
            int n;
            List<Double> probabilities;
            Intrinsics.checkNotNullParameter(elements, "elements");
            Intrinsics.checkNotNullParameter(distribution, "distribution");
            double result2 = Random.double0$default(this, 0.0, 1, null);
            List<Double> $this$indexOfFirst$iv = probabilities = distribution.invoke((Integer)elements.size());
            boolean $i$f$indexOfFirst = false;
            int index$iv = 0;
            for (Double item$iv : $this$indexOfFirst$iv) {
                double it = ((Number)item$iv).doubleValue();
                boolean bl = false;
                if (result2 <= it) {
                    n = index$iv;
                    break block3;
                }
                ++index$iv;
            }
            n = index = -1;
        }
        if ((t = CollectionsKt.elementAtOrNull((Iterable)elements, index)) == null) {
            t = CollectionsKt.last((Iterable)elements);
        }
        return t;
    }

    @NotNull
    public final Vector2 point(@NotNull Rectangle rect) {
        Intrinsics.checkNotNullParameter(rect, "rect");
        return rect.position(this.vector2(0.0, 1.0));
    }

    private static final double pareto$lambda$1(double $invAlpha) {
        return 1.0 / Math.pow(1.0 - Random.double0$default(INSTANCE, 0.0, 1, null), $invAlpha);
    }

    static {
        seed = "OPENRNDR";
        rnd = INSTANCE.newRandomGenerator(seed);
        state = new RandomState(seed, rnd);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lorg/openrndr/extra/noise/Random$Fractal;", "", "<init>", "(Ljava/lang/String;I)V", "FBM", "BILLOW", "RIGID", "orx-noise"})
    public static final class Fractal
    extends Enum<Fractal> {
        public static final /* enum */ Fractal FBM = new Fractal();
        public static final /* enum */ Fractal BILLOW = new Fractal();
        public static final /* enum */ Fractal RIGID = new Fractal();
        private static final /* synthetic */ Fractal[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static Fractal[] values() {
            return (Fractal[])$VALUES.clone();
        }

        public static Fractal valueOf(String value2) {
            return Enum.valueOf(Fractal.class, value2);
        }

        @NotNull
        public static EnumEntries<Fractal> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = fractalArray = new Fractal[]{Fractal.FBM, Fractal.BILLOW, Fractal.RIGID};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lorg/openrndr/extra/noise/Random$Noise;", "", "<init>", "(Ljava/lang/String;I)V", "LINEAR", "QUINTIC", "HERMIT", "orx-noise"})
    public static final class Noise
    extends Enum<Noise> {
        public static final /* enum */ Noise LINEAR = new Noise();
        public static final /* enum */ Noise QUINTIC = new Noise();
        public static final /* enum */ Noise HERMIT = new Noise();
        private static final /* synthetic */ Noise[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static Noise[] values() {
            return (Noise[])$VALUES.clone();
        }

        public static Noise valueOf(String value2) {
            return Enum.valueOf(Noise.class, value2);
        }

        @NotNull
        public static EnumEntries<Noise> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = noiseArray = new Noise[]{Noise.LINEAR, Noise.QUINTIC, Noise.HERMIT};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[Noise.values().length];
            try {
                nArray[Noise.LINEAR.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Noise.QUINTIC.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Noise.HERMIT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[Fractal.values().length];
            try {
                nArray[Fractal.FBM.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Fractal.RIGID.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Fractal.BILLOW.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

