/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.extra.noise;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequenceScope;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.openrndr.extra.hashgrid.HashGrid;
import org.openrndr.extra.noise.PoissonDiskKt;
import org.openrndr.extra.noise.TriangleNoiseKt;
import org.openrndr.extra.noise.UniformRandomKt;
import org.openrndr.math.Vector2;
import org.openrndr.shape.Rectangle;
import org.openrndr.shape.Segment2D;
import org.openrndr.shape.Shape;
import org.openrndr.shape.ShapeContour;
import org.openrndr.shape.ShapeExtensionsKt;
import org.openrndr.shape.ShapeProvider;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u001a\u001e\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\b\b\u0002\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u001a\"\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00010\u0007*\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u001aZ\u0010\n\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010\u00070\u000b0\u0007*\u00020\u00022\u0018\u0010\f\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u000b0\u00072\b\b\u0002\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\r\u001a\u00020\t2\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u001ab\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00010\u0007*\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u00042\b\b\u0002\u0010\u0010\u001a\u00020\u00042\b\b\u0002\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\r\u001a\u00020\t2 \b\u0002\u0010\u0011\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010\u00070\u000b0\u00072\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0012"}, d2={"uniform", "Lorg/openrndr/math/Vector2;", "Lorg/openrndr/shape/ShapeProvider;", "distanceToEdge", "", "random", "Lkotlin/random/Random;", "", "sampleCount", "", "multiScatter", "Lkotlin/Pair;", "radii", "tries", "scatter", "placementRadius", "objectRadius", "obstacles", "orx-noise"})
@SourceDebugExtension(value={"SMAP\nShapeNoise.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ShapeNoise.kt\norg/openrndr/extra/noise/ShapeNoiseKt\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,150:1\n127#2:151\n128#2:153\n183#2:171\n184#2:175\n1#3:152\n1#3:176\n1557#4:154\n1628#4,3:155\n1368#4:158\n1454#4,2:159\n1611#4,9:161\n1863#4:170\n1734#4,3:172\n1864#4:177\n1620#4:178\n1456#4,3:179\n1557#4:182\n1628#4,3:183\n*S KotlinDebug\n*F\n+ 1 ShapeNoise.kt\norg/openrndr/extra/noise/ShapeNoiseKt\n*L\n17#1:151\n17#1:153\n106#1:171\n106#1:175\n105#1:176\n87#1:154\n87#1:155,3\n104#1:158\n104#1:159,2\n105#1:161,9\n105#1:170\n107#1:172,3\n105#1:177\n105#1:178\n104#1:179,3\n123#1:182\n123#1:183,3\n*E\n"})
public final class ShapeNoiseKt {
    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static final Vector2 uniform(@NotNull ShapeProvider $this$uniform, double distanceToEdge, @NotNull Random random) {
        Vector2 element$iv;
        boolean bl;
        Intrinsics.checkNotNullParameter($this$uniform, "<this>");
        Intrinsics.checkNotNullParameter(random, "random");
        Shape shape = $this$uniform.getShape();
        if (!(!shape.getEmpty())) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        int attempts = 0;
        Rectangle innerBounds = Rectangle.offsetEdges$default(shape.getBounds(), -RangesKt.coerceAtLeast(distanceToEdge, 0.0), 0.0, 2, null);
        Sequence<Vector2> $this$first$iv = UniformRandomKt.uniformSequence(Vector2.Companion, innerBounds, random);
        boolean $i$f$first = false;
        Iterator<Vector2> iterator2 = $this$first$iv.iterator();
        do {
            Iterator iterator3;
            if (!iterator2.hasNext()) throw new NoSuchElementException("Sequence contains no element matching the predicate.");
            Vector2 it = element$iv = iterator2.next();
            boolean bl2 = false;
            if (!(++attempts < 100)) {
                iterator3 = "Failed requirement.";
                throw new IllegalArgumentException(iterator3.toString());
            }
            if (distanceToEdge == 0.0) {
                bl = ShapeExtensionsKt.contains(shape, it);
                continue;
            }
            if (ShapeExtensionsKt.contains(shape, it)) {
                iterator3 = ((Iterable)shape.getContours()).iterator();
                if (!iterator3.hasNext()) {
                    throw new NoSuchElementException();
                }
                ShapeContour c2 = (ShapeContour)iterator3.next();
                boolean bl3 = false;
                double d = c2.nearest(it).position().distanceTo(it);
                while (iterator3.hasNext()) {
                    ShapeContour c3 = (ShapeContour)iterator3.next();
                    $i$a$-minOf-ShapeNoiseKt$uniform$1$1 = false;
                    double d2 = c3.nearest(it).position().distanceTo(it);
                    d = Math.min(d, d2);
                }
                if (d > distanceToEdge) {
                    bl = true;
                    continue;
                }
            }
            bl = false;
        } while (!bl);
        return element$iv;
    }

    public static /* synthetic */ Vector2 uniform$default(ShapeProvider shapeProvider, double d, Random random, int n, Object object) {
        if ((n & 1) != 0) {
            d = 0.0;
        }
        if ((n & 2) != 0) {
            random = Random.Default;
        }
        return ShapeNoiseKt.uniform(shapeProvider, d, random);
    }

    @NotNull
    public static final List<Vector2> uniform(@NotNull ShapeProvider $this$uniform, int sampleCount, @NotNull Random random) {
        Intrinsics.checkNotNullParameter($this$uniform, "<this>");
        Intrinsics.checkNotNullParameter(random, "random");
        return TriangleNoiseKt.uniform($this$uniform.getShape().getTriangulation(), sampleCount, random);
    }

    public static /* synthetic */ List uniform$default(ShapeProvider shapeProvider, int n, Random random, int n2, Object object) {
        if ((n2 & 2) != 0) {
            random = Random.Default;
        }
        return ShapeNoiseKt.uniform(shapeProvider, n, random);
    }

    @NotNull
    public static final List<Pair<Double, List<Vector2>>> multiScatter(@NotNull ShapeProvider $this$multiScatter, @NotNull List<Pair<Double, Double>> radii, double distanceToEdge, int tries, @NotNull Random random) {
        Intrinsics.checkNotNullParameter($this$multiScatter, "<this>");
        Intrinsics.checkNotNullParameter(radii, "radii");
        Intrinsics.checkNotNullParameter(random, "random");
        List obstacles = new ArrayList();
        List result2 = new ArrayList();
        for (Pair<Double, Double> pair : radii) {
            double placementRadius = ((Number)pair.component1()).doubleValue();
            double objectRadius = ((Number)pair.component2()).doubleValue();
            List<Vector2> points2 = ShapeNoiseKt.scatter($this$multiScatter, placementRadius, objectRadius, distanceToEdge, tries, obstacles, random);
            obstacles.add(new Pair<Double, List<Vector2>>(objectRadius, points2));
            result2.add(new Pair<Double, List<Vector2>>(objectRadius, points2));
        }
        return result2;
    }

    public static /* synthetic */ List multiScatter$default(ShapeProvider shapeProvider, List list, double d, int n, Random random, int n2, Object object) {
        if ((n2 & 2) != 0) {
            d = 0.0;
        }
        if ((n2 & 4) != 0) {
            n = 30;
        }
        if ((n2 & 8) != 0) {
            random = Random.Default;
        }
        return ShapeNoiseKt.multiScatter(shapeProvider, list, d, n, random);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<Vector2> scatter(@NotNull ShapeProvider $this$scatter, double placementRadius, double objectRadius, double distanceToEdge, int tries, @NotNull List<? extends Pair<Double, ? extends List<Vector2>>> obstacles, @NotNull Random random) {
        Vector2 $this$mapNotNullTo$iv$iv;
        void $this$flatMapTo$iv$iv;
        Collection collection;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$scatter, "<this>");
        Intrinsics.checkNotNullParameter(obstacles, "obstacles");
        Intrinsics.checkNotNullParameter(random, "random");
        Shape shape = $this$scatter.getShape();
        if (shape.getEmpty()) {
            return CollectionsKt.emptyList();
        }
        Rectangle bounds = shape.getBounds();
        Iterable $this$map$iv = obstacles;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo22 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Pair pair = (Pair)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            double obstacleRadius = ((Number)pair.component1()).doubleValue();
            List points2 = (List)pair.component2();
            HashGrid hg = new HashGrid(obstacleRadius + objectRadius);
            for (Vector2 point : points2) {
                HashGrid.insert$default(hg, point, null, 2, null);
            }
            collection.add(hg);
        }
        List obstacleHashGrids = (List)destination$iv$iv;
        HashGrid initialPointHashGrid = new HashGrid(placementRadius);
        Iterable $this$flatMap$iv = Shape.splitCompounds$default(shape, null, 1, null);
        boolean $i$f$flatMap = false;
        Iterable $i$f$mapTo22 = $this$flatMap$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            Shape compound = (Shape)element$iv$iv;
            boolean bl = false;
            Iterable $this$mapNotNull$iv = compound.getOutline().getSegments();
            boolean $i$f$mapNotNull = false;
            Iterable iterable2 = $this$mapNotNull$iv;
            Collection destination$iv$iv3 = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                Vector2 it$iv$iv;
                Vector2 vector2;
                block15: {
                    Object element$iv$iv$iv;
                    Object element$iv$iv2 = element$iv$iv$iv = iterator2.next();
                    boolean bl2 = false;
                    Segment2D it = (Segment2D)element$iv$iv2;
                    boolean bl3 = false;
                    Sequence<Vector2> $this$firstOrNull$iv = ShapeNoiseKt.scatter$randomPoints(it, random, distanceToEdge, 20);
                    boolean $i$f$firstOrNull = false;
                    Iterator<Vector2> iterator3 = $this$firstOrNull$iv.iterator();
                    while (iterator3.hasNext()) {
                        boolean bl4;
                        Vector2 v;
                        Vector2 element$iv;
                        block14: {
                            v = element$iv = iterator3.next();
                            boolean bl5 = false;
                            Iterable $this$all$iv = obstacleHashGrids;
                            boolean $i$f$all = false;
                            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                                bl4 = true;
                            } else {
                                for (Object element$iv2 : $this$all$iv) {
                                    HashGrid ohg = (HashGrid)element$iv2;
                                    boolean bl6 = false;
                                    if (HashGrid.isFree$default(ohg, v, null, 2, null)) continue;
                                    bl4 = false;
                                    break block14;
                                }
                                bl4 = true;
                            }
                        }
                        if (!(bl4 && HashGrid.isFree$default(initialPointHashGrid, v, null, 2, null) && ShapeExtensionsKt.contains(compound, v) && compound.getOutline().nearest(v).position().distanceTo(v) >= distanceToEdge - 0.1)) continue;
                        vector2 = element$iv;
                        break block15;
                    }
                    vector2 = null;
                }
                Vector2 point = vector2;
                if (point != null) {
                    HashGrid.insert$default(initialPointHashGrid, point, null, 2, null);
                }
                if (point == null) continue;
                boolean bl7 = false;
                destination$iv$iv3.add(it$iv$iv);
            }
            Iterable list$iv$iv = (List)destination$iv$iv3;
            CollectionsKt.addAll(destination$iv$iv2, list$iv$iv);
        }
        List initialPoints = (List)destination$iv$iv2;
        if (!(!((Collection)initialPoints).isEmpty() || !((Collection)obstacles).isEmpty())) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        List candidatePoints = new ArrayList();
        for (Vector2 point : initialPoints) {
            void $this$mapTo$iv$iv2;
            Iterable $this$map$iv2 = candidatePoints;
            boolean $i$f$map2 = false;
            Iterable element$iv$iv = $this$map$iv2;
            Collection destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv2, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                void it;
                $this$mapNotNullTo$iv$iv = (Vector2)item$iv$iv;
                collection = destination$iv$iv4;
                boolean bl = false;
                collection.add(it.distanceTo(point));
            }
            Object t = CollectionsKt.minOrNull((List)destination$iv$iv4);
            double d = t != null ? (Double)t : Double.POSITIVE_INFINITY;
            if (!(d >= placementRadius * 2.0)) continue;
            candidatePoints.add(point);
        }
        if (candidatePoints.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        return PoissonDiskKt.poissonDiskSampling(bounds, placementRadius * 2.0, tries, true, random, candidatePoints, obstacleHashGrids, arg_0 -> ShapeNoiseKt.scatter$lambda$9(distanceToEdge, shape, arg_0));
    }

    public static /* synthetic */ List scatter$default(ShapeProvider shapeProvider, double d, double d2, double d3, int n, List list, Random random, int n2, Object object) {
        if ((n2 & 2) != 0) {
            d2 = d;
        }
        if ((n2 & 4) != 0) {
            d3 = 0.0;
        }
        if ((n2 & 8) != 0) {
            n = 30;
        }
        if ((n2 & 0x10) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n2 & 0x20) != 0) {
            random = Random.Default;
        }
        return ShapeNoiseKt.scatter(shapeProvider, d, d2, d3, n, list, random);
    }

    private static final Sequence<Vector2> scatter$randomPoints(Segment2D $this$scatter_u24randomPoints, Random $random, double $distanceToEdge, int count2) {
        return SequencesKt.sequence((Function2)new Function2<SequenceScope<? super Vector2>, Continuation<? super Unit>, Object>(count2, $random, $this$scatter_u24randomPoints, $distanceToEdge, null){
            int I$0;
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ int $count;
            final /* synthetic */ Random $random;
            final /* synthetic */ Segment2D $this_randomPoints;
            final /* synthetic */ double $distanceToEdge;
            {
                this.$count = $count;
                this.$random = $random;
                this.$this_randomPoints = $receiver;
                this.$distanceToEdge = $distanceToEdge;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object var1_1) {
                var6_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure(var1_1);
                        $this$sequence = (SequenceScope)this.L$0;
                        i = 0;
lbl7:
                        // 2 sources

                        while (i < this.$count) {
                            t = this.$random.nextDouble();
                            this.L$0 = $this$sequence;
                            this.I$0 = i;
                            this.label = 1;
                            v0 = $this$sequence.yield(this.$this_randomPoints.position(t).minus(((Vector2)Segment2D.normal$default(this.$this_randomPoints, t, null, 2, null).getNormalized()).times(this.$distanceToEdge)), this);
                            if (v0 == var6_2) {
                                return var6_2;
                            }
                            ** GOTO lbl22
                        }
                        break;
                    }
                    case 1: {
                        i = this.I$0;
                        $this$sequence = (SequenceScope)this.L$0;
                        ResultKt.throwOnFailure($result);
                        v0 = $result;
lbl22:
                        // 2 sources

                        ++i;
                        ** GOTO lbl7
                    }
                }
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value2;
                return var3_3;
            }

            public final Object invoke(SequenceScope<? super Vector2> p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean scatter$lambda$9(double $distanceToEdge, Shape $shape, Vector2 point) {
        Intrinsics.checkNotNullParameter($shape, "$shape");
        Intrinsics.checkNotNullParameter(point, "point");
        if (!($distanceToEdge == 0.0)) {
            if (!ShapeExtensionsKt.contains($shape, point)) return false;
            Iterator iterator2 = ((Iterable)$shape.getContours()).iterator();
            if (!iterator2.hasNext()) {
                throw new NoSuchElementException();
            }
            ShapeContour c2 = (ShapeContour)iterator2.next();
            boolean bl = false;
            double d = c2.nearest(point).position().distanceTo(point);
            while (iterator2.hasNext()) {
                ShapeContour c3 = (ShapeContour)iterator2.next();
                $i$a$-minOf-ShapeNoiseKt$scatter$2$1 = false;
                double d2 = c3.nearest(point).position().distanceTo(point);
                d = Math.min(d, d2);
            }
            if (!(d > $distanceToEdge)) return false;
            return true;
        }
        boolean bl = ShapeExtensionsKt.contains($shape, point);
        return bl;
    }
}

