/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.extra.noise;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.openrndr.extra.noise.GradCoordKt;
import org.openrndr.extra.noise.MathUtilsKt;
import org.openrndr.math.Vector3;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000$\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u001a\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u001a&\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u0005\u001a\u001a\u0010\u0004\u001a\u00020\t*\u00020\r2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0005\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"F3", "", "G3", "G33", "simplex", "", "seed", "", "position", "Lorg/openrndr/math/Vector3;", "x", "y", "z", "Lorg/openrndr/math/Vector3$Companion;", "orx-noise"})
public final class SimplexNoise3DKt {
    private static final float F3 = 0.33333334f;
    private static final float G3 = 0.16666667f;
    private static final float G33 = -0.5f;

    public static final double simplex(int seed, @NotNull Vector3 position) {
        Intrinsics.checkNotNullParameter(position, "position");
        return SimplexNoise3DKt.simplex(seed, position.x(), position.y(), position.z());
    }

    public static final double simplex(int seed, double x, double y, double z) {
        double t = (x + y + z) / 3.0;
        int i = MathUtilsKt.fastFloor(x + t);
        int j = MathUtilsKt.fastFloor(y + t);
        int k = MathUtilsKt.fastFloor(z + t);
        double t2 = (double)(i + j + k) / 6.0;
        double x0 = x - ((double)i - t2);
        double y0 = y - ((double)j - t2);
        double z0 = z - ((double)k - t2);
        int i1 = 0;
        int j1 = 0;
        int k1 = 0;
        int i2 = 0;
        int j2 = 0;
        int k2 = 0;
        if (x0 >= y0) {
            if (y0 >= z0) {
                i1 = 1;
                j1 = 0;
                k1 = 0;
                i2 = 1;
                j2 = 1;
                k2 = 0;
            } else if (x0 >= z0) {
                i1 = 1;
                j1 = 0;
                k1 = 0;
                i2 = 1;
                j2 = 0;
                k2 = 1;
            } else {
                i1 = 0;
                j1 = 0;
                k1 = 1;
                i2 = 1;
                j2 = 0;
                k2 = 1;
            }
        } else if (y0 < z0) {
            i1 = 0;
            j1 = 0;
            k1 = 1;
            i2 = 0;
            j2 = 1;
            k2 = 1;
        } else if (x0 < z0) {
            i1 = 0;
            j1 = 1;
            k1 = 0;
            i2 = 0;
            j2 = 1;
            k2 = 1;
        } else {
            i1 = 0;
            j1 = 1;
            k1 = 0;
            i2 = 1;
            j2 = 1;
            k2 = 0;
        }
        double x1 = x0 - (double)i1 + 0.16666666666666666;
        double y1 = y0 - (double)j1 + 0.16666666666666666;
        double z1 = z0 - (double)k1 + 0.16666666666666666;
        double x2 = x0 - (double)i2 + 0.3333333333333333;
        double y2 = y0 - (double)j2 + 0.3333333333333333;
        double z2 = z0 - (double)k2 + 0.3333333333333333;
        double x3 = x0 + (double)-0.5f;
        double y3 = y0 + (double)-0.5f;
        double z3 = z0 + (double)-0.5f;
        double n0 = 0.0;
        boolean bl = false;
        double lt = 0.6 - x0 * x0 - y0 * y0 - z0 * z0;
        if (lt < 0.0) {
            n0 = 0.0;
        } else {
            lt *= lt;
            n0 = lt * lt * GradCoordKt.gradCoord3D(seed, i, j, k, x0, y0, z0);
        }
        double n1 = 0.0;
        boolean bl2 = false;
        double lt2 = 0.6 - x1 * x1 - y1 * y1 - z1 * z1;
        if (lt2 < 0.0) {
            n1 = 0.0;
        } else {
            lt2 *= lt2;
            n1 = lt2 * lt2 * GradCoordKt.gradCoord3D(seed, i + i1, j + j1, k + k1, x1, y1, z1);
        }
        double n2 = 0.0;
        boolean bl3 = false;
        double lt3 = 0.6 - x2 * x2 - y2 * y2 - z2 * z2;
        if (lt3 < 0.0) {
            n2 = 0.0;
        } else {
            lt3 *= lt3;
            n2 = lt3 * lt3 * GradCoordKt.gradCoord3D(seed, i + i2, j + j2, k + k2, x2, y2, z2);
        }
        double n3 = 0.0;
        boolean bl4 = false;
        double lt4 = 0.6 - x3 * x3 - y3 * y3 - z3 * z3;
        if (lt4 < 0.0) {
            n3 = 0.0;
        } else {
            lt4 *= lt4;
            n3 = lt4 * lt4 * GradCoordKt.gradCoord3D(seed, i + 1, j + 1, k + 1, x3, y3, z3);
        }
        return (double)32 * (n0 + n1 + n2 + n3);
    }

    @NotNull
    public static final Vector3 simplex(@NotNull Vector3.Companion $this$simplex, int seed, double x) {
        Intrinsics.checkNotNullParameter($this$simplex, "<this>");
        return new Vector3(SimplexNoise3DKt.simplex(seed, x, 0.0, 0.0), SimplexNoise3DKt.simplex(seed, 0.0, x + 31.3383, 0.0), SimplexNoise3DKt.simplex(seed, 0.0, 0.0, x - 483.23));
    }
}

