/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.extra.noise;

import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.openrndr.extra.noise.GradCoordKt;
import org.openrndr.extra.noise.InterpolationKt;
import org.openrndr.extra.noise.MathUtilsKt;
import org.openrndr.extra.noise.ValueNoise2DKt;
import org.openrndr.math.MappingKt;
import org.openrndr.math.Vector2;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u001a\u001e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0001\u001a\u001e\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0001\u001a\u001e\u0010\u0007\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0001\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\t\u001a\u0016\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\t\u001a\u0016\u0010\u0007\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\t\u001a:\u0010\n\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u00012\u0014\b\u0006\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00010\fH\u0086\b\u00f8\u0001\u0000\")\u0010\r\u001a\u001a\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00010\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\")\u0010\u0011\u001a\u001a\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00010\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0010\")\u0010\u0013\u001a\u001a\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00010\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0010\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u0015"}, d2={"valueLinear", "", "seed", "", "x", "y", "valueQuintic", "valueHermite", "position", "Lorg/openrndr/math/Vector2;", "value", "interpolation", "Lkotlin/Function1;", "valueLinear2D", "Lkotlin/Function3;", "getValueLinear2D", "()Lkotlin/jvm/functions/Function3;", "valueQuintic2D", "getValueQuintic2D", "valueHermite2D", "getValueHermite2D", "orx-noise"})
@SourceDebugExtension(value={"SMAP\nValueNoise2D.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ValueNoise2D.kt\norg/openrndr/extra/noise/ValueNoise2DKt\n*L\n1#1,36:1\n20#1,12:37\n20#1,12:49\n20#1,12:61\n20#1,12:73\n20#1,12:85\n20#1,12:97\n*S KotlinDebug\n*F\n+ 1 ValueNoise2D.kt\norg/openrndr/extra/noise/ValueNoise2DKt\n*L\n6#1:37,12\n7#1:49,12\n8#1:61,12\n11#1:73,12\n14#1:85,12\n17#1:97,12\n*E\n"})
public final class ValueNoise2DKt {
    @NotNull
    private static final Function3<Integer, Double, Double, Double> valueLinear2D = valueLinear2D.1.INSTANCE;
    @NotNull
    private static final Function3<Integer, Double, Double, Double> valueQuintic2D = valueQuintic2D.1.INSTANCE;
    @NotNull
    private static final Function3<Integer, Double, Double, Double> valueHermite2D = valueHermite2D.1.INSTANCE;

    public static final double valueLinear(int seed, double x, double y) {
        boolean $i$f$value = false;
        int x0$iv = MathUtilsKt.fastFloor(x);
        int y0$iv = MathUtilsKt.fastFloor(y);
        int x1$iv = x0$iv + 1;
        int y1$iv = y0$iv + 1;
        double p0 = x - (double)x0$iv;
        boolean bl = false;
        double xs$iv = InterpolationKt.linear(p0);
        double p02 = y - (double)y0$iv;
        $i$a$-value-ValueNoise2DKt$valueLinear$1 = false;
        double ys$iv = InterpolationKt.linear(p02);
        double xf0$iv = MappingKt.mix(GradCoordKt.valCoord2D(seed, x0$iv, y0$iv), GradCoordKt.valCoord2D(seed, x1$iv, y0$iv), xs$iv);
        double xf1$iv = MappingKt.mix(GradCoordKt.valCoord2D(seed, x0$iv, y1$iv), GradCoordKt.valCoord2D(seed, x1$iv, y1$iv), xs$iv);
        return MappingKt.mix(xf0$iv, xf1$iv, ys$iv);
    }

    public static final double valueQuintic(int seed, double x, double y) {
        boolean $i$f$value = false;
        int x0$iv = MathUtilsKt.fastFloor(x);
        int y0$iv = MathUtilsKt.fastFloor(y);
        int x1$iv = x0$iv + 1;
        int y1$iv = y0$iv + 1;
        double p0 = x - (double)x0$iv;
        boolean bl = false;
        double xs$iv = InterpolationKt.quintic(p0);
        double p02 = y - (double)y0$iv;
        $i$a$-value-ValueNoise2DKt$valueQuintic$1 = false;
        double ys$iv = InterpolationKt.quintic(p02);
        double xf0$iv = MappingKt.mix(GradCoordKt.valCoord2D(seed, x0$iv, y0$iv), GradCoordKt.valCoord2D(seed, x1$iv, y0$iv), xs$iv);
        double xf1$iv = MappingKt.mix(GradCoordKt.valCoord2D(seed, x0$iv, y1$iv), GradCoordKt.valCoord2D(seed, x1$iv, y1$iv), xs$iv);
        return MappingKt.mix(xf0$iv, xf1$iv, ys$iv);
    }

    public static final double valueHermite(int seed, double x, double y) {
        boolean $i$f$value = false;
        int x0$iv = MathUtilsKt.fastFloor(x);
        int y0$iv = MathUtilsKt.fastFloor(y);
        int x1$iv = x0$iv + 1;
        int y1$iv = y0$iv + 1;
        double p0 = x - (double)x0$iv;
        boolean bl = false;
        double xs$iv = InterpolationKt.hermite(p0);
        double p02 = y - (double)y0$iv;
        $i$a$-value-ValueNoise2DKt$valueHermite$1 = false;
        double ys$iv = InterpolationKt.hermite(p02);
        double xf0$iv = MappingKt.mix(GradCoordKt.valCoord2D(seed, x0$iv, y0$iv), GradCoordKt.valCoord2D(seed, x1$iv, y0$iv), xs$iv);
        double xf1$iv = MappingKt.mix(GradCoordKt.valCoord2D(seed, x0$iv, y1$iv), GradCoordKt.valCoord2D(seed, x1$iv, y1$iv), xs$iv);
        return MappingKt.mix(xf0$iv, xf1$iv, ys$iv);
    }

    /*
     * WARNING - void declaration
     */
    public static final double valueLinear(int seed, @NotNull Vector2 position) {
        void x$iv;
        Intrinsics.checkNotNullParameter(position, "position");
        double d = position.x();
        double y$iv = position.y();
        boolean $i$f$value = false;
        int x0$iv = MathUtilsKt.fastFloor((double)x$iv);
        int y0$iv = MathUtilsKt.fastFloor(y$iv);
        int x1$iv = x0$iv + 1;
        int y1$iv = y0$iv + 1;
        void p0 = x$iv - (double)x0$iv;
        boolean bl = false;
        double xs$iv = InterpolationKt.linear((double)p0);
        double p02 = y$iv - (double)y0$iv;
        $i$a$-value-ValueNoise2DKt$valueLinear$2 = false;
        double ys$iv = InterpolationKt.linear(p02);
        double xf0$iv = MappingKt.mix(GradCoordKt.valCoord2D(seed, x0$iv, y0$iv), GradCoordKt.valCoord2D(seed, x1$iv, y0$iv), xs$iv);
        double xf1$iv = MappingKt.mix(GradCoordKt.valCoord2D(seed, x0$iv, y1$iv), GradCoordKt.valCoord2D(seed, x1$iv, y1$iv), xs$iv);
        return MappingKt.mix(xf0$iv, xf1$iv, ys$iv);
    }

    /*
     * WARNING - void declaration
     */
    public static final double valueQuintic(int seed, @NotNull Vector2 position) {
        void x$iv;
        Intrinsics.checkNotNullParameter(position, "position");
        double d = position.x();
        double y$iv = position.y();
        boolean $i$f$value = false;
        int x0$iv = MathUtilsKt.fastFloor((double)x$iv);
        int y0$iv = MathUtilsKt.fastFloor(y$iv);
        int x1$iv = x0$iv + 1;
        int y1$iv = y0$iv + 1;
        void p0 = x$iv - (double)x0$iv;
        boolean bl = false;
        double xs$iv = InterpolationKt.quintic((double)p0);
        double p02 = y$iv - (double)y0$iv;
        $i$a$-value-ValueNoise2DKt$valueQuintic$2 = false;
        double ys$iv = InterpolationKt.quintic(p02);
        double xf0$iv = MappingKt.mix(GradCoordKt.valCoord2D(seed, x0$iv, y0$iv), GradCoordKt.valCoord2D(seed, x1$iv, y0$iv), xs$iv);
        double xf1$iv = MappingKt.mix(GradCoordKt.valCoord2D(seed, x0$iv, y1$iv), GradCoordKt.valCoord2D(seed, x1$iv, y1$iv), xs$iv);
        return MappingKt.mix(xf0$iv, xf1$iv, ys$iv);
    }

    /*
     * WARNING - void declaration
     */
    public static final double valueHermite(int seed, @NotNull Vector2 position) {
        void x$iv;
        Intrinsics.checkNotNullParameter(position, "position");
        double d = position.x();
        double y$iv = position.y();
        boolean $i$f$value = false;
        int x0$iv = MathUtilsKt.fastFloor((double)x$iv);
        int y0$iv = MathUtilsKt.fastFloor(y$iv);
        int x1$iv = x0$iv + 1;
        int y1$iv = y0$iv + 1;
        void p0 = x$iv - (double)x0$iv;
        boolean bl = false;
        double xs$iv = InterpolationKt.hermite((double)p0);
        double p02 = y$iv - (double)y0$iv;
        $i$a$-value-ValueNoise2DKt$valueHermite$2 = false;
        double ys$iv = InterpolationKt.hermite(p02);
        double xf0$iv = MappingKt.mix(GradCoordKt.valCoord2D(seed, x0$iv, y0$iv), GradCoordKt.valCoord2D(seed, x1$iv, y0$iv), xs$iv);
        double xf1$iv = MappingKt.mix(GradCoordKt.valCoord2D(seed, x0$iv, y1$iv), GradCoordKt.valCoord2D(seed, x1$iv, y1$iv), xs$iv);
        return MappingKt.mix(xf0$iv, xf1$iv, ys$iv);
    }

    public static final double value(int seed, double x, double y, @NotNull Function1<? super Double, Double> interpolation) {
        Intrinsics.checkNotNullParameter(interpolation, "interpolation");
        boolean $i$f$value = false;
        int x0 = MathUtilsKt.fastFloor(x);
        int y0 = MathUtilsKt.fastFloor(y);
        int x1 = x0 + 1;
        int y1 = y0 + 1;
        double xs = ((Number)interpolation.invoke((Double)(x - (double)x0))).doubleValue();
        double ys = ((Number)interpolation.invoke((Double)(y - (double)y0))).doubleValue();
        double xf0 = MappingKt.mix(GradCoordKt.valCoord2D(seed, x0, y0), GradCoordKt.valCoord2D(seed, x1, y0), xs);
        double xf1 = MappingKt.mix(GradCoordKt.valCoord2D(seed, x0, y1), GradCoordKt.valCoord2D(seed, x1, y1), xs);
        return MappingKt.mix(xf0, xf1, ys);
    }

    public static /* synthetic */ double value$default(int seed, double x, double y, Function1 interpolation, int n, Object object) {
        if ((n & 8) != 0) {
            interpolation = value.1.INSTANCE;
        }
        Intrinsics.checkNotNullParameter(interpolation, "interpolation");
        boolean $i$f$value = false;
        int x0 = MathUtilsKt.fastFloor(x);
        int y0 = MathUtilsKt.fastFloor(y);
        int x1 = x0 + 1;
        int y1 = y0 + 1;
        double xs = ((Number)interpolation.invoke(x - (double)x0)).doubleValue();
        double ys = ((Number)interpolation.invoke(y - (double)y0)).doubleValue();
        double xf0 = MappingKt.mix(GradCoordKt.valCoord2D(seed, x0, y0), GradCoordKt.valCoord2D(seed, x1, y0), xs);
        double xf1 = MappingKt.mix(GradCoordKt.valCoord2D(seed, x0, y1), GradCoordKt.valCoord2D(seed, x1, y1), xs);
        return MappingKt.mix(xf0, xf1, ys);
    }

    @NotNull
    public static final Function3<Integer, Double, Double, Double> getValueLinear2D() {
        return valueLinear2D;
    }

    @NotNull
    public static final Function3<Integer, Double, Double, Double> getValueQuintic2D() {
        return valueQuintic2D;
    }

    @NotNull
    public static final Function3<Integer, Double, Double, Double> getValueHermite2D() {
        return valueHermite2D;
    }
}

