/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.extra.objloader;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openrndr.extra.objloader.Polygon;
import org.openrndr.extra.objloader.VertexData;
import org.openrndr.math.Matrix44;
import org.openrndr.math.Vector2;
import org.openrndr.math.Vector3;
import org.openrndr.math.Vector4;
import org.openrndr.shape.TriangulatorKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0015\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\u0012\u001a\u00020\u0013J\u000e\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000fJ\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00000\u00162\u0006\u0010\u000e\u001a\u00020\u000fJ\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00000\u00162\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u000e\u001a\u00020\u000fJ\t\u0010\u001a\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001c\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u001d\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u001e\u001a\u00020\u00112\b\u0010\u001f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010 \u001a\u00020!H\u00d6\u0001J\t\u0010\"\u001a\u00020#H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\t\u00a8\u0006$"}, d2={"Lorg/openrndr/extra/objloader/IndexedPolygon;", "", "positions", "", "textureCoords", "normals", "<init>", "([I[I[I)V", "getPositions", "()[I", "getTextureCoords", "getNormals", "base", "Lorg/openrndr/math/Matrix44;", "vertexData", "Lorg/openrndr/extra/objloader/VertexData;", "isPlanar", "", "eps", "", "isConvex", "tessellate", "", "triangulate", "toPolygon", "Lorg/openrndr/extra/objloader/Polygon;", "component1", "component2", "component3", "copy", "equals", "other", "hashCode", "", "toString", "", "orx-obj-loader"})
@SourceDebugExtension(value={"SMAP\nIndexedPolygon.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IndexedPolygon.kt\norg/openrndr/extra/objloader/IndexedPolygon\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,144:1\n1734#2,3:145\n1557#2:148\n1628#2,3:149\n1557#2:152\n1628#2,3:153\n37#3,2:156\n37#3,2:158\n37#3,2:160\n*S KotlinDebug\n*F\n+ 1 IndexedPolygon.kt\norg/openrndr/extra/objloader/IndexedPolygon\n*L\n43#1:145,3\n102#1:148\n102#1:149,3\n116#1:152\n116#1:153,3\n139#1:156,2\n140#1:158,2\n141#1:160,2\n*E\n"})
public final class IndexedPolygon {
    @NotNull
    private final int[] positions;
    @NotNull
    private final int[] textureCoords;
    @NotNull
    private final int[] normals;

    public IndexedPolygon(@NotNull int[] positions, @NotNull int[] textureCoords, @NotNull int[] normals) {
        Intrinsics.checkNotNullParameter(positions, "positions");
        Intrinsics.checkNotNullParameter(textureCoords, "textureCoords");
        Intrinsics.checkNotNullParameter(normals, "normals");
        this.positions = positions;
        this.textureCoords = textureCoords;
        this.normals = normals;
    }

    @NotNull
    public final int[] getPositions() {
        return this.positions;
    }

    @NotNull
    public final int[] getTextureCoords() {
        return this.textureCoords;
    }

    @NotNull
    public final int[] getNormals() {
        return this.normals;
    }

    @NotNull
    public final Matrix44 base(@NotNull VertexData vertexData) {
        Intrinsics.checkNotNullParameter(vertexData, "vertexData");
        Vector3 u = vertexData.getPositions()[this.positions[1]].minus(vertexData.getPositions()[this.positions[0]]);
        Vector3 v = vertexData.getPositions()[this.positions[this.positions.length - 1]].minus(vertexData.getPositions()[this.positions[0]]);
        Vector3 normal = u.cross(v);
        Vector3 bitangent = normal.cross(u);
        return Matrix44.Companion.fromColumnVectors((Vector4)u.xyz0().getNormalized(), (Vector4)bitangent.xyz0().getNormalized(), (Vector4)normal.xyz0().getNormalized(), Vector4.Companion.getUNIT_W());
    }

    public final boolean isPlanar(@NotNull VertexData vertexData, double eps) {
        boolean bl;
        block5: {
            Intrinsics.checkNotNullParameter(vertexData, "vertexData");
            if (this.positions.length <= 3) {
                bl = true;
            } else {
                Vector3 n0 = IndexedPolygon.isPlanar$normal(vertexData, this, 0);
                Iterable $this$all$iv = RangesKt.until(1, this.positions.length - 2);
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    Iterator iterator2 = $this$all$iv.iterator();
                    while (iterator2.hasNext()) {
                        int element$iv;
                        int it = element$iv = ((IntIterator)iterator2).nextInt();
                        boolean bl2 = false;
                        if (n0.dot(IndexedPolygon.isPlanar$normal(vertexData, this, it)) >= 1.0 - eps) continue;
                        bl = false;
                        break block5;
                    }
                    bl = true;
                }
            }
        }
        return bl;
    }

    public static /* synthetic */ boolean isPlanar$default(IndexedPolygon indexedPolygon, VertexData vertexData, double d, int n, Object object) {
        if ((n & 2) != 0) {
            d = 0.01;
        }
        return indexedPolygon.isPlanar(vertexData, d);
    }

    public final boolean isConvex(@NotNull VertexData vertexData) {
        Intrinsics.checkNotNullParameter(vertexData, "vertexData");
        Matrix44 planar = this.base(vertexData).inversed();
        if (this.positions.length < 3) {
            return false;
        }
        Vector2 old = IndexedPolygon.isConvex$p(planar, vertexData.getPositions()[this.positions[this.positions.length - 2]]);
        Vector2 vector2 = IndexedPolygon.isConvex$p(planar, vertexData.getPositions()[this.positions[this.positions.length - 1]]);
        double newDirection = Math.atan2(vector2.y() - old.y(), vector2.x() - old.x());
        double angleSum = 0.0;
        double oldDirection = 0.0;
        double orientation = Double.POSITIVE_INFINITY;
        int[] nArray = this.positions;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            Vector2 newPoint;
            int ndx = i;
            int newPointIndex = nArray[i];
            old = vector2;
            oldDirection = newDirection;
            vector2 = newPoint = IndexedPolygon.isConvex$p(planar, vertexData.getPositions()[newPointIndex]);
            newDirection = Math.atan2(vector2.y() - old.y(), vector2.x() - old.x());
            if (Intrinsics.areEqual(old, vector2)) {
                return false;
            }
            double angle = newDirection - oldDirection;
            if (angle <= -Math.PI) {
                angle += Math.PI * 2;
            }
            if (angle > Math.PI) {
                angle -= Math.PI * 2;
            }
            if (ndx == 0) {
                if (angle == 0.0) {
                    return false;
                }
                orientation = angle > 0.0 ? 1.0 : -1.0;
            } else if (orientation * angle <= 0.0) {
                return false;
            }
            angleSum += angle;
        }
        return Math.abs(Math.rint(angleSum / (Math.PI * 2))) == 1.0;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<IndexedPolygon> tessellate(@NotNull VertexData vertexData) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(vertexData, "vertexData");
        List<Vector3> points2 = ArraysKt.slice(vertexData.getPositions(), (Iterable<Integer>)ArraysKt.toList(this.positions));
        List triangles = TriangulatorKt.triangulateV3$default(CollectionsKt.listOf(points2), null, 2, null);
        Iterable $this$map$iv = CollectionsKt.windowed$default(triangles, 3, 3, false, 4, null);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            List list = (List)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new IndexedPolygon(ArraysKt.sliceArray(this.positions, (Collection<Integer>)((Collection)it)), !(this.textureCoords.length == 0) ? ArraysKt.sliceArray(this.textureCoords, (Collection<Integer>)((Collection)it)) : new int[]{}, !(this.normals.length == 0) ? ArraysKt.sliceArray(this.normals, (Collection<Integer>)((Collection)it)) : new int[]{}));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<IndexedPolygon> triangulate(@NotNull VertexData vertexData) {
        List list;
        Intrinsics.checkNotNullParameter(vertexData, "vertexData");
        if (this.positions.length == 3) {
            list = CollectionsKt.listOf(this);
        } else if (IndexedPolygon.isPlanar$default(this, vertexData, 0.0, 2, null) && this.isConvex(vertexData)) {
            void $this$mapTo$iv$iv;
            int triangleCount = this.positions.length - 2;
            Iterable $this$map$iv = RangesKt.until(0, triangleCount);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            Iterator iterator2 = $this$mapTo$iv$iv.iterator();
            while (iterator2.hasNext()) {
                void it;
                int item$iv$iv;
                int n = item$iv$iv = ((IntIterator)iterator2).nextInt();
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Object[] objectArray = new int[]{this.positions[0], this.positions[it + true], this.positions[it + 2]};
                int[] nArray = objectArray;
                objectArray = new Integer[3];
                objectArray[0] = ArraysKt.getOrNull(this.textureCoords, 0);
                objectArray[1] = ArraysKt.getOrNull(this.textureCoords, (int)it);
                objectArray[2] = ArraysKt.getOrNull(this.textureCoords, (int)(it + true));
                int[] nArray2 = CollectionsKt.toIntArray((Collection<Integer>)CollectionsKt.listOfNotNull(objectArray));
                objectArray = new Integer[3];
                objectArray[0] = ArraysKt.getOrNull(this.normals, 0);
                objectArray[1] = ArraysKt.getOrNull(this.normals, (int)it);
                objectArray[2] = ArraysKt.getOrNull(this.normals, (int)(it + true));
                collection.add(new IndexedPolygon(nArray, nArray2, CollectionsKt.toIntArray((Collection<Integer>)CollectionsKt.listOfNotNull(objectArray))));
            }
            list = (List)destination$iv$iv;
        } else {
            list = this.tessellate(vertexData);
        }
        return list;
    }

    @NotNull
    public final Polygon toPolygon(@NotNull VertexData vertexData) {
        Intrinsics.checkNotNullParameter(vertexData, "vertexData");
        Collection $this$toTypedArray$iv = ArraysKt.slice(vertexData.getPositions(), (Iterable<Integer>)ArraysKt.toList(this.positions));
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        $this$toTypedArray$iv = ArraysKt.slice(vertexData.getNormals(), (Iterable<Integer>)ArraysKt.toList(this.normals));
        $i$f$toTypedArray = false;
        thisCollection$iv = $this$toTypedArray$iv;
        $this$toTypedArray$iv = ArraysKt.slice(vertexData.getTextureCoords(), (Iterable<Integer>)ArraysKt.toList(this.textureCoords));
        $i$f$toTypedArray = false;
        thisCollection$iv = $this$toTypedArray$iv;
        return new Polygon(thisCollection$iv.toArray(new Vector3[0]), thisCollection$iv.toArray(new Vector3[0]), thisCollection$iv.toArray(new Vector2[0]));
    }

    @NotNull
    public final int[] component1() {
        return this.positions;
    }

    @NotNull
    public final int[] component2() {
        return this.textureCoords;
    }

    @NotNull
    public final int[] component3() {
        return this.normals;
    }

    @NotNull
    public final IndexedPolygon copy(@NotNull int[] positions, @NotNull int[] textureCoords, @NotNull int[] normals) {
        Intrinsics.checkNotNullParameter(positions, "positions");
        Intrinsics.checkNotNullParameter(textureCoords, "textureCoords");
        Intrinsics.checkNotNullParameter(normals, "normals");
        return new IndexedPolygon(positions, textureCoords, normals);
    }

    public static /* synthetic */ IndexedPolygon copy$default(IndexedPolygon indexedPolygon, int[] nArray, int[] nArray2, int[] nArray3, int n, Object object) {
        if ((n & 1) != 0) {
            nArray = indexedPolygon.positions;
        }
        if ((n & 2) != 0) {
            nArray2 = indexedPolygon.textureCoords;
        }
        if ((n & 4) != 0) {
            nArray3 = indexedPolygon.normals;
        }
        return indexedPolygon.copy(nArray, nArray2, nArray3);
    }

    @NotNull
    public String toString() {
        return "IndexedPolygon(positions=" + Arrays.toString(this.positions) + ", textureCoords=" + Arrays.toString(this.textureCoords) + ", normals=" + Arrays.toString(this.normals) + ")";
    }

    public int hashCode() {
        int result2 = Arrays.hashCode(this.positions);
        result2 = result2 * 31 + Arrays.hashCode(this.textureCoords);
        result2 = result2 * 31 + Arrays.hashCode(this.normals);
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof IndexedPolygon)) {
            return false;
        }
        IndexedPolygon indexedPolygon = (IndexedPolygon)other;
        if (!Intrinsics.areEqual(this.positions, indexedPolygon.positions)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.textureCoords, indexedPolygon.textureCoords)) {
            return false;
        }
        return Intrinsics.areEqual(this.normals, indexedPolygon.normals);
    }

    private static final Vector3 isPlanar$normal(VertexData $vertexData, IndexedPolygon this$0, int i) {
        int n = i - 1;
        int n2 = this$0.positions.length;
        int n3 = n % n2;
        Vector3 p0 = $vertexData.getPositions()[this$0.positions[n3 + (n2 & ((n3 ^ n2) & (n3 | -n3)) >> 31)]];
        n2 = i;
        n3 = this$0.positions.length;
        int n4 = n2 % n3;
        Vector3 p1 = $vertexData.getPositions()[this$0.positions[n4 + (n3 & ((n4 ^ n3) & (n4 | -n4)) >> 31)]];
        n3 = i + 1;
        n4 = this$0.positions.length;
        int n5 = n3 % n4;
        Vector3 p2 = $vertexData.getPositions()[this$0.positions[n5 + (n4 & ((n5 ^ n4) & (n5 | -n5)) >> 31)]];
        Vector3 u = (Vector3)p0.minus(p1).getNormalized();
        Vector3 v = (Vector3)p2.minus(p1).getNormalized();
        return (Vector3)u.cross(v).getNormalized();
    }

    private static final Vector2 isConvex$p(Matrix44 planar, Vector3 v) {
        return planar.times(v.xyz1()).xy();
    }
}

