/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.extra.objloader;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.openrndr.draw.VertexBuffer;
import org.openrndr.extra.objloader.IndexedPolygon;
import org.openrndr.extra.objloader.MeshData;
import org.openrndr.extra.objloader.MeshDataExtensionsKt;
import org.openrndr.extra.objloader.Polygon;
import org.openrndr.extra.objloader.VertexData;
import org.openrndr.math.Vector2;
import org.openrndr.math.Vector3;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u00002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a \u0010\u0000\u001a\u0014\u0012\u0004\u0012\u00020\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\u00012\u0006\u0010\u0005\u001a\u00020\u0002\u001a\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0005\u001a\u00020\u0002\u001a\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u001a\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b\u001a\u0014\u0010\u0006\u001a\u00020\u00072\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00020\u0003\u001a \u0010\u0000\u001a\u0014\u0012\u0004\u0012\u00020\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\u00012\u0006\u0010\n\u001a\u00020\u000b\u001a\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000b\u001a \u0010\u0000\u001a\u0014\u0012\u0004\u0012\u00020\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\u00012\u0006\u0010\b\u001a\u00020\t\u001a\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\t\u001a&\u0010\u0000\u001a\u0014\u0012\u0004\u0012\u00020\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\u00012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00020\u0003\u001a\u000e\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000b\u001a\u0014\u0010\u000f\u001a\u00020\u000e2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00020\u0003\u00a8\u0006\u0010"}, d2={"loadOBJ", "", "", "", "Lorg/openrndr/extra/objloader/Polygon;", "fileOrUrl", "loadOBJasVertexBuffer", "Lorg/openrndr/draw/VertexBuffer;", "url", "Ljava/net/URL;", "file", "Ljava/io/File;", "lines", "loadOBJEx", "Lorg/openrndr/extra/objloader/MeshData;", "loadOBJMeshData", "orx-obj-loader"})
@SourceDebugExtension(value={"SMAP\nOBJLoader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OBJLoader.kt\norg/openrndr/extra/objloader/OBJLoaderKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,101:1\n1863#2:102\n1557#2:103\n1628#2,3:104\n774#2:107\n865#2,2:108\n1557#2:110\n1628#2,3:111\n1557#2:114\n1628#2,2:115\n1557#2:117\n1628#2,3:118\n1630#2:121\n1557#2:122\n1628#2,3:123\n1557#2:126\n1628#2,3:127\n1557#2:130\n1628#2,3:131\n1864#2:134\n37#3,2:135\n*S KotlinDebug\n*F\n+ 1 OBJLoader.kt\norg/openrndr/extra/objloader/OBJLoaderKt\n*L\n57#1:102\n59#1:103\n59#1:104,3\n59#1:107\n59#1:108,2\n72#1:110\n72#1:111,3\n72#1:114\n72#1:115,2\n73#1:117\n73#1:118,3\n72#1:121\n81#1:122\n81#1:123,3\n82#1:126\n82#1:127,3\n83#1:130\n83#1:131,3\n57#1:134\n97#1:135,2\n*E\n"})
public final class OBJLoaderKt {
    @NotNull
    public static final Map<String, List<Polygon>> loadOBJ(@NotNull String fileOrUrl) {
        Map<String, List<Polygon>> map2;
        Intrinsics.checkNotNullParameter(fileOrUrl, "fileOrUrl");
        try {
            URL url = new URL(fileOrUrl);
            map2 = OBJLoaderKt.loadOBJ(url);
        }
        catch (MalformedURLException e) {
            map2 = OBJLoaderKt.loadOBJ(new File(fileOrUrl));
        }
        return map2;
    }

    @NotNull
    public static final VertexBuffer loadOBJasVertexBuffer(@NotNull String fileOrUrl) {
        VertexBuffer vertexBuffer;
        Intrinsics.checkNotNullParameter(fileOrUrl, "fileOrUrl");
        try {
            URL url = new URL(fileOrUrl);
            vertexBuffer = OBJLoaderKt.loadOBJasVertexBuffer(url);
        }
        catch (MalformedURLException e) {
            vertexBuffer = OBJLoaderKt.loadOBJasVertexBuffer(new File(fileOrUrl));
        }
        return vertexBuffer;
    }

    @NotNull
    public static final VertexBuffer loadOBJasVertexBuffer(@NotNull URL url) {
        Intrinsics.checkNotNullParameter(url, "url");
        String[] stringArray = url;
        Charset charset = Charsets.UTF_8;
        byte[] byArray = TextStreamsKt.readBytes((URL)stringArray);
        stringArray = new String[]{"\n"};
        return OBJLoaderKt.loadOBJasVertexBuffer(StringsKt.split$default((CharSequence)new String(byArray, charset), stringArray, false, 0, 6, null));
    }

    @NotNull
    public static final VertexBuffer loadOBJasVertexBuffer(@NotNull File file) {
        Intrinsics.checkNotNullParameter(file, "file");
        return OBJLoaderKt.loadOBJasVertexBuffer(FilesKt.readLines$default(file, null, 1, null));
    }

    @NotNull
    public static final VertexBuffer loadOBJasVertexBuffer(@NotNull List<String> lines) {
        Intrinsics.checkNotNullParameter(lines, "lines");
        return MeshDataExtensionsKt.toVertexBuffer(OBJLoaderKt.loadOBJMeshData(lines));
    }

    @NotNull
    public static final Map<String, List<Polygon>> loadOBJ(@NotNull File file) {
        Intrinsics.checkNotNullParameter(file, "file");
        return OBJLoaderKt.loadOBJ(FilesKt.readLines$default(file, null, 1, null));
    }

    @NotNull
    public static final MeshData loadOBJEx(@NotNull File file) {
        Intrinsics.checkNotNullParameter(file, "file");
        return OBJLoaderKt.loadOBJMeshData(FilesKt.readLines$default(file, null, 1, null));
    }

    @NotNull
    public static final Map<String, List<Polygon>> loadOBJ(@NotNull URL url) {
        Intrinsics.checkNotNullParameter(url, "url");
        String[] stringArray = url;
        Charset charset = Charsets.UTF_8;
        byte[] byArray = TextStreamsKt.readBytes((URL)stringArray);
        stringArray = new String[]{"\n"};
        return OBJLoaderKt.loadOBJ(StringsKt.split$default((CharSequence)new String(byArray, charset), stringArray, false, 0, 6, null));
    }

    @NotNull
    public static final MeshData loadOBJEx(@NotNull URL url) {
        Intrinsics.checkNotNullParameter(url, "url");
        String[] stringArray = url;
        Charset charset = Charsets.UTF_8;
        byte[] byArray = TextStreamsKt.readBytes((URL)stringArray);
        stringArray = new String[]{"\n"};
        return OBJLoaderKt.loadOBJMeshData(StringsKt.split$default((CharSequence)new String(byArray, charset), stringArray, false, 0, 6, null));
    }

    @NotNull
    public static final Map<String, List<Polygon>> loadOBJ(@NotNull List<String> lines) {
        Intrinsics.checkNotNullParameter(lines, "lines");
        return OBJLoaderKt.loadOBJMeshData(lines).triangulate().flattenPolygons();
    }

    @NotNull
    public static final MeshData loadOBJMeshData(@NotNull File file) {
        Intrinsics.checkNotNullParameter(file, "file");
        return OBJLoaderKt.loadOBJMeshData(FilesKt.readLines$default(file, null, 1, null));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final MeshData loadOBJMeshData(@NotNull List<String> lines) {
        Intrinsics.checkNotNullParameter(lines, "lines");
        Map meshes = new LinkedHashMap();
        List positions = new ArrayList();
        List normals = new ArrayList();
        List textureCoords = new ArrayList();
        List activeMesh = null;
        activeMesh = new ArrayList();
        Iterable $this$forEach$iv = lines;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String $this$filterTo$iv$iv;
            void $this$filter$iv;
            Iterator it;
            Collection collection;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            String line = (String)element$iv;
            boolean bl = false;
            if (!(((CharSequence)line).length() > 0)) continue;
            Object object = line;
            Regex regex = new Regex("[ |\t]+");
            int n = 0;
            object = regex.split((CharSequence)object, n);
            boolean $i$f$map = false;
            void var14_18 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                String string = (String)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(((Object)StringsKt.trim((CharSequence)((Object)it))).toString());
            }
            $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$filter2 = false;
            $this$mapTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo2 = false;
            Iterator iterator2 = $this$filterTo$iv$iv.iterator();
            while (iterator2.hasNext()) {
                Object element$iv$iv = iterator2.next();
                it = (String)element$iv$iv;
                boolean bl3 = false;
                boolean bl4 = ((CharSequence)((Object)it)).length() > 0;
                if (!bl4) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List tokens = (List)destination$iv$iv;
            if (!(!((Collection)tokens).isEmpty())) continue;
            switch ((String)tokens.get(0)) {
                case "v": {
                    ((Collection)positions).add(new Vector3(Double.parseDouble((String)tokens.get(1)), Double.parseDouble((String)tokens.get(2)), Double.parseDouble((String)tokens.get(3))));
                    break;
                }
                case "vn": {
                    ((Collection)normals).add(new Vector3(Double.parseDouble((String)tokens.get(1)), Double.parseDouble((String)tokens.get(2)), Double.parseDouble((String)tokens.get(3))));
                    break;
                }
                case "vt": {
                    ((Collection)textureCoords).add(new Vector2(Double.parseDouble((String)tokens.get(1)), Double.parseDouble((String)tokens.get(2))));
                    break;
                }
                case "g": {
                    activeMesh = new ArrayList();
                    Map $i$f$filter2 = meshes;
                    Object object2 = (String)CollectionsKt.getOrNull(tokens, 1);
                    if (object2 == null) {
                        object2 = "no-name-" + meshes.size();
                    }
                    $this$filterTo$iv$iv = object2;
                    destination$iv$iv = activeMesh;
                    $i$f$filter2.put($this$filterTo$iv$iv, destination$iv$iv);
                    break;
                }
                case "f": {
                    int[] nArray;
                    int[] nArray2;
                    Object object3;
                    int[] nArray3;
                    Object object4;
                    Iterable $this$mapTo$iv$iv2;
                    Iterable $this$map$iv2;
                    boolean $i$f$map2;
                    List it2;
                    Iterable $this$mapTo$iv$iv3;
                    Iterable $this$map$iv3 = tokens.subList(1, tokens.size());
                    boolean $i$f$map3 = false;
                    Iterable $i$f$filterTo2 = $this$map$iv3;
                    Iterable destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv3, 10));
                    boolean $i$f$mapTo2 = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv3) {
                        String string = (String)item$iv$iv;
                        collection = destination$iv$iv2;
                        boolean bl5 = false;
                        String[] stringArray = new String[]{"/"};
                        collection.add(StringsKt.split$default((CharSequence)((Object)it2), stringArray, false, 0, 6, null));
                    }
                    $this$map$iv3 = (List)destination$iv$iv2;
                    $i$f$map3 = false;
                    $this$mapTo$iv$iv3 = $this$map$iv3;
                    destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv3, 10));
                    $i$f$mapTo2 = false;
                    it = $this$mapTo$iv$iv3.iterator();
                    while (it.hasNext()) {
                        void $this$mapTo$iv$iv4;
                        Object item$iv$iv = it.next();
                        it2 = (List)item$iv$iv;
                        collection = destination$iv$iv2;
                        boolean bl6 = false;
                        Iterable $this$map$iv4 = it2;
                        boolean $i$f$map4 = false;
                        Iterable iterable = $this$map$iv4;
                        Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv4, 10));
                        boolean $i$f$mapTo3 = false;
                        for (Object item$iv$iv2 : $this$mapTo$iv$iv4) {
                            void it3;
                            String string = (String)item$iv$iv2;
                            Collection collection2 = destination$iv$iv3;
                            boolean bl7 = false;
                            Integer n2 = StringsKt.toIntOrNull((String)it3);
                            collection2.add(n2 != null ? n2 : 0);
                        }
                        collection.add((List)destination$iv$iv3);
                    }
                    List indices = (List)destination$iv$iv2;
                    Integer n3 = (Integer)CollectionsKt.getOrNull((List)indices.get(0), 0);
                    boolean hasPosition = (n3 != null ? n3 : 0) != 0;
                    Integer n4 = (Integer)CollectionsKt.getOrNull((List)indices.get(0), 1);
                    boolean hasUV = (n4 != null ? n4 : 0) != 0;
                    Integer n5 = (Integer)CollectionsKt.getOrNull((List)indices.get(0), 2);
                    boolean hasNormal = (n5 != null ? n5 : 0) != 0;
                    Collection collection3 = activeMesh;
                    if (hasPosition) {
                        destination$iv$iv2 = indices;
                        collection = collection3;
                        $i$f$map2 = false;
                        it = $this$map$iv2;
                        Collection destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv2, 10));
                        boolean $i$f$mapTo4 = false;
                        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                            void it4;
                            List $i$f$map4 = (List)item$iv$iv;
                            object4 = destination$iv$iv4;
                            boolean bl8 = false;
                            object4.add(((Number)it4.get(0)).intValue() - 1);
                        }
                        collection3 = collection;
                        nArray3 = CollectionsKt.toIntArray((List)destination$iv$iv4);
                    } else {
                        nArray3 = new int[]{};
                    }
                    if (hasUV) {
                        $this$map$iv2 = indices;
                        object4 = nArray3;
                        collection = collection3;
                        $i$f$map2 = false;
                        $this$mapTo$iv$iv2 = $this$map$iv2;
                        Collection destination$iv$iv5 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv2, 10));
                        boolean $i$f$mapTo5 = false;
                        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                            List it4 = (List)item$iv$iv;
                            object3 = destination$iv$iv5;
                            boolean bl9 = false;
                            object3.add(((Number)it4.get(1)).intValue() - 1);
                        }
                        object3 = (List)destination$iv$iv5;
                        collection3 = collection;
                        nArray3 = object4;
                        nArray2 = CollectionsKt.toIntArray((Collection)object3);
                    } else {
                        nArray2 = new int[]{};
                    }
                    if (hasNormal) {
                        Collection<Integer> collection4;
                        $this$map$iv2 = indices;
                        object3 = nArray2;
                        object4 = nArray3;
                        collection = collection3;
                        $i$f$map2 = false;
                        $this$mapTo$iv$iv2 = $this$map$iv2;
                        Collection destination$iv$iv6 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv2, 10));
                        boolean $i$f$mapTo6 = false;
                        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                            List it5 = (List)item$iv$iv;
                            collection4 = destination$iv$iv6;
                            boolean bl10 = false;
                            collection4.add(((Number)it5.get(2)).intValue() - 1);
                        }
                        collection4 = (List)destination$iv$iv6;
                        collection3 = collection;
                        nArray3 = object4;
                        nArray2 = object3;
                        nArray = CollectionsKt.toIntArray(collection4);
                    } else {
                        nArray = new int[]{};
                    }
                    int[] nArray4 = nArray;
                    int[] nArray5 = nArray2;
                    int[] nArray6 = nArray3;
                    collection3.add(new IndexedPolygon(nArray6, nArray5, nArray4));
                    if (!meshes.isEmpty()) break;
                    meshes.put("no-name", activeMesh);
                }
            }
        }
        Collection $this$toTypedArray$iv = positions;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        $this$toTypedArray$iv = normals;
        $i$f$toTypedArray = false;
        thisCollection$iv = $this$toTypedArray$iv;
        $this$toTypedArray$iv = textureCoords;
        $i$f$toTypedArray = false;
        thisCollection$iv = $this$toTypedArray$iv;
        return new MeshData(new VertexData(thisCollection$iv.toArray(new Vector3[0]), thisCollection$iv.toArray(new Vector3[0]), thisCollection$iv.toArray(new Vector2[0])), meshes);
    }
}

