/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.extra.shapes.rectify;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.openrndr.extra.shapes.utilities.SplitAtKt;
import org.openrndr.math.EuclideanVector;
import org.openrndr.math.FunctionsKt;
import org.openrndr.shape.Path;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0017\b&\u0018\u0000*\u000e\b\u0000\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00010\u00022\u00020\u0003B)\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u0015\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\b\u001aJ\u000e\u0010\u001b\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u0007J\u000e\u0010\u001c\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u0007J\u0013\u0010\u001d\u001a\u00028\u00002\u0006\u0010\u0019\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\u001eJ\u0013\u0010\u001f\u001a\u00028\u00002\u0006\u0010\u0019\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\u001eJ\u001e\u0010 \u001a\b\u0012\u0004\u0012\u00028\u00000\u00052\u0006\u0010!\u001a\u00020\u00072\u0006\u0010\"\u001a\u00020\u0007H&J,\u0010#\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00050\u000e2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00070\u000e2\b\b\u0002\u0010%\u001a\u00020\u0007H\u0016R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR#\u0010\r\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00070\u000f0\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R#\u0010\u0012\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00070\u000f0\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0011R-\u0010\u0014\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u000f0\u000e8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0016\u0010\u0017\u001a\u0004\b\u0015\u0010\u0011\u00a8\u0006&"}, d2={"Lorg/openrndr/extra/shapes/rectify/RectifiedPath;", "T", "Lorg/openrndr/math/EuclideanVector;", "", "originalPath", "Lorg/openrndr/shape/Path;", "distanceTolerance", "", "lengthScale", "<init>", "(Lorg/openrndr/shape/Path;DD)V", "getOriginalPath", "()Lorg/openrndr/shape/Path;", "candidatePoints", "", "Lkotlin/Pair;", "getCandidatePoints", "()Ljava/util/List;", "points", "getPoints", "intervals", "getIntervals", "intervals$delegate", "Lkotlin/Lazy;", "safe", "t", "safe$orx_shapes", "rectify", "inverseRectify", "position", "(D)Lorg/openrndr/math/EuclideanVector;", "direction", "sub", "t0", "t1", "splitAt", "ascendingTs", "weldEpsilon", "orx-shapes"})
@SourceDebugExtension(value={"SMAP\nRectifiedPath.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RectifiedPath.kt\norg/openrndr/extra/shapes/rectify/RectifiedPath\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,113:1\n1557#2:114\n1628#2,3:115\n1557#2:118\n1628#2,3:119\n*S KotlinDebug\n*F\n+ 1 RectifiedPath.kt\norg/openrndr/extra/shapes/rectify/RectifiedPath\n*L\n111#1:114\n111#1:115,3\n23#1:118\n23#1:119,3\n*E\n"})
public abstract class RectifiedPath<T extends EuclideanVector<T>> {
    @NotNull
    private final Path<T> originalPath;
    @NotNull
    private final List<Pair<T, Double>> candidatePoints;
    @NotNull
    private final List<Pair<T, Double>> points;
    @NotNull
    private final Lazy intervals$delegate;

    public RectifiedPath(@NotNull Path<T> originalPath, double distanceTolerance, double lengthScale) {
        Intrinsics.checkNotNullParameter(originalPath, "originalPath");
        this.originalPath = originalPath;
        this.candidatePoints = this.originalPath.equidistantPositionsWithT(RangesKt.coerceAtLeast((int)(this.originalPath.getLength() * lengthScale), 2), distanceTolerance);
        this.points = this.originalPath.getClosed() ? CollectionsKt.plus((Collection)this.candidatePoints, Pair.copy$default(CollectionsKt.first(this.candidatePoints), null, 1.0, 1, null)) : this.candidatePoints;
        this.intervals$delegate = LazyKt.lazy(() -> RectifiedPath.intervals_delegate$lambda$1(this));
    }

    public /* synthetic */ RectifiedPath(Path path, double d, double d2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            d = 0.5;
        }
        if ((n & 4) != 0) {
            d2 = 1.0;
        }
        this(path, d, d2);
    }

    @NotNull
    public final Path<T> getOriginalPath() {
        return this.originalPath;
    }

    @NotNull
    public final List<Pair<T, Double>> getCandidatePoints() {
        return this.candidatePoints;
    }

    @NotNull
    public final List<Pair<T, Double>> getPoints() {
        return this.points;
    }

    @NotNull
    public final List<Pair<Double, Double>> getIntervals() {
        Lazy lazy = this.intervals$delegate;
        return (List)lazy.getValue();
    }

    public final double safe$orx_shapes(double t) {
        double d;
        double d2;
        double d3;
        return this.originalPath.getClosed() ? (!((d3 = (d2 = t) % (d = 1.0)) == 0.0) && !(Math.signum(d3) == Math.signum(d)) ? d3 + d : d3) : FunctionsKt.doubleClamp(t, 0.0, 1.0);
    }

    public final double rectify(double t) {
        double d;
        if (this.originalPath.getEmpty()) {
            return 0.0;
        }
        if (t <= 0.0) {
            return 0.0;
        }
        double fi = t * ((double)this.points.size() - 1.0);
        double d2 = fi;
        double d3 = d2 % (d = 1.0);
        double fr = !(d3 == 0.0) && !(Math.signum(d3) == Math.signum(d)) ? d3 + d : d3;
        int i0 = (int)fi;
        int i1 = i0 + 1;
        return i0 >= this.points.size() - 1 ? 1.0 : ((Number)this.points.get(i0).getSecond()).doubleValue() * (1.0 - fr) + ((Number)this.points.get(i1).getSecond()).doubleValue() * fr;
    }

    public final double inverseRectify(double t) {
        if (this.originalPath.getEmpty()) {
            return 0.0;
        }
        if (t <= 0.0) {
            return 0.0;
        }
        if (t >= 1.0) {
            return 1.0;
        }
        int index = CollectionsKt.binarySearch$default(this.getIntervals(), 0, 0, arg_0 -> RectifiedPath.inverseRectify$lambda$2(t, arg_0), 3, null);
        double t0 = t - ((Number)this.getIntervals().get(index).getFirst()).doubleValue();
        double dt = ((Number)this.getIntervals().get(index).getSecond()).doubleValue() - ((Number)this.getIntervals().get(index).getFirst()).doubleValue();
        double f = t0 / dt;
        double f0 = (double)index / (double)this.getIntervals().size();
        double f1 = ((double)index + 1.0) / (double)this.getIntervals().size();
        return f0 * (1.0 - f) + f1 * f;
    }

    @NotNull
    public final T position(double t) {
        return this.originalPath.getEmpty() ? this.originalPath.getInfinity() : this.originalPath.position(this.rectify(this.safe$orx_shapes(t)));
    }

    @NotNull
    public final T direction(double t) {
        return this.originalPath.getEmpty() ? this.originalPath.getInfinity() : this.originalPath.direction(this.rectify(this.safe$orx_shapes(t)));
    }

    @NotNull
    public abstract Path<T> sub(double var1, double var3);

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<Path<T>> splitAt(@NotNull List<Double> ascendingTs, double weldEpsilon) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(ascendingTs, "ascendingTs");
        Iterable iterable = ascendingTs;
        Path<T> path = this.originalPath;
        boolean $i$f$map = false;
        void var6_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            double d = ((Number)item$iv$iv).doubleValue();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.rectify((double)it));
        }
        return SplitAtKt.splitAtBase(path, (List<Double>)((List)destination$iv$iv), weldEpsilon);
    }

    public static /* synthetic */ List splitAt$default(RectifiedPath rectifiedPath, List list, double d, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: splitAt");
        }
        if ((n & 2) != 0) {
            d = 1.0E-6;
        }
        return rectifiedPath.splitAt(list, d);
    }

    /*
     * WARNING - void declaration
     */
    private static final List intervals_delegate$lambda$1(RectifiedPath this$0) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Iterable $this$map$iv = CollectionsKt.zipWithNext(this$0.points);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Pair pair = (Pair)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new Pair(((Pair)it.getFirst()).getSecond(), ((Pair)it.getSecond()).getSecond()));
        }
        return (List)destination$iv$iv;
    }

    private static final int inverseRectify$lambda$2(double $t, Pair it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return $t < ((Number)it.getFirst()).doubleValue() ? 1 : ($t > ((Number)it.getSecond()).doubleValue() ? -1 : 0);
    }
}

