/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.extra.shapes.rectify;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.openrndr.extra.shapes.rectify.RectifiedPath;
import org.openrndr.math.Vector3;
import org.openrndr.shape.Path;
import org.openrndr.shape.Path3D;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\n\n\u0002\u0010 \n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B#\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u0018\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0006H\u0016J$\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00040\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00060\u00112\u0006\u0010\u0013\u001a\u00020\u0006H\u0016R\u0011\u0010\n\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0014"}, d2={"Lorg/openrndr/extra/shapes/rectify/RectifiedPath3D;", "Lorg/openrndr/extra/shapes/rectify/RectifiedPath;", "Lorg/openrndr/math/Vector3;", "contour", "Lorg/openrndr/shape/Path3D;", "distanceTolerance", "", "lengthScale", "<init>", "(Lorg/openrndr/shape/Path3D;DD)V", "path", "getPath", "()Lorg/openrndr/shape/Path3D;", "sub", "t0", "t1", "splitAt", "", "ascendingTs", "weldEpsilon", "orx-shapes"})
public final class RectifiedPath3D
extends RectifiedPath<Vector3> {
    public RectifiedPath3D(@NotNull Path3D contour, double distanceTolerance, double lengthScale) {
        Intrinsics.checkNotNullParameter(contour, "contour");
        super(contour, distanceTolerance, lengthScale);
    }

    public /* synthetic */ RectifiedPath3D(Path3D path3D, double d, double d2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            d = 0.5;
        }
        if ((n & 4) != 0) {
            d2 = 1.0;
        }
        this(path3D, d, d2);
    }

    @NotNull
    public final Path3D getPath() {
        Path path = this.getOriginalPath();
        Intrinsics.checkNotNull(path, "null cannot be cast to non-null type org.openrndr.shape.Path3D");
        return (Path3D)path;
    }

    @NotNull
    public Path3D sub(double t0, double t1) {
        Path3D path3D;
        if (this.getPath().getEmpty()) {
            return new Path3D(CollectionsKt.emptyList(), false);
        }
        if (this.getPath().getClosed()) {
            double d = t0;
            double d2 = 1.0;
            double d3 = d % d2;
            double d4 = this.rectify(!(d3 == 0.0) && !(Math.signum(d3) == Math.signum(d2)) ? d3 + d2 : d3) + Math.floor(t0);
            d = t1;
            d2 = 1.0;
            d3 = d % d2;
            path3D = this.getPath().sub(d4, this.rectify(!(d3 == 0.0) && !(Math.signum(d3) == Math.signum(d2)) ? d3 + d2 : d3) + Math.floor(t1));
        } else {
            path3D = this.getPath().sub(this.rectify(t0), this.rectify(t1));
        }
        return path3D;
    }

    @Override
    @NotNull
    public List<Path3D> splitAt(@NotNull List<Double> ascendingTs, double weldEpsilon) {
        Intrinsics.checkNotNullParameter(ascendingTs, "ascendingTs");
        List list = super.splitAt(ascendingTs, weldEpsilon);
        Intrinsics.checkNotNull(list, "null cannot be cast to non-null type kotlin.collections.List<org.openrndr.shape.Path3D>");
        return list;
    }
}

