/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.extra.svg;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jsoup.nodes.Attribute;
import org.jsoup.nodes.Element;
import org.openrndr.extra.composition.CompositionStyleSheetKt;
import org.openrndr.extra.composition.Style;
import org.openrndr.extra.svg.SVGElementKt;
import org.openrndr.extra.svg.SVGParse;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b0\u0018\u00002\u00020\u0001B\u0013\b\u0004\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H&J\u0016\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u0007J\u000e\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\t\"\u0004\b\u000e\u0010\u000bR\u001a\u0010\u000f\u001a\u00020\u0010X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014\u0082\u0001\u0002\u001d\u001e\u00a8\u0006\u001f"}, d2={"Lorg/openrndr/extra/svg/SVGElement;", "", "element", "Lorg/jsoup/nodes/Element;", "<init>", "(Lorg/jsoup/nodes/Element;)V", "tag", "", "getTag", "()Ljava/lang/String;", "setTag", "(Ljava/lang/String;)V", "id", "getId", "setId", "style", "Lorg/openrndr/extra/composition/Style;", "getStyle", "()Lorg/openrndr/extra/composition/Style;", "setStyle", "(Lorg/openrndr/extra/composition/Style;)V", "handleAttribute", "", "attribute", "Lorg/jsoup/nodes/Attribute;", "styleProperty", "key", "value", "inlineStyles", "Lorg/openrndr/extra/svg/SVGGroup;", "Lorg/openrndr/extra/svg/SVGPath;", "orx-svg"})
@SourceDebugExtension(value={"SMAP\nSVGElement.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SVGElement.kt\norg/openrndr/extra/svg/SVGElement\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,430:1\n1863#2:431\n1557#2:432\n1628#2,3:433\n1864#2:436\n*S KotlinDebug\n*F\n+ 1 SVGElement.kt\norg/openrndr/extra/svg/SVGElement\n*L\n36#1:431\n37#1:432\n37#1:433,3\n36#1:436\n*E\n"})
public abstract class SVGElement {
    @NotNull
    private String tag;
    @NotNull
    private String id;
    @NotNull
    private Style style;

    private SVGElement(Element element) {
        Object object;
        Object object2 = element;
        if (object2 == null || (object2 = ((Element)object2).tagName()) == null) {
            object2 = this.tag = "";
        }
        if ((object = element) == null || (object = ((Element)object).id()) == null) {
            object = "";
        }
        this.id = object;
        this.style = new Style();
    }

    @NotNull
    public final String getTag() {
        return this.tag;
    }

    public final void setTag(@NotNull String string) {
        Intrinsics.checkNotNullParameter(string, "<set-?>");
        this.tag = string;
    }

    @NotNull
    public final String getId() {
        return this.id;
    }

    public final void setId(@NotNull String string) {
        Intrinsics.checkNotNullParameter(string, "<set-?>");
        this.id = string;
    }

    @NotNull
    public Style getStyle() {
        return this.style;
    }

    public void setStyle(@NotNull Style style) {
        Intrinsics.checkNotNullParameter(style, "<set-?>");
        this.style = style;
    }

    public abstract void handleAttribute(@NotNull Attribute var1);

    public final void styleProperty(@NotNull String key, @NotNull String value2) {
        Intrinsics.checkNotNullParameter(key, "key");
        Intrinsics.checkNotNullParameter(value2, "value");
        switch (key) {
            case "stroke": {
                CompositionStyleSheetKt.setStroke(this.getStyle(), SVGParse.INSTANCE.color(value2));
                break;
            }
            case "stroke-opacity": {
                CompositionStyleSheetKt.setStrokeOpacity(this.getStyle(), SVGParse.INSTANCE.number(value2));
                break;
            }
            case "stroke-width": {
                CompositionStyleSheetKt.setStrokeWeight(this.getStyle(), SVGParse.INSTANCE.length(value2));
                break;
            }
            case "stroke-miterlimit": {
                CompositionStyleSheetKt.setMiterLimit(this.getStyle(), SVGParse.INSTANCE.number(value2));
                break;
            }
            case "stroke-linecap": {
                CompositionStyleSheetKt.setLineCap(this.getStyle(), SVGParse.INSTANCE.lineCap(value2));
                break;
            }
            case "stroke-linejoin": {
                CompositionStyleSheetKt.setLineJoin(this.getStyle(), SVGParse.INSTANCE.lineJoin(value2));
                break;
            }
            case "fill": {
                CompositionStyleSheetKt.setFill(this.getStyle(), SVGParse.INSTANCE.color(value2));
                break;
            }
            case "fill-opacity": {
                CompositionStyleSheetKt.setFillOpacity(this.getStyle(), SVGParse.INSTANCE.number(value2));
                break;
            }
            case "opacity": {
                CompositionStyleSheetKt.setOpacity(this.getStyle(), SVGParse.INSTANCE.number(value2));
                break;
            }
            default: {
                SVGElementKt.access$getLogger$p().warn(() -> SVGElement.styleProperty$lambda$0(key));
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void inlineStyles(@NotNull Attribute attribute) {
        Intrinsics.checkNotNullParameter(attribute, "attribute");
        String string = attribute.getValue();
        Intrinsics.checkNotNullExpressionValue(string, "<get-value>(...)");
        String[] stringArray = new String[]{";"};
        Iterable $this$forEach$iv = StringsKt.split$default((CharSequence)string, stringArray, false, 0, 6, null);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void $this$mapTo$iv$iv;
            String it = (String)element$iv;
            boolean bl = false;
            String[] stringArray2 = new String[]{":"};
            Iterable $this$map$iv = StringsKt.split$default((CharSequence)it, stringArray2, false, 0, 6, null);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void s;
                String string2 = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(((Object)StringsKt.trim((CharSequence)s)).toString());
            }
            List result2 = (List)destination$iv$iv;
            if (result2.size() < 2) continue;
            this.styleProperty((String)result2.get(0), (String)result2.get(1));
        }
    }

    private static final Object styleProperty$lambda$0(String $key) {
        Intrinsics.checkNotNullParameter($key, "$key");
        return "Unknown property: " + $key;
    }

    public /* synthetic */ SVGElement(Element element, DefaultConstructorMarker $constructor_marker) {
        this(element);
    }
}

