/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.extra.temporalblur;

import java.lang.reflect.Field;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openrndr.Extension;
import org.openrndr.Program;
import org.openrndr.ProgramImplementation;
import org.openrndr.color.ColorRGBa;
import org.openrndr.draw.BlendMode;
import org.openrndr.draw.BufferMultisample;
import org.openrndr.draw.ColorBuffer;
import org.openrndr.draw.ColorTransformsKt;
import org.openrndr.draw.ColorType;
import org.openrndr.draw.DepthBuffer;
import org.openrndr.draw.DepthTestPass;
import org.openrndr.draw.Drawer;
import org.openrndr.draw.DrawerKt;
import org.openrndr.draw.Filter;
import org.openrndr.draw.RenderTarget;
import org.openrndr.draw.RenderTargetBuilder;
import org.openrndr.draw.RenderTargetKt;
import org.openrndr.extra.noise.UniformRandomKt;
import org.openrndr.extra.temporalblur.TemporalBlurKt;
import org.openrndr.filter.color.ColorFiltersKt;
import org.openrndr.math.Matrix44;
import org.openrndr.math.Matrix55;
import org.openrndr.math.Vector2;
import org.openrndr.math.transforms.TransformsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\b\n\u0002\b\u0014\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010G\u001a\u00020C2\u0006\u0010H\u001a\u00020I2\u0006\u0010J\u001a\u00020KH\u0016J\u0018\u0010L\u001a\u00020C2\u0006\u0010H\u001a\u00020I2\u0006\u0010J\u001a\u00020KH\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u00020\rX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0017\u001a\u0004\u0018\u00010\u0006X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u001c\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u001a\u0010\u001d\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\t\"\u0004\b\u001f\u0010\u000bR\u001a\u0010 \u001a\u00020!X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%R\u001a\u0010&\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010\t\"\u0004\b(\u0010\u000bR\u001a\u0010)\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010\t\"\u0004\b+\u0010\u000bR\u001a\u0010,\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010\t\"\u0004\b.\u0010\u000bR\u001a\u0010/\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b0\u0010\u000f\"\u0004\b1\u0010\u0011R\u001a\u00102\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b3\u0010\u000f\"\u0004\b4\u0010\u0011R\u001a\u00105\u001a\u000206X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b7\u00108\"\u0004\b9\u0010:R&\u0010;\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020=0<X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b>\u0010?\"\u0004\b@\u0010AR+\u0010B\u001a\u0013\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020C0<\u00a2\u0006\u0002\bDX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bE\u0010?\"\u0004\bF\u0010A\u00a8\u0006M"}, d2={"Lorg/openrndr/extra/temporalblur/TemporalBlur;", "Lorg/openrndr/Extension;", "<init>", "()V", "oldClock", "Lkotlin/Function0;", "", "oldClockTime", "getOldClockTime", "()D", "setOldClockTime", "(D)V", "enabled", "", "getEnabled", "()Z", "setEnabled", "(Z)V", "accumulator", "Lorg/openrndr/draw/RenderTarget;", "result", "image", "imageResolved", "contentScale", "getContentScale", "()Ljava/lang/Double;", "setContentScale", "(Ljava/lang/Double;)V", "Ljava/lang/Double;", "gain", "getGain", "setGain", "samples", "", "getSamples", "()I", "setSamples", "(I)V", "duration", "getDuration", "setDuration", "fps", "getFps", "setFps", "jitter", "getJitter", "setJitter", "linearizeInput", "getLinearizeInput", "setLinearizeInput", "delinearizeOutput", "getDelinearizeOutput", "setDelinearizeOutput", "multisample", "Lorg/openrndr/draw/BufferMultisample;", "getMultisample", "()Lorg/openrndr/draw/BufferMultisample;", "setMultisample", "(Lorg/openrndr/draw/BufferMultisample;)V", "colorMatrix", "Lkotlin/Function1;", "Lorg/openrndr/math/Matrix55;", "getColorMatrix", "()Lkotlin/jvm/functions/Function1;", "setColorMatrix", "(Lkotlin/jvm/functions/Function1;)V", "beforeDrawAccumulated", "", "Lkotlin/ExtensionFunctionType;", "getBeforeDrawAccumulated", "setBeforeDrawAccumulated", "beforeDraw", "drawer", "Lorg/openrndr/draw/Drawer;", "program", "Lorg/openrndr/Program;", "afterDraw", "orx-temporal-blur"})
public final class TemporalBlur
implements Extension {
    @NotNull
    private Function0<Double> oldClock = TemporalBlur::oldClock$lambda$0;
    private double oldClockTime;
    private boolean enabled = true;
    @Nullable
    private RenderTarget accumulator;
    @Nullable
    private RenderTarget result;
    @Nullable
    private RenderTarget image;
    @Nullable
    private RenderTarget imageResolved;
    @Nullable
    private Double contentScale;
    private double gain = 1.0;
    private int samples = 30;
    private double duration = 0.5;
    private double fps = 60.0;
    private double jitter = 1.0;
    private boolean linearizeInput = true;
    private boolean delinearizeOutput = true;
    @NotNull
    private BufferMultisample multisample = new BufferMultisample.SampleCount(8);
    @NotNull
    private Function1<? super Double, Matrix55> colorMatrix = TemporalBlur::colorMatrix$lambda$1;
    @NotNull
    private Function1<? super TemporalBlur, Unit> beforeDrawAccumulated = TemporalBlur::beforeDrawAccumulated$lambda$2;

    public final double getOldClockTime() {
        return this.oldClockTime;
    }

    public final void setOldClockTime(double d) {
        this.oldClockTime = d;
    }

    @Override
    public boolean getEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    @Nullable
    public final Double getContentScale() {
        return this.contentScale;
    }

    public final void setContentScale(@Nullable Double d) {
        this.contentScale = d;
    }

    public final double getGain() {
        return this.gain;
    }

    public final void setGain(double d) {
        this.gain = d;
    }

    public final int getSamples() {
        return this.samples;
    }

    public final void setSamples(int n) {
        this.samples = n;
    }

    public final double getDuration() {
        return this.duration;
    }

    public final void setDuration(double d) {
        this.duration = d;
    }

    public final double getFps() {
        return this.fps;
    }

    public final void setFps(double d) {
        this.fps = d;
    }

    public final double getJitter() {
        return this.jitter;
    }

    public final void setJitter(double d) {
        this.jitter = d;
    }

    public final boolean getLinearizeInput() {
        return this.linearizeInput;
    }

    public final void setLinearizeInput(boolean bl) {
        this.linearizeInput = bl;
    }

    public final boolean getDelinearizeOutput() {
        return this.delinearizeOutput;
    }

    public final void setDelinearizeOutput(boolean bl) {
        this.delinearizeOutput = bl;
    }

    @NotNull
    public final BufferMultisample getMultisample() {
        return this.multisample;
    }

    public final void setMultisample(@NotNull BufferMultisample bufferMultisample) {
        Intrinsics.checkNotNullParameter(bufferMultisample, "<set-?>");
        this.multisample = bufferMultisample;
    }

    @NotNull
    public final Function1<Double, Matrix55> getColorMatrix() {
        return this.colorMatrix;
    }

    public final void setColorMatrix(@NotNull Function1<? super Double, Matrix55> function1) {
        Intrinsics.checkNotNullParameter(function1, "<set-?>");
        this.colorMatrix = function1;
    }

    @NotNull
    public final Function1<TemporalBlur, Unit> getBeforeDrawAccumulated() {
        return this.beforeDrawAccumulated;
    }

    public final void setBeforeDrawAccumulated(@NotNull Function1<? super TemporalBlur, Unit> function1) {
        Intrinsics.checkNotNullParameter(function1, "<set-?>");
        this.beforeDrawAccumulated = function1;
    }

    @Override
    public void beforeDraw(@NotNull Drawer drawer, @NotNull Program program2) {
        double resolvedContentScale;
        RenderTarget i;
        Intrinsics.checkNotNullParameter(drawer, "drawer");
        Intrinsics.checkNotNullParameter(program2, "program");
        int extensionOffset = program2.getExtensions().indexOf(this);
        List extensionTail = CollectionsKt.drop((Iterable)program2.getExtensions(), extensionOffset + 1);
        RenderTarget renderTarget = this.accumulator;
        if (renderTarget != null) {
            RenderTarget a = renderTarget;
            boolean bl = false;
            if (a.getWidth() != program2.getWidth() || a.getHeight() != program2.getHeight()) {
                a.colorBuffer(0).destroy();
                a.detachColorAttachments();
                a.destroy();
            }
        }
        RenderTarget renderTarget2 = this.result;
        if (renderTarget2 != null) {
            RenderTarget r = renderTarget2;
            boolean bl = false;
            if (r.getWidth() != program2.getWidth() || r.getHeight() != program2.getHeight()) {
                r.colorBuffer(0).destroy();
                r.detachColorAttachments();
                r.destroy();
            }
        }
        RenderTarget renderTarget3 = this.image;
        if (renderTarget3 != null) {
            i = renderTarget3;
            boolean bl = false;
            if (i.getWidth() != program2.getWidth() || i.getHeight() != program2.getHeight()) {
                i.colorBuffer(0).destroy();
                DepthBuffer depthBuffer = i.getDepthBuffer();
                if (depthBuffer != null) {
                    depthBuffer.destroy();
                }
                i.detachColorAttachments();
                i.detachDepthBuffer();
                i.destroy();
            }
        }
        RenderTarget renderTarget4 = this.imageResolved;
        if (renderTarget4 != null) {
            i = renderTarget4;
            boolean bl = false;
            if (i.getWidth() != program2.getWidth() || i.getHeight() != program2.getHeight()) {
                i.colorBuffer(0).destroy();
                i.detachColorAttachments();
                i.destroy();
            }
        }
        Double d = this.contentScale;
        double d2 = resolvedContentScale = d != null ? d.doubleValue() : RenderTarget.Companion.getActive().getContentScale();
        if (this.accumulator == null) {
            this.accumulator = RenderTargetKt.renderTarget$default(program2.getWidth(), program2.getHeight(), resolvedContentScale, null, null, TemporalBlur::beforeDraw$lambda$7, 24, null);
        }
        if (this.result == null) {
            this.result = RenderTargetKt.renderTarget$default(program2.getWidth(), program2.getHeight(), resolvedContentScale, null, null, TemporalBlur::beforeDraw$lambda$8, 24, null);
        }
        if (this.image == null) {
            int i2 = program2.getWidth();
            int n = program2.getHeight();
            BufferMultisample bufferMultisample = this.multisample;
            this.image = RenderTargetKt.renderTarget$default(i2, n, resolvedContentScale, bufferMultisample, null, TemporalBlur::beforeDraw$lambda$9, 16, null);
        }
        if (this.imageResolved == null) {
            this.imageResolved = RenderTargetKt.renderTarget$default(program2.getWidth(), program2.getHeight(), resolvedContentScale, null, null, TemporalBlur::beforeDraw$lambda$10, 24, null);
        }
        RenderTarget renderTarget5 = this.accumulator;
        if (renderTarget5 != null) {
            RenderTarget it = renderTarget5;
            boolean bl = false;
            drawer.withTarget(it, arg_0 -> TemporalBlur.beforeDraw$lambda$12$lambda$11(drawer, arg_0));
        }
        this.oldClock = program2.getClock();
        this.oldClockTime = ((Number)program2.getClock().invoke()).doubleValue();
        double oldClockValue = ((Number)this.oldClock.invoke()).doubleValue();
        for (int i3 = this.samples - 1; 0 < i3; --i3) {
            Matrix55 activeColorMatrix;
            RenderTarget renderTarget6 = this.image;
            if (renderTarget6 != null) {
                renderTarget6.bind();
            }
            drawer.clear(ColorRGBa.Companion.getBLACK());
            program2.setClock(() -> TemporalBlur.beforeDraw$lambda$13(oldClockValue, i3, this));
            Field fsf = ProgramImplementation.class.getDeclaredField("frameSeconds");
            fsf.setAccessible(true);
            fsf.setDouble(program2, ((Number)program2.getClock().invoke()).doubleValue());
            drawer.getDrawStyle().setBlendMode(BlendMode.OVER);
            drawer.getDrawStyle().setColorMatrix(Matrix55.Companion.getIDENTITY());
            DrawerKt.isolated(drawer, arg_0 -> TemporalBlur.beforeDraw$lambda$14(this, drawer, program2, extensionTail, arg_0));
            RenderTarget renderTarget7 = this.image;
            if (renderTarget7 != null) {
                renderTarget7.unbind();
            }
            RenderTarget renderTarget8 = this.image;
            Intrinsics.checkNotNull(renderTarget8);
            ColorBuffer colorBuffer = renderTarget8.colorBuffer(0);
            RenderTarget renderTarget9 = this.imageResolved;
            Intrinsics.checkNotNull(renderTarget9);
            ColorBuffer.copyTo$default(colorBuffer, renderTarget9.colorBuffer(0), 0, 0, null, 14, null);
            if (this.linearizeInput) {
                if (this.imageResolved != null) {
                    RenderTarget it;
                    boolean bl = false;
                    Filter.apply$default((Filter)ColorFiltersKt.getLinearize(), it.colorBuffer(0), it.colorBuffer(0), null, 4, null);
                }
            }
            if ((activeColorMatrix = this.colorMatrix.invoke((Double)((double)i3 / ((double)this.samples - 1.0)))) != Matrix55.Companion.getIDENTITY()) {
                RenderTarget renderTarget10 = this.imageResolved;
                Intrinsics.checkNotNull(renderTarget10);
                DrawerKt.isolatedWithTarget(drawer, renderTarget10, arg_0 -> TemporalBlur.beforeDraw$lambda$16(drawer, activeColorMatrix, this, arg_0));
            }
            Filter filter2 = TemporalBlurKt.access$getAdd();
            ColorBuffer[] colorBufferArray = new ColorBuffer[2];
            RenderTarget renderTarget11 = this.imageResolved;
            Intrinsics.checkNotNull(renderTarget11);
            colorBufferArray[0] = renderTarget11.colorBuffer(0);
            RenderTarget renderTarget12 = this.accumulator;
            Intrinsics.checkNotNull(renderTarget12);
            colorBufferArray[1] = renderTarget12.colorBuffer(0);
            RenderTarget renderTarget13 = this.accumulator;
            Intrinsics.checkNotNull(renderTarget13);
            Filter.apply$default(filter2, colorBufferArray, renderTarget13.colorBuffer(0), null, 4, null);
            fsf.setDouble(program2, ((Number)program2.getClock().invoke()).doubleValue());
        }
        RenderTarget renderTarget14 = this.image;
        if (renderTarget14 != null) {
            RenderTarget it = renderTarget14;
            boolean bl = false;
            drawer.withTarget(it, arg_0 -> TemporalBlur.beforeDraw$lambda$18$lambda$17(drawer, arg_0));
        }
        RenderTarget renderTarget15 = this.image;
        if (renderTarget15 != null) {
            renderTarget15.bind();
        }
        program2.setClock(this.oldClock);
        Field fsf = ProgramImplementation.class.getDeclaredField("frameSeconds");
        fsf.setAccessible(true);
        fsf.setDouble(program2, this.oldClockTime);
    }

    @Override
    public void afterDraw(@NotNull Drawer drawer, @NotNull Program program2) {
        Matrix55 activeColorMatrix;
        Intrinsics.checkNotNullParameter(drawer, "drawer");
        Intrinsics.checkNotNullParameter(program2, "program");
        RenderTarget renderTarget = this.image;
        if (renderTarget != null) {
            renderTarget.unbind();
        }
        RenderTarget renderTarget2 = this.image;
        Intrinsics.checkNotNull(renderTarget2);
        ColorBuffer colorBuffer = renderTarget2.colorBuffer(0);
        RenderTarget renderTarget3 = this.imageResolved;
        Intrinsics.checkNotNull(renderTarget3);
        ColorBuffer.copyTo$default(colorBuffer, renderTarget3.colorBuffer(0), 0, 0, null, 14, null);
        if (this.linearizeInput) {
            RenderTarget renderTarget4 = this.imageResolved;
            if (renderTarget4 != null) {
                RenderTarget it = renderTarget4;
                boolean bl = false;
                Filter.apply$default((Filter)ColorFiltersKt.getLinearize(), it.colorBuffer(0), it.colorBuffer(0), null, 4, null);
            }
        }
        if ((activeColorMatrix = this.colorMatrix.invoke((Double)0.0)) != Matrix55.Companion.getIDENTITY()) {
            RenderTarget renderTarget5 = this.imageResolved;
            Intrinsics.checkNotNull(renderTarget5);
            DrawerKt.isolatedWithTarget(drawer, renderTarget5, arg_0 -> TemporalBlur.afterDraw$lambda$20(drawer, activeColorMatrix, this, arg_0));
        }
        Filter filter2 = TemporalBlurKt.access$getAdd();
        ColorBuffer[] colorBufferArray = new ColorBuffer[2];
        RenderTarget renderTarget6 = this.imageResolved;
        Intrinsics.checkNotNull(renderTarget6);
        colorBufferArray[0] = renderTarget6.colorBuffer(0);
        RenderTarget renderTarget7 = this.accumulator;
        Intrinsics.checkNotNull(renderTarget7);
        colorBufferArray[1] = renderTarget7.colorBuffer(0);
        RenderTarget renderTarget8 = this.accumulator;
        Intrinsics.checkNotNull(renderTarget8);
        Filter.apply$default(filter2, colorBufferArray, renderTarget8.colorBuffer(0), null, 4, null);
        this.beforeDrawAccumulated.invoke(this);
        DrawerKt.isolated(drawer, arg_0 -> TemporalBlur.afterDraw$lambda$22(drawer, this, arg_0));
    }

    @Override
    public void setup(@NotNull Program program2) {
        Extension.DefaultImpls.setup(this, program2);
    }

    @Override
    public void shutdown(@NotNull Program program2) {
        Extension.DefaultImpls.shutdown(this, program2);
    }

    private static final double oldClock$lambda$0() {
        return 0.0;
    }

    private static final Matrix55 colorMatrix$lambda$1(double it) {
        return Matrix55.Companion.getIDENTITY();
    }

    private static final Unit beforeDrawAccumulated$lambda$2(TemporalBlur temporalBlur) {
        Intrinsics.checkNotNullParameter(temporalBlur, "<this>");
        return Unit.INSTANCE;
    }

    private static final Unit beforeDraw$lambda$7(RenderTargetBuilder $this$renderTarget) {
        Intrinsics.checkNotNullParameter($this$renderTarget, "$this$renderTarget");
        RenderTargetBuilder.colorBuffer$default($this$renderTarget, null, ColorType.FLOAT32, 1, null);
        return Unit.INSTANCE;
    }

    private static final Unit beforeDraw$lambda$8(RenderTargetBuilder $this$renderTarget) {
        Intrinsics.checkNotNullParameter($this$renderTarget, "$this$renderTarget");
        RenderTargetBuilder.colorBuffer$default($this$renderTarget, null, ColorType.FLOAT32, 1, null);
        return Unit.INSTANCE;
    }

    private static final Unit beforeDraw$lambda$9(RenderTargetBuilder $this$renderTarget) {
        Intrinsics.checkNotNullParameter($this$renderTarget, "$this$renderTarget");
        RenderTargetBuilder.depthBuffer$default($this$renderTarget, null, 1, null);
        RenderTargetBuilder.colorBuffer$default($this$renderTarget, null, ColorType.FLOAT32, 1, null);
        return Unit.INSTANCE;
    }

    private static final Unit beforeDraw$lambda$10(RenderTargetBuilder $this$renderTarget) {
        Intrinsics.checkNotNullParameter($this$renderTarget, "$this$renderTarget");
        RenderTargetBuilder.depthBuffer$default($this$renderTarget, null, 1, null);
        RenderTargetBuilder.colorBuffer$default($this$renderTarget, null, ColorType.FLOAT32, 1, null);
        return Unit.INSTANCE;
    }

    private static final Unit beforeDraw$lambda$12$lambda$11(Drawer $drawer, Drawer $this$withTarget) {
        Intrinsics.checkNotNullParameter($drawer, "$drawer");
        Intrinsics.checkNotNullParameter($this$withTarget, "$this$withTarget");
        $drawer.clear(ColorRGBa.Companion.getBLACK());
        return Unit.INSTANCE;
    }

    private static final double beforeDraw$lambda$13(double $oldClockValue, int $i, TemporalBlur this$0) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        return $oldClockValue - (double)$i * this$0.duration / (this$0.fps * (double)this$0.samples);
    }

    private static final Unit beforeDraw$lambda$14(TemporalBlur this$0, Drawer $drawer, Program $program, List $extensionTail, Drawer $this$isolated) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($drawer, "$drawer");
        Intrinsics.checkNotNullParameter($program, "$program");
        Intrinsics.checkNotNullParameter($extensionTail, "$extensionTail");
        Intrinsics.checkNotNullParameter($this$isolated, "$this$isolated");
        if (this$0.jitter > 0.0) {
            Vector2 offset = UniformRandomKt.uniformRing$default(Vector2.Companion, 0.0, this$0.jitter, null, 4, null);
            $drawer.setProjection(TransformsKt.translate(Matrix44.Companion, offset.x() * (1.0 / (double)$program.getWidth()), offset.y() * (1.0 / (double)$program.getHeight()), 0.0).times($drawer.getProjection()));
        }
        for (Extension extension : $extensionTail) {
            extension.beforeDraw($drawer, $program);
        }
        for (Extension extension : CollectionsKt.reversed($extensionTail)) {
            extension.afterDraw($drawer, $program);
        }
        return Unit.INSTANCE;
    }

    private static final Unit beforeDraw$lambda$16(Drawer $drawer, Matrix55 $activeColorMatrix, TemporalBlur this$0, Drawer $this$isolatedWithTarget) {
        Intrinsics.checkNotNullParameter($drawer, "$drawer");
        Intrinsics.checkNotNullParameter($activeColorMatrix, "$activeColorMatrix");
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($this$isolatedWithTarget, "$this$isolatedWithTarget");
        $drawer.getDrawStyle().setColorMatrix($activeColorMatrix);
        $drawer.getDrawStyle().setBlendMode(BlendMode.REPLACE);
        RenderTarget renderTarget = this$0.imageResolved;
        Intrinsics.checkNotNull(renderTarget);
        $drawer.image(renderTarget.colorBuffer(0));
        return Unit.INSTANCE;
    }

    private static final Unit beforeDraw$lambda$18$lambda$17(Drawer $drawer, Drawer $this$withTarget) {
        Intrinsics.checkNotNullParameter($drawer, "$drawer");
        Intrinsics.checkNotNullParameter($this$withTarget, "$this$withTarget");
        $drawer.clear(ColorRGBa.Companion.getBLACK());
        return Unit.INSTANCE;
    }

    private static final Unit afterDraw$lambda$20(Drawer $drawer, Matrix55 $activeColorMatrix, TemporalBlur this$0, Drawer $this$isolatedWithTarget) {
        Intrinsics.checkNotNullParameter($drawer, "$drawer");
        Intrinsics.checkNotNullParameter($activeColorMatrix, "$activeColorMatrix");
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($this$isolatedWithTarget, "$this$isolatedWithTarget");
        $drawer.getDrawStyle().setColorMatrix($activeColorMatrix);
        $drawer.getDrawStyle().setBlendMode(BlendMode.REPLACE);
        RenderTarget renderTarget = this$0.imageResolved;
        Intrinsics.checkNotNull(renderTarget);
        $drawer.image(renderTarget.colorBuffer(0));
        return Unit.INSTANCE;
    }

    private static final Unit afterDraw$lambda$22$lambda$21(Drawer $drawer, TemporalBlur this$0, Drawer $this$isolatedWithTarget) {
        Intrinsics.checkNotNullParameter($drawer, "$drawer");
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($this$isolatedWithTarget, "$this$isolatedWithTarget");
        $drawer.getDrawStyle().setBlendMode(BlendMode.OVER);
        $drawer.clear(ColorRGBa.Companion.getBLACK());
        $drawer.getDrawStyle().setColorMatrix(ColorTransformsKt.tint(ColorRGBa.Companion.getWHITE().shade(1.0 / (double)this$0.samples * this$0.gain)));
        RenderTarget renderTarget = this$0.accumulator;
        Intrinsics.checkNotNull(renderTarget);
        $drawer.image(renderTarget.colorBuffer(0));
        return Unit.INSTANCE;
    }

    private static final Unit afterDraw$lambda$22(Drawer $drawer, TemporalBlur this$0, Drawer $this$isolated) {
        Intrinsics.checkNotNullParameter($drawer, "$drawer");
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($this$isolated, "$this$isolated");
        $drawer.defaults();
        RenderTarget renderTarget = this$0.result;
        Intrinsics.checkNotNull(renderTarget);
        $drawer.ortho(renderTarget);
        RenderTarget renderTarget2 = this$0.result;
        Intrinsics.checkNotNull(renderTarget2);
        DrawerKt.isolatedWithTarget($drawer, renderTarget2, arg_0 -> TemporalBlur.afterDraw$lambda$22$lambda$21($drawer, this$0, arg_0));
        if (this$0.delinearizeOutput) {
            Filter filter2 = ColorFiltersKt.getDelinearize();
            RenderTarget renderTarget3 = this$0.result;
            Intrinsics.checkNotNull(renderTarget3);
            ColorBuffer colorBuffer = renderTarget3.colorBuffer(0);
            RenderTarget renderTarget4 = this$0.result;
            Intrinsics.checkNotNull(renderTarget4);
            Filter.apply$default(filter2, colorBuffer, renderTarget4.colorBuffer(0), null, 4, null);
        }
        $drawer.getDrawStyle().setBlendMode(BlendMode.OVER);
        $drawer.getDrawStyle().setColorMatrix(Matrix55.Companion.getIDENTITY());
        $drawer.getDrawStyle().setDepthTestPass(DepthTestPass.ALWAYS);
        $drawer.clear(ColorRGBa.Companion.getBLACK());
        RenderTarget renderTarget5 = this$0.result;
        Intrinsics.checkNotNull(renderTarget5);
        $drawer.image(renderTarget5.colorBuffer(0));
        return Unit.INSTANCE;
    }
}

