/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.ffmpeg;

import java.io.File;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openrndr.Extension;
import org.openrndr.Program;
import org.openrndr.color.ColorRGBa;
import org.openrndr.draw.BufferMultisample;
import org.openrndr.draw.ColorBuffer;
import org.openrndr.draw.ColorBufferKt;
import org.openrndr.draw.DepthBuffer;
import org.openrndr.draw.Drawer;
import org.openrndr.draw.DrawerKt;
import org.openrndr.draw.RenderTarget;
import org.openrndr.draw.RenderTargetBuilder;
import org.openrndr.draw.RenderTargetKt;
import org.openrndr.events.Event;
import org.openrndr.ffmpeg.H264Profile;
import org.openrndr.ffmpeg.ScreenRecorderKt;
import org.openrndr.ffmpeg.VideoWriter;
import org.openrndr.ffmpeg.VideoWriterProfile;
import org.openrndr.shape.IntRectangleKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u0006\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0014\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\\\u001a\u00020]2\u0006\u0010^\u001a\u00020_H\u0016J\u0018\u0010`\u001a\u00020]2\u0006\u0010a\u001a\u00020b2\u0006\u0010^\u001a\u00020_H\u0016J\u0018\u0010c\u001a\u00020]2\u0006\u0010a\u001a\u00020b2\u0006\u0010^\u001a\u00020_H\u0016J\u0010\u0010d\u001a\u00020]2\u0006\u0010e\u001a\u00020\u000fH\u0002J\u0010\u0010f\u001a\u00020]2\u0006\u0010^\u001a\u00020_H\u0016R\u001a\u0010\u0004\u001a\u00020\u0005X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00000\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0018\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0019\u001a\u0004\u0018\u00010\u001aX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u001f\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u001e\u0010 \u001a\u0004\u0018\u00010\u001aX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u001f\u001a\u0004\b!\u0010\u001c\"\u0004\b\"\u0010\u001eR\u001c\u0010#\u001a\u0004\u0018\u00010$X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(R\u001a\u0010)\u001a\u00020\u001aX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010+\"\u0004\b,\u0010-R\u001a\u0010.\u001a\u00020/X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b0\u00101\"\u0004\b2\u00103R\u001a\u00104\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b5\u00106\"\u0004\b7\u00108R\u001a\u00109\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b:\u0010\u0007\"\u0004\b;\u0010\tR\u001a\u0010<\u001a\u00020=X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b>\u0010?\"\u0004\b@\u0010AR\u001a\u0010B\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bC\u0010\u0007\"\u0004\bD\u0010\tR\u001c\u0010E\u001a\u0004\u0018\u00010FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bG\u0010H\"\u0004\bI\u0010JR\u001a\u0010K\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bL\u00106\"\u0004\bM\u00108R\u001a\u0010N\u001a\u00020/X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bO\u00101\"\u0004\bP\u00103R\u001a\u0010Q\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bR\u0010\u0007\"\u0004\bS\u0010\tR\u001e\u0010T\u001a\u0004\u0018\u00010/X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010Y\u001a\u0004\bU\u0010V\"\u0004\bW\u0010XR\u0016\u0010Z\u001a\n\u0012\u0004\u0012\u00020/\u0018\u00010[X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006g"}, d2={"Lorg/openrndr/ffmpeg/ScreenRecorder;", "Lorg/openrndr/Extension;", "<init>", "()V", "enabled", "", "getEnabled", "()Z", "setEnabled", "(Z)V", "videoWriter", "Lorg/openrndr/ffmpeg/VideoWriter;", "frame", "Lorg/openrndr/draw/RenderTarget;", "crop", "Lorg/openrndr/draw/ColorBuffer;", "resolved", "frameIndex", "", "framesWritten", "finished", "Lorg/openrndr/events/Event;", "getFinished", "()Lorg/openrndr/events/Event;", "recording", "width", "", "getWidth", "()Ljava/lang/Integer;", "setWidth", "(Ljava/lang/Integer;)V", "Ljava/lang/Integer;", "height", "getHeight", "setHeight", "outputFile", "", "getOutputFile", "()Ljava/lang/String;", "setOutputFile", "(Ljava/lang/String;)V", "frameRate", "getFrameRate", "()I", "setFrameRate", "(I)V", "timeOffset", "", "getTimeOffset", "()D", "setTimeOffset", "(D)V", "frameSkip", "getFrameSkip", "()J", "setFrameSkip", "(J)V", "outputToVideo", "getOutputToVideo", "setOutputToVideo", "profile", "Lorg/openrndr/ffmpeg/VideoWriterProfile;", "getProfile", "()Lorg/openrndr/ffmpeg/VideoWriterProfile;", "setProfile", "(Lorg/openrndr/ffmpeg/VideoWriterProfile;)V", "frameClock", "getFrameClock", "setFrameClock", "multisample", "Lorg/openrndr/draw/BufferMultisample;", "getMultisample", "()Lorg/openrndr/draw/BufferMultisample;", "setMultisample", "(Lorg/openrndr/draw/BufferMultisample;)V", "maximumFrames", "getMaximumFrames", "setMaximumFrames", "maximumDuration", "getMaximumDuration", "setMaximumDuration", "quitAfterMaximum", "getQuitAfterMaximum", "setQuitAfterMaximum", "contentScale", "getContentScale", "()Ljava/lang/Double;", "setContentScale", "(Ljava/lang/Double;)V", "Ljava/lang/Double;", "storedClock", "Lkotlin/Function0;", "setup", "", "program", "Lorg/openrndr/Program;", "beforeDraw", "drawer", "Lorg/openrndr/draw/Drawer;", "afterDraw", "writeFrame", "colorBuffer", "shutdown", "openrndr-ffmpeg"})
public final class ScreenRecorder
implements Extension {
    private boolean enabled = true;
    private VideoWriter videoWriter;
    private RenderTarget frame;
    @Nullable
    private ColorBuffer crop;
    @Nullable
    private ColorBuffer resolved;
    private long frameIndex;
    private long framesWritten;
    @NotNull
    private final Event<ScreenRecorder> finished = new Event(null, false, 3, null);
    private boolean recording = true;
    @Nullable
    private Integer width;
    @Nullable
    private Integer height;
    @Nullable
    private String outputFile;
    private int frameRate = 30;
    private double timeOffset;
    private long frameSkip;
    private boolean outputToVideo = true;
    @NotNull
    private VideoWriterProfile profile = new H264Profile();
    private boolean frameClock = true;
    @Nullable
    private BufferMultisample multisample;
    private long maximumFrames = Long.MAX_VALUE;
    private double maximumDuration = Double.POSITIVE_INFINITY;
    private boolean quitAfterMaximum = true;
    @Nullable
    private Double contentScale;
    @Nullable
    private Function0<Double> storedClock;

    @Override
    public boolean getEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    @NotNull
    public final Event<ScreenRecorder> getFinished() {
        return this.finished;
    }

    @Nullable
    public final Integer getWidth() {
        return this.width;
    }

    public final void setWidth(@Nullable Integer n) {
        this.width = n;
    }

    @Nullable
    public final Integer getHeight() {
        return this.height;
    }

    public final void setHeight(@Nullable Integer n) {
        this.height = n;
    }

    @Nullable
    public final String getOutputFile() {
        return this.outputFile;
    }

    public final void setOutputFile(@Nullable String string) {
        this.outputFile = string;
    }

    public final int getFrameRate() {
        return this.frameRate;
    }

    public final void setFrameRate(int n) {
        this.frameRate = n;
    }

    public final double getTimeOffset() {
        return this.timeOffset;
    }

    public final void setTimeOffset(double d) {
        this.timeOffset = d;
    }

    public final long getFrameSkip() {
        return this.frameSkip;
    }

    public final void setFrameSkip(long l) {
        this.frameSkip = l;
    }

    public final boolean getOutputToVideo() {
        return this.outputToVideo;
    }

    public final void setOutputToVideo(boolean bl) {
        this.outputToVideo = bl;
    }

    @NotNull
    public final VideoWriterProfile getProfile() {
        return this.profile;
    }

    public final void setProfile(@NotNull VideoWriterProfile videoWriterProfile) {
        Intrinsics.checkNotNullParameter(videoWriterProfile, "<set-?>");
        this.profile = videoWriterProfile;
    }

    public final boolean getFrameClock() {
        return this.frameClock;
    }

    public final void setFrameClock(boolean bl) {
        this.frameClock = bl;
    }

    @Nullable
    public final BufferMultisample getMultisample() {
        return this.multisample;
    }

    public final void setMultisample(@Nullable BufferMultisample bufferMultisample) {
        this.multisample = bufferMultisample;
    }

    public final long getMaximumFrames() {
        return this.maximumFrames;
    }

    public final void setMaximumFrames(long l) {
        this.maximumFrames = l;
    }

    public final double getMaximumDuration() {
        return this.maximumDuration;
    }

    public final void setMaximumDuration(double d) {
        this.maximumDuration = d;
    }

    public final boolean getQuitAfterMaximum() {
        return this.quitAfterMaximum;
    }

    public final void setQuitAfterMaximum(boolean bl) {
        this.quitAfterMaximum = bl;
    }

    @Nullable
    public final Double getContentScale() {
        return this.contentScale;
    }

    public final void setContentScale(@Nullable Double d) {
        this.contentScale = d;
    }

    @Override
    public void setup(@NotNull Program program2) {
        VideoWriter videoWriter;
        int advisedHeight;
        int advisedWidth;
        String filename;
        block23: {
            block22: {
                RenderTarget renderTarget;
                VideoWriter videoWriter2;
                Object object;
                Object object2;
                int requestedHeight;
                Intrinsics.checkNotNullParameter(program2, "program");
                if (program2.getWindow().getResizable()) {
                    ScreenRecorderKt.access$getLogger$p().warn(ScreenRecorder::setup$lambda$0);
                    program2.getWindow().setResizable(false);
                }
                Integer n = this.width;
                int requestedWidth = n != null ? n.intValue() : program2.getWidth();
                Integer n2 = this.height;
                int n3 = requestedHeight = n2 != null ? n2.intValue() : program2.getHeight();
                if (this.multisample == null) {
                    this.multisample = program2.getWindow().getMultisample().bufferEquivalent();
                }
                if (this.contentScale == null) {
                    this.contentScale = program2.getWindow().getContentScale();
                }
                BufferMultisample bufferMultisample = this.multisample;
                Intrinsics.checkNotNull(bufferMultisample);
                BufferMultisample bufferMultisample2 = bufferMultisample;
                Double d = this.contentScale;
                Intrinsics.checkNotNull(d);
                double d2 = d;
                this.frame = RenderTargetKt.renderTarget$default(requestedWidth, requestedHeight, d2, bufferMultisample2, null, ScreenRecorder::setup$lambda$1, 16, null);
                if (!Intrinsics.areEqual(this.multisample, BufferMultisample.Disabled.INSTANCE)) {
                    Double d3 = this.contentScale;
                    Intrinsics.checkNotNull(d3);
                    this.resolved = ColorBufferKt.colorBuffer$default(requestedWidth, requestedHeight, d3, null, null, null, 0, null, 248, null);
                }
                if (!((object2 = (CharSequence)this.outputFile) == null || StringsKt.isBlank((CharSequence)object2))) {
                    String string = this.outputFile;
                    object = string;
                    Intrinsics.checkNotNull(string);
                } else {
                    object = "video/" + program2.getAssetMetadata().invoke().assetBaseName() + "." + this.profile.getFileExtension();
                }
                filename = object;
                File file = new File(filename).getParentFile();
                if (file != null) {
                    File it = file;
                    boolean bl = false;
                    if (!it.exists()) {
                        it.mkdirs();
                    }
                }
                if ((videoWriter2 = (this.videoWriter = new VideoWriter())) == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("videoWriter");
                    videoWriter2 = null;
                }
                videoWriter2.profile(this.profile);
                VideoWriter videoWriter3 = this.videoWriter;
                if (videoWriter3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("videoWriter");
                    videoWriter3 = null;
                }
                if ((renderTarget = this.frame) == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("frame");
                    renderTarget = null;
                }
                int n4 = renderTarget.getPixelWidth();
                RenderTarget renderTarget2 = this.frame;
                if (renderTarget2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("frame");
                    renderTarget2 = null;
                }
                object2 = videoWriter3.advisedSize(n4, renderTarget2.getPixelHeight());
                advisedWidth = ((Number)((Pair)object2).component1()).intValue();
                advisedHeight = ((Number)((Pair)object2).component2()).intValue();
                RenderTarget renderTarget3 = this.frame;
                if (renderTarget3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("frame");
                    renderTarget3 = null;
                }
                if (advisedWidth != renderTarget3.getPixelWidth()) break block22;
                RenderTarget renderTarget4 = this.frame;
                if (renderTarget4 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("frame");
                    renderTarget4 = null;
                }
                if (advisedHeight == renderTarget4.getPixelHeight()) break block23;
            }
            ScreenRecorderKt.access$getLogger$p().warn(() -> ScreenRecorder.setup$lambda$3(this, advisedWidth, advisedHeight));
            this.crop = ColorBufferKt.colorBuffer$default(advisedWidth, advisedHeight, 0.0, null, null, null, 0, null, 252, null);
        }
        if ((videoWriter = this.videoWriter) == null) {
            Intrinsics.throwUninitializedPropertyAccessException("videoWriter");
            videoWriter = null;
        }
        videoWriter.output(filename);
        VideoWriter videoWriter4 = this.videoWriter;
        if (videoWriter4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("videoWriter");
            videoWriter4 = null;
        }
        videoWriter4.size(advisedWidth, advisedHeight);
        VideoWriter videoWriter5 = this.videoWriter;
        if (videoWriter5 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("videoWriter");
            videoWriter5 = null;
        }
        videoWriter5.setFrameRate(this.frameRate);
    }

    @Override
    public void beforeDraw(@NotNull Drawer drawer, @NotNull Program program2) {
        block3: {
            Intrinsics.checkNotNullParameter(drawer, "drawer");
            Intrinsics.checkNotNullParameter(program2, "program");
            if (this.frameClock) {
                this.storedClock = program2.getClock();
                program2.setClock(() -> ScreenRecorder.beforeDraw$lambda$4(this));
                program2.updateFrameSecondsFromClock();
            }
            if (this.frameIndex < this.frameSkip) break block3;
            RenderTarget renderTarget = this.frame;
            if (renderTarget == null) {
                Intrinsics.throwUninitializedPropertyAccessException("frame");
                renderTarget = null;
            }
            renderTarget.bind();
            ColorRGBa colorRGBa = program2.getBackgroundColor();
            if (colorRGBa != null) {
                ColorRGBa it = colorRGBa;
                boolean bl = false;
                drawer.clear(it);
            }
        }
    }

    @Override
    public void afterDraw(@NotNull Drawer drawer, @NotNull Program program2) {
        block17: {
            Intrinsics.checkNotNullParameter(drawer, "drawer");
            Intrinsics.checkNotNullParameter(program2, "program");
            if (this.frameIndex >= this.frameSkip) {
                RenderTarget renderTarget = this.frame;
                if (renderTarget == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("frame");
                    renderTarget = null;
                }
                renderTarget.unbind();
                if (this.framesWritten < this.maximumFrames && (double)this.framesWritten / (double)this.frameRate < this.maximumDuration) {
                    ColorBuffer lresolved = this.resolved;
                    ColorBuffer lcrop = this.crop;
                    if (lresolved != null) {
                        RenderTarget renderTarget2 = this.frame;
                        if (renderTarget2 == null) {
                            Intrinsics.throwUninitializedPropertyAccessException("frame");
                            renderTarget2 = null;
                        }
                        ColorBuffer.copyTo$default(renderTarget2.colorBuffer(0), lresolved, 0, 0, null, 14, null);
                        if (lcrop == null) {
                            this.writeFrame(lresolved);
                        } else {
                            ColorBuffer.copyTo$default(lresolved, lcrop, 0, 0, IntRectangleKt.IntRectangle(0, 0, lcrop.getEffectiveWidth(), lcrop.getEffectiveHeight()), IntRectangleKt.IntRectangle(0, 0, lcrop.getEffectiveWidth(), lcrop.getEffectiveHeight()), null, 38, null);
                            this.writeFrame(lcrop);
                        }
                    } else if (lcrop == null) {
                        RenderTarget renderTarget3 = this.frame;
                        if (renderTarget3 == null) {
                            Intrinsics.throwUninitializedPropertyAccessException("frame");
                            renderTarget3 = null;
                        }
                        this.writeFrame(renderTarget3.colorBuffer(0));
                    } else {
                        RenderTarget renderTarget4 = this.frame;
                        if (renderTarget4 == null) {
                            Intrinsics.throwUninitializedPropertyAccessException("frame");
                            renderTarget4 = null;
                        }
                        ColorBuffer.copyTo$default(renderTarget4.colorBuffer(0), lcrop, 0, 0, IntRectangleKt.IntRectangle(0, 0, lcrop.getEffectiveWidth(), lcrop.getEffectiveHeight()), IntRectangleKt.IntRectangle(0, 0, lcrop.getEffectiveWidth(), lcrop.getEffectiveHeight()), null, 38, null);
                        this.writeFrame(lcrop);
                    }
                } else {
                    if (this.quitAfterMaximum) {
                        program2.getApplication().exit();
                    }
                    if (this.recording) {
                        VideoWriter videoWriter = this.videoWriter;
                        if (videoWriter == null) {
                            Intrinsics.throwUninitializedPropertyAccessException("videoWriter");
                            videoWriter = null;
                        }
                        videoWriter.stop();
                        this.recording = false;
                        this.finished.trigger(this);
                    }
                }
            }
            DrawerKt.isolated(drawer, arg_0 -> ScreenRecorder.afterDraw$lambda$6(drawer, this, arg_0));
            long l = this.frameIndex;
            this.frameIndex = l + 1L;
            if (!this.frameClock) break block17;
            Function0<Double> function0 = this.storedClock;
            if (function0 != null) {
                Function0<Double> it = function0;
                boolean bl = false;
                program2.setClock(it);
                program2.updateFrameSecondsFromClock();
            }
        }
    }

    private final void writeFrame(ColorBuffer colorBuffer) {
        if (this.outputToVideo) {
            VideoWriter videoWriter;
            VideoWriter videoWriter2 = this.videoWriter;
            if (videoWriter2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("videoWriter");
                videoWriter2 = null;
            }
            if (!videoWriter2.getStarted()) {
                VideoWriter videoWriter3 = this.videoWriter;
                if (videoWriter3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("videoWriter");
                    videoWriter3 = null;
                }
                videoWriter3.start();
            }
            if ((videoWriter = this.videoWriter) == null) {
                Intrinsics.throwUninitializedPropertyAccessException("videoWriter");
                videoWriter = null;
            }
            videoWriter.frame(colorBuffer);
            long l = this.framesWritten;
            this.framesWritten = l + 1L;
        }
    }

    @Override
    public void shutdown(@NotNull Program program2) {
        RenderTarget renderTarget;
        Intrinsics.checkNotNullParameter(program2, "program");
        RenderTarget renderTarget2 = this.frame;
        if (renderTarget2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("frame");
            renderTarget2 = null;
        }
        renderTarget2.colorBuffer(0).destroy();
        RenderTarget renderTarget3 = this.frame;
        if (renderTarget3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("frame");
            renderTarget3 = null;
        }
        DepthBuffer depthBuffer = renderTarget3.getDepthBuffer();
        if (depthBuffer != null) {
            depthBuffer.destroy();
        }
        ColorBuffer colorBuffer = this.resolved;
        if (colorBuffer != null) {
            colorBuffer.destroy();
        }
        if ((renderTarget = this.frame) == null) {
            Intrinsics.throwUninitializedPropertyAccessException("frame");
            renderTarget = null;
        }
        renderTarget.destroy();
        VideoWriter videoWriter = this.videoWriter;
        if (videoWriter == null) {
            Intrinsics.throwUninitializedPropertyAccessException("videoWriter");
            videoWriter = null;
        }
        if (videoWriter.getStarted()) {
            VideoWriter videoWriter2 = this.videoWriter;
            if (videoWriter2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("videoWriter");
                videoWriter2 = null;
            }
            videoWriter2.stop();
        }
    }

    private static final Object setup$lambda$0() {
        return "Resizable windows are not supported, disabling window resizing.";
    }

    private static final Unit setup$lambda$1(RenderTargetBuilder $this$renderTarget) {
        Intrinsics.checkNotNullParameter($this$renderTarget, "$this$renderTarget");
        RenderTargetBuilder.colorBuffer$default($this$renderTarget, null, null, 3, null);
        RenderTargetBuilder.depthBuffer$default($this$renderTarget, null, 1, null);
        return Unit.INSTANCE;
    }

    private static final Object setup$lambda$3(ScreenRecorder this$0, int $advisedWidth, int $advisedHeight) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        RenderTarget renderTarget = this$0.frame;
        if (renderTarget == null) {
            Intrinsics.throwUninitializedPropertyAccessException("frame");
            renderTarget = null;
        }
        int n = renderTarget.getPixelWidth();
        RenderTarget renderTarget2 = this$0.frame;
        if (renderTarget2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("frame");
            renderTarget2 = null;
        }
        return "cropping video from " + n + "x" + renderTarget2.getPixelHeight() + " to " + $advisedWidth + "x" + $advisedHeight;
    }

    private static final double beforeDraw$lambda$4(ScreenRecorder this$0) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        return (double)this$0.frameIndex / (double)this$0.frameRate + this$0.timeOffset;
    }

    private static final Unit afterDraw$lambda$6(Drawer $drawer, ScreenRecorder this$0, Drawer $this$isolated) {
        Intrinsics.checkNotNullParameter($drawer, "$drawer");
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($this$isolated, "$this$isolated");
        $drawer.defaults();
        ColorBuffer lresolved = this$0.resolved;
        if (lresolved != null) {
            $drawer.image(lresolved);
        } else {
            RenderTarget renderTarget = this$0.frame;
            if (renderTarget == null) {
                Intrinsics.throwUninitializedPropertyAccessException("frame");
                renderTarget = null;
            }
            ColorBuffer colorBuffer = renderTarget.colorBuffer(0);
            RenderTarget renderTarget2 = this$0.frame;
            if (renderTarget2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("frame");
                renderTarget2 = null;
            }
            double d = renderTarget2.getWidth();
            RenderTarget renderTarget3 = this$0.frame;
            if (renderTarget3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("frame");
                renderTarget3 = null;
            }
            $drawer.image(colorBuffer, 0.0, 0.0, d, renderTarget3.getHeight());
        }
        return Unit.INSTANCE;
    }
}

