/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.ffmpeg;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.openrndr.draw.ColorBuffer;
import org.openrndr.ffmpeg.H264Profile;
import org.openrndr.ffmpeg.VideoWriterKt;
import org.openrndr.ffmpeg.VideoWriterProfile;
import org.openrndr.platform.Platform;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010!\u001a\u00020(2\u0006\u0010!\u001a\u00020\"J\"\u0010)\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r0*2\u0006\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\rJ\u0016\u0010+\u001a\u00020(2\u0006\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\rJ\u000e\u0010,\u001a\u00020(2\u0006\u0010\u0017\u001a\u00020\u0018J\b\u0010-\u001a\u0004\u0018\u00010\u0005J\u0006\u0010.\u001a\u00020\u0000J\u000e\u00102\u001a\u00020(2\u0006\u00102\u001a\u000203J\u0006\u00104\u001a\u00020(R\u001a\u0010\u0004\u001a\u00020\u0005X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001e\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\r@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u000fR\u001e\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\r@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u000fR\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001f\u001a\u0004\u0018\u00010 X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\"X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010#\u001a\u00020\u0018X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'R\u0011\u0010/\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b0\u00101\u00a8\u00065"}, d2={"Lorg/openrndr/ffmpeg/VideoWriter;", "", "<init>", "()V", "ffmpegOutput", "Ljava/io/File;", "getFfmpegOutput$openrndr_ffmpeg", "()Ljava/io/File;", "setFfmpegOutput$openrndr_ffmpeg", "(Ljava/io/File;)V", "stopped", "", "frameRate", "", "getFrameRate", "()I", "setFrameRate", "(I)V", "value", "width", "getWidth", "height", "getHeight", "filename", "", "frameBuffer", "Ljava/nio/ByteBuffer;", "channel", "Ljava/nio/channels/WritableByteChannel;", "ffmpeg", "Ljava/lang/Process;", "movieStream", "Ljava/io/OutputStream;", "profile", "Lorg/openrndr/ffmpeg/VideoWriterProfile;", "inputFormat", "getInputFormat", "()Ljava/lang/String;", "setInputFormat", "(Ljava/lang/String;)V", "", "advisedSize", "Lkotlin/Pair;", "size", "output", "findFfmpeg", "start", "started", "getStarted", "()Z", "frame", "Lorg/openrndr/draw/ColorBuffer;", "stop", "openrndr-ffmpeg"})
@SourceDebugExtension(value={"SMAP\nVideoWriter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VideoWriter.kt\norg/openrndr/ffmpeg/VideoWriter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,302:1\n1#2:303\n37#3,2:304\n*S KotlinDebug\n*F\n+ 1 VideoWriter.kt\norg/openrndr/ffmpeg/VideoWriter\n*L\n234#1:304,2\n*E\n"})
public final class VideoWriter {
    @NotNull
    private File ffmpegOutput = new File("ffmpegOutput.txt");
    private boolean stopped;
    private int frameRate = 25;
    private int width = -1;
    private int height = -1;
    @NotNull
    private String filename = "openrndr.mp4";
    private ByteBuffer frameBuffer;
    private WritableByteChannel channel;
    @Nullable
    private Process ffmpeg;
    @Nullable
    private OutputStream movieStream;
    @NotNull
    private VideoWriterProfile profile = new H264Profile();
    @NotNull
    private String inputFormat = "rgba";

    @NotNull
    public final File getFfmpegOutput$openrndr_ffmpeg() {
        return this.ffmpegOutput;
    }

    public final void setFfmpegOutput$openrndr_ffmpeg(@NotNull File file) {
        Intrinsics.checkNotNullParameter(file, "<set-?>");
        this.ffmpegOutput = file;
    }

    public final int getFrameRate() {
        return this.frameRate;
    }

    public final void setFrameRate(int n) {
        this.frameRate = n;
    }

    public final int getWidth() {
        return this.width;
    }

    public final int getHeight() {
        return this.height;
    }

    @NotNull
    public final String getInputFormat() {
        return this.inputFormat;
    }

    public final void setInputFormat(@NotNull String string) {
        Intrinsics.checkNotNullParameter(string, "<set-?>");
        this.inputFormat = string;
    }

    public final void profile(@NotNull VideoWriterProfile profile) {
        Intrinsics.checkNotNullParameter(profile, "profile");
        this.profile = profile;
    }

    @NotNull
    public final Pair<Integer, Integer> advisedSize(int width, int height) {
        int advisedWidth = width / 2 * 2;
        int advisedHeight = height / 2 * 2;
        return new Pair<Integer, Integer>(advisedWidth, advisedHeight);
    }

    public final void size(int width, int height) {
        if (width % 2 != 0 || height % 2 != 0) {
            throw new IllegalArgumentException("width (" + width + ") and height (" + height + ") should be divisible by 2");
        }
        this.width = width;
        this.height = height;
    }

    public final void output(@NotNull String filename) {
        Intrinsics.checkNotNullParameter(filename, "filename");
        this.filename = filename;
    }

    @Nullable
    public final File findFfmpeg() {
        Object object;
        String ffmpegPathArg;
        String string = System.getProperty("os.name");
        Intrinsics.checkNotNullExpressionValue(string, "getProperty(...)");
        String ffmpegExe = StringsKt.contains$default((CharSequence)string, "Windows", false, 2, null) ? "ffmpeg.exe" : "ffmpeg";
        Object object2 = System.getProperties().get("org.openrndr.ffmpeg");
        String string2 = ffmpegPathArg = object2 instanceof String ? (String)object2 : null;
        if (ffmpegPathArg == null) {
            Object v2;
            block8: {
                Iterable iterable = CollectionsKt.plus((Collection)CollectionsKt.listOf(new File(".")), (Iterable)Platform.INSTANCE.path());
                for (Object t : iterable) {
                    File it = (File)t;
                    boolean bl = false;
                    if (!new File(it, ffmpegExe).exists()) continue;
                    v2 = t;
                    break block8;
                }
                v2 = null;
            }
            File directory = v2;
            if (directory != null) {
                VideoWriterKt.access$getLogger$p().info(() -> VideoWriter.findFfmpeg$lambda$1(directory));
                object = new File(directory, ffmpegExe);
            } else {
                object = null;
            }
        } else if (Intrinsics.areEqual(ffmpegPathArg, "jar")) {
            object = null;
        } else {
            File specified = new File(ffmpegPathArg);
            if (!specified.exists()) {
                boolean bl = false;
                String string3 = "file '" + ffmpegPathArg + "' does not exist";
                throw new IllegalArgumentException(string3.toString());
            }
            object = object2;
        }
        return object;
    }

    @NotNull
    public final VideoWriter start() {
        ByteBuffer byteBuffer;
        String finalFilename;
        VideoWriterKt.access$getLogger$p().debug(() -> VideoWriter.start$lambda$3(this));
        File file = new File(this.filename);
        String string = finalFilename = !Intrinsics.areEqual(FilesKt.getExtension(file), this.profile.getFileExtension()) ? VideoWriterKt.getFileWithoutExtension(file) + "." + this.profile.getFileExtension() : this.filename;
        if (this.width <= 0) {
            throw new RuntimeException("invalid width or width not set " + this.width);
        }
        if (this.height <= 0) {
            throw new RuntimeException("invalid height or height not set " + this.height);
        }
        String string2 = this.inputFormat;
        if (Intrinsics.areEqual(string2, "rgba")) {
            byteBuffer = BufferUtils.createByteBuffer(this.width * this.height * 4);
        } else if (Intrinsics.areEqual(string2, "rgba64le")) {
            byteBuffer = BufferUtils.createByteBuffer(this.width * this.height * 8);
        } else {
            throw new RuntimeException("unsupported format " + this.inputFormat);
        }
        this.frameBuffer = byteBuffer;
        String[] stringArray = new String[13];
        stringArray[0] = "-y";
        stringArray[1] = "-f";
        stringArray[2] = "rawvideo";
        stringArray[3] = "-vcodec";
        stringArray[4] = "rawvideo";
        stringArray[5] = "-s";
        String string3 = "%dx%d";
        Object[] objectArray = new Object[]{this.width, this.height};
        Intrinsics.checkNotNullExpressionValue(String.format(string3, Arrays.copyOf(objectArray, objectArray.length)), "format(...)");
        stringArray[7] = "-pix_fmt";
        stringArray[8] = this.inputFormat;
        stringArray[9] = "-r";
        stringArray[10] = "" + this.frameRate;
        stringArray[11] = "-i";
        stringArray[12] = "-";
        String[] preamble = stringArray;
        String[] codec = this.profile.arguments();
        ArrayList<String> arguments = new ArrayList<String>();
        File ffmpegFile = this.findFfmpeg();
        boolean bl = ffmpegFile != null ? arguments.add(ffmpegFile.toString()) : arguments.add(VideoWriterKt.access$getBuiltInFfmpegBinary());
        arguments.addAll((Collection)CollectionsKt.listOf(Arrays.copyOf(preamble, preamble.length)));
        arguments.addAll((Collection)CollectionsKt.listOf(Arrays.copyOf(codec, codec.length)));
        arguments.add(finalFilename);
        VideoWriterKt.access$getLogger$p().debug(() -> VideoWriter.start$lambda$4(arguments));
        Collection $this$toTypedArray$iv = arguments;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray2 = thisCollection$iv.toArray(new String[0]);
        ProcessBuilder pb = new ProcessBuilder(new String[0]).command(Arrays.copyOf(stringArray2, stringArray2.length));
        pb.redirectErrorStream(true);
        pb.redirectOutput(this.ffmpegOutput);
        try {
            Process process = this.ffmpeg = pb.start();
            Intrinsics.checkNotNull(process);
            this.movieStream = process.getOutputStream();
            this.channel = Channels.newChannel(this.movieStream);
            return this;
        }
        catch (IOException e) {
            VideoWriterKt.access$getLogger$p().error(VideoWriter::start$lambda$5);
            VideoWriterKt.access$getLogger$p().error(() -> VideoWriter.start$lambda$6(arguments));
            throw new RuntimeException("failed to launch ffmpeg", e);
        }
    }

    public final boolean getStarted() {
        return this.ffmpeg != null;
    }

    public final void frame(@NotNull ColorBuffer frame) {
        Intrinsics.checkNotNullParameter(frame, "frame");
        if (!this.stopped) {
            int frameBytes = frame.getEffectiveWidth() * frame.getEffectiveHeight() * frame.getFormat().getComponentCount() * frame.getType().getComponentSize();
            ByteBuffer byteBuffer = this.frameBuffer;
            if (byteBuffer == null) {
                Intrinsics.throwUninitializedPropertyAccessException("frameBuffer");
                byteBuffer = null;
            }
            if (!(frameBytes == byteBuffer.capacity())) {
                boolean $i$a$-require-VideoWriter$frame$22 = false;
                String $i$a$-require-VideoWriter$frame$22 = "frame size/format/type mismatch. (" + this.width + " x " + this.height + ") vs ({" + frame.getEffectiveWidth() + " x " + frame.getEffectiveHeight() + ")";
                throw new IllegalArgumentException($i$a$-require-VideoWriter$frame$22.toString());
            }
            ByteBuffer byteBuffer2 = this.frameBuffer;
            if (byteBuffer2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("frameBuffer");
                byteBuffer2 = null;
            }
            ((Buffer)byteBuffer2).rewind();
            ByteBuffer byteBuffer3 = this.frameBuffer;
            if (byteBuffer3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("frameBuffer");
                byteBuffer3 = null;
            }
            ColorBuffer.read$default(frame, byteBuffer3, null, null, 0, 14, null);
            ByteBuffer byteBuffer4 = this.frameBuffer;
            if (byteBuffer4 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("frameBuffer");
                byteBuffer4 = null;
            }
            ((Buffer)byteBuffer4).rewind();
            try {
                ByteBuffer byteBuffer5;
                WritableByteChannel writableByteChannel = this.channel;
                if (writableByteChannel == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("channel");
                    writableByteChannel = null;
                }
                if ((byteBuffer5 = this.frameBuffer) == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("frameBuffer");
                    byteBuffer5 = null;
                }
                int n = writableByteChannel.write(byteBuffer5);
            }
            catch (IOException e) {
                throw new RuntimeException("failed to write frame", e);
            }
        } else {
            VideoWriterKt.access$getLogger$p().warn(VideoWriter::frame$lambda$8);
        }
    }

    public final void stop() {
        if (!this.stopped) {
            this.stopped = true;
            try {
                OutputStream outputStream = this.movieStream;
                Intrinsics.checkNotNull(outputStream);
                outputStream.close();
                try {
                    VideoWriterKt.access$getLogger$p().info(VideoWriter::stop$lambda$9);
                    Process process = this.ffmpeg;
                    Intrinsics.checkNotNull(process);
                    process.waitFor();
                    VideoWriterKt.access$getLogger$p().info(VideoWriter::stop$lambda$10);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            catch (IOException e) {
                throw new RuntimeException("failed to close the movie stream", e);
            }
        }
    }

    private static final Object findFfmpeg$lambda$1(File $directory) {
        return "ffmpeg found in '" + $directory + "'";
    }

    private static final Object start$lambda$3(VideoWriter this$0) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        return "starting video writer with " + this$0.width + " x " + this$0.height + " output using " + this$0.inputFormat + " writing to " + this$0.filename;
    }

    private static final Object start$lambda$4(ArrayList $arguments) {
        Intrinsics.checkNotNullParameter($arguments, "$arguments");
        return "using arguments: " + CollectionsKt.joinToString$default($arguments, null, null, null, 0, null, null, 63, null);
    }

    private static final Object start$lambda$5() {
        return "system path: " + System.getenv("path");
    }

    private static final Object start$lambda$6(ArrayList $arguments) {
        Intrinsics.checkNotNullParameter($arguments, "$arguments");
        return "command: " + CollectionsKt.joinToString$default($arguments, " ", null, null, 0, null, null, 62, null);
    }

    private static final Object frame$lambda$8() {
        return "ignoring frame after VideoWriter stop";
    }

    private static final Object stop$lambda$9() {
        return "waiting for ffmpeg to finish";
    }

    private static final Object stop$lambda$10() {
        return "ffmpeg finished";
    }
}

