/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.openrndr.draw.ArrayTexture;
import org.openrndr.draw.BufferMultisample;
import org.openrndr.draw.BufferWriter;
import org.openrndr.draw.ColorBuffer;
import org.openrndr.draw.DrawContext;
import org.openrndr.draw.DrawPrimitive;
import org.openrndr.draw.DrawStyle;
import org.openrndr.draw.DrawerConfiguration;
import org.openrndr.draw.Session;
import org.openrndr.draw.ShadeStructure;
import org.openrndr.draw.ShadeStyle;
import org.openrndr.draw.ShadeStyleManager;
import org.openrndr.draw.Shader;
import org.openrndr.draw.VertexBuffer;
import org.openrndr.draw.VertexBufferKt;
import org.openrndr.draw.VertexBufferShadow;
import org.openrndr.draw.VertexElementType;
import org.openrndr.draw.VertexFormat;
import org.openrndr.draw.VertexFormatKt;
import org.openrndr.internal.Driver;
import org.openrndr.internal.ShaderGenerators;
import org.openrndr.math.Vector2;
import org.openrndr.math.Vector3;
import org.openrndr.math.Vector4;
import org.openrndr.shape.Rectangle;
import org.openrndr.shape.RectangleKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0007H\u0002J8\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0018\u0010\u001a\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u001c0\u001b0\u000bJF\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001d\u001a\u00020\u001e2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00070\u000b2\u0018\u0010\u001a\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u001c0\u001b0\u000bJ>\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020!2\u0006\u0010#\u001a\u00020!2\u0006\u0010$\u001a\u00020!JF\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010%\u001a\u00020\u00072\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020!2\u0006\u0010#\u001a\u00020!2\u0006\u0010$\u001a\u00020!R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lorg/openrndr/internal/ImageDrawer;", "", "<init>", "()V", "vertices", "Lorg/openrndr/draw/VertexBuffer;", "count", "", "instanceFormat", "Lorg/openrndr/draw/VertexFormat;", "singleInstanceAttributes", "", "instanceAttributes", "shaderManager", "Lorg/openrndr/draw/ShadeStyleManager;", "arrayTextureShaderManager", "assertInstanceSize", "", "size", "drawImage", "drawContext", "Lorg/openrndr/draw/DrawContext;", "drawStyle", "Lorg/openrndr/draw/DrawStyle;", "colorBuffer", "Lorg/openrndr/draw/ColorBuffer;", "rectangles", "Lkotlin/Pair;", "Lorg/openrndr/shape/Rectangle;", "arrayTexture", "Lorg/openrndr/draw/ArrayTexture;", "layers", "x", "", "y", "width", "height", "layer", "openrndr-draw"})
@SourceDebugExtension(value={"SMAP\nImageDrawer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ImageDrawer.kt\norg/openrndr/internal/ImageDrawer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,222:1\n1863#2,2:223\n1872#2,3:225\n*S KotlinDebug\n*F\n+ 1 ImageDrawer.kt\norg/openrndr/internal/ImageDrawer\n*L\n107#1:223,2\n158#1:225,3\n*E\n"})
public final class ImageDrawer {
    @NotNull
    private final VertexBuffer vertices = VertexBuffer.Companion.createDynamic(VertexFormatKt.vertexFormat(ImageDrawer::vertices$lambda$0), 6, Session.Companion.getRoot());
    private int count;
    @NotNull
    private final VertexFormat instanceFormat = VertexFormatKt.vertexFormat(ImageDrawer::instanceFormat$lambda$1);
    @NotNull
    private final List<VertexBuffer> singleInstanceAttributes;
    @NotNull
    private VertexBuffer instanceAttributes;
    @NotNull
    private final ShadeStyleManager shaderManager;
    @NotNull
    private final ShadeStyleManager arrayTextureShaderManager;

    public ImageDrawer() {
        BufferWriter bufferWriter;
        int n = DrawerConfiguration.INSTANCE.getVertexBufferMultiBufferCount();
        ImageDrawer imageDrawer = this;
        ArrayList<VertexBuffer> arrayList = new ArrayList<VertexBuffer>(n);
        int n2 = 0;
        while (n2 < n) {
            int n3;
            int n4 = n3 = n2++;
            ArrayList<VertexBuffer> arrayList2 = arrayList;
            boolean bl = false;
            arrayList2.add(VertexBufferKt.vertexBuffer(this.instanceFormat, 1, Session.Companion.getRoot()));
        }
        imageDrawer.singleInstanceAttributes = arrayList;
        this.instanceAttributes = VertexBufferKt.vertexBuffer(this.instanceFormat, 10, Session.Companion.getRoot());
        this.shaderManager = ShadeStyleManager.Companion.fromGenerators$default(ShadeStyleManager.Companion, "image", new Function1<ShadeStructure, String>((Object)Driver.Companion.getInstance().getShaderGenerators()){

            public final String invoke(ShadeStructure p0) {
                Intrinsics.checkNotNullParameter(p0, "p0");
                return ((ShaderGenerators)this.receiver).imageVertexShader(p0);
            }
        }, null, null, null, new Function1<ShadeStructure, String>((Object)Driver.Companion.getInstance().getShaderGenerators()){

            public final String invoke(ShadeStructure p0) {
                Intrinsics.checkNotNullParameter(p0, "p0");
                return ((ShaderGenerators)this.receiver).imageFragmentShader(p0);
            }
        }, 28, null);
        this.arrayTextureShaderManager = ShadeStyleManager.Companion.fromGenerators$default(ShadeStyleManager.Companion, "array-texture", new Function1<ShadeStructure, String>((Object)Driver.Companion.getInstance().getShaderGenerators()){

            public final String invoke(ShadeStructure p0) {
                Intrinsics.checkNotNullParameter(p0, "p0");
                return ((ShaderGenerators)this.receiver).imageArrayTextureVertexShader(p0);
            }
        }, null, null, null, new Function1<ShadeStructure, String>((Object)Driver.Companion.getInstance().getShaderGenerators()){

            public final String invoke(ShadeStructure p0) {
                Intrinsics.checkNotNullParameter(p0, "p0");
                return ((ShaderGenerators)this.receiver).imageArrayTextureFragmentShader(p0);
            }
        }, 28, null);
        BufferWriter w = this.vertices.getShadow().writer();
        w.rewind();
        Vector3 pa = new Vector3(0.0, 0.0, 0.0);
        Vector3 pb = new Vector3(1.0, 0.0, 0.0);
        Vector3 pc = new Vector3(1.0, 1.0, 0.0);
        Vector3 pd = new Vector3(0.0, 1.0, 0.0);
        double u0 = 0.0;
        double u1 = 1.0;
        double v0 = 1.0;
        double v1 = 0.0;
        Vector2 ta = new Vector2(u0, v1);
        Vector2 tb = new Vector2(u1, v1);
        Vector2 tc = new Vector2(u1, v0);
        Vector2 td = new Vector2(u0, v0);
        Vector3 n5 = new Vector3(0.0, 0.0, -1.0);
        BufferWriter $this$_init__u24lambda_u243 = bufferWriter = w;
        boolean bl = false;
        $this$_init__u24lambda_u243.write(pa);
        $this$_init__u24lambda_u243.write(n5);
        $this$_init__u24lambda_u243.write(ta);
        $this$_init__u24lambda_u243.write(pd);
        $this$_init__u24lambda_u243.write(n5);
        $this$_init__u24lambda_u243.write(td);
        $this$_init__u24lambda_u243.write(pc);
        $this$_init__u24lambda_u243.write(n5);
        $this$_init__u24lambda_u243.write(tc);
        $this$_init__u24lambda_u243.write(pc);
        $this$_init__u24lambda_u243.write(n5);
        $this$_init__u24lambda_u243.write(tc);
        $this$_init__u24lambda_u243.write(pb);
        $this$_init__u24lambda_u243.write(n5);
        $this$_init__u24lambda_u243.write(tb);
        $this$_init__u24lambda_u243.write(pa);
        $this$_init__u24lambda_u243.write(n5);
        $this$_init__u24lambda_u243.write(ta);
        VertexBufferShadow.DefaultImpls.upload$default(this.vertices.getShadow(), 0, 0, 3, null);
    }

    private final void assertInstanceSize(int size) {
        if (this.instanceAttributes.getVertexCount() < size) {
            Session.Companion.getRoot().untrack(this.instanceAttributes);
            this.instanceAttributes.destroy();
            this.instanceAttributes = VertexBufferKt.vertexBuffer(this.instanceFormat, size, Session.Companion.getRoot());
        }
    }

    public final void drawImage(@NotNull DrawContext drawContext, @NotNull DrawStyle drawStyle, @NotNull ColorBuffer colorBuffer, @NotNull List<Pair<Rectangle, Rectangle>> rectangles) {
        Object object;
        VertexBuffer vertexBuffer;
        Intrinsics.checkNotNullParameter(drawContext, "drawContext");
        Intrinsics.checkNotNullParameter(drawStyle, "drawStyle");
        Intrinsics.checkNotNullParameter(colorBuffer, "colorBuffer");
        Intrinsics.checkNotNullParameter(rectangles, "rectangles");
        if (!Intrinsics.areEqual(colorBuffer.getMultisample(), BufferMultisample.Disabled.INSTANCE)) {
            boolean $i$a$-require-ImageDrawer$drawImage$22 = false;
            String $i$a$-require-ImageDrawer$drawImage$22 = "multisample color buffer " + colorBuffer + " needs to be resolved first";
            throw new IllegalArgumentException($i$a$-require-ImageDrawer$drawImage$22.toString());
        }
        this.assertInstanceSize(rectangles.size());
        if (rectangles.size() == 1) {
            int $i$a$-require-ImageDrawer$drawImage$22 = this.count;
            int n = this.singleInstanceAttributes.size();
            int n2 = $i$a$-require-ImageDrawer$drawImage$22 % n;
            vertexBuffer = this.singleInstanceAttributes.get(n2 + (n & ((n2 ^ n) & (n2 | -n2)) >> 31));
        } else {
            vertexBuffer = this.instanceAttributes;
        }
        VertexBuffer localInstanceAttributes = vertexBuffer;
        Shader shader = this.shaderManager.shader(drawStyle.getShadeStyle(), CollectionsKt.listOf(this.vertices.getVertexFormat()), CollectionsKt.listOf(localInstanceAttributes.getVertexFormat()));
        BufferWriter iw = localInstanceAttributes.getShadow().writer();
        iw.rewind();
        Iterable $this$forEach$iv = rectangles;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Pair it = (Pair)element$iv;
            boolean bl = false;
            Rectangle source = (Rectangle)it.component1();
            Rectangle target = (Rectangle)it.component2();
            iw.write(new Vector4(source.corner().x() / (double)colorBuffer.getWidth(), source.corner().y() / (double)colorBuffer.getHeight(), source.width() / (double)colorBuffer.getWidth(), source.height() / (double)colorBuffer.getHeight()));
            iw.write(new Vector4(target.corner().x(), target.corner().y(), target.width(), target.height()));
            iw.write(0.0f);
        }
        localInstanceAttributes.getShadow().uploadElements(0, rectangles.size());
        colorBuffer.bind(0);
        shader.begin();
        drawContext.applyToShader(shader);
        shader.uniform("u_flipV", colorBuffer.getFlipV() ? 1 : 0);
        drawStyle.applyToShader(shader);
        Driver.Companion.getInstance().setState(drawStyle);
        Driver.Companion.getInstance().drawInstances(shader, CollectionsKt.listOf(this.vertices), CollectionsKt.plus((Collection)CollectionsKt.listOf(localInstanceAttributes), (object = drawStyle.getShadeStyle()) != null && (object = ((ShadeStyle)object).getAttributes()) != null ? (Iterable)object : (Iterable)CollectionsKt.emptyList()), DrawPrimitive.TRIANGLES, 0, 6, 0, rectangles.size(), 0);
        shader.end();
        int n = this.count;
        this.count = n + 1;
    }

    /*
     * WARNING - void declaration
     */
    public final void drawImage(@NotNull DrawContext drawContext, @NotNull DrawStyle drawStyle, @NotNull ArrayTexture arrayTexture, @NotNull List<Integer> layers, @NotNull List<Pair<Rectangle, Rectangle>> rectangles) {
        Object object;
        Intrinsics.checkNotNullParameter(drawContext, "drawContext");
        Intrinsics.checkNotNullParameter(drawStyle, "drawStyle");
        Intrinsics.checkNotNullParameter(arrayTexture, "arrayTexture");
        Intrinsics.checkNotNullParameter(layers, "layers");
        Intrinsics.checkNotNullParameter(rectangles, "rectangles");
        this.assertInstanceSize(rectangles.size());
        Shader shader = this.arrayTextureShaderManager.shader(drawStyle.getShadeStyle(), CollectionsKt.listOf(this.vertices.getVertexFormat()), CollectionsKt.listOf(this.instanceAttributes.getVertexFormat()));
        BufferWriter iw = this.instanceAttributes.getShadow().writer();
        iw.rewind();
        Iterable $this$forEachIndexed$iv = rectangles;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void it;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Pair pair = (Pair)item$iv;
            int index = n;
            boolean bl = false;
            Rectangle source = (Rectangle)it.component1();
            Rectangle target = (Rectangle)it.component2();
            iw.write(new Vector4(source.corner().x() / (double)arrayTexture.getWidth(), source.corner().y() / (double)arrayTexture.getHeight(), source.width() / (double)arrayTexture.getWidth(), source.height() / (double)arrayTexture.getHeight()));
            iw.write(new Vector4(target.corner().x(), target.corner().y(), target.width(), target.height()));
            iw.write((float)((Number)layers.get(index)).intValue());
        }
        this.instanceAttributes.getShadow().uploadElements(0, rectangles.size());
        arrayTexture.bind(0);
        shader.begin();
        drawContext.applyToShader(shader);
        shader.uniform("u_flipV", arrayTexture.getFlipV() ? 1 : 0);
        drawStyle.applyToShader(shader);
        Driver.Companion.getInstance().setState(drawStyle);
        Driver.Companion.getInstance().drawInstances(shader, CollectionsKt.listOf(this.vertices), CollectionsKt.plus((Collection)CollectionsKt.listOf(this.instanceAttributes), (object = drawStyle.getShadeStyle()) != null && (object = ((ShadeStyle)object).getAttributes()) != null ? (Iterable)object : (Iterable)CollectionsKt.emptyList()), DrawPrimitive.TRIANGLES, 0, 6, 0, rectangles.size(), 0);
        shader.end();
    }

    public final void drawImage(@NotNull DrawContext drawContext, @NotNull DrawStyle drawStyle, @NotNull ColorBuffer colorBuffer, double x, double y, double width, double height) {
        Intrinsics.checkNotNullParameter(drawContext, "drawContext");
        Intrinsics.checkNotNullParameter(drawStyle, "drawStyle");
        Intrinsics.checkNotNullParameter(colorBuffer, "colorBuffer");
        this.drawImage(drawContext, drawStyle, colorBuffer, CollectionsKt.listOf(TuplesKt.to(colorBuffer.getBounds(), RectangleKt.Rectangle(x, y, width, height))));
    }

    public final void drawImage(@NotNull DrawContext drawContext, @NotNull DrawStyle drawStyle, @NotNull ArrayTexture arrayTexture, int layer, double x, double y, double width, double height) {
        Intrinsics.checkNotNullParameter(drawContext, "drawContext");
        Intrinsics.checkNotNullParameter(drawStyle, "drawStyle");
        Intrinsics.checkNotNullParameter(arrayTexture, "arrayTexture");
        this.drawImage(drawContext, drawStyle, arrayTexture, CollectionsKt.listOf(layer), CollectionsKt.listOf(TuplesKt.to(arrayTexture.getBounds(), RectangleKt.Rectangle(x, y, width, height))));
    }

    private static final Unit vertices$lambda$0(VertexFormat $this$vertexFormat) {
        Intrinsics.checkNotNullParameter($this$vertexFormat, "$this$vertexFormat");
        $this$vertexFormat.position(3);
        $this$vertexFormat.normal(3);
        VertexFormat.textureCoordinate$default($this$vertexFormat, 2, 0, 2, null);
        return Unit.INSTANCE;
    }

    private static final Unit instanceFormat$lambda$1(VertexFormat $this$vertexFormat) {
        Intrinsics.checkNotNullParameter($this$vertexFormat, "$this$vertexFormat");
        VertexFormat.attribute$default($this$vertexFormat, "source", VertexElementType.VECTOR4_FLOAT32, 0, 4, null);
        VertexFormat.attribute$default($this$vertexFormat, "target", VertexElementType.VECTOR4_FLOAT32, 0, 4, null);
        VertexFormat.attribute$default($this$vertexFormat, "layer", VertexElementType.FLOAT32, 0, 4, null);
        return Unit.INSTANCE;
    }
}

