/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.openrndr.draw.LineCap;
import org.openrndr.draw.LineJoin;
import org.openrndr.internal.Expansion;
import org.openrndr.internal.ExpansionKt;
import org.openrndr.internal.ExpansionType;
import org.openrndr.internal.PathPoint;
import org.openrndr.math.Vector2;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\b\n\u0000\n\u0002\u0010!\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 &2\u00020\u0001:\u0001&B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J.\u0010\u0015\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0019H\u0002J\u0014\u0010\u001d\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011J.\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u00192\u0006\u0010!\u001a\u00020\u00192\u0006\u0010\"\u001a\u00020#2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0019J,\u0010$\u001a\b\u0012\u0004\u0012\u00020\u001f0\u00112\u0006\u0010 \u001a\u00020\u00192\u0006\u0010%\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0019R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\u0007\"\u0004\b\f\u0010\tR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u000f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\u00110\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006'"}, d2={"Lorg/openrndr/internal/Path;", "", "<init>", "()V", "convex", "", "getConvex", "()Z", "setConvex", "(Z)V", "closed", "getClosed", "setClosed", "nbevel", "", "contours", "", "", "Lorg/openrndr/internal/PathPoint;", "getContours", "()Ljava/util/List;", "calculateJoins", "", "points", "w", "", "lineJoin", "Lorg/openrndr/draw/LineJoin;", "miterLimit", "prepare", "expandStroke", "Lorg/openrndr/internal/Expansion;", "fringeWidth", "strokeWeight", "lineCap", "Lorg/openrndr/draw/LineCap;", "expandFill", "weight", "Companion", "openrndr-draw"})
@SourceDebugExtension(value={"SMAP\nExpansion.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Expansion.kt\norg/openrndr/internal/Path\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,744:1\n1#2:745\n1863#3,2:746\n1863#3,2:748\n1863#3,2:750\n*S KotlinDebug\n*F\n+ 1 Expansion.kt\norg/openrndr/internal/Path\n*L\n585#1:746,2\n586#1:748,2\n602#1:750,2\n*E\n"})
public final class Path {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private boolean convex;
    private boolean closed;
    private int nbevel;
    @NotNull
    private final List<List<PathPoint>> contours = new ArrayList();

    public final boolean getConvex() {
        return this.convex;
    }

    public final void setConvex(boolean bl) {
        this.convex = bl;
    }

    public final boolean getClosed() {
        return this.closed;
    }

    public final void setClosed(boolean bl) {
        this.closed = bl;
    }

    @NotNull
    public final List<List<PathPoint>> getContours() {
        return this.contours;
    }

    private final void calculateJoins(List<PathPoint> points2, double w, LineJoin lineJoin, double miterLimit) {
        if (points2.isEmpty()) {
            return;
        }
        this.nbevel = 0;
        double iw = w > 0.0 ? 1.0 / w : 0.0;
        int nleft = 0;
        PathPoint p0 = points2.get(points2.size() - 1);
        PathPoint p1 = points2.get(0);
        int p1ptr = 0;
        int n = ((Collection)points2).size();
        for (int j = 0; j < n; ++j) {
            double limit;
            double dlx0 = p0.getDy();
            double dly0 = -p0.getDx();
            double dlx1 = p1.getDy();
            double dly1 = -p1.getDx();
            p1.setDmx((dlx0 + dlx1) * 0.5);
            p1.setDmy((dly0 + dly1) * 0.5);
            double dmr2 = p1.getDmx() * p1.getDmx() + p1.getDmy() * p1.getDmy();
            if (dmr2 > (double)1.0E-6f) {
                double scale = 1.0 / dmr2;
                if (scale > 600.0) {
                    scale = 600.0;
                }
                PathPoint pathPoint = p1;
                pathPoint.setDmx(pathPoint.getDmx() * scale);
                pathPoint = p1;
                pathPoint.setDmy(pathPoint.getDmy() * scale);
            }
            p1.setFlags((p1.getFlags() & 1) != 0 ? 1 : 0);
            double cross = p1.getDx() * p0.getDy() - p0.getDx() * p1.getDy();
            if (cross > 0.0) {
                ++nleft;
                p1.setFlags(p1.getFlags() | 2);
            }
            if (dmr2 * (limit = Math.max(1.01, Math.min(p0.getLength(), p1.getLength()) * iw)) * limit < 1.0) {
                p1.setFlags(p1.getFlags() | 8);
            }
            if ((p1.getFlags() & 1) != 0 && (dmr2 * miterLimit * miterLimit < 1.0 || lineJoin == LineJoin.BEVEL || lineJoin == LineJoin.ROUND)) {
                p1.setFlags(p1.getFlags() | 4);
            }
            if ((p1.getFlags() & 0xC) != 0) {
                int n2 = this.nbevel;
                this.nbevel = n2 + 1;
            }
            p0 = p1;
            if (++p1ptr >= points2.size()) continue;
            p1 = points2.get(p1ptr);
        }
        this.convex = nleft == points2.size();
    }

    public final void prepare(@NotNull List<PathPoint> points2) {
        Intrinsics.checkNotNullParameter(points2, "points");
        if (points2.isEmpty()) {
            return;
        }
        PathPoint p0 = null;
        p0 = points2.get(points2.size() - 1);
        PathPoint p1 = points2.get(0);
        int p1ptr = 0;
        int n = ((Collection)points2).size();
        for (int i = 0; i < n; ++i) {
            p0.setDx(p1.getX() - p0.getX());
            p0.setDy(p1.getY() - p0.getY());
            double distanceSquared = p0.getDx() * p0.getDx() + p0.getDy() * p0.getDy();
            if (!(distanceSquared > 0.0 || i == 0 && !this.closed)) {
                boolean bl = false;
                String string = "consecutive point duplication in input geometry at (" + i + " and " + (i + 1) + ") (" + p0.getX() + "," + p0.getY() + ")";
                throw new IllegalArgumentException(string.toString());
            }
            p0.setLength(Math.sqrt(distanceSquared));
            if (p0.getLength() > 0.0) {
                PathPoint pathPoint = p0;
                pathPoint.setDx(pathPoint.getDx() / p0.getLength());
                pathPoint = p0;
                pathPoint.setDy(pathPoint.getDy() / p0.getLength());
            } else {
                p0.setDx(0.0);
                p0.setDy(0.0);
            }
            p0 = p1;
            if (++p1ptr >= points2.size()) continue;
            p1 = points2.get(p1ptr);
        }
    }

    @NotNull
    public final Expansion expandStroke(double fringeWidth, double strokeWeight, @NotNull LineCap lineCap, @NotNull LineJoin lineJoin, double miterLimit) {
        Intrinsics.checkNotNullParameter((Object)lineCap, "lineCap");
        Intrinsics.checkNotNullParameter((Object)lineJoin, "lineJoin");
        double weight = strokeWeight + fringeWidth * 1.0;
        if (!((Collection)this.contours).isEmpty() && ExpansionKt.access$getRenderable(this.contours.get(0))) {
            double length;
            double dy;
            int p1ptr;
            List<PathPoint> points2 = this.contours.get(0);
            double tessTol = 0.1 * fringeWidth;
            int capSteps = ExpansionKt.curveDivs(weight, Math.PI, tessTol);
            this.prepare(points2);
            this.calculateJoins(points2, weight, lineJoin, miterLimit);
            int cverts = 0;
            cverts += lineJoin == LineJoin.ROUND ? (points2.size() + this.nbevel * (capSteps + 2) + 1) * 2 : (points2.size() + this.nbevel * 5 + 1) * 2;
            if (!this.closed) {
                cverts += lineCap == LineCap.ROUND ? (capSteps * 2 + 2) * 2 : 12;
            }
            Expansion expansion = new Expansion(ExpansionType.STROKE, new float[cverts * 5], 0);
            double offset = 0.0;
            double aa = fringeWidth;
            PathPoint p0 = this.closed ? points2.get(points2.size() - 1) : points2.get(0);
            PathPoint p1 = this.closed ? points2.get(0) : points2.get(1);
            int start = this.closed ? 0 : 1;
            int end = this.closed ? points2.size() : points2.size() - 1;
            int n = p1ptr = this.closed ? 0 : 1;
            if (!this.closed) {
                double dx = p1.getX() - p0.getX();
                length = Math.sqrt(dx * dx + (dy = p1.getY() - p0.getY()) * dy);
                if (length > 0.0) {
                    dx /= length;
                    dy /= length;
                }
                switch (WhenMappings.$EnumSwitchMapping$0[lineCap.ordinal()]) {
                    case 1: {
                        expansion.buttCapStart(p0, dx, dy, weight, -aa * 0.5, aa, offset);
                        break;
                    }
                    case 2: {
                        expansion.buttCapStart(p0, dx, dy, weight, weight - aa, aa, offset);
                        break;
                    }
                    case 3: {
                        expansion.roundCapStart(p0, dx, dy, weight, capSteps, offset);
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
            }
            for (int j = start; j < end; ++j) {
                offset += p0.getLength();
                if ((p1.getFlags() & 0xC) != 0) {
                    if (lineJoin == LineJoin.ROUND) {
                        expansion.roundJoin(p0, p1, weight, weight, 0.0, 1.0, capSteps, offset);
                    } else {
                        expansion.bevelJoin(p0, p1, weight, weight, 0.0, 1.0, offset);
                    }
                } else {
                    expansion.addVertex(p1.getX() + p1.getDmx() * weight, p1.getY() + p1.getDmy() * weight, 0.0, 1.0, offset);
                    expansion.addVertex(p1.getX() - p1.getDmx() * weight, p1.getY() - p1.getDmy() * weight, 1.0, 1.0, offset);
                }
                p0 = p1;
                if (++p1ptr >= points2.size()) continue;
                p1 = points2.get(p1ptr);
            }
            if (points2.size() == 2) {
                double dx = p1.getX() - p0.getX();
                dy = p1.getY() - p0.getY();
                offset = length = Math.sqrt(dx * dx + dy * dy);
            } else {
                offset += p0.getLength();
            }
            if (this.closed) {
                Vector2 v0 = expansion.vertex(0);
                Vector2 v1 = expansion.vertex(1);
                expansion.addVertex(v0.x(), v0.y(), 0.0, 1.0, offset);
                expansion.addVertex(v1.x(), v1.y(), 1.0, 1.0, offset);
            } else {
                double dx = p1.getX() - p0.getX();
                double l = Math.sqrt(dx * dx + (dy = p1.getY() - p0.getY()) * dy);
                if (l > 0.0) {
                    dx /= l;
                    dy /= l;
                }
                switch (WhenMappings.$EnumSwitchMapping$0[lineCap.ordinal()]) {
                    case 1: {
                        expansion.buttCapEnd(p1, dx, dy, weight, -aa * 0.5, aa, offset);
                        break;
                    }
                    case 2: {
                        expansion.buttCapEnd(p1, dx, dy, weight, weight - aa, aa, offset);
                        break;
                    }
                    case 3: {
                        expansion.roundCapEnd(p1, dx, dy, weight, capSteps, offset);
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
            }
            return expansion;
        }
        return new Expansion(ExpansionType.SKIP, new float[0], 0);
    }

    @NotNull
    public final List<Expansion> expandFill(double fringeWidth, double weight, @NotNull LineJoin lineJoin, double miterLimit) {
        Intrinsics.checkNotNullParameter((Object)lineJoin, "lineJoin");
        if (!((Collection)this.contours).isEmpty()) {
            int size;
            List it;
            List result2 = new ArrayList();
            Iterable $this$forEach$iv = this.contours;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (List)element$iv;
                boolean bl = false;
                this.prepare(it);
            }
            $this$forEach$iv = this.contours;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (List)element$iv;
                boolean bl = false;
                this.calculateJoins(it, weight, lineJoin, miterLimit);
            }
            if (this.contours.size() > 1) {
                this.convex = false;
            }
            this.convex = false;
            double woff = 0.5 * fringeWidth;
            boolean generateFringe = fringeWidth > 0.0;
            double pathOffset = 0.0;
            for (List<PathPoint> points2 : this.contours) {
                int n;
                if (points2.isEmpty()) continue;
                size = 0;
                size = 4;
                Iterable $this$forEach$iv2 = points2;
                boolean $i$f$forEach2 = false;
                for (Object element$iv : $this$forEach$iv2) {
                    PathPoint point = (PathPoint)element$iv;
                    n = 0;
                    size += (point.getFlags() & 4) != 0 ? 12 : 4;
                }
                Expansion fill = new Expansion(ExpansionType.FILL, new float[size * 5], 0);
                if (generateFringe) {
                    PathPoint p0 = CollectionsKt.last(points2);
                    PathPoint p1 = points2.get(0);
                    int p1ptr = 0;
                    n = ((Collection)points2).size();
                    for (int j = 0; j < n; ++j) {
                        if ((p1.getFlags() & 4) != 0) {
                            if ((p1.getFlags() & 2) != 0) {
                                fill.addVertex(p1.getX() + p1.getDmx() * woff, p1.getY() + p1.getDmy() * woff, 0.5, 1.0, pathOffset);
                            } else {
                                double dlx0 = p0.getDy();
                                double dly0 = -p0.getDx();
                                double dlx1 = p1.getDy();
                                double dly1 = -p1.getDx();
                                double lx0 = p1.getX() + dlx0 * woff;
                                double ly0 = p1.getY() + dly0 * woff;
                                double lx1 = p1.getX() + dlx1 * woff;
                                double ly1 = p1.getY() + dly1 * woff;
                                fill.addVertex(lx0, ly0, 0.5, 1.0, pathOffset);
                                fill.addVertex(lx1, ly1, 0.5, 1.0, pathOffset);
                            }
                        } else {
                            fill.addVertex(p1.getX() + p1.getDmx() * woff, p1.getY() + p1.getDmy() * woff, 0.5, 1.0, pathOffset);
                        }
                        p0 = p1;
                        if (++p1ptr >= points2.size()) continue;
                        p1 = points2.get(p1ptr);
                    }
                } else {
                    int n2 = ((Collection)points2).size();
                    for (int j = 0; j < n2; ++j) {
                        fill.addVertex(points2.get(j).getX(), points2.get(j).getY(), 0.5, 1.0, pathOffset);
                    }
                }
                result2.add(fill);
            }
            if (generateFringe) {
                for (List<PathPoint> points2 : this.contours) {
                    if (points2.isEmpty()) continue;
                    size = 2;
                    for (PathPoint point : points2) {
                        size += (point.getFlags() & 0xC) != 0 ? 10 : 4;
                    }
                    Expansion fringe = new Expansion(ExpansionType.FRINGE, new float[size * 5], 0);
                    double lw = weight + woff;
                    double rw = weight - woff;
                    double lu = 0.0;
                    double ru = 1.0;
                    if (this.convex) {
                        lw = woff;
                        lu = 0.5;
                    }
                    PathPoint p0 = points2.get(points2.size() - 1);
                    PathPoint p1 = points2.get(0);
                    int p1ptr = 0;
                    int n = ((Collection)points2).size();
                    for (int j = 0; j < n; ++j) {
                        if ((p1.getFlags() & 0xC) != 0) {
                            fringe.bevelJoin(p0, p1, lw, rw, lu, ru, pathOffset);
                        } else {
                            fringe.addVertex(p1.getX() + p1.getDmx() * lw, p1.getY() + p1.getDmy() * lw, lu, 1.0, pathOffset);
                            fringe.addVertex(p1.getX() - p1.getDmx() * rw, p1.getY() - p1.getDmy() * rw, ru, 1.0, pathOffset);
                        }
                        p0 = p1;
                        if (++p1ptr >= points2.size()) continue;
                        p1 = points2.get(p1ptr);
                    }
                    Vector2 v0 = fringe.vertex(0);
                    Vector2 v1 = fringe.vertex(1);
                    fringe.addVertex(v0.x(), v0.y(), lu, 1.0, pathOffset);
                    fringe.addVertex(v1.x(), v1.y(), ru, 1.0, pathOffset);
                    result2.add(fringe);
                }
            }
            return result2;
        }
        return CollectionsKt.emptyList();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J*\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u00072\u0006\u0010\u000b\u001a\u00020\nJ.\u0010\f\u001a\u00020\u00052\u0012\u0010\r\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u00072\u0012\u0010\t\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\u00070\u0007\u00a8\u0006\u000e"}, d2={"Lorg/openrndr/internal/Path$Companion;", "", "<init>", "()V", "fromLineStrip", "Lorg/openrndr/internal/Path;", "segments", "", "Lorg/openrndr/math/Vector2;", "corners", "", "closed", "fromLineLoops", "contours", "openrndr-draw"})
    @SourceDebugExtension(value={"SMAP\nExpansion.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Expansion.kt\norg/openrndr/internal/Path$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,744:1\n1567#2:745\n1598#2,3:746\n1601#2:750\n1872#2,2:751\n1567#2:753\n1598#2,4:754\n1874#2:758\n1#3:749\n*S KotlinDebug\n*F\n+ 1 Expansion.kt\norg/openrndr/internal/Path$Companion\n*L\n328#1:745\n328#1:746,3\n328#1:750\n345#1:751,2\n346#1:753\n346#1:754,4\n345#1:758\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Path fromLineStrip(@NotNull List<Vector2> segments, @NotNull List<Boolean> corners, boolean closed) {
            void $this$mapIndexedTo$iv$iv;
            Intrinsics.checkNotNullParameter(segments, "segments");
            Intrinsics.checkNotNullParameter(corners, "corners");
            Path sp = new Path();
            if (segments.isEmpty()) {
                return sp;
            }
            boolean drop2 = closed && CollectionsKt.first(segments).squaredDistanceTo(CollectionsKt.last(segments)) < 1.0E-5;
            Iterable $this$mapIndexed$iv = segments;
            boolean $i$f$mapIndexed = false;
            Iterable iterable = $this$mapIndexed$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$mapIndexed$iv, 10));
            boolean $i$f$mapIndexedTo = false;
            int index$iv$iv = 0;
            for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
                void index;
                void it;
                PathPoint pathPoint;
                int n;
                if ((n = index$iv$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                Vector2 vector2 = (Vector2)item$iv$iv;
                int n2 = n;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                PathPoint $this$fromLineStrip_u24lambda_u241_u24lambda_u240 = pathPoint = new PathPoint();
                boolean bl2 = false;
                $this$fromLineStrip_u24lambda_u241_u24lambda_u240.setX(it.x());
                $this$fromLineStrip_u24lambda_u241_u24lambda_u240.setY(it.y());
                $this$fromLineStrip_u24lambda_u241_u24lambda_u240.setFlags(corners.get((int)index) != false ? 1 : 0);
                collection.add(pathPoint);
            }
            List path = CollectionsKt.dropLast((List)destination$iv$iv, drop2 ? 1 : 0);
            if (!((Collection)path).isEmpty()) {
                if (!closed) {
                    ((PathPoint)path.get(0)).setFlags(0);
                    ((PathPoint)path.get(path.size() - 1)).setFlags(0);
                }
                sp.getContours().add(path);
            }
            sp.setClosed(closed);
            return sp;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Path fromLineLoops(@NotNull List<? extends List<Vector2>> contours, @NotNull List<? extends List<Boolean>> corners) {
            Intrinsics.checkNotNullParameter(contours, "contours");
            Intrinsics.checkNotNullParameter(corners, "corners");
            Path sp = new Path();
            Iterable $this$forEachIndexed$iv = contours;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void $this$mapIndexedTo$iv$iv;
                void contour;
                int n;
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                List list = (List)item$iv;
                int contourIndex = n;
                boolean bl = false;
                Iterable $this$mapIndexed$iv = (Iterable)contour;
                boolean $i$f$mapIndexed = false;
                Iterable iterable = $this$mapIndexed$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$mapIndexed$iv, 10));
                boolean $i$f$mapIndexedTo = false;
                int index$iv$iv = 0;
                for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
                    void index;
                    void it;
                    PathPoint pathPoint;
                    int n2;
                    if ((n2 = index$iv$iv++) < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    Vector2 vector2 = (Vector2)item$iv$iv;
                    int n3 = n2;
                    Collection collection = destination$iv$iv;
                    boolean bl2 = false;
                    PathPoint $this$fromLineLoops_u24lambda_u244_u24lambda_u243_u24lambda_u242 = pathPoint = new PathPoint();
                    boolean bl3 = false;
                    $this$fromLineLoops_u24lambda_u244_u24lambda_u243_u24lambda_u242.setX(it.x());
                    $this$fromLineLoops_u24lambda_u244_u24lambda_u243_u24lambda_u242.setY(it.y());
                    $this$fromLineLoops_u24lambda_u244_u24lambda_u243_u24lambda_u242.setFlags(corners.get(contourIndex).get((int)index) != false ? 1 : 0);
                    collection.add(pathPoint);
                }
                List path = CollectionsKt.dropLast((List)destination$iv$iv, 1);
                sp.getContours().add(path);
            }
            sp.setClosed(true);
            return sp;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[LineCap.values().length];
            try {
                nArray[LineCap.BUTT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LineCap.SQUARE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LineCap.ROUND.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

