/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.openrndr.draw.BatchesKt;
import org.openrndr.draw.BufferWriter;
import org.openrndr.draw.DrawContext;
import org.openrndr.draw.DrawPrimitive;
import org.openrndr.draw.DrawStyle;
import org.openrndr.draw.DrawerConfiguration;
import org.openrndr.draw.PointBatch;
import org.openrndr.draw.Session;
import org.openrndr.draw.ShadeStructure;
import org.openrndr.draw.ShadeStyle;
import org.openrndr.draw.ShadeStyleManager;
import org.openrndr.draw.Shader;
import org.openrndr.draw.VertexBuffer;
import org.openrndr.draw.VertexBufferShadow;
import org.openrndr.draw.VertexFormat;
import org.openrndr.internal.Driver;
import org.openrndr.internal.ShaderGenerators;
import org.openrndr.math.Vector2;
import org.openrndr.math.Vector3;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u000fH\u0000\u00a2\u0006\u0002\b\u0017J+\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\u0011H\u0007\u00a2\u0006\u0002\b\u001fJ+\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020 0\u0011H\u0007\u00a2\u0006\u0002\b!J.\u0010\"\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020$2\u0006\u0010&\u001a\u00020$J&\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\u00020\tX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\t0\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lorg/openrndr/internal/PointDrawer;", "", "<init>", "()V", "vertices", "Lorg/openrndr/draw/VertexBuffer;", "getVertices", "()Lorg/openrndr/draw/VertexBuffer;", "batch", "Lorg/openrndr/draw/PointBatch;", "getBatch$openrndr_draw", "()Lorg/openrndr/draw/PointBatch;", "setBatch$openrndr_draw", "(Lorg/openrndr/draw/PointBatch;)V", "count", "", "singleBatches", "", "shaderManager", "Lorg/openrndr/draw/ShadeStyleManager;", "ensureBatchSize", "", "size", "ensureBatchSize$openrndr_draw", "drawPoints", "drawContext", "Lorg/openrndr/draw/DrawContext;", "drawStyle", "Lorg/openrndr/draw/DrawStyle;", "positions", "Lorg/openrndr/math/Vector2;", "drawPoints2D", "Lorg/openrndr/math/Vector3;", "drawPoints3D", "drawPoint", "x", "", "y", "z", "openrndr-draw"})
@SourceDebugExtension(value={"SMAP\nPointDrawer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PointDrawer.kt\norg/openrndr/internal/PointDrawer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,108:1\n1557#2:109\n1628#2,3:110\n*S KotlinDebug\n*F\n+ 1 PointDrawer.kt\norg/openrndr/internal/PointDrawer\n*L\n20#1:109\n20#1:110,3\n*E\n"})
public final class PointDrawer {
    @NotNull
    private final VertexBuffer vertices;
    @NotNull
    private PointBatch batch;
    private int count;
    @NotNull
    private final List<PointBatch> singleBatches;
    @NotNull
    private final ShadeStyleManager shaderManager;

    /*
     * WARNING - void declaration
     */
    public PointDrawer() {
        BufferWriter bufferWriter;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        void $this$vertices_u24lambda_u240;
        Object object = new VertexFormat();
        VertexFormat vertexFormat = object;
        Object object2 = VertexBuffer.Companion;
        PointDrawer pointDrawer = this;
        boolean $i$a$-apply-PointDrawer$vertices$22 = false;
        $this$vertices_u24lambda_u240.position(3);
        $this$vertices_u24lambda_u240.normal(3);
        Unit unit = Unit.INSTANCE;
        pointDrawer.vertices = VertexBuffer.Companion.createDynamic$default((VertexBuffer.Companion)object2, (VertexFormat)object, 1, null, 4, null);
        this.batch = PointBatch.Companion.create(10000, Session.Companion.getRoot());
        object = RangesKt.until(0, DrawerConfiguration.INSTANCE.getVertexBufferMultiBufferCount());
        pointDrawer = this;
        boolean $i$f$map = false;
        void $i$a$-apply-PointDrawer$vertices$22 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator2).nextInt();
            object2 = destination$iv$iv;
            boolean bl = false;
            object2.add(PointBatch.Companion.create$default(PointBatch.Companion, 1, null, 2, null));
        }
        pointDrawer.singleBatches = (List)destination$iv$iv;
        this.shaderManager = ShadeStyleManager.Companion.fromGenerators$default(ShadeStyleManager.Companion, "point", new Function1<ShadeStructure, String>((Object)Driver.Companion.getInstance().getShaderGenerators()){

            public final String invoke(ShadeStructure p0) {
                Intrinsics.checkNotNullParameter(p0, "p0");
                return ((ShaderGenerators)this.receiver).pointVertexShader(p0);
            }
        }, null, null, null, new Function1<ShadeStructure, String>((Object)Driver.Companion.getInstance().getShaderGenerators()){

            public final String invoke(ShadeStructure p0) {
                Intrinsics.checkNotNullParameter(p0, "p0");
                return ((ShaderGenerators)this.receiver).pointFragmentShader(p0);
            }
        }, 28, null);
        BufferWriter w = this.vertices.getShadow().writer();
        w.rewind();
        double x = 0.0;
        double y = 0.0;
        Vector3 pa = new Vector3(x, y, 0.0);
        Vector3 n = new Vector3(0.0, 0.0, -1.0);
        BufferWriter $this$_init__u24lambda_u242 = bufferWriter = w;
        boolean bl = false;
        $this$_init__u24lambda_u242.write(pa);
        $this$_init__u24lambda_u242.write(n);
        VertexBufferShadow.DefaultImpls.upload$default(this.vertices.getShadow(), 0, 0, 3, null);
    }

    @NotNull
    public final VertexBuffer getVertices() {
        return this.vertices;
    }

    @NotNull
    public final PointBatch getBatch$openrndr_draw() {
        return this.batch;
    }

    public final void setBatch$openrndr_draw(@NotNull PointBatch pointBatch) {
        Intrinsics.checkNotNullParameter(pointBatch, "<set-?>");
        this.batch = pointBatch;
    }

    public final void ensureBatchSize$openrndr_draw(int size) {
        if (this.batch.getSize() < size) {
            this.batch.destroy();
            this.batch = PointBatch.Companion.create(size, Session.Companion.getRoot());
        }
    }

    @JvmName(name="drawPoints2D")
    public final void drawPoints2D(@NotNull DrawContext drawContext, @NotNull DrawStyle drawStyle, @NotNull List<Vector2> positions) {
        Intrinsics.checkNotNullParameter(drawContext, "drawContext");
        Intrinsics.checkNotNullParameter(drawStyle, "drawStyle");
        Intrinsics.checkNotNullParameter(positions, "positions");
        this.ensureBatchSize$openrndr_draw(positions.size());
        VertexBuffer.put$default(this.batch.getGeometry(), 0, arg_0 -> PointDrawer.drawPoints$lambda$3(positions, arg_0), 1, null);
        VertexBuffer.put$default(this.batch.getDrawStyle(), 0, arg_0 -> PointDrawer.drawPoints$lambda$4(positions, drawStyle, arg_0), 1, null);
        this.drawPoints(drawContext, drawStyle, this.batch, positions.size());
    }

    @JvmName(name="drawPoints3D")
    public final void drawPoints3D(@NotNull DrawContext drawContext, @NotNull DrawStyle drawStyle, @NotNull List<Vector3> positions) {
        Intrinsics.checkNotNullParameter(drawContext, "drawContext");
        Intrinsics.checkNotNullParameter(drawStyle, "drawStyle");
        Intrinsics.checkNotNullParameter(positions, "positions");
        this.ensureBatchSize$openrndr_draw(positions.size());
        VertexBuffer.put$default(this.batch.getGeometry(), 0, arg_0 -> PointDrawer.drawPoints$lambda$5(positions, arg_0), 1, null);
        VertexBuffer.put$default(this.batch.getDrawStyle(), 0, arg_0 -> PointDrawer.drawPoints$lambda$6(positions, drawStyle, arg_0), 1, null);
        this.drawPoints(drawContext, drawStyle, this.batch, positions.size());
    }

    public final void drawPoint(@NotNull DrawContext drawContext, @NotNull DrawStyle drawStyle, double x, double y, double z) {
        Intrinsics.checkNotNullParameter(drawContext, "drawContext");
        Intrinsics.checkNotNullParameter(drawStyle, "drawStyle");
        this.ensureBatchSize$openrndr_draw(1);
        int n = this.count;
        int n2 = this.singleBatches.size();
        int n3 = n % n2;
        PointBatch batch = this.singleBatches.get(n3 + (n2 & ((n3 ^ n2) & (n3 | -n3)) >> 31));
        VertexBuffer.put$default(batch.getGeometry(), 0, arg_0 -> PointDrawer.drawPoint$lambda$7(x, y, z, arg_0), 1, null);
        VertexBuffer.put$default(batch.getDrawStyle(), 0, arg_0 -> PointDrawer.drawPoint$lambda$8(drawStyle, arg_0), 1, null);
        this.drawPoints(drawContext, drawStyle, batch, 1);
    }

    public final void drawPoints(@NotNull DrawContext drawContext, @NotNull DrawStyle drawStyle, @NotNull PointBatch batch, int count2) {
        Object object;
        Intrinsics.checkNotNullParameter(drawContext, "drawContext");
        Intrinsics.checkNotNullParameter(drawStyle, "drawStyle");
        Intrinsics.checkNotNullParameter(batch, "batch");
        Object[] objectArray = new VertexFormat[]{batch.getGeometry().getVertexFormat(), batch.getDrawStyle().getVertexFormat()};
        Shader shader = this.shaderManager.shader(drawStyle.getShadeStyle(), CollectionsKt.listOf(this.vertices.getVertexFormat()), CollectionsKt.listOf(objectArray));
        shader.begin();
        drawContext.applyToShader(shader);
        drawStyle.applyToShader(shader);
        Driver.Companion.getInstance().setState(drawStyle);
        objectArray = new VertexBuffer[]{batch.getDrawStyle(), batch.getGeometry()};
        Driver.DefaultImpls.drawInstances$default(Driver.Companion.getInstance(), shader, CollectionsKt.listOf(this.vertices), CollectionsKt.plus((Collection)CollectionsKt.listOf(objectArray), (object = drawStyle.getShadeStyle()) != null && (object = ((ShadeStyle)object).getAttributes()) != null ? (Iterable)object : (Iterable)CollectionsKt.emptyList()), DrawPrimitive.POINTS, 0, 1, 0, count2, 0, 256, null);
        shader.end();
    }

    private static final Unit drawPoints$lambda$3(List $positions, BufferWriter $this$put) {
        Intrinsics.checkNotNullParameter($positions, "$positions");
        Intrinsics.checkNotNullParameter($this$put, "$this$put");
        int n = ((Collection)$positions).size();
        for (int i = 0; i < n; ++i) {
            $this$put.write(new Vector3(((Vector2)$positions.get(i)).x(), ((Vector2)$positions.get(i)).y(), 0.0));
        }
        return Unit.INSTANCE;
    }

    private static final Unit drawPoints$lambda$4(List $positions, DrawStyle $drawStyle, BufferWriter $this$put) {
        Intrinsics.checkNotNullParameter($positions, "$positions");
        Intrinsics.checkNotNullParameter($drawStyle, "$drawStyle");
        Intrinsics.checkNotNullParameter($this$put, "$this$put");
        int n = ((Collection)$positions).size();
        for (int i = 0; i < n; ++i) {
            BatchesKt.write($this$put, $drawStyle);
        }
        return Unit.INSTANCE;
    }

    private static final Unit drawPoints$lambda$5(List $positions, BufferWriter $this$put) {
        Intrinsics.checkNotNullParameter($positions, "$positions");
        Intrinsics.checkNotNullParameter($this$put, "$this$put");
        int n = ((Collection)$positions).size();
        for (int i = 0; i < n; ++i) {
            $this$put.write((Vector3)$positions.get(i));
        }
        return Unit.INSTANCE;
    }

    private static final Unit drawPoints$lambda$6(List $positions, DrawStyle $drawStyle, BufferWriter $this$put) {
        Intrinsics.checkNotNullParameter($positions, "$positions");
        Intrinsics.checkNotNullParameter($drawStyle, "$drawStyle");
        Intrinsics.checkNotNullParameter($this$put, "$this$put");
        int n = ((Collection)$positions).size();
        for (int i = 0; i < n; ++i) {
            BatchesKt.write($this$put, $drawStyle);
        }
        return Unit.INSTANCE;
    }

    private static final Unit drawPoint$lambda$7(double $x, double $y, double $z, BufferWriter $this$put) {
        Intrinsics.checkNotNullParameter($this$put, "$this$put");
        $this$put.write(new Vector3($x, $y, $z));
        return Unit.INSTANCE;
    }

    private static final Unit drawPoint$lambda$8(DrawStyle $drawStyle, BufferWriter $this$put) {
        Intrinsics.checkNotNullParameter($drawStyle, "$drawStyle");
        Intrinsics.checkNotNullParameter($this$put, "$this$put");
        BatchesKt.write($this$put, $drawStyle);
        return Unit.INSTANCE;
    }
}

