/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.internal.gl3;

import java.nio.IntBuffer;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.NotImplementedError;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.PointerBuffer;
import org.lwjgl.egl.EGL15;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL45C;
import org.lwjgl.opengles.GLES32;
import org.lwjgl.system.MemoryStack;
import org.openrndr.Application;
import org.openrndr.ApplicationWindow;
import org.openrndr.Configuration;
import org.openrndr.CursorType;
import org.openrndr.Extension;
import org.openrndr.MouseCursorHideMode;
import org.openrndr.Pointer;
import org.openrndr.PresentationMode;
import org.openrndr.Program;
import org.openrndr.ProgramEvent;
import org.openrndr.ProgramEventType;
import org.openrndr.WindowConfiguration;
import org.openrndr.WindowMultisample;
import org.openrndr.animatable.Animatable;
import org.openrndr.animatable.Clock;
import org.openrndr.draw.Drawer;
import org.openrndr.draw.RenderTarget;
import org.openrndr.draw.RenderTargetBuilder;
import org.openrndr.draw.RenderTargetKt;
import org.openrndr.internal.Driver;
import org.openrndr.internal.gl3.ApplicationEGLGL3Kt;
import org.openrndr.internal.gl3.DriverGL3;
import org.openrndr.internal.gl3.DriverVersionGL;
import org.openrndr.internal.gl3.GLGLESKt;
import org.openrndr.internal.gl3.ProgramRenderTargetGL3;
import org.openrndr.math.Vector2;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u00107\u001a\u000208H\u0016J\b\u00109\u001a\u000208H\u0016J\b\u0010:\u001a\u000208H\u0016J\u000e\u0010;\u001a\u000208H\u0096@\u00a2\u0006\u0002\u0010<J\b\u0010=\u001a\u000208H\u0016J\u0018\u0010d\u001a\u00020e2\u0006\u0010\u0004\u001a\u00020f2\u0006\u0010\u0002\u001a\u00020\u0003H\u0016R\u001a\u0010\u0002\u001a\u00020\u0003X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\u0004\u001a\u00020\u0005X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u0011X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\u00020\u0017X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u001a\u0010\u001c\u001a\u00020\u001dX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R \u0010\"\u001a\b\u0012\u0004\u0012\u00020$0#X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(R$\u0010+\u001a\u00020*2\u0006\u0010)\u001a\u00020*8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b,\u0010-\"\u0004\b.\u0010/R\u000e\u00100\u001a\u000201X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00102\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00103\u001a\u000204X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00105\u001a\u000206X\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010?\u001a\u0004\u0018\u00010>2\b\u0010)\u001a\u0004\u0018\u00010>8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b@\u0010A\"\u0004\bB\u0010CR$\u0010D\u001a\u00020>2\u0006\u0010)\u001a\u00020>8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\bE\u0010A\"\u0004\bF\u0010CR$\u0010G\u001a\u00020*2\u0006\u0010)\u001a\u00020*8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\bH\u0010-\"\u0004\bI\u0010/R$\u0010J\u001a\u00020*2\u0006\u0010)\u001a\u00020*8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\bK\u0010-\"\u0004\bL\u0010/R$\u0010N\u001a\u00020M2\u0006\u0010)\u001a\u00020M8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\bO\u0010P\"\u0004\bQ\u0010RR$\u0010S\u001a\u00020\u00112\u0006\u0010)\u001a\u00020\u00118V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\bT\u0010\u0013\"\u0004\bU\u0010\u0015R\u0014\u0010V\u001a\u00020W8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bX\u0010YR$\u0010[\u001a\u00020Z2\u0006\u0010)\u001a\u00020Z8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\\\u0010]\"\u0004\b^\u0010_R$\u0010`\u001a\u00020W2\u0006\u0010)\u001a\u00020W8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\ba\u0010Y\"\u0004\bb\u0010c\u00a8\u0006g"}, d2={"Lorg/openrndr/internal/gl3/ApplicationEGLGL3;", "Lorg/openrndr/Application;", "program", "Lorg/openrndr/Program;", "configuration", "Lorg/openrndr/Configuration;", "<init>", "(Lorg/openrndr/Program;Lorg/openrndr/Configuration;)V", "getProgram", "()Lorg/openrndr/Program;", "setProgram", "(Lorg/openrndr/Program;)V", "getConfiguration", "()Lorg/openrndr/Configuration;", "setConfiguration", "(Lorg/openrndr/Configuration;)V", "cursorVisible", "", "getCursorVisible", "()Z", "setCursorVisible", "(Z)V", "cursorHideMode", "Lorg/openrndr/MouseCursorHideMode;", "getCursorHideMode", "()Lorg/openrndr/MouseCursorHideMode;", "setCursorHideMode", "(Lorg/openrndr/MouseCursorHideMode;)V", "cursorType", "Lorg/openrndr/CursorType;", "getCursorType", "()Lorg/openrndr/CursorType;", "setCursorType", "(Lorg/openrndr/CursorType;)V", "pointers", "", "Lorg/openrndr/Pointer;", "getPointers", "()Ljava/util/List;", "setPointers", "(Ljava/util/List;)V", "value", "Lorg/openrndr/math/Vector2;", "cursorPosition", "getCursorPosition", "()Lorg/openrndr/math/Vector2;", "setCursorPosition", "(Lorg/openrndr/math/Vector2;)V", "driver", "Lorg/openrndr/internal/gl3/DriverGL3;", "exitRequested", "startTime", "", "vaos", "", "requestDraw", "", "requestFocus", "exit", "setup", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "loop", "", "clipboardContents", "getClipboardContents", "()Ljava/lang/String;", "setClipboardContents", "(Ljava/lang/String;)V", "windowTitle", "getWindowTitle", "setWindowTitle", "windowPosition", "getWindowPosition", "setWindowPosition", "windowSize", "getWindowSize", "setWindowSize", "Lorg/openrndr/WindowMultisample;", "windowMultisample", "getWindowMultisample", "()Lorg/openrndr/WindowMultisample;", "setWindowMultisample", "(Lorg/openrndr/WindowMultisample;)V", "windowResizable", "getWindowResizable", "setWindowResizable", "seconds", "", "getSeconds", "()D", "Lorg/openrndr/PresentationMode;", "presentationMode", "getPresentationMode", "()Lorg/openrndr/PresentationMode;", "setPresentationMode", "(Lorg/openrndr/PresentationMode;)V", "windowContentScale", "getWindowContentScale", "setWindowContentScale", "(D)V", "createChildWindow", "Lorg/openrndr/ApplicationWindow;", "Lorg/openrndr/WindowConfiguration;", "openrndr-gl3"})
@SourceDebugExtension(value={"SMAP\nApplicationEGLGL3.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ApplicationEGLGL3.kt\norg/openrndr/internal/gl3/ApplicationEGLGL3\n+ 2 GLGLES.kt\norg/openrndr/internal/gl3/GLGLESKt\n*L\n1#1,194:1\n68#2,3:195\n68#2,3:198\n500#2,5:201\n197#2,3:206\n197#2,3:209\n*S KotlinDebug\n*F\n+ 1 ApplicationEGLGL3.kt\norg/openrndr/internal/gl3/ApplicationEGLGL3\n*L\n104#1:195,3\n105#1:198,3\n107#1:201,5\n108#1:206,3\n142#1:209,3\n*E\n"})
public final class ApplicationEGLGL3
extends Application {
    @NotNull
    private Program program;
    @NotNull
    private Configuration configuration;
    private boolean cursorVisible;
    @NotNull
    private MouseCursorHideMode cursorHideMode;
    @NotNull
    private CursorType cursorType;
    @NotNull
    private List<Pointer> pointers;
    @NotNull
    private DriverGL3 driver;
    private boolean exitRequested;
    private long startTime;
    @NotNull
    private final int[] vaos;

    public ApplicationEGLGL3(@NotNull Program program2, @NotNull Configuration configuration) {
        Intrinsics.checkNotNullParameter(program2, "program");
        Intrinsics.checkNotNullParameter(configuration, "configuration");
        this.program = program2;
        this.configuration = configuration;
        this.cursorHideMode = MouseCursorHideMode.HIDE;
        this.cursorType = CursorType.ARROW_CURSOR;
        this.pointers = CollectionsKt.emptyList();
        this.driver = new DriverGL3(DriverVersionGL.GL_VERSION_3_3);
        this.startTime = System.currentTimeMillis();
        this.vaos = new int[1];
        Driver.Companion.setDriver(this.driver);
        this.getProgram().setApplication(this);
    }

    @Override
    @NotNull
    public Program getProgram() {
        return this.program;
    }

    @Override
    public void setProgram(@NotNull Program program2) {
        Intrinsics.checkNotNullParameter(program2, "<set-?>");
        this.program = program2;
    }

    @Override
    @NotNull
    public Configuration getConfiguration() {
        return this.configuration;
    }

    @Override
    public void setConfiguration(@NotNull Configuration configuration) {
        Intrinsics.checkNotNullParameter(configuration, "<set-?>");
        this.configuration = configuration;
    }

    @Override
    public boolean getCursorVisible() {
        return this.cursorVisible;
    }

    @Override
    public void setCursorVisible(boolean bl) {
        this.cursorVisible = bl;
    }

    @Override
    @NotNull
    public MouseCursorHideMode getCursorHideMode() {
        return this.cursorHideMode;
    }

    @Override
    public void setCursorHideMode(@NotNull MouseCursorHideMode mouseCursorHideMode) {
        Intrinsics.checkNotNullParameter((Object)mouseCursorHideMode, "<set-?>");
        this.cursorHideMode = mouseCursorHideMode;
    }

    @Override
    @NotNull
    public CursorType getCursorType() {
        return this.cursorType;
    }

    @Override
    public void setCursorType(@NotNull CursorType cursorType) {
        Intrinsics.checkNotNullParameter((Object)cursorType, "<set-?>");
        this.cursorType = cursorType;
    }

    @Override
    @NotNull
    public List<Pointer> getPointers() {
        return this.pointers;
    }

    public void setPointers(@NotNull List<Pointer> list) {
        Intrinsics.checkNotNullParameter(list, "<set-?>");
        this.pointers = list;
    }

    @Override
    @NotNull
    public Vector2 getCursorPosition() {
        return new Vector2(0.0, 0.0);
    }

    @Override
    public void setCursorPosition(@NotNull Vector2 value2) {
        Intrinsics.checkNotNullParameter(value2, "value");
    }

    @Override
    public void requestDraw() {
        String string = "not implemented";
        throw new NotImplementedError("An operation is not implemented: " + string);
    }

    @Override
    public void requestFocus() {
    }

    @Override
    public void exit() {
        this.exitRequested = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public Object setup(@NotNull Continuation<? super Unit> $completion) {
        long display = EGL15.eglGetDisplay(0L);
        System.out.println((Object)("display " + display));
        IntBuffer major = BufferUtils.createIntBuffer(1);
        IntBuffer minor = BufferUtils.createIntBuffer(1);
        EGL15.eglInitialize(display, major, minor);
        System.out.println((Object)("EGL version " + major.get(0) + "." + minor.get(0)));
        AutoCloseable autoCloseable = MemoryStack.stackPush();
        Throwable throwable = null;
        try {
            MemoryStack it = (MemoryStack)autoCloseable;
            boolean bl = false;
            IntBuffer configCount = it.mallocInt(1);
            int[] nArray = new int[]{12339, 1, 12322, 8, 12323, 8, 12324, 8, 12325, 24, 12326, 8, 12352, 8, 12344};
            IntBuffer attributes = it.ints(nArray);
            if (!EGL15.eglChooseConfig(display, attributes, null, configCount)) {
                throw new RuntimeException(String.valueOf(EGL15.eglGetError()));
            }
            System.out.println((Object)("number of configs found : " + configCount.get(0)));
            PointerBuffer configs = it.mallocPointer(configCount.get(0));
            EGL15.eglChooseConfig(display, attributes, configs, configCount);
            long surface = EGL15.eglCreatePbufferSurface(display, configs.get(0), attributes);
            EGL15.eglBindAPI(12450);
            int EGL_CONTEXT_FLAGS = 12540;
            int[] nArray2 = new int[]{12440, 3, 12539, 3, EGL_CONTEXT_FLAGS, 1, 12344};
            IntBuffer contextAttributes = it.ints(nArray2);
            long context = EGL15.eglCreateContext(display, configs.get(0), 0L, contextAttributes);
            System.out.println((Object)("context: " + context));
            System.out.println((Object)("client api " + EGL15.eglQueryString(display, 12429)));
            EGL15.eglMakeCurrent(display, surface, surface, context);
            GL.createCapabilities();
            int pname$iv = 7936;
            boolean $i$f$glGetString = false;
            System.out.println((Object)String.valueOf(switch (GLGLESKt.WhenMappings.$EnumSwitchMapping$0[GLGLESKt.getDriverType().ordinal()]) {
                case 1 -> GL45C.glGetString(pname$iv);
                case 2 -> GLES32.glGetString(pname$iv);
                default -> throw new NoWhenBranchMatchedException();
            }));
            pname$iv = 7938;
            $i$f$glGetString = false;
            String pname$iv2 = "opengl version: " + (switch (GLGLESKt.WhenMappings.$EnumSwitchMapping$0[GLGLESKt.getDriverType().ordinal()]) {
                case 1 -> GL45C.glGetString(pname$iv);
                case 2 -> GLES32.glGetString(pname$iv);
                default -> throw new NoWhenBranchMatchedException();
            });
            System.out.println((Object)pname$iv2);
            int[] arrays$iv = this.vaos;
            boolean $i$f$glGenVertexArrays = false;
            switch (GLGLESKt.WhenMappings.$EnumSwitchMapping$0[GLGLESKt.getDriverType().ordinal()]) {
                case 1: {
                    GL45C.glGenVertexArrays(arrays$iv);
                    break;
                }
                case 2: {
                    GLES32.glGenVertexArrays(arrays$iv);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            int array$iv = this.vaos[0];
            boolean $i$f$glBindVertexArray = false;
            switch (GLGLESKt.WhenMappings.$EnumSwitchMapping$0[GLGLESKt.getDriverType().ordinal()]) {
                case 1: {
                    GL45C.glBindVertexArray(array$iv);
                    break;
                }
                case 2: {
                    GLES32.glBindVertexArray(array$iv);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            this.startTime = System.currentTimeMillis();
            Animatable.Companion.clock(new Clock(this){
                final /* synthetic */ ApplicationEGLGL3 this$0;
                {
                    this.this$0 = $receiver;
                }

                public long getTime() {
                    return (long)(this.this$0.getProgram().getSeconds() * 1000.0);
                }

                public long getTimeNanos() {
                    return (long)(this.this$0.getProgram().getSeconds() * 1000000.0);
                }
            });
            ProgramRenderTargetGL3 defaultRenderTarget = new ProgramRenderTargetGL3(this.getProgram());
            defaultRenderTarget.bind();
            Application.Companion.setupPreload(this.getProgram(), this.getConfiguration());
            this.getProgram().setDrawer(new Drawer(this.driver));
            BuildersKt.runBlocking$default(null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                int label;
                final /* synthetic */ ApplicationEGLGL3 this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Object invokeSuspend(Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure(object);
                            this.label = 1;
                            Object object3 = this.this$0.getProgram().setup(this);
                            if (object3 != object2) return Unit.INSTANCE;
                            return object2;
                        }
                        case 1: {
                            void $result;
                            ResultKt.throwOnFailure($result);
                            Object object3 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                    return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }, 1, null);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally(autoCloseable, throwable);
        }
        return Unit.INSTANCE;
    }

    @Override
    public void loop() {
        RenderTarget defaultRenderTarget = RenderTargetKt.renderTarget$default(this.getConfiguration().getWidth(), this.getConfiguration().getHeight(), 0.0, null, null, ApplicationEGLGL3::loop$lambda$1, 28, null);
        defaultRenderTarget.bind();
        while (!this.exitRequested) {
            int array$iv = this.vaos[0];
            boolean $i$f$glBindVertexArray = false;
            switch (GLGLESKt.WhenMappings.$EnumSwitchMapping$0[GLGLESKt.getDriverType().ordinal()]) {
                case 1: {
                    GL45C.glBindVertexArray(array$iv);
                    break;
                }
                case 2: {
                    GLES32.glBindVertexArray(array$iv);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            this.getProgram().getDrawer().reset();
            this.getProgram().getDrawer().ortho();
            this.getProgram().drawImpl();
        }
        for (Extension extension : this.getProgram().getExtensions()) {
            extension.shutdown(this.getProgram());
        }
        this.getProgram().getEnded().trigger(new ProgramEvent(ProgramEventType.ENDED));
    }

    @Override
    @Nullable
    public String getClipboardContents() {
        return "";
    }

    @Override
    public void setClipboardContents(@Nullable String value2) {
    }

    @Override
    @NotNull
    public String getWindowTitle() {
        return "";
    }

    @Override
    public void setWindowTitle(@NotNull String value2) {
        Intrinsics.checkNotNullParameter(value2, "value");
    }

    @Override
    @NotNull
    public Vector2 getWindowPosition() {
        return Vector2.Companion.getZERO();
    }

    @Override
    public void setWindowPosition(@NotNull Vector2 value2) {
        Intrinsics.checkNotNullParameter(value2, "value");
    }

    @Override
    @NotNull
    public Vector2 getWindowSize() {
        return new Vector2(this.getConfiguration().getWidth(), this.getConfiguration().getHeight());
    }

    @Override
    public void setWindowSize(@NotNull Vector2 value2) {
        Intrinsics.checkNotNullParameter(value2, "value");
    }

    @Override
    @NotNull
    public WindowMultisample getWindowMultisample() {
        return WindowMultisample.Disabled.INSTANCE;
    }

    @Override
    public void setWindowMultisample(@NotNull WindowMultisample value2) {
        Intrinsics.checkNotNullParameter(value2, "value");
        ApplicationEGLGL3Kt.access$getLogger$p().warn(ApplicationEGLGL3::_set_windowMultisample_$lambda$2);
    }

    @Override
    public boolean getWindowResizable() {
        return false;
    }

    @Override
    public void setWindowResizable(boolean value2) {
        if (value2) {
            ApplicationEGLGL3Kt.access$getLogger$p().warn(ApplicationEGLGL3::_set_windowResizable_$lambda$3);
        }
    }

    @Override
    public double getSeconds() {
        return (double)(System.currentTimeMillis() - this.startTime) / 1000.0;
    }

    @Override
    @NotNull
    public PresentationMode getPresentationMode() {
        return PresentationMode.AUTOMATIC;
    }

    @Override
    public void setPresentationMode(@NotNull PresentationMode value2) {
        Intrinsics.checkNotNullParameter((Object)value2, "value");
    }

    @Override
    public double getWindowContentScale() {
        return 1.0;
    }

    @Override
    public void setWindowContentScale(double value2) {
    }

    @Override
    @NotNull
    public ApplicationWindow createChildWindow(@NotNull WindowConfiguration configuration, @NotNull Program program2) {
        Intrinsics.checkNotNullParameter(configuration, "configuration");
        Intrinsics.checkNotNullParameter(program2, "program");
        String string = "Not yet implemented";
        throw new NotImplementedError("An operation is not implemented: " + string);
    }

    private static final Unit loop$lambda$1(RenderTargetBuilder $this$renderTarget) {
        Intrinsics.checkNotNullParameter($this$renderTarget, "$this$renderTarget");
        RenderTargetBuilder.colorBuffer$default($this$renderTarget, null, null, 3, null);
        RenderTargetBuilder.depthBuffer$default($this$renderTarget, null, 1, null);
        return Unit.INSTANCE;
    }

    private static final Object _set_windowMultisample_$lambda$2() {
        return "Setting window multisampling is not supported";
    }

    private static final Object _set_windowResizable_$lambda$3() {
        return "Resizable windows are not supported";
    }
}

