/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.internal.gl3;

import java.io.File;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.PointerBuffer;
import org.lwjgl.glfw.Callbacks;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWErrorCallback;
import org.lwjgl.glfw.GLFWImage;
import org.lwjgl.glfw.GLFWVidMode;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL45C;
import org.lwjgl.opengl.GLUtil;
import org.lwjgl.opengles.GLES;
import org.lwjgl.opengles.GLES32;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.MemoryStack;
import org.openrndr.Application;
import org.openrndr.ApplicationWindow;
import org.openrndr.CharacterEvent;
import org.openrndr.Configuration;
import org.openrndr.CursorType;
import org.openrndr.Display;
import org.openrndr.DropEvent;
import org.openrndr.Extension;
import org.openrndr.Fullscreen;
import org.openrndr.KeyEvent;
import org.openrndr.KeyEventType;
import org.openrndr.KeyModifier;
import org.openrndr.MouseButton;
import org.openrndr.MouseCursorHideMode;
import org.openrndr.MouseEvent;
import org.openrndr.MouseEventType;
import org.openrndr.Pointer;
import org.openrndr.PresentationMode;
import org.openrndr.Program;
import org.openrndr.ProgramEvent;
import org.openrndr.ProgramEventType;
import org.openrndr.UnfocusBehaviour;
import org.openrndr.WindowConfiguration;
import org.openrndr.WindowEvent;
import org.openrndr.WindowEventType;
import org.openrndr.WindowMultisample;
import org.openrndr.WindowProgram;
import org.openrndr.animatable.Animatable;
import org.openrndr.animatable.Clock;
import org.openrndr.draw.Drawer;
import org.openrndr.draw.RenderTarget;
import org.openrndr.draw.Session;
import org.openrndr.events.Event;
import org.openrndr.internal.Driver;
import org.openrndr.internal.gl3.ApplicationGLFWGL3Kt;
import org.openrndr.internal.gl3.ApplicationGlfwConfiguration;
import org.openrndr.internal.gl3.ApplicationWindowGLFW;
import org.openrndr.internal.gl3.ApplicationWindowGLFWKt;
import org.openrndr.internal.gl3.DisplayGLFWGL3;
import org.openrndr.internal.gl3.DriverGL3;
import org.openrndr.internal.gl3.DriverGL3Configuration;
import org.openrndr.internal.gl3.DriverGL3Kt;
import org.openrndr.internal.gl3.DriverTypeGL;
import org.openrndr.internal.gl3.DriverVersionGL;
import org.openrndr.internal.gl3.GLGLESKt;
import org.openrndr.internal.gl3.GlesBackend;
import org.openrndr.internal.gl3.PointerInputManager;
import org.openrndr.internal.gl3.PointerInputManagerWin32;
import org.openrndr.internal.gl3.ProgramRenderTargetGL3;
import org.openrndr.math.IntVector2;
import org.openrndr.math.Vector2;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00a6\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u001e\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0003\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010n\u001a\u00020oH\u0096@\u00a2\u0006\u0002\u0010pJ\u0018\u0010q\u001a\u00020r2\u0006\u0010\u0004\u001a\u00020s2\u0006\u0010\u0002\u001a\u00020\u0003H\u0016J\b\u0010t\u001a\u00020oH\u0002J\u0006\u0010|\u001a\u00020oJ\b\u0010~\u001a\u00020oH\u0016J\u0014\u0010\u007f\u001a\u00020o2\f\b\u0002\u0010\u0080\u0001\u001a\u0005\u0018\u00010\u0081\u0001J\t\u0010\u0082\u0001\u001a\u00020oH\u0002J\f\u0010\u0083\u0001\u001a\u0005\u0018\u00010\u0081\u0001H\u0002J\t\u0010\u0084\u0001\u001a\u00020oH\u0002J\t\u0010\u0085\u0001\u001a\u00020oH\u0016J\t\u0010\u0086\u0001\u001a\u00020oH\u0016J\t\u0010\u0087\u0001\u001a\u00020oH\u0016R\u001a\u0010\u0002\u001a\u00020\u0003X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\u0004\u001a\u00020\u0005X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010 \u001a\u00020!X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%R$\u0010(\u001a\u00020'2\u0006\u0010&\u001a\u00020'8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b)\u0010*\"\u0004\b+\u0010,R\u000e\u0010-\u001a\u00020.X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010/\u001a\u000200X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u00102\u001a\u00020.2\u0006\u00101\u001a\u00020.8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b3\u00104\"\u0004\b5\u00106R$\u00107\u001a\u00020\u00182\u0006\u00101\u001a\u00020\u0018@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b8\u00109\"\u0004\b:\u0010;R$\u0010=\u001a\u00020<2\u0006\u00101\u001a\u00020<@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b>\u0010?\"\u0004\b@\u0010AR'\u0010B\u001a\u000e\u0012\u0004\u0012\u00020D\u0012\u0004\u0012\u00020\u001a0C8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\bG\u0010H\u001a\u0004\bE\u0010FR$\u0010I\u001a\u00020D2\u0006\u00101\u001a\u00020D@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bJ\u0010K\"\u0004\bL\u0010MR \u0010N\u001a\b\u0012\u0004\u0012\u00020P0OX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bQ\u0010R\"\u0004\bS\u0010TR\u0010\u0010U\u001a\u0004\u0018\u00010.X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010V\u001a\u00020.2\u0006\u00101\u001a\u00020.8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\bW\u00104\"\u0004\bX\u00106R$\u0010Y\u001a\u00020.2\u0006\u00101\u001a\u00020.8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\bZ\u00104\"\u0004\b[\u00106R$\u0010\\\u001a\u00020\u00182\u0006\u00101\u001a\u00020\u00188V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b]\u00109\"\u0004\b^\u0010;R$\u0010_\u001a\u0002002\u0006\u0010&\u001a\u0002008V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b`\u0010a\"\u0004\bb\u0010cR(\u0010d\u001a\u0004\u0018\u00010\u001c2\b\u00101\u001a\u0004\u0018\u00010\u001c8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\be\u0010f\"\u0004\bg\u0010hR\u0014\u0010i\u001a\u00020'8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bj\u0010*R$\u0010k\u001a\u00020\u001c2\u0006\u00101\u001a\u00020\u001c8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\bl\u0010f\"\u0004\bm\u0010hR\u000e\u0010u\u001a\u00020vX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010w\u001a\u00020x8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b{\u0010H\u001a\u0004\by\u0010zR\u000e\u0010}\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0088\u0001"}, d2={"Lorg/openrndr/internal/gl3/ApplicationGLFWGL3;", "Lorg/openrndr/Application;", "program", "Lorg/openrndr/Program;", "configuration", "Lorg/openrndr/Configuration;", "<init>", "(Lorg/openrndr/Program;Lorg/openrndr/Configuration;)V", "getProgram", "()Lorg/openrndr/Program;", "setProgram", "(Lorg/openrndr/Program;)V", "getConfiguration", "()Lorg/openrndr/Configuration;", "setConfiguration", "(Lorg/openrndr/Configuration;)V", "windows", "Ljava/util/concurrent/CopyOnWriteArrayList;", "Lorg/openrndr/internal/gl3/ApplicationWindowGLFW;", "getWindows$openrndr_gl3", "()Ljava/util/concurrent/CopyOnWriteArrayList;", "pointerInput", "Lorg/openrndr/internal/gl3/PointerInputManager;", "windowFocused", "", "window", "", "realWindowTitle", "", "exitRequested", "exitHandled", "setupCalled", "presentationMode", "Lorg/openrndr/PresentationMode;", "getPresentationMode", "()Lorg/openrndr/PresentationMode;", "setPresentationMode", "(Lorg/openrndr/PresentationMode;)V", "_", "", "windowContentScale", "getWindowContentScale", "()D", "setWindowContentScale", "(D)V", "realCursorPosition", "Lorg/openrndr/math/Vector2;", "requestedMultisample", "Lorg/openrndr/WindowMultisample;", "value", "cursorPosition", "getCursorPosition", "()Lorg/openrndr/math/Vector2;", "setCursorPosition", "(Lorg/openrndr/math/Vector2;)V", "cursorVisible", "getCursorVisible", "()Z", "setCursorVisible", "(Z)V", "Lorg/openrndr/MouseCursorHideMode;", "cursorHideMode", "getCursorHideMode", "()Lorg/openrndr/MouseCursorHideMode;", "setCursorHideMode", "(Lorg/openrndr/MouseCursorHideMode;)V", "cursorCache", "", "Lorg/openrndr/CursorType;", "getCursorCache", "()Ljava/util/Map;", "cursorCache$delegate", "Lkotlin/Lazy;", "cursorType", "getCursorType", "()Lorg/openrndr/CursorType;", "setCursorType", "(Lorg/openrndr/CursorType;)V", "pointers", "", "Lorg/openrndr/Pointer;", "getPointers", "()Ljava/util/List;", "setPointers", "(Ljava/util/List;)V", "_windowSize", "windowSize", "getWindowSize", "setWindowSize", "windowPosition", "getWindowPosition", "setWindowPosition", "windowResizable", "getWindowResizable", "setWindowResizable", "windowMultisample", "getWindowMultisample", "()Lorg/openrndr/WindowMultisample;", "setWindowMultisample", "(Lorg/openrndr/WindowMultisample;)V", "clipboardContents", "getClipboardContents", "()Ljava/lang/String;", "setClipboardContents", "(Ljava/lang/String;)V", "seconds", "getSeconds", "windowTitle", "getWindowTitle", "setWindowTitle", "setup", "", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "createChildWindow", "Lorg/openrndr/ApplicationWindow;", "Lorg/openrndr/WindowConfiguration;", "createPrimaryWindow", "vaos", "", "defaultRenderTarget", "Lorg/openrndr/internal/gl3/ProgramRenderTargetGL3;", "getDefaultRenderTarget", "()Lorg/openrndr/internal/gl3/ProgramRenderTargetGL3;", "defaultRenderTarget$delegate", "preloop", "drawRequested", "loop", "postloop", "exception", "", "deliverEvents", "drawFrame", "setupSizes", "exit", "requestDraw", "requestFocus", "openrndr-gl3"})
@SourceDebugExtension(value={"SMAP\nApplicationGLFWGL3.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ApplicationGLFWGL3.kt\norg/openrndr/internal/gl3/ApplicationGLFWGL3\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 GLGLES.kt\norg/openrndr/internal/gl3/GLGLESKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,1120:1\n381#2,7:1121\n18#3,3:1128\n117#3,3:1131\n130#3,3:1134\n139#3,3:1137\n130#3,3:1140\n139#3,3:1143\n117#3,3:1146\n197#3,3:1149\n109#3,3:1152\n68#3,3:1163\n68#3,3:1166\n68#3,3:1169\n1557#4:1155\n1628#4,3:1156\n1557#4:1159\n1628#4,3:1160\n*S KotlinDebug\n*F\n+ 1 ApplicationGLFWGL3.kt\norg/openrndr/internal/gl3/ApplicationGLFWGL3\n*L\n104#1:1121,7\n651#1:1128,3\n912#1:1131,3\n913#1:1134,3\n914#1:1137,3\n920#1:1140,3\n921#1:1143,3\n922#1:1146,3\n1076#1:1149,3\n1103#1:1152,3\n929#1:1163,3\n930#1:1166,3\n931#1:1169,3\n772#1:1155\n772#1:1156,3\n775#1:1159\n775#1:1160,3\n*E\n"})
public final class ApplicationGLFWGL3
extends Application {
    @NotNull
    private Program program;
    @NotNull
    private Configuration configuration;
    @NotNull
    private final CopyOnWriteArrayList<ApplicationWindowGLFW> windows;
    @Nullable
    private PointerInputManager pointerInput;
    private boolean windowFocused;
    private long window;
    @NotNull
    private String realWindowTitle;
    private boolean exitRequested;
    private boolean exitHandled;
    private boolean setupCalled;
    @NotNull
    private PresentationMode presentationMode;
    @NotNull
    private Vector2 realCursorPosition;
    @NotNull
    private WindowMultisample requestedMultisample;
    private boolean cursorVisible;
    @NotNull
    private MouseCursorHideMode cursorHideMode;
    @NotNull
    private final Lazy cursorCache$delegate;
    @NotNull
    private CursorType cursorType;
    @NotNull
    private List<Pointer> pointers;
    @Nullable
    private Vector2 _windowSize;
    @NotNull
    private final int[] vaos;
    @NotNull
    private final Lazy defaultRenderTarget$delegate;
    private boolean drawRequested;

    public ApplicationGLFWGL3(@NotNull Program program2, @NotNull Configuration configuration) {
        Intrinsics.checkNotNullParameter(program2, "program");
        Intrinsics.checkNotNullParameter(configuration, "configuration");
        this.program = program2;
        this.configuration = configuration;
        this.windows = new CopyOnWriteArrayList();
        this.windowFocused = true;
        this.realWindowTitle = this.getConfiguration().getTitle();
        this.presentationMode = PresentationMode.AUTOMATIC;
        this.realCursorPosition = new Vector2(0.0, 0.0);
        this.requestedMultisample = this.getConfiguration().getMultisample();
        this.cursorVisible = true;
        this.cursorHideMode = MouseCursorHideMode.HIDE;
        this.cursorCache$delegate = LazyKt.lazy(ApplicationGLFWGL3::cursorCache_delegate$lambda$0);
        this.cursorType = CursorType.ARROW_CURSOR;
        this.pointers = new ArrayList();
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                ApplicationGLFWGL3Kt.access$getLogger$p().debug(1::run$lambda$0);
                exitRequested = true;
                long start = System.currentTimeMillis();
                while (!exitHandled && System.currentTimeMillis() - start < 2000L) {
                    Thread.sleep(10L);
                }
            }

            private static final Object run$lambda$0() {
                return "Program interrupted";
            }
        });
        ApplicationGLFWGL3Kt.access$getLogger$p().debug(ApplicationGLFWGL3::_init_$lambda$4);
        ApplicationGLFWGL3Kt.access$getLogger$p().trace(ApplicationGLFWGL3::_init_$lambda$5);
        this.createPrimaryWindow();
        this.getProgram().setApplication(this);
        this.vaos = new int[1];
        this.defaultRenderTarget$delegate = LazyKt.lazy(() -> ApplicationGLFWGL3.defaultRenderTarget_delegate$lambda$35(this));
        this.drawRequested = true;
    }

    @Override
    @NotNull
    public Program getProgram() {
        return this.program;
    }

    @Override
    public void setProgram(@NotNull Program program2) {
        Intrinsics.checkNotNullParameter(program2, "<set-?>");
        this.program = program2;
    }

    @Override
    @NotNull
    public Configuration getConfiguration() {
        return this.configuration;
    }

    @Override
    public void setConfiguration(@NotNull Configuration configuration) {
        Intrinsics.checkNotNullParameter(configuration, "<set-?>");
        this.configuration = configuration;
    }

    @NotNull
    public final CopyOnWriteArrayList<ApplicationWindowGLFW> getWindows$openrndr_gl3() {
        return this.windows;
    }

    @Override
    @NotNull
    public PresentationMode getPresentationMode() {
        return this.presentationMode;
    }

    @Override
    public void setPresentationMode(@NotNull PresentationMode presentationMode) {
        Intrinsics.checkNotNullParameter((Object)presentationMode, "<set-?>");
        this.presentationMode = presentationMode;
    }

    @Override
    public double getWindowContentScale() {
        float[] wcsx = new float[1];
        float[] wcsy = new float[1];
        GLFW.glfwGetWindowContentScale(this.window, wcsx, wcsy);
        return wcsx[0];
    }

    @Override
    public void setWindowContentScale(double d) {
    }

    @Override
    @NotNull
    public Vector2 getCursorPosition() {
        return this.realCursorPosition;
    }

    @Override
    public void setCursorPosition(@NotNull Vector2 value2) {
        Intrinsics.checkNotNullParameter(value2, "value");
        this.realCursorPosition = value2;
        GLFW.glfwSetCursorPos(this.window, value2.x(), value2.y());
    }

    @Override
    public boolean getCursorVisible() {
        return this.cursorVisible;
    }

    @Override
    public void setCursorVisible(boolean value2) {
        this.cursorVisible = value2;
        if (value2) {
            GLFW.glfwSetInputMode(this.window, 208897, 212993);
        } else {
            switch (WhenMappings.$EnumSwitchMapping$0[this.getCursorHideMode().ordinal()]) {
                case 1: {
                    GLFW.glfwSetInputMode(this.window, 208897, 212994);
                    break;
                }
                case 2: {
                    GLFW.glfwSetInputMode(this.window, 208897, 212995);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }
    }

    @Override
    @NotNull
    public MouseCursorHideMode getCursorHideMode() {
        return this.cursorHideMode;
    }

    @Override
    public void setCursorHideMode(@NotNull MouseCursorHideMode value2) {
        Intrinsics.checkNotNullParameter((Object)value2, "value");
        this.cursorHideMode = value2;
        this.setCursorVisible(this.getCursorVisible());
    }

    private final Map<CursorType, Long> getCursorCache() {
        Lazy lazy = this.cursorCache$delegate;
        return (Map)lazy.getValue();
    }

    @Override
    @NotNull
    public CursorType getCursorType() {
        return this.cursorType;
    }

    @Override
    public void setCursorType(@NotNull CursorType value2) {
        Intrinsics.checkNotNullParameter((Object)value2, "value");
        if (value2 != this.cursorType) {
            Long l;
            Map<CursorType, Long> $this$getOrPut$iv = this.getCursorCache();
            boolean $i$f$getOrPut = false;
            Long value$iv = $this$getOrPut$iv.get((Object)value2);
            if (value$iv == null) {
                boolean bl = false;
                int glfwCursor = switch (WhenMappings.$EnumSwitchMapping$1[value2.ordinal()]) {
                    case 1 -> 221185;
                    case 2 -> 221186;
                    case 3 -> 221188;
                    case 4 -> 221187;
                    case 5 -> 221189;
                    case 6 -> 221190;
                    default -> throw new NoWhenBranchMatchedException();
                };
                Long answer$iv = GLFW.glfwCreateStandardCursor(glfwCursor);
                $this$getOrPut$iv.put(value2, answer$iv);
                l = answer$iv;
            } else {
                l = value$iv;
            }
            long cursor = ((Number)l).longValue();
            GLFW.glfwSetCursor(this.window, cursor);
            this.cursorType = value2;
        }
    }

    @Override
    @NotNull
    public List<Pointer> getPointers() {
        return this.pointers;
    }

    public void setPointers(@NotNull List<Pointer> list) {
        Intrinsics.checkNotNullParameter(list, "<set-?>");
        this.pointers = list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Vector2 getWindowSize() {
        if (this._windowSize == null) {
            AutoCloseable autoCloseable = MemoryStack.stackPush();
            Throwable throwable = null;
            try {
                MemoryStack it = (MemoryStack)autoCloseable;
                boolean bl = false;
                IntBuffer w = it.mallocInt(1);
                IntBuffer h = it.mallocInt(1);
                GLFW.glfwGetWindowSize(this.window, w, h);
                this._windowSize = new Vector2(ApplicationGlfwConfiguration.INSTANCE.getFixWindowSize() ? (double)w.get(0) / this.getProgram().getWindow().getContentScale() : (double)w.get(0), ApplicationGlfwConfiguration.INSTANCE.getFixWindowSize() ? (double)h.get(0) / this.getProgram().getWindow().getContentScale() : (double)h.get(0));
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally(autoCloseable, throwable);
            }
        }
        Vector2 vector2 = this._windowSize;
        if (vector2 == null) {
            throw new IllegalStateException("window size unknown".toString());
        }
        return vector2;
    }

    @Override
    public void setWindowSize(@NotNull Vector2 value2) {
        Intrinsics.checkNotNullParameter(value2, "value");
        GLFW.glfwSetWindowSize(this.window, ApplicationGlfwConfiguration.INSTANCE.getFixWindowSize() ? (int)(value2.x() * this.getProgram().getWindow().getContentScale()) : (int)value2.x(), ApplicationGlfwConfiguration.INSTANCE.getFixWindowSize() ? (int)(value2.y() * this.getProgram().getWindow().getContentScale()) : (int)value2.y());
        this._windowSize = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Vector2 getWindowPosition() {
        AutoCloseable autoCloseable = MemoryStack.stackPush();
        Throwable throwable = null;
        try {
            MemoryStack it = (MemoryStack)autoCloseable;
            boolean bl = false;
            IntBuffer x = it.mallocInt(1);
            IntBuffer y = it.mallocInt(1);
            GLFW.glfwGetWindowPos(this.window, x, y);
            Vector2 vector2 = new Vector2(ApplicationGlfwConfiguration.INSTANCE.getFixWindowSize() ? (double)x.get(0) / this.getProgram().getWindow().getContentScale() : (double)x.get(0), ApplicationGlfwConfiguration.INSTANCE.getFixWindowSize() ? (double)y.get(0) / this.getProgram().getWindow().getContentScale() : (double)y.get(0));
            return vector2;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally(autoCloseable, throwable);
        }
    }

    @Override
    public void setWindowPosition(@NotNull Vector2 value2) {
        Intrinsics.checkNotNullParameter(value2, "value");
        GLFW.glfwSetWindowPos(this.window, ApplicationGlfwConfiguration.INSTANCE.getFixWindowSize() ? (int)(value2.x() * this.getProgram().getWindow().getContentScale()) : (int)value2.x(), ApplicationGlfwConfiguration.INSTANCE.getFixWindowSize() ? (int)(value2.y() * this.getProgram().getWindow().getContentScale()) : (int)value2.y());
    }

    @Override
    public boolean getWindowResizable() {
        int attrib = GLFW.glfwGetWindowAttrib(this.window, 131075);
        return attrib != 0;
    }

    @Override
    public void setWindowResizable(boolean value2) {
        GLFW.glfwSetWindowAttrib(this.window, 131075, value2 ? 1 : 0);
    }

    @Override
    @NotNull
    public WindowMultisample getWindowMultisample() {
        return this.requestedMultisample;
    }

    @Override
    public void setWindowMultisample(@NotNull WindowMultisample windowMultisample) {
        Intrinsics.checkNotNullParameter(windowMultisample, "_");
        throw new IllegalStateException("Changing window multisampling is not supported.".toString());
    }

    @Override
    @Nullable
    public String getClipboardContents() {
        String string;
        try {
            String result2 = GLFW.glfwGetClipboardString(this.window);
        }
        catch (Exception e) {
            string = "";
        }
        return string;
    }

    @Override
    public void setClipboardContents(@Nullable String value2) {
        if (value2 == null) {
            throw new RuntimeException("clipboard contents can't be null");
        }
        GLFW.glfwSetClipboardString(this.window, value2);
    }

    @Override
    public double getSeconds() {
        return GLFW.glfwGetTime();
    }

    @Override
    @NotNull
    public String getWindowTitle() {
        return this.realWindowTitle;
    }

    @Override
    public void setWindowTitle(@NotNull String value2) {
        Intrinsics.checkNotNullParameter(value2, "value");
        GLFW.glfwSetWindowTitle(this.window, value2);
        this.realWindowTitle = value2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public Object setup(@NotNull Continuation<? super Unit> $completion) {
        Object object;
        Display display;
        GLFW.glfwDefaultWindowHints();
        switch (WhenMappings.$EnumSwitchMapping$2[DriverGL3Configuration.INSTANCE.getDriverType().ordinal()]) {
            case 1: {
                GLFW.glfwWindowHint(139270, 1);
                GLFW.glfwWindowHint(139272, 204801);
                break;
            }
            case 2: {
                boolean useAngle;
                boolean bl = useAngle = DriverGL3Configuration.INSTANCE.getGlesBackend() == GlesBackend.ANGLE;
                if (useAngle) {
                    GLFW.glfwWindowHint(327682, 225288);
                }
                GLFW.glfwWindowHint(139265, 196610);
                GLFW.glfwWindowHint(139275, 221186);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        GLFW.glfwWindowHint(131076, 0);
        GLFW.glfwWindowHint(131078, 0);
        GLFW.glfwWindowHint(131075, this.getConfiguration().getWindowResizable() ? 1 : 0);
        GLFW.glfwWindowHint(131077, this.getConfiguration().getHideWindowDecorations() ? 0 : 1);
        WindowMultisample c2 = this.getConfiguration().getMultisample();
        if (c2 instanceof WindowMultisample.SampleCount) {
            GLFW.glfwWindowHint(135181, ((WindowMultisample.SampleCount)c2).getCount());
        } else if (Intrinsics.areEqual(c2, WindowMultisample.SystemDefault.INSTANCE)) {
            GLFW.glfwWindowHint(135181, -1);
        } else if (Intrinsics.areEqual(c2, WindowMultisample.Disabled.INSTANCE)) {
            GLFW.glfwWindowHint(135181, 0);
        } else {
            throw new IllegalStateException(("unsupported value " + c2).toString());
        }
        GLFW.glfwWindowHint(135169, 8);
        GLFW.glfwWindowHint(135170, 8);
        GLFW.glfwWindowHint(135171, 8);
        GLFW.glfwWindowHint(135174, 8);
        GLFW.glfwWindowHint(135173, 24);
        if (this.getConfiguration().getWindowAlwaysOnTop()) {
            GLFW.glfwWindowHint(131079, 1);
        }
        ApplicationGLFWGL3Kt.access$getLogger$p().info(ApplicationGLFWGL3::setup$lambda$6);
        if (DriverGL3Configuration.INSTANCE.getUseDebugContext()) {
            GLFW.glfwWindowHint(139271, 1);
        }
        DisplayGLFWGL3 displayGLFWGL3 = (display = this.getConfiguration().getDisplay()) instanceof DisplayGLFWGL3 ? (DisplayGLFWGL3)display : null;
        long display2 = displayGLFWGL3 != null ? displayGLFWGL3.getPointer() : GLFW.glfwGetPrimaryMonitor();
        float[] xscale = new float[1];
        ApplicationGLFWGL3 $this$setup_u24lambda_u249 = this;
        boolean bl = false;
        float[] yscale = new float[1];
        GLFW.glfwGetMonitorContentScale(display2, xscale, yscale);
        ApplicationGLFWGL3Kt.access$getLogger$p().debug(() -> ApplicationGLFWGL3.setup$lambda$9$lambda$7(xscale, yscale));
        if (!(xscale[0] == yscale[0])) {
            ApplicationGLFWGL3Kt.access$getLogger$p().debug(() -> ApplicationGLFWGL3.setup$lambda$9$lambda$8(xscale, yscale));
        }
        if (this.getConfiguration().getFullscreen() == Fullscreen.SET_DISPLAY_MODE) {
            xscale[0] = 1.0f;
        }
        this.getProgram().getWindow().setContentScale(xscale[0]);
        ApplicationGLFWGL3Kt.access$getLogger$p().debug(ApplicationGLFWGL3::setup$lambda$10);
        if (this.getConfiguration().getWindowTransparent()) {
            GLFW.glfwWindowHint(131082, 1);
        }
        List versions = DriverGL3.Companion.candidateVersions$default(DriverGL3.Companion, null, 1, null);
        for (int versionIndex = 0; this.window == 0L && versionIndex < versions.size(); ++versionIndex) {
            long l;
            GLFW.glfwWindowHint(139266, ((DriverVersionGL)((Object)versions.get(versionIndex))).getMajorVersion());
            GLFW.glfwWindowHint(139267, ((DriverVersionGL)((Object)versions.get(versionIndex))).getMinorVersion());
            if (this.getConfiguration().getFullscreen() == Fullscreen.DISABLED) {
                float[] primaryDisplayScale = new float[1];
                GLFW.glfwGetMonitorContentScale(GLFW.glfwGetPrimaryMonitor(), primaryDisplayScale, null);
                ApplicationGLFWGL3Kt.access$getLogger$p().debug(() -> ApplicationGLFWGL3.setup$lambda$11(primaryDisplayScale));
                int adjustedWidth = ApplicationGlfwConfiguration.INSTANCE.getFixWindowSize() ? (int)(primaryDisplayScale[0] * (float)this.getConfiguration().getWidth()) : this.getConfiguration().getWidth();
                int adjustedHeight = ApplicationGlfwConfiguration.INSTANCE.getFixWindowSize() ? (int)(primaryDisplayScale[0] * (float)this.getConfiguration().getHeight()) : this.getConfiguration().getHeight();
                ApplicationGLFWGL3Kt.access$getLogger$p().debug(() -> ApplicationGLFWGL3.setup$lambda$12(adjustedWidth, adjustedHeight));
                l = GLFW.glfwCreateWindow(adjustedWidth, adjustedHeight, this.getConfiguration().getTitle(), 0L, ApplicationGLFWGL3Kt.getPrimaryWindow());
            } else {
                ApplicationGLFWGL3Kt.access$getLogger$p().info(ApplicationGLFWGL3::setup$lambda$13);
                int requestWidth = this.getConfiguration().getWidth();
                int requestHeight = this.getConfiguration().getHeight();
                if (this.getConfiguration().getFullscreen() == Fullscreen.CURRENT_DISPLAY_MODE) {
                    GLFWVidMode mode = GLFW.glfwGetVideoMode(display2);
                    if (mode != null) {
                        requestWidth = mode.width();
                        requestHeight = mode.height();
                    } else {
                        throw new RuntimeException("failed to determine current video mode");
                    }
                }
                l = GLFW.glfwCreateWindow(requestWidth, requestHeight, this.getConfiguration().getTitle(), display2, ApplicationGLFWGL3Kt.getPrimaryWindow());
            }
            this.window = l;
        }
        if (this.window == 0L) {
            throw new IllegalStateException("Window creation failed. " + DriverGL3Configuration.INSTANCE.getDriverType());
        }
        String string = System.getProperty("os.name");
        Intrinsics.checkNotNullExpressionValue(string, "getProperty(...)");
        if (StringsKt.contains((CharSequence)string, "windows", true) && System.getProperty("org.openrndr.pointerevents") != null) {
            ApplicationGLFWGL3Kt.access$getLogger$p().info(ApplicationGLFWGL3::setup$lambda$14);
            this.pointerInput = new PointerInputManagerWin32(this.window, this);
        }
        if (this.getConfiguration().getWindowSetIcon()) {
            ByteBuffer buf = BufferUtils.createByteBuffer(65536);
            Intrinsics.checkNotNull(buf, "null cannot be cast to non-null type java.nio.Buffer");
            ((Buffer)buf).rewind();
            for (int y = 0; y < 128; ++y) {
                for (int x = 0; x < 128; ++x) {
                    buf.putInt(-4142081);
                }
            }
            ((Buffer)buf).flip();
            object = MemoryStack.stackPush();
            Throwable x = null;
            try {
                Object it = (MemoryStack)object;
                boolean bl2 = false;
                GLFW.glfwSetWindowIcon(this.window, GLFWImage.malloc(1, (MemoryStack)it).width(128).height(128).pixels(buf));
                it = Unit.INSTANCE;
            }
            catch (Throwable it) {
                x = it;
                throw it;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)object, x);
            }
        }
        ApplicationGLFWGL3Kt.access$getLogger$p().debug(() -> ApplicationGLFWGL3.setup$lambda$16(this));
        if (Intrinsics.areEqual(System.getenv("DESKTOP_SESSION"), "i3")) {
            ApplicationGLFWGL3Kt.access$getLogger$p().debug(() -> ApplicationGLFWGL3.setup$lambda$17(this));
            GLFW.glfwShowWindow(this.window);
        }
        AutoCloseable buf = MemoryStack.stackPush();
        object = null;
        try {
            Unit unit;
            Object stack = (MemoryStack)buf;
            boolean bl3 = false;
            IntBuffer px = ((MemoryStack)stack).mallocInt(1);
            IntBuffer py = ((MemoryStack)stack).mallocInt(1);
            GLFW.glfwGetMonitorPos(display2, px, py);
            GLFW.glfwSetWindowPos(this.window, px.get(0), py.get(0));
            IntBuffer pWidth = ((MemoryStack)stack).mallocInt(1);
            IntBuffer pHeight = ((MemoryStack)stack).mallocInt(1);
            GLFW.glfwGetWindowSize(this.window, pWidth, pHeight);
            GLFWVidMode vidmode = GLFW.glfwGetVideoMode(display2);
            if (this.getConfiguration().getPosition() == null) {
                if (vidmode != null) {
                    GLFW.glfwSetWindowPos(this.window, px.get(0) + (vidmode.width() - pWidth.get(0)) / 2, py.get(0) + (vidmode.height() - pHeight.get(0)) / 2);
                }
                unit = Unit.INSTANCE;
            } else {
                IntVector2 intVector2 = this.getConfiguration().getPosition();
                if (intVector2 != null) {
                    IntVector2 it = intVector2;
                    boolean bl4 = false;
                    GLFW.glfwSetWindowPos(this.window, px.get(0) + it.x(), py.get(0) + it.y());
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
            }
            stack = unit;
        }
        catch (Throwable stack) {
            object = stack;
            throw stack;
        }
        finally {
            AutoCloseableKt.closeFinally(buf, (Throwable)object);
        }
        ApplicationGLFWGL3Kt.access$getLogger$p().debug(ApplicationGLFWGL3::setup$lambda$20);
        GLFW.glfwMakeContextCurrent(this.window);
        if (this.getConfiguration().getVsync()) {
            boolean enableTearControl = false;
            GLFW.glfwSwapInterval(1);
        }
        Ref.IntRef readyFrames = new Ref.IntRef();
        GLFW.glfwSetWindowRefreshCallback(this.window, arg_0 -> ApplicationGLFWGL3.setup$lambda$21(readyFrames, this, arg_0));
        GLFW.glfwSetFramebufferSizeCallback(this.window, (arg_0, arg_1, arg_2) -> ApplicationGLFWGL3.setup$lambda$23(this, readyFrames, arg_0, arg_1, arg_2));
        GLFW.glfwSetWindowPosCallback(this.window, (arg_0, arg_1, arg_2) -> ApplicationGLFWGL3.setup$lambda$25(this, arg_0, arg_1, arg_2));
        GLFW.glfwSetWindowFocusCallback(this.window, (arg_0, arg_1) -> ApplicationGLFWGL3.setup$lambda$27(this, arg_0, arg_1));
        GLFW.glfwSetWindowCloseCallback(this.window, arg_0 -> ApplicationGLFWGL3.setup$lambda$29(this, arg_0));
        ApplicationGLFWGL3Kt.access$getLogger$p().debug(ApplicationGLFWGL3::setup$lambda$30);
        ApplicationGLFWGL3 $this$setup_u24lambda_u2431 = this;
        boolean bl5 = false;
        int adjustedMinimumWidth = ApplicationGlfwConfiguration.INSTANCE.getFixWindowSize() ? (int)(xscale[0] * (float)$this$setup_u24lambda_u2431.getConfiguration().getMinimumWidth()) : $this$setup_u24lambda_u2431.getConfiguration().getMinimumWidth();
        int adjustedMinimumHeight = ApplicationGlfwConfiguration.INSTANCE.getFixWindowSize() ? (int)(xscale[0] * (float)$this$setup_u24lambda_u2431.getConfiguration().getMinimumHeight()) : $this$setup_u24lambda_u2431.getConfiguration().getMinimumHeight();
        int adjustedMaximumWidth = ApplicationGlfwConfiguration.INSTANCE.getFixWindowSize() && $this$setup_u24lambda_u2431.getConfiguration().getMaximumWidth() != Integer.MAX_VALUE ? (int)(xscale[0] * (float)$this$setup_u24lambda_u2431.getConfiguration().getMaximumWidth()) : $this$setup_u24lambda_u2431.getConfiguration().getMaximumWidth();
        int adjustedMaximumHeight = ApplicationGlfwConfiguration.INSTANCE.getFixWindowSize() && $this$setup_u24lambda_u2431.getConfiguration().getMaximumHeight() != Integer.MAX_VALUE ? (int)(xscale[0] * (float)$this$setup_u24lambda_u2431.getConfiguration().getMaximumHeight()) : $this$setup_u24lambda_u2431.getConfiguration().getMaximumHeight();
        GLFW.glfwSetWindowSizeLimits($this$setup_u24lambda_u2431.window, adjustedMinimumWidth, adjustedMinimumHeight, adjustedMaximumWidth, adjustedMaximumHeight);
        Animatable.Companion.clock(new Clock(this){
            final /* synthetic */ ApplicationGLFWGL3 this$0;
            {
                this.this$0 = $receiver;
            }

            public long getTime() {
                return (long)(this.this$0.getProgram().getSeconds() * 1000.0);
            }

            public long getTimeNanos() {
                return (long)(this.this$0.getProgram().getSeconds() * 1000000.0);
            }
        });
        GLFW.glfwShowWindow(this.window);
        GLFW.glfwSwapBuffers(this.window);
        return Unit.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public ApplicationWindow createChildWindow(@NotNull WindowConfiguration configuration, @NotNull Program program2) {
        Intrinsics.checkNotNullParameter(configuration, "configuration");
        Intrinsics.checkNotNullParameter(program2, "program");
        long currentActiveContext = GLFW.glfwGetCurrentContext();
        try {
            ApplicationWindowGLFW window2 = ApplicationWindowGLFWKt.createApplicationWindowGlfw(this, configuration, program2);
            program2.setApplication(this);
            ((WindowProgram)program2).setApplicationWindow(window2);
            ((WindowProgram)program2).setDrawer(this.getProgram().getDrawer());
            window2.setupGlfwEvents(this);
            window2.updateSize$openrndr_gl3();
            BuildersKt.runBlocking$default(null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(program2, null){
                int label;
                final /* synthetic */ Program $program;
                {
                    this.$program = $program;
                    super(2, $completion);
                }

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Object invokeSuspend(Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure(object);
                            this.label = 1;
                            Object object3 = ((WindowProgram)this.$program).setup(this);
                            if (object3 != object2) return Unit.INSTANCE;
                            return object2;
                        }
                        case 1: {
                            void $result;
                            ResultKt.throwOnFailure($result);
                            Object object3 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                    return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }, 1, null);
            CopyOnWriteArrayList<ApplicationWindowGLFW> copyOnWriteArrayList = this.windows;
            synchronized (copyOnWriteArrayList) {
                boolean bl = false;
                boolean bl2 = this.windows.add(window2);
            }
            ApplicationWindow applicationWindow = window2;
            return applicationWindow;
        }
        finally {
            if (currentActiveContext != 0L) {
                GLFW.glfwMakeContextCurrent(currentActiveContext);
            }
        }
    }

    private final void createPrimaryWindow() {
        if (ApplicationGLFWGL3Kt.getPrimaryWindow() == 0L) {
            GLFW.glfwSetErrorCallback(GLFWErrorCallback.create(ApplicationGLFWGL3::createPrimaryWindow$lambda$34));
            if (!GLFW.glfwInit()) {
                throw new IllegalStateException("Unable to initialize GLFW");
            }
            String title = "OPENRNDR primary window";
            List versions = DriverGL3.Companion.candidateVersions$default(DriverGL3.Companion, null, 1, null);
            GLFW.glfwDefaultWindowHints();
            switch (WhenMappings.$EnumSwitchMapping$2[DriverGL3Configuration.INSTANCE.getDriverType().ordinal()]) {
                case 1: {
                    GLFW.glfwWindowHint(139270, 1);
                    GLFW.glfwWindowHint(139272, 204801);
                    break;
                }
                case 2: {
                    boolean useAngle;
                    GLFW.glfwWindowHint(139265, 196610);
                    boolean bl = useAngle = DriverGL3Configuration.INSTANCE.getGlesBackend() == GlesBackend.ANGLE;
                    if (useAngle) {
                        GLFW.glfwWindowHint(327682, 225288);
                    }
                    GLFW.glfwWindowHint(139275, 221186);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            GLFW.glfwWindowHint(139276, 1);
            GLFW.glfwWindowHint(135169, 8);
            GLFW.glfwWindowHint(135170, 8);
            GLFW.glfwWindowHint(135171, 8);
            GLFW.glfwWindowHint(135174, 8);
            GLFW.glfwWindowHint(135173, 24);
            GLFW.glfwWindowHint(131076, 0);
            DriverVersionGL foundVersion = null;
            for (DriverVersionGL version : versions) {
                GLFW.glfwWindowHint(139266, version.getMajorVersion());
                GLFW.glfwWindowHint(139267, version.getMinorVersion());
                ApplicationGLFWGL3Kt.setPrimaryWindow(GLFW.glfwCreateWindow(640, 480, title, 0L, 0L));
                foundVersion = version;
                if (ApplicationGLFWGL3Kt.getPrimaryWindow() == 0L) continue;
                foundVersion = version;
                break;
            }
            if (ApplicationGLFWGL3Kt.getPrimaryWindow() == 0L) {
                throw new IllegalStateException(("primary window could not be created using " + DriverGL3Configuration.INSTANCE.getDriverType() + " context").toString());
            }
            DriverVersionGL driverVersionGL = foundVersion;
            if (driverVersionGL == null) {
                throw new IllegalStateException("no version found".toString());
            }
            Driver.Companion.setDriver(new DriverGL3(driverVersionGL));
        }
    }

    @NotNull
    public final ProgramRenderTargetGL3 getDefaultRenderTarget() {
        Lazy lazy = this.defaultRenderTarget$delegate;
        return (ProgramRenderTargetGL3)lazy.getValue();
    }

    public final void preloop() {
        switch (WhenMappings.$EnumSwitchMapping$2[DriverGL3Kt.getGlType(Driver.Companion).ordinal()]) {
            case 1: {
                Object object = GL.createCapabilities();
                break;
            }
            case 2: {
                Object object = GLES.createCapabilities();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        if (DriverGL3Configuration.INSTANCE.getUseDebugContext() && DriverGL3Kt.getGlType(Driver.Companion) == DriverTypeGL.GL) {
            GLUtil.setupDebugMessageCallback();
            int target$iv = 33346;
            boolean $i$f$glEnable = false;
            switch (GLGLESKt.WhenMappings.$EnumSwitchMapping$0[GLGLESKt.getDriverType().ordinal()]) {
                case 1: {
                    GL45C.glEnable(target$iv);
                    break;
                }
                case 2: {
                    GLES32.glEnable(target$iv);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }
        this.getProgram().setDriver(Driver.Companion.getInstance());
        this.getProgram().setDrawer(new Drawer(Driver.Companion.getInstance()));
        switch (WhenMappings.$EnumSwitchMapping$2[DriverGL3Kt.getGlType(Driver.Companion).ordinal()]) {
            case 1: {
                break;
            }
            case 2: {
                Driver driver = Driver.Companion.getInstance();
                Intrinsics.checkNotNull(driver, "null cannot be cast to non-null type org.openrndr.internal.gl3.DriverGL3");
                FunctionProvider functionProvider = GLES.getFunctionProvider();
                if (functionProvider == null) {
                    throw new IllegalStateException("no function provider".toString());
                }
                ((DriverGL3)driver).setupExtensions(functionProvider);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        this.getDefaultRenderTarget().bind();
        this.setupSizes();
        Application.Companion.setupPreload(this.getProgram(), this.getConfiguration());
        this.getProgram().getDrawer().ortho();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void loop() {
        ApplicationGLFWGL3Kt.access$getLogger$p().debug(ApplicationGLFWGL3::loop$lambda$36);
        this.preloop();
        Ref.ObjectRef lastDragPosition = new Ref.ObjectRef();
        lastDragPosition.element = Vector2.Companion.getZERO();
        Ref.ObjectRef lastMouseButtonDown = new Ref.ObjectRef();
        lastMouseButtonDown.element = MouseButton.NONE;
        Set modifiers = new LinkedHashSet();
        GLFW.glfwSetKeyCallback(this.window, (arg_0, arg_1, arg_2, arg_3, arg_4) -> ApplicationGLFWGL3.loop$lambda$37(modifiers, this, arg_0, arg_1, arg_2, arg_3, arg_4));
        GLFW.glfwSetCharCallback(this.window, (arg_0, arg_1) -> ApplicationGLFWGL3.loop$lambda$38(this, arg_0, arg_1));
        GLFW.glfwSetDropCallback(this.window, (arg_0, arg_1, arg_2) -> ApplicationGLFWGL3.loop$lambda$42(this, arg_0, arg_1, arg_2));
        Ref.BooleanRef down = new Ref.BooleanRef();
        GLFW.glfwSetScrollCallback(this.window, (arg_0, arg_1, arg_2) -> ApplicationGLFWGL3.loop$lambda$43(this, modifiers, arg_0, arg_1, arg_2));
        GLFW.glfwSetWindowIconifyCallback(this.window, (arg_0, arg_1) -> ApplicationGLFWGL3.loop$lambda$44(this, arg_0, arg_1));
        GLFW.glfwSetCursorEnterCallback(this.window, (arg_0, arg_1) -> ApplicationGLFWGL3.loop$lambda$45(this, arg_0, arg_1));
        GLFW.glfwSetMouseButtonCallback(this.window, (arg_0, arg_1, arg_2, arg_3) -> ApplicationGLFWGL3.loop$lambda$46(down, lastDragPosition, this, lastMouseButtonDown, modifiers, arg_0, arg_1, arg_2, arg_3));
        GLFW.glfwSetCursorPosCallback(this.window, (arg_0, arg_1, arg_2) -> ApplicationGLFWGL3.loop$lambda$48(this, modifiers, down, lastDragPosition, lastMouseButtonDown, arg_0, arg_1, arg_2));
        if (this.getConfiguration().getShowBeforeSetup()) {
            float blue$iv;
            ApplicationGLFWGL3Kt.access$getLogger$p().debug(ApplicationGLFWGL3::loop$lambda$49);
            boolean flag$iv22 = true;
            boolean $i$f$glDepthMask22 = false;
            switch (GLGLESKt.WhenMappings.$EnumSwitchMapping$0[GLGLESKt.getDriverType().ordinal()]) {
                case 1: {
                    GL45C.glDepthMask(flag$iv22);
                    break;
                }
                case 2: {
                    GLES32.glDepthMask(flag$iv22);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            float flag$iv22 = 0.0f;
            float $i$f$glDepthMask22 = 0.0f;
            float f = 0.0f;
            float alpha$iv = 0.0f;
            boolean $i$f$glClearColor = false;
            switch (GLGLESKt.WhenMappings.$EnumSwitchMapping$0[GLGLESKt.getDriverType().ordinal()]) {
                case 1: {
                    void green$iv;
                    void red$iv;
                    GL45C.glClearColor((float)red$iv, (float)green$iv, blue$iv, alpha$iv);
                    break;
                }
                case 2: {
                    void green$iv;
                    void red$iv;
                    GLES32.glClearColor((float)red$iv, (float)green$iv, blue$iv, alpha$iv);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            int mask$iv22 = 17664;
            boolean $i$f$glClear22 = false;
            switch (GLGLESKt.WhenMappings.$EnumSwitchMapping$0[GLGLESKt.getDriverType().ordinal()]) {
                case 1: {
                    GL45C.glClear(mask$iv22);
                    break;
                }
                case 2: {
                    GLES32.glClear(mask$iv22);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            GLFW.glfwSwapBuffers(this.window);
            float mask$iv22 = 0.0f;
            float $i$f$glClear22 = 0.0f;
            blue$iv = 0.0f;
            alpha$iv = 0.0f;
            $i$f$glClearColor = false;
            switch (GLGLESKt.WhenMappings.$EnumSwitchMapping$0[GLGLESKt.getDriverType().ordinal()]) {
                case 1: {
                    void green$iv;
                    void red$iv;
                    GL45C.glClearColor((float)red$iv, (float)green$iv, blue$iv, alpha$iv);
                    break;
                }
                case 2: {
                    void green$iv;
                    void red$iv;
                    GLES32.glClearColor((float)red$iv, (float)green$iv, blue$iv, alpha$iv);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            int mask$iv = 17664;
            boolean $i$f$glClear = false;
            switch (GLGLESKt.WhenMappings.$EnumSwitchMapping$0[GLGLESKt.getDriverType().ordinal()]) {
                case 1: {
                    GL45C.glClear(mask$iv);
                    break;
                }
                case 2: {
                    GLES32.glClear(mask$iv);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            boolean flag$iv = false;
            boolean $i$f$glDepthMask = false;
            switch (GLGLESKt.WhenMappings.$EnumSwitchMapping$0[GLGLESKt.getDriverType().ordinal()]) {
                case 1: {
                    GL45C.glDepthMask(flag$iv);
                    break;
                }
                case 2: {
                    GLES32.glDepthMask(flag$iv);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            GLFW.glfwSwapBuffers(this.window);
            PointerInputManager pointerInputManager = this.pointerInput;
            if (pointerInputManager != null) {
                pointerInputManager.pollEvents();
            }
            GLFW.glfwPollEvents();
        }
        ApplicationGLFWGL3Kt.access$getLogger$p().info(ApplicationGLFWGL3::loop$lambda$50);
        ApplicationGLFWGL3Kt.access$getLogger$p().info(ApplicationGLFWGL3::loop$lambda$51);
        ApplicationGLFWGL3Kt.access$getLogger$p().info(ApplicationGLFWGL3::loop$lambda$52);
        if (this.getConfiguration().getHideCursor()) {
            this.setCursorVisible(false);
        }
        this.setCursorHideMode(this.getConfiguration().getCursorHideMode());
        if (this.getConfiguration().getVsync()) {
            if (GLFW.glfwExtensionSupported("GLX_EXT_swap_control_tear") || GLFW.glfwExtensionSupported("WGL_EXT_swap_control_tear")) {
                GLFW.glfwSwapInterval(-1);
            } else {
                GLFW.glfwSwapInterval(1);
            }
        }
        ApplicationGLFWGL3Kt.access$getLogger$p().debug(ApplicationGLFWGL3::loop$lambda$53);
        Throwable setupException = null;
        try {
            BuildersKt.runBlocking$default(null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                int label;
                final /* synthetic */ ApplicationGLFWGL3 this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Object invokeSuspend(Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure(object);
                            this.label = 1;
                            Object object3 = this.this$0.getProgram().setup(this);
                            if (object3 != object2) return Unit.INSTANCE;
                            return object2;
                        }
                        case 1: {
                            void $result;
                            ResultKt.throwOnFailure($result);
                            Object object3 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                    return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }, 1, null);
        }
        catch (Throwable t) {
            setupException = t;
        }
        Throwable throwable = setupException;
        if (throwable != null) {
            Throwable it = throwable;
            boolean bl = false;
            ApplicationGLFWGL3Kt.access$getLogger$p().error(ApplicationGLFWGL3::loop$lambda$55$lambda$54);
            this.postloop(setupException);
        }
        this.setupCalled = true;
        Throwable exception = null;
        while (!this.exitRequested && !GLFW.glfwWindowShouldClose(this.window)) {
            Iterator<ApplicationWindowGLFW> iterator2;
            GLFW.glfwMakeContextCurrent(this.window);
            if (this.getPresentationMode() == PresentationMode.AUTOMATIC || this.drawRequested) {
                this.drawRequested = false;
                exception = this.drawFrame();
                if (exception != null) {
                    ApplicationGLFWGL3Kt.access$getLogger$p().error(ApplicationGLFWGL3::loop$lambda$56);
                    break;
                }
                GLFW.glfwSwapBuffers(this.window);
            }
            if (!this.windowFocused && this.getConfiguration().getUnfocusBehaviour() == UnfocusBehaviour.THROTTLE) {
                Thread.sleep(100L);
            }
            if (this.getPresentationMode() == PresentationMode.AUTOMATIC) {
                PointerInputManager pointerInputManager = this.pointerInput;
                if (pointerInputManager != null) {
                    pointerInputManager.pollEvents();
                }
                GLFW.glfwPollEvents();
            } else {
                Thread.sleep(10L);
                PointerInputManager pointerInputManager = this.pointerInput;
                if (pointerInputManager != null) {
                    pointerInputManager.pollEvents();
                }
                GLFW.glfwPollEvents();
                this.deliverEvents();
                this.getProgram().getDispatcher().execute();
            }
            Intrinsics.checkNotNullExpressionValue(this.windows.iterator(), "iterator(...)");
            while (iterator2.hasNext()) {
                ApplicationWindowGLFW window2 = iterator2.next();
                window2.update();
            }
        }
        ApplicationGLFWGL3Kt.access$getLogger$p().debug(ApplicationGLFWGL3::loop$lambda$57);
        this.postloop(exception);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void postloop(@Nullable Throwable exception) {
        Object window2;
        GLFW.glfwMakeContextCurrent(this.window);
        if (!Intrinsics.areEqual(RenderTarget.Companion.getActive(), this.getDefaultRenderTarget())) {
            this.getDefaultRenderTarget().bindTarget();
        }
        Iterator<ApplicationWindowGLFW> iterator2 = this.windows.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, "iterator(...)");
        Iterator<ApplicationWindowGLFW> iterator3 = iterator2;
        while (iterator3.hasNext()) {
            window2 = iterator3.next();
            ((ApplicationWindowGLFW)window2).destroy();
        }
        ApplicationGLFWGL3Kt.access$getLogger$p().debug(ApplicationGLFWGL3::postloop$lambda$58);
        window2 = this.getProgram().getExtensions();
        synchronized (window2) {
            boolean $i$a$-synchronized-ApplicationGLFWGL3$postloop$32 = false;
            for (Extension extension : this.getProgram().getExtensions()) {
                extension.shutdown(this.getProgram());
            }
            this.getProgram().getExtensions().clear();
            Unit $i$a$-synchronized-ApplicationGLFWGL3$postloop$32 = Unit.INSTANCE;
        }
        ApplicationGLFWGL3Kt.access$getLogger$p().debug(ApplicationGLFWGL3::postloop$lambda$60);
        this.getProgram().getEnded().trigger(new ProgramEvent(ProgramEventType.ENDED));
        if (exception == null) {
            Session.Companion.getRoot().end();
        }
        Driver.Companion.getInstance().destroyContext(Driver.Companion.getInstance().getContextID());
        Callbacks.glfwFreeCallbacks(this.window);
        GLFW.glfwDestroyWindow(this.window);
        this.exitHandled = true;
        ApplicationGLFWGL3Kt.access$getLogger$p().debug(ApplicationGLFWGL3::postloop$lambda$61);
        GLFWErrorCallback gLFWErrorCallback = GLFW.glfwSetErrorCallback(null);
        if (gLFWErrorCallback != null) {
            gLFWErrorCallback.free();
        }
        if (!DriverGL3Configuration.INSTANCE.getSkipGlfwTermination()) {
            GLFW.glfwTerminate();
        }
        ApplicationGLFWGL3Kt.access$getLogger$p().debug(ApplicationGLFWGL3::postloop$lambda$62);
        if (exception != null) {
            Throwable it = exception;
            boolean bl = false;
            ApplicationGLFWGL3Kt.access$getLogger$p().error(() -> ApplicationGLFWGL3.postloop$lambda$64$lambda$63(exception));
            throw it;
        }
    }

    public static /* synthetic */ void postloop$default(ApplicationGLFWGL3 applicationGLFWGL3, Throwable throwable, int n, Object object) {
        if ((n & 1) != 0) {
            throwable = null;
        }
        applicationGLFWGL3.postloop(throwable);
    }

    private final void deliverEvents() {
        this.getProgram().getWindow().getDrop().deliver();
        this.getProgram().getWindow().getSized().deliver();
        this.getProgram().getWindow().getUnfocused().deliver();
        this.getProgram().getWindow().getFocused().deliver();
        this.getProgram().getWindow().getMinimized().deliver();
        this.getProgram().getWindow().getRestored().deliver();
        this.getProgram().getKeyboard().getKeyDown().deliver();
        this.getProgram().getKeyboard().getKeyUp().deliver();
        this.getProgram().getKeyboard().getKeyRepeat().deliver();
        this.getProgram().getKeyboard().getCharacter().deliver();
        this.getProgram().getMouse().getMoved().deliver();
        this.getProgram().getMouse().getScrolled().deliver();
        this.getProgram().getMouse().getButtonDown().deliver();
        this.getProgram().getMouse().getButtonUp().deliver();
        this.getProgram().getMouse().getDragged().deliver();
        this.getProgram().getMouse().getEntered().deliver();
        this.getProgram().getMouse().getExited().deliver();
    }

    private final Throwable drawFrame() {
        this._windowSize = null;
        this.setupSizes();
        this.getDefaultRenderTarget().bindTarget();
        int array$iv = this.vaos[0];
        boolean $i$f$glBindVertexArray = false;
        switch (GLGLESKt.WhenMappings.$EnumSwitchMapping$0[GLGLESKt.getDriverType().ordinal()]) {
            case 1: {
                GL45C.glBindVertexArray(array$iv);
                break;
            }
            case 2: {
                GLES32.glBindVertexArray(array$iv);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        this.getProgram().getDrawer().reset();
        this.getProgram().getDrawer().ortho();
        this.deliverEvents();
        this.getProgram().getDispatcher().execute();
        try {
            ApplicationGLFWGL3Kt.access$getLogger$p().trace(() -> ApplicationGLFWGL3.drawFrame$lambda$65(this));
            this.getProgram().drawImpl();
        }
        catch (Throwable e) {
            ApplicationGLFWGL3Kt.access$getLogger$p().error(() -> ApplicationGLFWGL3.drawFrame$lambda$66(e));
            return e;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void setupSizes() {
        AutoCloseable autoCloseable = MemoryStack.stackPush();
        Throwable throwable = null;
        try {
            MemoryStack stack = (MemoryStack)autoCloseable;
            boolean bl = false;
            FloatBuffer wcsx = stack.mallocFloat(1);
            FloatBuffer wcsy = stack.mallocFloat(1);
            GLFW.glfwGetWindowContentScale(this.window, wcsx, wcsy);
            this.getProgram().getWindow().setContentScale(wcsx.get(0));
            IntBuffer fbw = stack.mallocInt(1);
            IntBuffer fbh = stack.mallocInt(1);
            GLFW.glfwGetFramebufferSize(this.window, fbw, fbh);
            boolean bl2 = false;
            boolean bl3 = false;
            int n = fbw.get(0);
            int h$iv = fbh.get(0);
            boolean $i$f$glViewport = false;
            switch (GLGLESKt.WhenMappings.$EnumSwitchMapping$0[GLGLESKt.getDriverType().ordinal()]) {
                case 1: {
                    void w$iv;
                    void y$iv;
                    void x$iv;
                    GL45C.glViewport((int)x$iv, (int)y$iv, (int)w$iv, h$iv);
                    break;
                }
                case 2: {
                    void w$iv;
                    void y$iv;
                    void x$iv;
                    GLES32.glViewport((int)x$iv, (int)y$iv, (int)w$iv, h$iv);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            this.getProgram().setWidth((int)Math.ceil((double)fbw.get(0) / this.getProgram().getWindow().getContentScale()));
            this.getProgram().setHeight((int)Math.ceil((double)fbh.get(0) / this.getProgram().getWindow().getContentScale()));
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally(autoCloseable, throwable);
        }
    }

    @Override
    public void exit() {
        this.exitRequested = true;
    }

    @Override
    public void requestDraw() {
        this.drawRequested = true;
    }

    @Override
    public void requestFocus() {
        GLFW.glfwFocusWindow(this.window);
    }

    private static final Map cursorCache_delegate$lambda$0() {
        return new LinkedHashMap();
    }

    private static final Object _init_$lambda$4() {
        return "debug output enabled";
    }

    private static final Object _init_$lambda$5() {
        return "trace level enabled";
    }

    private static final Object setup$lambda$6() {
        return GLFW.glfwGetVersionString();
    }

    private static final Object setup$lambda$9$lambda$7(float[] $xscale, float[] $yscale) {
        Intrinsics.checkNotNullParameter($xscale, "$xscale");
        Intrinsics.checkNotNullParameter($yscale, "$yscale");
        return "content scale " + $xscale[0] + " " + $yscale[0];
    }

    private static final Object setup$lambda$9$lambda$8(float[] $xscale, float[] $yscale) {
        Intrinsics.checkNotNullParameter($xscale, "$xscale");
        Intrinsics.checkNotNullParameter($yscale, "$yscale");
        return "non uni-form scaling factors: " + $xscale[0] + " " + $yscale[0];
    }

    private static final Object setup$lambda$10() {
        return "creating window";
    }

    private static final Object setup$lambda$11(float[] $primaryDisplayScale) {
        Intrinsics.checkNotNullParameter($primaryDisplayScale, "$primaryDisplayScale");
        return "primary display content scale: " + $primaryDisplayScale[0];
    }

    private static final Object setup$lambda$12(int $adjustedWidth, int $adjustedHeight) {
        return "adjusted width x height " + $adjustedWidth + " x " + $adjustedHeight;
    }

    private static final Object setup$lambda$13() {
        return "creating fullscreen window";
    }

    private static final Object setup$lambda$14() {
        return "experimental touch input enabled";
    }

    private static final Object setup$lambda$16(ApplicationGLFWGL3 this$0) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        return "window created: " + this$0.window;
    }

    private static final Object setup$lambda$17(ApplicationGLFWGL3 this$0) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        return "showing window early: " + this$0.window;
    }

    private static final Object setup$lambda$20() {
        return "making context current";
    }

    private static final void setup$lambda$21(Ref.IntRef $readyFrames, ApplicationGLFWGL3 this$0, long it) {
        Intrinsics.checkNotNullParameter($readyFrames, "$readyFrames");
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        if ($readyFrames.element > 0) {
            if (this$0.setupCalled) {
                this$0.drawFrame();
            }
            GLFW.glfwSwapBuffers(this$0.window);
        }
        int n = $readyFrames.element;
        $readyFrames.element = n + 1;
    }

    private static final Object setup$lambda$23$lambda$22(long $window, int $width, int $height) {
        return "resizing window (" + $window + ") to " + $width + "x" + $height + " ";
    }

    private static final void setup$lambda$23(ApplicationGLFWGL3 this$0, Ref.IntRef $readyFrames, long window2, int width, int height) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($readyFrames, "$readyFrames");
        ApplicationGLFWGL3Kt.access$getLogger$p().debug(() -> ApplicationGLFWGL3.setup$lambda$23$lambda$22(window2, width, height));
        this$0._windowSize = null;
        if ($readyFrames.element > 0) {
            this$0.setupSizes();
            this$0.getProgram().getWindow().getSized().trigger(new WindowEvent(WindowEventType.RESIZED, this$0.getProgram().getWindow().getPosition(), this$0.getProgram().getWindow().getSize(), true));
        }
        int n = $readyFrames.element;
        $readyFrames.element = n + 1;
    }

    private static final Object setup$lambda$25$lambda$24(ApplicationGLFWGL3 this$0, int $x, int $y) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        return "window (" + this$0.window + ") has moved to " + $x + " " + $y;
    }

    private static final void setup$lambda$25(ApplicationGLFWGL3 this$0, long l, int x, int y) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        ApplicationGLFWGL3Kt.access$getLogger$p().trace(() -> ApplicationGLFWGL3.setup$lambda$25$lambda$24(this$0, x, y));
        this$0.getProgram().getWindow().getMoved().trigger(new WindowEvent(WindowEventType.MOVED, new Vector2(x, y), new Vector2(0.0, 0.0), true));
    }

    private static final Object setup$lambda$27$lambda$26(ApplicationGLFWGL3 this$0, boolean $focused) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        return "window (" + this$0.window + ") focus has changed; focused=" + $focused;
    }

    private static final void setup$lambda$27(ApplicationGLFWGL3 this$0, long l, boolean focused) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        ApplicationGLFWGL3Kt.access$getLogger$p().trace(() -> ApplicationGLFWGL3.setup$lambda$27$lambda$26(this$0, focused));
        this$0.windowFocused = focused;
        if (focused) {
            this$0.getProgram().getWindow().getFocused().trigger(new WindowEvent(WindowEventType.FOCUSED, this$0.getProgram().getWindow().getPosition(), this$0.getProgram().getWindow().getSize(), true));
        } else {
            this$0.getProgram().getWindow().getUnfocused().trigger(new WindowEvent(WindowEventType.FOCUSED, this$0.getProgram().getWindow().getPosition(), this$0.getProgram().getWindow().getSize(), false));
        }
    }

    private static final Object setup$lambda$29$lambda$28(long $window) {
        return "window (" + $window + ") closed";
    }

    private static final void setup$lambda$29(ApplicationGLFWGL3 this$0, long window2) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        ApplicationGLFWGL3Kt.access$getLogger$p().debug(() -> ApplicationGLFWGL3.setup$lambda$29$lambda$28(window2));
        this$0.getProgram().getWindow().getClosed().trigger(new WindowEvent(WindowEventType.CLOSED, this$0.getProgram().getWindow().getPosition(), this$0.getProgram().getWindow().getSize(), true));
        this$0.exitRequested = true;
    }

    private static final Object setup$lambda$30() {
        return "showing window";
    }

    private static final Object createPrimaryWindow$lambda$34$lambda$33(int $error, long $description) {
        return "LWJGL Error - Code: " + Integer.toHexString($error) + ", Description: " + GLFWErrorCallback.getDescription($description);
    }

    private static final void createPrimaryWindow$lambda$34(int error, long description) {
        ApplicationGLFWGL3Kt.access$getLogger$p().debug(() -> ApplicationGLFWGL3.createPrimaryWindow$lambda$34$lambda$33(error, description));
    }

    private static final ProgramRenderTargetGL3 defaultRenderTarget_delegate$lambda$35(ApplicationGLFWGL3 this$0) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        return new ProgramRenderTargetGL3(this$0.getProgram());
    }

    private static final Object loop$lambda$36() {
        return "starting loop";
    }

    private static final void loop$lambda$37(Set $modifiers, ApplicationGLFWGL3 this$0, long l, int key, int scancode, int action, int n) {
        String string;
        Intrinsics.checkNotNullParameter($modifiers, "$modifiers");
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        switch (key) {
            case 32: {
                string = "space";
                break;
            }
            case 257: {
                string = "enter";
                break;
            }
            case 258: {
                string = "tab";
                break;
            }
            case 256: {
                string = "escape";
                break;
            }
            case 265: {
                string = "arrow-up";
                break;
            }
            case 264: {
                string = "arrow-down";
                break;
            }
            case 263: {
                string = "arrow-left";
                break;
            }
            case 262: {
                string = "arrow-right";
                break;
            }
            case 283: {
                string = "print-screen";
                break;
            }
            case 267: {
                string = "page-down";
                break;
            }
            case 266: {
                string = "page-up";
                break;
            }
            case 268: {
                string = "home";
                break;
            }
            case 269: {
                string = "end";
                break;
            }
            case 259: {
                string = "backspace";
                break;
            }
            case 342: {
                string = "left-alt";
                break;
            }
            case 346: {
                string = "right-alt";
                break;
            }
            case 341: {
                string = "left-control";
                break;
            }
            case 345: {
                string = "right-control";
                break;
            }
            case 260: {
                string = "insert";
                break;
            }
            case 261: {
                string = "delete";
                break;
            }
            case 340: {
                string = "left-shift";
                break;
            }
            case 344: {
                string = "right-shift";
                break;
            }
            case 343: {
                string = "left-super";
                break;
            }
            case 347: {
                string = "right-super";
                break;
            }
            case 290: {
                string = "f1";
                break;
            }
            case 291: {
                string = "f2";
                break;
            }
            case 292: {
                string = "f3";
                break;
            }
            case 293: {
                string = "f4";
                break;
            }
            case 294: {
                string = "f5";
                break;
            }
            case 295: {
                string = "f6";
                break;
            }
            case 296: {
                string = "f7";
                break;
            }
            case 297: {
                string = "f8";
                break;
            }
            case 298: {
                string = "f9";
                break;
            }
            case 299: {
                string = "f10";
                break;
            }
            case 300: {
                string = "f11";
                break;
            }
            case 301: {
                string = "f12";
                break;
            }
            case 280: {
                string = "caps-lock";
                break;
            }
            default: {
                string = GLFW.glfwGetKeyName(key, scancode);
                if (string != null) break;
                string = "<null>";
            }
        }
        String name = string;
        switch (action) {
            case 1: {
                switch (key) {
                    case 342: 
                    case 346: {
                        ((Collection)$modifiers).add(KeyModifier.ALT);
                    }
                }
                switch (key) {
                    case 341: 
                    case 345: {
                        ((Collection)$modifiers).add(KeyModifier.CTRL);
                    }
                }
                switch (key) {
                    case 340: 
                    case 344: {
                        ((Collection)$modifiers).add(KeyModifier.SHIFT);
                    }
                }
                switch (key) {
                    case 343: 
                    case 347: {
                        ((Collection)$modifiers).add(KeyModifier.SUPER);
                    }
                }
                this$0.getProgram().getKeyboard().getKeyDown().trigger(new KeyEvent(KeyEventType.KEY_DOWN, key, name, $modifiers));
                break;
            }
            case 0: {
                switch (key) {
                    case 342: 
                    case 346: {
                        ((Collection)$modifiers).remove((Object)KeyModifier.ALT);
                    }
                }
                switch (key) {
                    case 341: 
                    case 345: {
                        ((Collection)$modifiers).remove((Object)KeyModifier.CTRL);
                    }
                }
                switch (key) {
                    case 340: 
                    case 344: {
                        ((Collection)$modifiers).remove((Object)KeyModifier.SHIFT);
                    }
                }
                switch (key) {
                    case 343: 
                    case 347: {
                        ((Collection)$modifiers).remove((Object)KeyModifier.SUPER);
                    }
                }
                this$0.getProgram().getKeyboard().getKeyUp().trigger(new KeyEvent(KeyEventType.KEY_UP, key, name, $modifiers));
                break;
            }
            case 2: {
                this$0.getProgram().getKeyboard().getKeyRepeat().trigger(new KeyEvent(KeyEventType.KEY_REPEAT, key, name, $modifiers));
            }
        }
    }

    private static final void loop$lambda$38(ApplicationGLFWGL3 this$0, long l, int codepoint) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        this$0.getProgram().getKeyboard().getCharacter().trigger(new CharacterEvent((char)codepoint, SetsKt.emptySet()));
    }

    private static final Object loop$lambda$42$lambda$39(int $count) {
        return $count + " file(s) have been dropped";
    }

    /*
     * WARNING - void declaration
     */
    private static final void loop$lambda$42(ApplicationGLFWGL3 this$0, long l, int count2, long names) {
        Collection<String> collection;
        Object object;
        Iterable $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        ApplicationGLFWGL3Kt.access$getLogger$p().debug(() -> ApplicationGLFWGL3.loop$lambda$42$lambda$39(count2));
        PointerBuffer pointers = PointerBuffer.create(names, count2);
        Iterable $this$map$iv = RangesKt.until(0, count2);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            void it;
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator2).nextInt();
            object = destination$iv$iv;
            boolean bl = false;
            object.add(new File(pointers.getStringUTF8((int)it)));
        }
        List files = (List)destination$iv$iv;
        $this$map$iv = files;
        Vector2 vector2 = this$0.getProgram().getMouse().getPosition();
        object = this$0.getProgram().getWindow().getDrop();
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            File it = (File)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.toString());
        }
        collection = (List)destination$iv$iv;
        List list = collection;
        Vector2 vector22 = vector2;
        ((Event)object).trigger(new DropEvent(vector22, list));
    }

    private static final void loop$lambda$43(ApplicationGLFWGL3 this$0, Set $modifiers, long l, double xoffset, double yoffset) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($modifiers, "$modifiers");
        this$0.getProgram().getMouse().getScrolled().trigger(new MouseEvent(this$0.getProgram().getMouse().getPosition(), new Vector2(xoffset, yoffset), Vector2.Companion.getZERO(), MouseEventType.SCROLLED, MouseButton.NONE, $modifiers));
    }

    private static final void loop$lambda$44(ApplicationGLFWGL3 this$0, long l, boolean iconified) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        if (iconified) {
            this$0.getProgram().getWindow().getMinimized().trigger(new WindowEvent(WindowEventType.MINIMIZED, Vector2.Companion.getZERO(), Vector2.Companion.getZERO(), false));
        } else {
            this$0.getProgram().getWindow().getRestored().trigger(new WindowEvent(WindowEventType.RESTORED, this$0.getProgram().getWindow().getPosition(), this$0.getProgram().getWindow().getSize(), true));
        }
    }

    private static final void loop$lambda$45(ApplicationGLFWGL3 this$0, long l, boolean entered) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        if (entered) {
            this$0.getProgram().getMouse().getEntered().trigger(new MouseEvent(this$0.getProgram().getMouse().getPosition(), Vector2.Companion.getZERO(), Vector2.Companion.getZERO(), MouseEventType.ENTERED, MouseButton.NONE, SetsKt.emptySet()));
        } else {
            this$0.getProgram().getMouse().getExited().trigger(new MouseEvent(this$0.getProgram().getMouse().getPosition(), Vector2.Companion.getZERO(), Vector2.Companion.getZERO(), MouseEventType.EXITED, MouseButton.NONE, SetsKt.emptySet()));
        }
    }

    private static final void loop$lambda$46(Ref.BooleanRef $down, Ref.ObjectRef $lastDragPosition, ApplicationGLFWGL3 this$0, Ref.ObjectRef $lastMouseButtonDown, Set $modifiers, long l, int button, int action, int n) {
        Intrinsics.checkNotNullParameter($down, "$down");
        Intrinsics.checkNotNullParameter($lastDragPosition, "$lastDragPosition");
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($lastMouseButtonDown, "$lastMouseButtonDown");
        Intrinsics.checkNotNullParameter($modifiers, "$modifiers");
        MouseButton mouseButton = switch (button) {
            case 0 -> MouseButton.LEFT;
            case 1 -> MouseButton.RIGHT;
            case 2 -> MouseButton.CENTER;
            default -> MouseButton.NONE;
        };
        BitSet buttonsDown = new BitSet();
        switch (action) {
            case 1: {
                $down.element = true;
                $lastDragPosition.element = this$0.getProgram().getMouse().getPosition();
                $lastMouseButtonDown.element = mouseButton;
                this$0.getProgram().getMouse().getButtonDown().trigger(new MouseEvent(this$0.getProgram().getMouse().getPosition(), Vector2.Companion.getZERO(), Vector2.Companion.getZERO(), MouseEventType.BUTTON_DOWN, mouseButton, $modifiers));
                buttonsDown.set(button, true);
                break;
            }
            case 0: {
                $down.element = false;
                this$0.getProgram().getMouse().getButtonUp().trigger(new MouseEvent(this$0.getProgram().getMouse().getPosition(), Vector2.Companion.getZERO(), Vector2.Companion.getZERO(), MouseEventType.BUTTON_UP, mouseButton, $modifiers));
                buttonsDown.set(button, false);
            }
        }
    }

    private static final Object loop$lambda$48$lambda$47(double $xpos, double $ypos, Vector2 $position) {
        Intrinsics.checkNotNullParameter($position, "$position");
        return "mouse moved " + $xpos + " " + $ypos + " -- " + $position;
    }

    private static final void loop$lambda$48(ApplicationGLFWGL3 this$0, Set $modifiers, Ref.BooleanRef $down, Ref.ObjectRef $lastDragPosition, Ref.ObjectRef $lastMouseButtonDown, long l, double xpos, double ypos) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($modifiers, "$modifiers");
        Intrinsics.checkNotNullParameter($down, "$down");
        Intrinsics.checkNotNullParameter($lastDragPosition, "$lastDragPosition");
        Intrinsics.checkNotNullParameter($lastMouseButtonDown, "$lastMouseButtonDown");
        Vector2 position = ApplicationGlfwConfiguration.INSTANCE.getFixWindowSize() ? new Vector2(xpos, ypos).div(this$0.getProgram().getWindow().getContentScale()) : new Vector2(xpos, ypos);
        ApplicationGLFWGL3Kt.access$getLogger$p().trace(() -> ApplicationGLFWGL3.loop$lambda$48$lambda$47(xpos, ypos, position));
        this$0.realCursorPosition = position;
        this$0.getProgram().getMouse().getMoved().trigger(new MouseEvent(position, Vector2.Companion.getZERO(), Vector2.Companion.getZERO(), MouseEventType.MOVED, MouseButton.NONE, $modifiers));
        if ($down.element) {
            this$0.getProgram().getMouse().getDragged().trigger(new MouseEvent(position, Vector2.Companion.getZERO(), position.minus((Vector2)$lastDragPosition.element), MouseEventType.DRAGGED, (MouseButton)((Object)$lastMouseButtonDown.element), $modifiers));
            $lastDragPosition.element = position;
        }
    }

    private static final Object loop$lambda$49() {
        return "clearing and displaying pre-setup";
    }

    private static final Object loop$lambda$50() {
        int pname$iv = 7936;
        boolean $i$f$glGetString = false;
        return "OpenGL vendor: " + (switch (GLGLESKt.WhenMappings.$EnumSwitchMapping$0[GLGLESKt.getDriverType().ordinal()]) {
            case 1 -> GL45C.glGetString(pname$iv);
            case 2 -> GLES32.glGetString(pname$iv);
            default -> throw new NoWhenBranchMatchedException();
        });
    }

    private static final Object loop$lambda$51() {
        int pname$iv = 7937;
        boolean $i$f$glGetString = false;
        return "OpenGL renderer: " + (switch (GLGLESKt.WhenMappings.$EnumSwitchMapping$0[GLGLESKt.getDriverType().ordinal()]) {
            case 1 -> GL45C.glGetString(pname$iv);
            case 2 -> GLES32.glGetString(pname$iv);
            default -> throw new NoWhenBranchMatchedException();
        });
    }

    private static final Object loop$lambda$52() {
        int pname$iv = 7938;
        boolean $i$f$glGetString = false;
        return "OpenGL version: " + (switch (GLGLESKt.WhenMappings.$EnumSwitchMapping$0[GLGLESKt.getDriverType().ordinal()]) {
            case 1 -> GL45C.glGetString(pname$iv);
            case 2 -> GLES32.glGetString(pname$iv);
            default -> throw new NoWhenBranchMatchedException();
        });
    }

    private static final Object loop$lambda$53() {
        return "calling program.setup";
    }

    private static final Object loop$lambda$55$lambda$54() {
        return "An error occurred inside the program setup";
    }

    private static final Object loop$lambda$56() {
        return "An exception was thrown inside the OPENRNDR program";
    }

    private static final Object loop$lambda$57() {
        return "Exiting draw loop";
    }

    private static final Object postloop$lambda$58() {
        return "Shutting down extensions";
    }

    private static final Object postloop$lambda$60() {
        return "Triggering program ended event";
    }

    private static final Object postloop$lambda$61() {
        return "Exit handled";
    }

    private static final Object postloop$lambda$62() {
        return "done";
    }

    private static final Object postloop$lambda$64$lambda$63(Throwable $exception) {
        return "OPENRNDR program ended with exception. (" + $exception.getMessage() + ")}";
    }

    private static final Object drawFrame$lambda$65(ApplicationGLFWGL3 this$0) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        return "window: " + (int)this$0.getProgram().getWindow().getSize().x() + "x" + (int)this$0.getProgram().getWindow().getSize().y() + " program: " + this$0.getProgram().getWidth() + "x" + this$0.getProgram().getHeight();
    }

    private static final Object drawFrame$lambda$66(Throwable $e) {
        Intrinsics.checkNotNullParameter($e, "$e");
        return "Caught exception inside the program loop. (" + $e.getMessage() + ")";
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;
        public static final /* synthetic */ int[] $EnumSwitchMapping$2;

        static {
            int[] nArray = new int[MouseCursorHideMode.values().length];
            try {
                nArray[MouseCursorHideMode.HIDE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MouseCursorHideMode.DISABLE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[CursorType.values().length];
            try {
                nArray[CursorType.ARROW_CURSOR.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CursorType.IBEAM_CURSOR.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CursorType.HAND_CURSOR.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CursorType.CROSSHAIR_CURSOR.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CursorType.HRESIZE_CURSOR.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CursorType.VRESIZE_CURSOR.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
            nArray = new int[DriverTypeGL.values().length];
            try {
                nArray[DriverTypeGL.GL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DriverTypeGL.GLES.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$2 = nArray;
        }
    }
}

