/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.internal.gl3;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.opengl.GL43C;
import org.lwjgl.opengl.GL44C;
import org.lwjgl.opengl.GL45C;
import org.lwjgl.opengles.GLES32;
import org.openrndr.draw.AtomicCounterBuffer;
import org.openrndr.internal.Driver;
import org.openrndr.internal.gl3.DriverGL3;
import org.openrndr.internal.gl3.DriverVersionGL;
import org.openrndr.internal.gl3.GLGLESKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0005\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0012H\u0016J\b\u0010\u0014\u001a\u00020\u0010H\u0016J\b\u0010\u0015\u001a\u00020\u0010H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u0004\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\f\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0017"}, d2={"Lorg/openrndr/internal/gl3/AtomicCounterBufferGL42;", "Lorg/openrndr/draw/AtomicCounterBuffer;", "buffer", "", "size", "<init>", "(II)V", "getBuffer", "()I", "getSize", "destroyed", "", "useNamedBuffers", "getUseNamedBuffers", "()Z", "write", "", "data", "", "read", "reset", "destroy", "Companion", "openrndr-gl3"})
@SourceDebugExtension(value={"SMAP\nAtomicCounterBufferGL42.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AtomicCounterBufferGL42.kt\norg/openrndr/internal/gl3/AtomicCounterBufferGL42\n+ 2 GLGLES.kt\norg/openrndr/internal/gl3/GLGLESKt\n*L\n1#1,69:1\n40#2,3:70\n40#2,3:73\n*S KotlinDebug\n*F\n+ 1 AtomicCounterBufferGL42.kt\norg/openrndr/internal/gl3/AtomicCounterBufferGL42\n*L\n38#1:70,3\n50#1:73,3\n*E\n"})
public final class AtomicCounterBufferGL42
implements AtomicCounterBuffer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int buffer;
    private final int size;
    private boolean destroyed;
    private final boolean useNamedBuffers;

    public AtomicCounterBufferGL42(int buffer, int size) {
        this.buffer = buffer;
        this.size = size;
        Driver driver = Driver.Companion.getInstance();
        Intrinsics.checkNotNull(driver, "null cannot be cast to non-null type org.openrndr.internal.gl3.DriverGL3");
        this.useNamedBuffers = ((DriverGL3)driver).getVersion().compareTo((Enum)DriverVersionGL.GL_VERSION_4_5) >= 0;
    }

    public final int getBuffer() {
        return this.buffer;
    }

    @Override
    public int getSize() {
        return this.size;
    }

    public final boolean getUseNamedBuffers() {
        return this.useNamedBuffers;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void write(@NotNull int[] data) {
        Intrinsics.checkNotNullParameter(data, "data");
        if (!(!this.destroyed)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (this.useNamedBuffers) {
            GL45C.glNamedBufferSubData(this.buffer, 0L, data);
        } else {
            int n = 37568;
            int buffer$iv = this.buffer;
            boolean $i$f$glBindBuffer = false;
            switch (GLGLESKt.WhenMappings.$EnumSwitchMapping$0[GLGLESKt.getDriverType().ordinal()]) {
                case 1: {
                    void target$iv;
                    GL45C.glBindBuffer((int)target$iv, buffer$iv);
                    break;
                }
                case 2: {
                    void target$iv;
                    GLES32.glBindBuffer((int)target$iv, buffer$iv);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            GL43C.glBufferSubData(37568, 0L, data);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public int[] read() {
        if (!(!this.destroyed)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        int[] result2 = new int[this.getSize()];
        if (this.useNamedBuffers) {
            GL45C.glGetNamedBufferSubData(this.buffer, 0L, result2);
        } else {
            int n = 37568;
            int buffer$iv = this.buffer;
            boolean $i$f$glBindBuffer = false;
            switch (GLGLESKt.WhenMappings.$EnumSwitchMapping$0[GLGLESKt.getDriverType().ordinal()]) {
                case 1: {
                    void target$iv;
                    GL45C.glBindBuffer((int)target$iv, buffer$iv);
                    break;
                }
                case 2: {
                    void target$iv;
                    GLES32.glBindBuffer((int)target$iv, buffer$iv);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            GL43C.glGetBufferSubData(37568, 0L, result2);
        }
        return result2;
    }

    @Override
    public void reset() {
        if (!(!this.destroyed)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        this.write(new int[this.getSize()]);
    }

    @Override
    public void destroy() {
        if (!this.destroyed) {
            this.destroyed = true;
            GLGLESKt.glDeleteBuffers(this.buffer);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lorg/openrndr/internal/gl3/AtomicCounterBufferGL42$Companion;", "", "<init>", "()V", "create", "Lorg/openrndr/internal/gl3/AtomicCounterBufferGL42;", "counterCount", "", "openrndr-gl3"})
    @SourceDebugExtension(value={"SMAP\nAtomicCounterBufferGL42.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AtomicCounterBufferGL42.kt\norg/openrndr/internal/gl3/AtomicCounterBufferGL42$Companion\n+ 2 GLGLES.kt\norg/openrndr/internal/gl3/GLGLESKt\n*L\n1#1,69:1\n33#2,3:70\n40#2,3:73\n*S KotlinDebug\n*F\n+ 1 AtomicCounterBufferGL42.kt\norg/openrndr/internal/gl3/AtomicCounterBufferGL42$Companion\n*L\n18#1:70,3\n19#1:73,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final AtomicCounterBufferGL42 create(int counterCount) {
            boolean useBufferStorage;
            boolean $i$f$glGenBuffers = false;
            int counterBuffer = switch (GLGLESKt.WhenMappings.$EnumSwitchMapping$0[GLGLESKt.getDriverType().ordinal()]) {
                case 1 -> GL45C.glGenBuffers();
                case 2 -> GLES32.glGenBuffers();
                default -> throw new NoWhenBranchMatchedException();
            };
            int target$iv = 37568;
            boolean $i$f$glBindBuffer = false;
            switch (GLGLESKt.WhenMappings.$EnumSwitchMapping$0[GLGLESKt.getDriverType().ordinal()]) {
                case 1: {
                    GL45C.glBindBuffer(target$iv, counterBuffer);
                    break;
                }
                case 2: {
                    GLES32.glBindBuffer(target$iv, counterBuffer);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            Driver driver = Driver.Companion.getInstance();
            Intrinsics.checkNotNull(driver, "null cannot be cast to non-null type org.openrndr.internal.gl3.DriverGL3");
            boolean bl = useBufferStorage = ((DriverGL3)driver).getVersion().compareTo((Enum)DriverVersionGL.GL_VERSION_4_4) >= 0;
            if (useBufferStorage) {
                GL43C.glBufferData(37568, new int[counterCount], 35048);
            } else {
                GL44C.glBufferStorage(37568, (long)counterCount * 4L, 256);
            }
            return new AtomicCounterBufferGL42(counterBuffer, counterCount);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

