/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.internal.gl3;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.openrndr.color.ColorRGBa;
import org.openrndr.draw.BufferWriter;
import org.openrndr.math.IntVector2;
import org.openrndr.math.IntVector3;
import org.openrndr.math.IntVector4;
import org.openrndr.math.Matrix33;
import org.openrndr.math.Matrix44;
import org.openrndr.math.Vector2;
import org.openrndr.math.Vector3;
import org.openrndr.math.Vector4;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0005\n\u0002\u0010\n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0014\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J \u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0005H\u0016J!\u0010\u0011\u001a\u00020\r2\u0012\u0010\u0012\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00140\u0013\"\u00020\u0014H\u0016\u00a2\u0006\u0002\u0010\u0015J\u0010\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0016H\u0016J\u0010\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0017H\u0016J\u0010\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0005H\u0016J\u0010\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0018H\u0016J\u0010\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0019H\u0016J\u0010\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u001aH\u0016J \u0010\u0011\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\u0005H\u0016J\u0010\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0014H\u0016J\u0010\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u001fH\u0016J\u0010\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020 H\u0016J\u0010\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020!H\u0016J\u0010\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\"H\u0016J\u0010\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020#H\u0016J \u0010\u0011\u001a\u00020\r2\u0006\u0010$\u001a\u00020#2\u0006\u0010%\u001a\u00020#2\u0006\u0010&\u001a\u00020#H\u0016J(\u0010\u0011\u001a\u00020\r2\u0006\u0010$\u001a\u00020#2\u0006\u0010%\u001a\u00020#2\u0006\u0010&\u001a\u00020#2\u0006\u0010'\u001a\u00020#H\u0016J\u0018\u0010\u0011\u001a\u00020\r2\u0006\u0010$\u001a\u00020#2\u0006\u0010%\u001a\u00020#H\u0016J\u0010\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020(H\u0016J\b\u00101\u001a\u00020\rH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR$\u0010*\u001a\u00020\u00052\u0006\u0010)\u001a\u00020\u00058V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b+\u0010\u000b\"\u0004\b,\u0010-R$\u0010.\u001a\u00020\u00052\u0006\u0010)\u001a\u00020\u00058V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b/\u0010\u000b\"\u0004\b0\u0010-\u00a8\u00062"}, d2={"Lorg/openrndr/internal/gl3/BufferWriterGL3;", "Lorg/openrndr/draw/BufferWriter;", "buffer", "Ljava/nio/ByteBuffer;", "elementSize", "", "<init>", "(Ljava/nio/ByteBuffer;I)V", "getBuffer", "()Ljava/nio/ByteBuffer;", "getElementSize", "()I", "copyBuffer", "", "sourceBuffer", "sourceOffset", "sourceSizeInBytes", "write", "v", "", "Lorg/openrndr/math/Vector3;", "([Lorg/openrndr/math/Vector3;)V", "", "", "Lorg/openrndr/math/IntVector2;", "Lorg/openrndr/math/IntVector3;", "Lorg/openrndr/math/IntVector4;", "a", "", "offset", "size", "Lorg/openrndr/math/Vector2;", "Lorg/openrndr/math/Vector4;", "Lorg/openrndr/math/Matrix33;", "Lorg/openrndr/math/Matrix44;", "", "x", "y", "z", "w", "Lorg/openrndr/color/ColorRGBa;", "value", "position", "getPosition", "setPosition", "(I)V", "positionElements", "getPositionElements", "setPositionElements", "rewind", "openrndr-gl3"})
public final class BufferWriterGL3
extends BufferWriter {
    @NotNull
    private final ByteBuffer buffer;
    private final int elementSize;

    public BufferWriterGL3(@NotNull ByteBuffer buffer, int elementSize) {
        Intrinsics.checkNotNullParameter(buffer, "buffer");
        this.buffer = buffer;
        this.elementSize = elementSize;
        this.buffer.order(ByteOrder.nativeOrder());
    }

    public /* synthetic */ BufferWriterGL3(ByteBuffer byteBuffer, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            n = 1;
        }
        this(byteBuffer, n);
    }

    @NotNull
    public final ByteBuffer getBuffer() {
        return this.buffer;
    }

    public final int getElementSize() {
        return this.elementSize;
    }

    @Override
    public void copyBuffer(@NotNull ByteBuffer sourceBuffer, int sourceOffset, int sourceSizeInBytes) {
        Intrinsics.checkNotNullParameter(sourceBuffer, "sourceBuffer");
        if (!sourceBuffer.isDirect()) {
            boolean bl = false;
            String string = "can only copy from direct buffers";
            throw new IllegalArgumentException(string.toString());
        }
        ((Buffer)sourceBuffer).limit(sourceBuffer.capacity());
        ((Buffer)sourceBuffer).position(sourceOffset);
        ((Buffer)sourceBuffer).limit(sourceOffset + sourceSizeInBytes);
        this.buffer.put(sourceBuffer);
        ((Buffer)sourceBuffer).limit(sourceBuffer.capacity());
    }

    @Override
    public void write(Vector3 ... v) {
        Intrinsics.checkNotNullParameter(v, "v");
        for (Vector3 i : v) {
            this.write(i);
        }
    }

    @Override
    public void write(byte v) {
        this.buffer.put(v);
    }

    @Override
    public void write(short v) {
        this.buffer.putShort(v);
    }

    @Override
    public void write(int v) {
        this.buffer.putInt(v);
    }

    @Override
    public void write(@NotNull IntVector2 v) {
        Intrinsics.checkNotNullParameter(v, "v");
        this.buffer.putInt(v.x());
        this.buffer.putInt(v.y());
    }

    @Override
    public void write(@NotNull IntVector3 v) {
        Intrinsics.checkNotNullParameter(v, "v");
        this.buffer.putInt(v.x());
        this.buffer.putInt(v.y());
        this.buffer.putInt(v.z());
    }

    @Override
    public void write(@NotNull IntVector4 v) {
        Intrinsics.checkNotNullParameter(v, "v");
        this.buffer.putInt(v.x());
        this.buffer.putInt(v.y());
        this.buffer.putInt(v.z());
        this.buffer.putInt(v.w());
    }

    @Override
    public void write(@NotNull float[] a, int offset, int size) {
        Intrinsics.checkNotNullParameter(a, "a");
        this.buffer.asFloatBuffer().put(a, offset, size);
        ByteBuffer byteBuffer = this.buffer;
        Intrinsics.checkNotNull(byteBuffer, "null cannot be cast to non-null type java.nio.Buffer");
        ((Buffer)byteBuffer).position(this.buffer.position() + size * 4);
    }

    @Override
    public void write(@NotNull Vector3 v) {
        Intrinsics.checkNotNullParameter(v, "v");
        this.buffer.putFloat((float)v.x());
        this.buffer.putFloat((float)v.y());
        this.buffer.putFloat((float)v.z());
    }

    @Override
    public void write(@NotNull Vector2 v) {
        Intrinsics.checkNotNullParameter(v, "v");
        this.buffer.putFloat((float)v.x());
        this.buffer.putFloat((float)v.y());
    }

    @Override
    public void write(@NotNull Vector4 v) {
        Intrinsics.checkNotNullParameter(v, "v");
        this.buffer.putFloat((float)v.x());
        this.buffer.putFloat((float)v.y());
        this.buffer.putFloat((float)v.z());
        this.buffer.putFloat((float)v.w());
    }

    @Override
    public void write(@NotNull Matrix33 v) {
        Intrinsics.checkNotNullParameter(v, "v");
        this.buffer.putFloat((float)v.c0r0());
        this.buffer.putFloat((float)v.c0r1());
        this.buffer.putFloat((float)v.c0r2());
        this.buffer.putFloat((float)v.c1r0());
        this.buffer.putFloat((float)v.c1r1());
        this.buffer.putFloat((float)v.c1r2());
        this.buffer.putFloat((float)v.c2r0());
        this.buffer.putFloat((float)v.c2r1());
        this.buffer.putFloat((float)v.c2r2());
    }

    @Override
    public void write(@NotNull Matrix44 v) {
        Intrinsics.checkNotNullParameter(v, "v");
        this.buffer.putFloat((float)v.c0r0());
        this.buffer.putFloat((float)v.c0r1());
        this.buffer.putFloat((float)v.c0r2());
        this.buffer.putFloat((float)v.c0r3());
        this.buffer.putFloat((float)v.c1r0());
        this.buffer.putFloat((float)v.c1r1());
        this.buffer.putFloat((float)v.c1r2());
        this.buffer.putFloat((float)v.c1r3());
        this.buffer.putFloat((float)v.c2r0());
        this.buffer.putFloat((float)v.c2r1());
        this.buffer.putFloat((float)v.c2r2());
        this.buffer.putFloat((float)v.c2r3());
        this.buffer.putFloat((float)v.c3r0());
        this.buffer.putFloat((float)v.c3r1());
        this.buffer.putFloat((float)v.c3r2());
        this.buffer.putFloat((float)v.c3r3());
    }

    @Override
    public void write(float v) {
        this.buffer.putFloat(v);
    }

    @Override
    public void write(float x, float y, float z) {
        this.buffer.putFloat(x);
        this.buffer.putFloat(y);
        this.buffer.putFloat(z);
    }

    @Override
    public void write(float x, float y, float z, float w) {
        this.buffer.putFloat(x);
        this.buffer.putFloat(y);
        this.buffer.putFloat(z);
        this.buffer.putFloat(w);
    }

    @Override
    public void write(float x, float y) {
        this.buffer.putFloat(x);
        this.buffer.putFloat(y);
    }

    @Override
    public void write(@NotNull ColorRGBa v) {
        Intrinsics.checkNotNullParameter(v, "v");
        this.buffer.putFloat((float)v.getR());
        this.buffer.putFloat((float)v.getG());
        this.buffer.putFloat((float)v.getB());
        this.buffer.putFloat((float)v.getAlpha());
    }

    @Override
    public int getPosition() {
        ByteBuffer byteBuffer = this.buffer;
        Intrinsics.checkNotNull(byteBuffer, "null cannot be cast to non-null type java.nio.Buffer");
        return ((Buffer)byteBuffer).position();
    }

    @Override
    public void setPosition(int value2) {
        ByteBuffer byteBuffer = this.buffer;
        Intrinsics.checkNotNull(byteBuffer, "null cannot be cast to non-null type java.nio.Buffer");
        ((Buffer)byteBuffer).position(value2);
    }

    @Override
    public int getPositionElements() {
        ByteBuffer byteBuffer = this.buffer;
        Intrinsics.checkNotNull(byteBuffer, "null cannot be cast to non-null type java.nio.Buffer");
        return ((Buffer)byteBuffer).position() / this.elementSize;
    }

    @Override
    public void setPositionElements(int value2) {
        ByteBuffer byteBuffer = this.buffer;
        Intrinsics.checkNotNull(byteBuffer, "null cannot be cast to non-null type java.nio.Buffer");
        ((Buffer)byteBuffer).position(value2 * this.elementSize);
    }

    @Override
    public void rewind() {
        ByteBuffer byteBuffer = this.buffer;
        Intrinsics.checkNotNull(byteBuffer, "null cannot be cast to non-null type java.nio.Buffer");
        ((Buffer)byteBuffer).rewind();
    }
}

