/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.internal.gl3;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.openrndr.color.ColorRGBa;
import org.openrndr.draw.BufferWriterStd430;
import org.openrndr.draw.ShaderStorageElement;
import org.openrndr.draw.ShaderStoragePrimitive;
import org.openrndr.draw.ShaderStorageStruct;
import org.openrndr.math.IntVector2;
import org.openrndr.math.IntVector3;
import org.openrndr.math.IntVector4;
import org.openrndr.math.Matrix33;
import org.openrndr.math.Matrix44;
import org.openrndr.math.Vector2;
import org.openrndr.math.Vector3;
import org.openrndr.math.Vector4;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0010\u0005\n\u0002\u0010\n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u0015\u001a\u00020\u0016H\u0002J\b\u0010\u0017\u001a\u00020\u0016H\u0002J \u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\bH\u0016J!\u0010\u001c\u001a\u00020\u00162\u0012\u0010\u001d\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001f0\u001e\"\u00020\u001fH\u0016\u00a2\u0006\u0002\u0010 J\u0010\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020!H\u0016J\u0010\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020\"H\u0016J\u0010\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020#H\u0016J\u0010\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020\bH\u0016J\u0010\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020$H\u0016J\u0010\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020%H\u0016J\u0010\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020&H\u0016J\u0010\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020\u001fH\u0016J\u0010\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020'H\u0016J\u0010\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020(H\u0016J\u0010\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020)H\u0016J\u0010\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020*H\u0016J\u0010\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020+H\u0016J\u0010\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020,H\u0016J \u0010\u001c\u001a\u00020\u00162\u0006\u0010-\u001a\u00020,2\u0006\u0010.\u001a\u00020,2\u0006\u0010/\u001a\u00020,H\u0016J(\u0010\u001c\u001a\u00020\u00162\u0006\u0010-\u001a\u00020,2\u0006\u0010.\u001a\u00020,2\u0006\u0010/\u001a\u00020,2\u0006\u00100\u001a\u00020,H\u0016J\u0018\u0010\u001c\u001a\u00020\u00162\u0006\u0010-\u001a\u00020,2\u0006\u0010.\u001a\u00020,H\u0016J\u0010\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u000201H\u0016J\b\u0010:\u001a\u00020\u0016H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082.\u00a2\u0006\u0002\n\u0000R$\u00103\u001a\u00020\b2\u0006\u00102\u001a\u00020\b8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b4\u0010\u0010\"\u0004\b5\u00106R$\u00107\u001a\u00020\b2\u0006\u00102\u001a\u00020\b8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b8\u0010\u0010\"\u0004\b9\u00106\u00a8\u0006;"}, d2={"Lorg/openrndr/internal/gl3/BufferWriterStd430GL3;", "Lorg/openrndr/draw/BufferWriterStd430;", "buffer", "Ljava/nio/ByteBuffer;", "elements", "", "Lorg/openrndr/draw/ShaderStorageElement;", "elementSize", "", "<init>", "(Ljava/nio/ByteBuffer;Ljava/util/List;I)V", "getBuffer", "()Ljava/nio/ByteBuffer;", "getElements", "()Ljava/util/List;", "getElementSize", "()I", "pointer", "element", "member", "Lorg/openrndr/draw/ShaderStoragePrimitive;", "next", "", "padding", "copyBuffer", "sourceBuffer", "sourceOffset", "sourceSizeInBytes", "write", "v", "", "Lorg/openrndr/math/Vector3;", "([Lorg/openrndr/math/Vector3;)V", "", "", "", "Lorg/openrndr/math/IntVector2;", "Lorg/openrndr/math/IntVector3;", "Lorg/openrndr/math/IntVector4;", "Lorg/openrndr/math/Vector2;", "Lorg/openrndr/math/Vector4;", "Lorg/openrndr/math/Matrix33;", "Lorg/openrndr/math/Matrix44;", "", "", "x", "y", "z", "w", "Lorg/openrndr/color/ColorRGBa;", "value", "position", "getPosition", "setPosition", "(I)V", "positionElements", "getPositionElements", "setPositionElements", "rewind", "openrndr-gl3"})
public final class BufferWriterStd430GL3
implements BufferWriterStd430 {
    @NotNull
    private final ByteBuffer buffer;
    @NotNull
    private final List<ShaderStorageElement> elements;
    private final int elementSize;
    private int pointer;
    @NotNull
    private ShaderStorageElement element;
    private ShaderStoragePrimitive member;

    public BufferWriterStd430GL3(@NotNull ByteBuffer buffer, @NotNull List<? extends ShaderStorageElement> elements, int elementSize) {
        Intrinsics.checkNotNullParameter(buffer, "buffer");
        Intrinsics.checkNotNullParameter(elements, "elements");
        this.buffer = buffer;
        this.elements = elements;
        this.elementSize = elementSize;
        this.element = this.elements.get(this.pointer);
        this.buffer.order(ByteOrder.nativeOrder());
    }

    public /* synthetic */ BufferWriterStd430GL3(ByteBuffer byteBuffer, List list, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            n = 1;
        }
        this(byteBuffer, list, n);
    }

    @NotNull
    public final ByteBuffer getBuffer() {
        return this.buffer;
    }

    @NotNull
    public final List<ShaderStorageElement> getElements() {
        return this.elements;
    }

    public final int getElementSize() {
        return this.elementSize;
    }

    private final void next() {
        ShaderStorageElement shaderStorageElement = this.element;
        if (shaderStorageElement instanceof ShaderStoragePrimitive) {
            ShaderStorageElement shaderStorageElement2 = this.element;
            Intrinsics.checkNotNull(shaderStorageElement2, "null cannot be cast to non-null type org.openrndr.draw.ShaderStoragePrimitive");
            this.member = (ShaderStoragePrimitive)shaderStorageElement2;
            int n = this.pointer;
            this.pointer = n + 1;
            int index = this.elements.indexOf(this.element);
            if (this.pointer >= index + this.element.getArraySize()) {
                this.pointer = index + 1;
                this.element = this.elements.get(this.pointer % this.elements.size());
            }
        } else if (shaderStorageElement instanceof ShaderStorageStruct) {
            ShaderStorageElement shaderStorageElement3 = this.element;
            Intrinsics.checkNotNull(shaderStorageElement3, "null cannot be cast to non-null type org.openrndr.draw.ShaderStorageStruct");
            ShaderStorageStruct struct = (ShaderStorageStruct)shaderStorageElement3;
            int index = this.elements.indexOf(this.element);
            if (this.pointer >= index + struct.getArraySize() * struct.getElements().size()) {
                this.pointer = index + 1;
                this.element = this.elements.get(this.pointer % this.elements.size());
                this.next();
            } else {
                int memberIdx = (this.pointer - index) % struct.getElements().size();
                ShaderStorageElement shaderStorageElement4 = struct.getElements().get(memberIdx % struct.getElements().size());
                Intrinsics.checkNotNull(shaderStorageElement4, "null cannot be cast to non-null type org.openrndr.draw.ShaderStoragePrimitive");
                this.member = (ShaderStoragePrimitive)shaderStorageElement4;
                int n = this.pointer;
                this.pointer = n + 1;
            }
        }
    }

    private final void padding() {
        this.next();
        ShaderStoragePrimitive shaderStoragePrimitive = this.member;
        if (shaderStoragePrimitive == null) {
            Intrinsics.throwUninitializedPropertyAccessException("member");
            shaderStoragePrimitive = null;
        }
        int n = shaderStoragePrimitive.getPadding() / 4;
        int n2 = 0;
        while (n2 < n) {
            int it = n2++;
            boolean bl = false;
            this.buffer.putInt(0);
        }
    }

    @Override
    public void copyBuffer(@NotNull ByteBuffer sourceBuffer, int sourceOffset, int sourceSizeInBytes) {
        Intrinsics.checkNotNullParameter(sourceBuffer, "sourceBuffer");
        if (!sourceBuffer.isDirect()) {
            boolean bl = false;
            String string = "can only copy from direct buffers";
            throw new IllegalArgumentException(string.toString());
        }
        ((Buffer)sourceBuffer).limit(sourceBuffer.capacity());
        ((Buffer)sourceBuffer).position(sourceOffset);
        ((Buffer)sourceBuffer).limit(sourceOffset + sourceSizeInBytes);
        this.buffer.put(sourceBuffer);
        ((Buffer)sourceBuffer).limit(sourceBuffer.capacity());
    }

    @Override
    public void write(Vector3 ... v) {
        Intrinsics.checkNotNullParameter(v, "v");
        for (Vector3 v3 : v) {
            this.write(v3);
        }
    }

    @Override
    public void write(boolean v) {
        this.buffer.putInt(v ? 1 : 0);
        this.padding();
    }

    @Override
    public void write(byte v) {
        this.buffer.put(v);
        this.padding();
    }

    @Override
    public void write(short v) {
        this.buffer.putShort(v);
        this.padding();
    }

    @Override
    public void write(int v) {
        this.buffer.putInt(v);
        this.padding();
    }

    @Override
    public void write(@NotNull IntVector2 v) {
        Intrinsics.checkNotNullParameter(v, "v");
        this.buffer.putInt(v.x());
        this.buffer.putInt(v.y());
        this.padding();
    }

    @Override
    public void write(@NotNull IntVector3 v) {
        Intrinsics.checkNotNullParameter(v, "v");
        this.buffer.putInt(v.x());
        this.buffer.putInt(v.y());
        this.buffer.putInt(v.z());
        this.padding();
    }

    @Override
    public void write(@NotNull IntVector4 v) {
        Intrinsics.checkNotNullParameter(v, "v");
        this.buffer.putInt(v.x());
        this.buffer.putInt(v.y());
        this.buffer.putInt(v.z());
        this.buffer.putInt(v.w());
        this.padding();
    }

    @Override
    public void write(@NotNull Vector3 v) {
        Intrinsics.checkNotNullParameter(v, "v");
        this.buffer.putFloat((float)v.x());
        this.buffer.putFloat((float)v.y());
        this.buffer.putFloat((float)v.z());
        this.padding();
    }

    @Override
    public void write(@NotNull Vector2 v) {
        Intrinsics.checkNotNullParameter(v, "v");
        this.buffer.putFloat((float)v.x());
        this.buffer.putFloat((float)v.y());
        this.padding();
    }

    @Override
    public void write(@NotNull Vector4 v) {
        Intrinsics.checkNotNullParameter(v, "v");
        this.buffer.putFloat((float)v.x());
        this.buffer.putFloat((float)v.y());
        this.buffer.putFloat((float)v.z());
        this.buffer.putFloat((float)v.w());
        this.padding();
    }

    @Override
    public void write(@NotNull Matrix33 v) {
        Intrinsics.checkNotNullParameter(v, "v");
        this.buffer.putFloat((float)v.c0r0());
        this.buffer.putFloat((float)v.c0r1());
        this.buffer.putFloat((float)v.c0r2());
        this.buffer.putFloat((float)v.c1r0());
        this.buffer.putFloat((float)v.c1r1());
        this.buffer.putFloat((float)v.c1r2());
        this.buffer.putFloat((float)v.c2r0());
        this.buffer.putFloat((float)v.c2r1());
        this.buffer.putFloat((float)v.c2r2());
        this.padding();
    }

    @Override
    public void write(@NotNull Matrix44 v) {
        Intrinsics.checkNotNullParameter(v, "v");
        this.buffer.putFloat((float)v.c0r0());
        this.buffer.putFloat((float)v.c0r1());
        this.buffer.putFloat((float)v.c0r2());
        this.buffer.putFloat((float)v.c0r3());
        this.buffer.putFloat((float)v.c1r0());
        this.buffer.putFloat((float)v.c1r1());
        this.buffer.putFloat((float)v.c1r2());
        this.buffer.putFloat((float)v.c1r3());
        this.buffer.putFloat((float)v.c2r0());
        this.buffer.putFloat((float)v.c2r1());
        this.buffer.putFloat((float)v.c2r2());
        this.buffer.putFloat((float)v.c2r3());
        this.buffer.putFloat((float)v.c3r0());
        this.buffer.putFloat((float)v.c3r1());
        this.buffer.putFloat((float)v.c3r2());
        this.buffer.putFloat((float)v.c3r3());
        this.padding();
    }

    @Override
    public void write(double v) {
        this.buffer.putDouble(v);
        this.padding();
    }

    @Override
    public void write(float v) {
        this.buffer.putFloat(v);
        this.padding();
    }

    @Override
    public void write(float x, float y, float z) {
        this.buffer.putFloat(x);
        this.buffer.putFloat(y);
        this.buffer.putFloat(z);
        this.padding();
    }

    @Override
    public void write(float x, float y, float z, float w) {
        this.buffer.putFloat(x);
        this.buffer.putFloat(y);
        this.buffer.putFloat(z);
        this.buffer.putFloat(w);
        this.padding();
    }

    @Override
    public void write(float x, float y) {
        this.buffer.putFloat(x);
        this.buffer.putFloat(y);
        this.padding();
    }

    @Override
    public void write(@NotNull ColorRGBa v) {
        Intrinsics.checkNotNullParameter(v, "v");
        this.buffer.putFloat((float)v.getR());
        this.buffer.putFloat((float)v.getG());
        this.buffer.putFloat((float)v.getB());
        this.buffer.putFloat((float)v.getAlpha());
        this.padding();
    }

    @Override
    public int getPosition() {
        ByteBuffer byteBuffer = this.buffer;
        Intrinsics.checkNotNull(byteBuffer, "null cannot be cast to non-null type java.nio.Buffer");
        return ((Buffer)byteBuffer).position();
    }

    @Override
    public void setPosition(int value2) {
        ByteBuffer byteBuffer = this.buffer;
        Intrinsics.checkNotNull(byteBuffer, "null cannot be cast to non-null type java.nio.Buffer");
        ((Buffer)byteBuffer).position(value2);
    }

    @Override
    public int getPositionElements() {
        ByteBuffer byteBuffer = this.buffer;
        Intrinsics.checkNotNull(byteBuffer, "null cannot be cast to non-null type java.nio.Buffer");
        return ((Buffer)byteBuffer).position() / this.elementSize;
    }

    @Override
    public void setPositionElements(int value2) {
        ByteBuffer byteBuffer = this.buffer;
        Intrinsics.checkNotNull(byteBuffer, "null cannot be cast to non-null type java.nio.Buffer");
        ((Buffer)byteBuffer).position(value2 * this.elementSize);
    }

    @Override
    public void rewind() {
        ByteBuffer byteBuffer = this.buffer;
        Intrinsics.checkNotNull(byteBuffer, "null cannot be cast to non-null type java.nio.Buffer");
        ((Buffer)byteBuffer).rewind();
    }
}

