/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.internal.gl3;

import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.UByte;
import kotlin.UShort;
import kotlin.UnsignedKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.BufferUtils;
import org.openrndr.color.ColorRGBa;
import org.openrndr.draw.BufferWriter;
import org.openrndr.draw.ColorBuffer;
import org.openrndr.draw.ColorBufferShadow;
import org.openrndr.draw.ColorType;
import org.openrndr.internal.gl3.BufferWriterGL3;
import org.openrndr.internal.gl3.ColorBufferGL3;
import org.openrndr.internal.gl3.ColorBufferShadowGL3Kt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0013H\u0016J\b\u0010\u0015\u001a\u00020\u0013H\u0016J8\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u001aH\u0016J\u0018\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\tH\u0016J\b\u0010 \u001a\u00020!H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u0014\u0010\u000e\u001a\u00020\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\""}, d2={"Lorg/openrndr/internal/gl3/ColorBufferShadowGL3;", "Lorg/openrndr/draw/ColorBufferShadow;", "colorBuffer", "Lorg/openrndr/internal/gl3/ColorBufferGL3;", "<init>", "(Lorg/openrndr/internal/gl3/ColorBufferGL3;)V", "getColorBuffer", "()Lorg/openrndr/internal/gl3/ColorBufferGL3;", "size", "", "getSize", "()I", "elementSize", "getElementSize", "buffer", "Ljava/nio/ByteBuffer;", "getBuffer", "()Ljava/nio/ByteBuffer;", "download", "", "upload", "destroy", "write", "x", "y", "r", "", "g", "b", "a", "read", "Lorg/openrndr/color/ColorRGBa;", "writer", "Lorg/openrndr/draw/BufferWriter;", "openrndr-gl3"})
@SourceDebugExtension(value={"SMAP\nColorBufferShadowGL3.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ColorBufferShadowGL3.kt\norg/openrndr/internal/gl3/ColorBufferShadowGL3\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,122:1\n1#2:123\n*E\n"})
public final class ColorBufferShadowGL3
implements ColorBufferShadow {
    @NotNull
    private final ColorBufferGL3 colorBuffer;
    private final int size;
    private final int elementSize;
    @NotNull
    private final ByteBuffer buffer;

    public ColorBufferShadowGL3(@NotNull ColorBufferGL3 colorBuffer) {
        Intrinsics.checkNotNullParameter(colorBuffer, "colorBuffer");
        this.colorBuffer = colorBuffer;
        this.size = this.getColorBuffer().getEffectiveWidth() * this.getColorBuffer().getEffectiveHeight();
        this.elementSize = this.getColorBuffer().getFormat().getComponentCount() * this.getColorBuffer().getType().getComponentSize();
        ByteBuffer byteBuffer = BufferUtils.createByteBuffer(this.elementSize * this.size);
        Intrinsics.checkNotNullExpressionValue(byteBuffer, "createByteBuffer(...)");
        this.buffer = byteBuffer;
    }

    @Override
    @NotNull
    public ColorBufferGL3 getColorBuffer() {
        return this.colorBuffer;
    }

    public final int getSize() {
        return this.size;
    }

    public final int getElementSize() {
        return this.elementSize;
    }

    @Override
    @NotNull
    public ByteBuffer getBuffer() {
        return this.buffer;
    }

    @Override
    public void download() {
        ColorBufferShadowGL3Kt.access$getLogger$p().trace(ColorBufferShadowGL3::download$lambda$0);
        ColorBuffer.read$default(this.getColorBuffer(), this.getBuffer(), null, null, 0, 14, null);
    }

    @Override
    public void upload() {
        ColorBuffer.write$default(this.getColorBuffer(), this.getBuffer(), null, null, 0, 14, null);
    }

    @Override
    public void destroy() {
        this.getColorBuffer().destroyShadow();
    }

    @Override
    public void write(int x, int y, double r, double g, double b, double a) {
        int ay = this.getColorBuffer().getFlipV() ? y : this.getColorBuffer().getEffectiveHeight() - 1 - y;
        int offset = (ay * this.getColorBuffer().getEffectiveWidth() + x) * this.getColorBuffer().getFormat().getComponentCount() * this.getColorBuffer().getType().getComponentSize();
        int cc = this.getColorBuffer().getFormat().getComponentCount();
        switch (WhenMappings.$EnumSwitchMapping$0[this.getColorBuffer().getType().ordinal()]) {
            case 1: {
                byte ir = (byte)RangesKt.coerceIn(r * (double)255, 0.0, 255.0);
                byte ig = (byte)RangesKt.coerceIn(g * (double)255, 0.0, 255.0);
                byte ib = (byte)RangesKt.coerceIn(b * (double)255, 0.0, 255.0);
                byte ia = (byte)RangesKt.coerceIn(a * (double)255, 0.0, 255.0);
                this.getBuffer().put(offset, ir);
                if (cc > 1) {
                    this.getBuffer().put(offset + 1, ig);
                }
                if (cc > 2) {
                    this.getBuffer().put(offset + 2, ib);
                }
                if (cc <= 3) break;
                this.getBuffer().put(offset + 3, ia);
                break;
            }
            case 2: {
                short ir = (short)RangesKt.coerceIn(r * (double)65535, 0.0, 65535.0);
                short ig = (short)RangesKt.coerceIn(g * (double)65535, 0.0, 65535.0);
                short ib = (short)RangesKt.coerceIn(b * (double)65335, 0.0, 65535.0);
                short ia = (short)RangesKt.coerceIn(a * (double)65535, 0.0, 65535.0);
                this.getBuffer().putShort(offset, ir);
                if (cc > 1) {
                    this.getBuffer().putShort(offset + 2, ig);
                }
                if (cc > 2) {
                    this.getBuffer().putShort(offset + 4, ib);
                }
                if (cc <= 3) break;
                this.getBuffer().putShort(offset + 6, ia);
                break;
            }
            case 3: {
                this.getBuffer().putFloat(offset, (float)r);
                if (cc > 1) {
                    this.getBuffer().putFloat(offset + 4, (float)g);
                }
                if (cc > 2) {
                    this.getBuffer().putFloat(offset + 8, (float)b);
                }
                if (cc <= 3) break;
                this.getBuffer().putFloat(offset + 12, (float)a);
                break;
            }
            default: {
                String string = "support for " + this.getColorBuffer().getType();
                throw new NotImplementedError("An operation is not implemented: " + string);
            }
        }
    }

    @Override
    @NotNull
    public ColorRGBa read(int x, int y) {
        int ay = this.getColorBuffer().getFlipV() ? y : this.getColorBuffer().getEffectiveHeight() - 1 - y;
        int offset = (ay * this.getColorBuffer().getEffectiveWidth() + x) * this.getColorBuffer().getFormat().getComponentCount() * this.getColorBuffer().getType().getComponentSize();
        if (!(x >= 0 && x < this.getColorBuffer().getEffectiveWidth())) {
            boolean $i$a$-require-ColorBufferShadowGL3$read$52 = false;
            String $i$a$-require-ColorBufferShadowGL3$read$52 = "x out of bounds (0 < " + x + " < " + this.getColorBuffer().getEffectiveWidth();
            throw new IllegalArgumentException($i$a$-require-ColorBufferShadowGL3$read$52.toString());
        }
        if (!(y >= 0 && y < this.getColorBuffer().getEffectiveHeight())) {
            boolean $i$a$-require-ColorBufferShadowGL3$read$62 = false;
            String $i$a$-require-ColorBufferShadowGL3$read$62 = "y out of bounds (0 < " + y + " < " + this.getColorBuffer().getEffectiveHeight();
            throw new IllegalArgumentException($i$a$-require-ColorBufferShadowGL3$read$62.toString());
        }
        if (!(offset >= 0)) {
            boolean $i$a$-require-ColorBufferShadowGL3$read$72 = false;
            String $i$a$-require-ColorBufferShadowGL3$read$72 = "offset > 0 (" + offset + ")";
            throw new IllegalArgumentException($i$a$-require-ColorBufferShadowGL3$read$72.toString());
        }
        if (!(offset < this.size * this.elementSize)) {
            boolean bl = false;
            String string = "offset < " + this.size + " (" + offset + ")";
            throw new IllegalArgumentException(string.toString());
        }
        int cc = this.getColorBuffer().getFormat().getComponentCount();
        return switch (WhenMappings.$EnumSwitchMapping$0[this.getColorBuffer().getType().ordinal()]) {
            case 1 -> {
                byte ir = UByte.constructor-impl(this.getBuffer().get(offset));
                byte ig = cc >= 2 ? UByte.constructor-impl(this.getBuffer().get(offset + 1)) : (byte)0;
                byte ib = cc >= 3 ? UByte.constructor-impl(this.getBuffer().get(offset + 2)) : (byte)0;
                int ia = cc >= 4 ? (int)UByte.constructor-impl(this.getBuffer().get(offset + 3)) : -1;
                yield new ColorRGBa(UnsignedKt.uintToDouble(ir & 0xFF) / 255.0, UnsignedKt.uintToDouble(ig & 0xFF) / 255.0, UnsignedKt.uintToDouble(ib & 0xFF) / 255.0, UnsignedKt.uintToDouble(ia & 0xFF) / 255.0, null, 16, null);
            }
            case 2 -> {
                short ir = UShort.constructor-impl(this.getBuffer().getShort(offset));
                short ig = cc >= 2 ? UShort.constructor-impl(this.getBuffer().getShort(offset + 2)) : (short)0;
                short ib = cc >= 3 ? UShort.constructor-impl(this.getBuffer().getShort(offset + 4)) : (short)0;
                int ia = cc >= 4 ? (int)UShort.constructor-impl(this.getBuffer().getShort(offset + 6)) : -1;
                yield new ColorRGBa(UnsignedKt.uintToDouble(ir & 0xFFFF) / 65535.0, UnsignedKt.uintToDouble(ig & 0xFFFF) / 65535.0, UnsignedKt.uintToDouble(ib & 0xFFFF) / 65535.0, UnsignedKt.uintToDouble(ia & 0xFFFF) / 65535.0, null, 16, null);
            }
            case 3 -> {
                float fr = this.getBuffer().getFloat(offset);
                float fg = cc >= 2 ? this.getBuffer().getFloat(offset + 4) : 0.0f;
                float fb = cc >= 3 ? this.getBuffer().getFloat(offset + 8) : 0.0f;
                float fa = cc >= 4 ? this.getBuffer().getFloat(offset + 12) : 1.0f;
                yield new ColorRGBa(fr, fg, fb, fa, null, 16, null);
            }
            default -> {
                String var7_17 = "support for " + this.getColorBuffer().getType();
                throw new NotImplementedError("An operation is not implemented: " + var7_17);
            }
        };
    }

    @Override
    @NotNull
    public BufferWriter writer() {
        return new BufferWriterGL3(this.getBuffer(), 0, 2, null);
    }

    @Override
    public void write(int x, int y, @NotNull ColorRGBa color) {
        ColorBufferShadow.DefaultImpls.write(this, x, y, color);
    }

    @Override
    public void write(int x, int y, float r, float g, float b, float a) {
        ColorBufferShadow.DefaultImpls.write(this, x, y, r, g, b, a);
    }

    @Override
    @NotNull
    public ColorRGBa get(int x, int y) {
        return ColorBufferShadow.DefaultImpls.get(this, x, y);
    }

    @Override
    public void set(int x, int y, @NotNull ColorRGBa c2) {
        ColorBufferShadow.DefaultImpls.set(this, x, y, c2);
    }

    private static final Object download$lambda$0() {
        return "downloading colorbuffer into shadow";
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ColorType.values().length];
            try {
                nArray[ColorType.UINT8.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ColorType.UINT16.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ColorType.FLOAT32.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

