/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.internal.gl3;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.system.MemoryUtil;
import org.openrndr.binpack.IntPacker;
import org.openrndr.binpack.PackNode;
import org.openrndr.draw.CharacterPair;
import org.openrndr.draw.ColorBuffer;
import org.openrndr.draw.ColorBufferKt;
import org.openrndr.draw.ColorFormat;
import org.openrndr.draw.FontImageMap;
import org.openrndr.draw.GlyphMetrics;
import org.openrndr.draw.Session;
import org.openrndr.draw.font.Face;
import org.openrndr.draw.font.FontKt;
import org.openrndr.draw.font.Glyph;
import org.openrndr.internal.FontMapManager;
import org.openrndr.internal.gl3.FontImageMapManagerKt;
import org.openrndr.math.IntVector2;
import org.openrndr.shape.IntRectangle;
import org.openrndr.shape.IntRectangleKt;
import org.openrndr.utils.buffer.MPPBuffer;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\"\n\u0002\u0010\f\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J.\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\tH\u0016\u00a8\u0006\u000e"}, d2={"Lorg/openrndr/internal/gl3/FontImageMapManager;", "Lorg/openrndr/internal/FontMapManager;", "<init>", "()V", "fontMapFromUrl", "Lorg/openrndr/draw/FontImageMap;", "url", "", "size", "", "characterSet", "", "", "contentScale", "openrndr-gl3"})
@SourceDebugExtension(value={"SMAP\nFontImageMapManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FontImageMapManager.kt\norg/openrndr/internal/gl3/FontImageMapManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,129:1\n1279#2,2:130\n1293#2,4:132\n1062#2:136\n1863#2,2:137\n*S KotlinDebug\n*F\n+ 1 FontImageMapManager.kt\norg/openrndr/internal/gl3/FontImageMapManager\n*L\n29#1:130,2\n29#1:132,4\n64#1:136\n64#1:137,2\n*E\n"})
public final class FontImageMapManager
extends FontMapManager {
    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public FontImageMap fontMapFromUrl(@NotNull String url, double size, @NotNull Set<Character> characterSet, double contentScale) {
        FontImageMap fontImageMap;
        void $this$forEach$iv;
        IntPacker packer;
        PackNode root;
        int n;
        Intrinsics.checkNotNullParameter(url, "url");
        Intrinsics.checkNotNullParameter(characterSet, "characterSet");
        FontImageMapManagerKt.access$getLogger$p().debug(() -> FontImageMapManager.fontMapFromUrl$lambda$0(contentScale));
        Ref.IntRef packSize = new Ref.IntRef();
        packSize.element = 256;
        Face face = FontKt.loadFace(url);
        Iterable $this$associateWith$iv = characterSet;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($this$associateWith$iv, 10)), 16));
        Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            void c2;
            char c3 = ((Character)element$iv$iv).charValue();
            Object t = element$iv$iv;
            Map map2 = result$iv;
            n = 0;
            IntRectangle bounds = Glyph.DefaultImpls.bitmapBounds$default(face.glyphForCharacter((char)c2), size * contentScale, false, 2, null);
            IntVector2 intVector2 = new IntVector2(bounds.width(), bounds.height());
            map2.put(t, intVector2);
        }
        Map glyphDimensions = result$iv;
        int sanding = 3;
        while (!FontImageMapManagerKt.attemptPack(root = new PackNode(IntRectangleKt.IntRectangle(0, 0, packSize.element, packSize.element), null, 2, null), packer = new IntPacker(null, null, null, 7, null), glyphDimensions, sanding)) {
            packSize.element *= 2;
        }
        FontImageMapManagerKt.access$getLogger$p().debug(() -> FontImageMapManager.fontMapFromUrl$lambda$2(packSize));
        ColorBuffer image = ColorBufferKt.colorBuffer$default(packSize.element, packSize.element, 1.0, ColorFormat.R, null, null, 0, Session.Companion.getRoot(), 112, null);
        Map map3 = new LinkedHashMap();
        PackNode root2 = new PackNode(IntRectangleKt.IntRectangle(0, 0, packSize.element, packSize.element), null, 2, null);
        IntPacker packer2 = new IntPacker(null, null, null, 7, null);
        Map glyphMetrics = new LinkedHashMap();
        ByteBuffer bitmap = MemoryUtil.memAlloc(packSize.element * packSize.element);
        n = packSize.element * packSize.element;
        for (int i = 0; i < n; ++i) {
            bitmap.put((byte)0);
        }
        bitmap.rewind();
        FontImageMapManagerKt.access$getLogger$p().debug(FontImageMapManager::fontMapFromUrl$lambda$3);
        Iterable $this$sortedByDescending$iv = glyphDimensions.entrySet();
        boolean $i$f$sortedByDescending = false;
        $this$sortedByDescending$iv = CollectionsKt.sortedWith($this$sortedByDescending$iv, new Comparator(){

            public final int compare(T a, T b) {
                Map.Entry it = (Map.Entry)b;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(((IntVector2)it.getValue()).squaredLength());
                it = (Map.Entry)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues(comparable2, ((IntVector2)it.getValue()).squaredLength());
            }
        });
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PackNode t;
            Map.Entry it = (Map.Entry)element$iv;
            boolean bl = false;
            PackNode target = IntPacker.insert$default(packer2, root2, IntRectangleKt.IntRectangle(0, 0, ((IntVector2)it.getValue()).x() + 2 * sanding, ((IntVector2)it.getValue()).y() + 2 * sanding), null, 4, null);
            if (target == null) continue;
            boolean bl2 = false;
            map3.put(it.getKey(), IntRectangleKt.IntRectangle(t.getArea().x() + sanding, t.getArea().y() + sanding, t.getArea().width() - 2 * sanding, t.getArea().height() - 2 * sanding));
            Glyph glyph = face.glyphForCharacter(((Character)it.getKey()).charValue());
            IntRectangle bitmapBounds = Glyph.DefaultImpls.bitmapBounds$default(glyph, size * contentScale, false, 2, null);
            glyphMetrics.put(it.getKey(), new GlyphMetrics(glyph.advanceWidth(size), glyph.leftSideBearing(size), bitmapBounds.x(), bitmapBounds.y()));
            Intrinsics.checkNotNull(bitmap, "null cannot be cast to non-null type java.nio.Buffer");
            ((Buffer)bitmap).rewind();
            ((Buffer)bitmap).position((sanding + t.getArea().y()) * packSize.element + sanding + t.getArea().x());
            glyph.rasterize(size * contentScale, new MPPBuffer(bitmap), packSize.element, true);
        }
        FontImageMapManagerKt.access$getLogger$p().debug(FontImageMapManager::fontMapFromUrl$lambda$7);
        Intrinsics.checkNotNull(bitmap, "null cannot be cast to non-null type java.nio.Buffer");
        ((Buffer)bitmap).rewind();
        ColorBuffer.write$default(image, bitmap, null, null, 0, 14, null);
        MemoryUtil.memFree(bitmap);
        double ascent = face.ascent(size * contentScale);
        double descent = face.descent(size * contentScale);
        double leading = face.lineSpace(size * contentScale);
        FontImageMap $this$fontMapFromUrl_u24lambda_u248 = fontImageMap = new FontImageMap(image, map3, glyphMetrics, size, contentScale, ascent / contentScale, descent / contentScale, (ascent + descent) / contentScale, leading / contentScale, url);
        boolean bl = false;
        for (char outer : characterSet) {
            for (char inner : characterSet) {
                $this$fontMapFromUrl_u24lambda_u248.getKerningTable().put(new CharacterPair(outer, inner), face.kernAdvance(size, outer, inner));
            }
        }
        return fontImageMap;
    }

    private static final Object fontMapFromUrl$lambda$0(double $contentScale) {
        return "content scale " + $contentScale;
    }

    private static final Object fontMapFromUrl$lambda$2(Ref.IntRef $packSize) {
        Intrinsics.checkNotNullParameter($packSize, "$packSize");
        return "final map size " + $packSize.element + "x" + $packSize.element;
    }

    private static final Object fontMapFromUrl$lambda$3() {
        return "creating font bitmap";
    }

    private static final Object fontMapFromUrl$lambda$7() {
        return "uploading bitmap to color buffer";
    }
}

