/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.internal.gl3;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.PointerBuffer;
import org.lwjgl.stb.STBIWriteCallback;
import org.lwjgl.stb.STBImage;
import org.lwjgl.stb.STBImageWrite;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.util.tinyexr.EXRChannelInfo;
import org.lwjgl.util.tinyexr.EXRHeader;
import org.lwjgl.util.tinyexr.EXRImage;
import org.lwjgl.util.tinyexr.EXRVersion;
import org.lwjgl.util.tinyexr.TinyEXR;
import org.openrndr.dds.DDSData;
import org.openrndr.dds.DDSReaderFunctions;
import org.openrndr.dds.DDSReaderKt;
import org.openrndr.draw.ColorFormat;
import org.openrndr.draw.ColorType;
import org.openrndr.draw.ImageFileDetails;
import org.openrndr.draw.ImageFileFormat;
import org.openrndr.internal.CubemapImageData;
import org.openrndr.internal.ImageData;
import org.openrndr.internal.ImageDriver;
import org.openrndr.internal.gl3.CubemapImageDataDds;
import org.openrndr.internal.gl3.ImageDataDds;
import org.openrndr.internal.gl3.ImageDataStb;
import org.openrndr.utils.buffer.MPPBuffer;
import org.openrndr.utils.url.TextFromURLKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016J\u001a\u0010\f\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016J$\u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\t2\b\u0010\u000e\u001a\u0004\u0018\u00010\u00072\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016J\"\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u00072\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016J\u001a\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\r2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016J\u001a\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016J$\u0010\u0014\u001a\u00020\u00152\u0006\u0010\b\u001a\u00020\t2\b\u0010\u000e\u001a\u0004\u0018\u00010\u00072\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016\u00a8\u0006\u0016"}, d2={"Lorg/openrndr/internal/gl3/ImageDriverStbImage;", "Lorg/openrndr/internal/ImageDriver;", "<init>", "()V", "probeImage", "Lorg/openrndr/draw/ImageFileDetails;", "fileOrUrl", "", "buffer", "Lorg/openrndr/utils/buffer/MPPBuffer;", "formatHint", "Lorg/openrndr/draw/ImageFileFormat;", "loadImage", "Lorg/openrndr/internal/ImageData;", "name", "saveImage", "", "imageData", "filename", "imageToDataUrl", "loadCubemapImage", "Lorg/openrndr/internal/CubemapImageData;", "openrndr-gl3"})
@SourceDebugExtension(value={"SMAP\nImageDriverStbImage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ImageDriverStbImage.kt\norg/openrndr/internal/gl3/ImageDriverStbImage\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,771:1\n1#2:772\n1557#3:773\n1628#3,3:774\n1557#3:777\n1628#3,3:778\n1557#3:781\n1628#3,3:782\n1557#3:785\n1628#3,3:786\n1557#3:789\n1628#3,3:790\n2632#3,3:793\n1557#3:796\n1628#3,3:797\n1863#3,2:800\n*S KotlinDebug\n*F\n+ 1 ImageDriverStbImage.kt\norg/openrndr/internal/gl3/ImageDriverStbImage\n*L\n427#1:773\n427#1:774,3\n429#1:777\n429#1:778,3\n437#1:781\n437#1:782,3\n438#1:785\n438#1:786,3\n439#1:789\n439#1:790,3\n442#1:793,3\n444#1:796\n444#1:797,3\n445#1:800,2\n*E\n"})
public final class ImageDriverStbImage
implements ImageDriver {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public ImageFileDetails probeImage(@NotNull String fileOrUrl) {
        Throwable throwable;
        Closeable closeable;
        Serializable it;
        Intrinsics.checkNotNullParameter(fileOrUrl, "fileOrUrl");
        Pair<File, URL> pair = TextFromURLKt.resolveFileOrUrl(fileOrUrl);
        File file = pair.component1();
        URL url = pair.component2();
        byte[] header = new byte[1024];
        URL uRL = url;
        if (uRL != null) {
            it = uRL;
            boolean bl = false;
            closeable = it.openStream();
            throwable = null;
            try {
                InputStream stream22 = (InputStream)closeable;
                boolean bl2 = false;
                int stream22 = stream22.read(header);
            }
            catch (Throwable stream22) {
                throwable = stream22;
                throw stream22;
            }
            finally {
                CloseableKt.closeFinally(closeable, throwable);
            }
        }
        File file2 = file;
        if (file2 != null) {
            it = file2;
            boolean bl = false;
            closeable = new FileInputStream((File)it);
            throwable = null;
            try {
                FileInputStream stream = (FileInputStream)closeable;
                boolean bl3 = false;
                int n = stream.read(header);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally(closeable, throwable);
            }
        }
        AutoCloseable autoCloseable = MemoryStack.stackPush();
        Throwable throwable3 = null;
        try {
            MemoryStack stack = (MemoryStack)autoCloseable;
            boolean bl = false;
            ByteBuffer bb = stack.malloc(header.length);
            bb.put(header);
            bb.flip();
            Intrinsics.checkNotNull(bb);
            ImageFileDetails imageFileDetails = this.probeImage(new MPPBuffer(bb), null);
            return imageFileDetails;
        }
        catch (Throwable throwable4) {
            throwable3 = throwable4;
            throw throwable4;
        }
        finally {
            AutoCloseableKt.closeFinally(autoCloseable, throwable3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public ImageFileDetails probeImage(@NotNull MPPBuffer buffer, @Nullable ImageFileFormat formatHint) {
        Intrinsics.checkNotNullParameter(buffer, "buffer");
        AutoCloseable autoCloseable = MemoryStack.stackPush();
        Throwable throwable = null;
        try {
            MemoryStack stack = (MemoryStack)autoCloseable;
            boolean bl = false;
            IntBuffer x = stack.mallocInt(1);
            IntBuffer y = stack.mallocInt(1);
            IntBuffer channels = stack.mallocInt(1);
            boolean result2 = STBImage.stbi_info_from_memory(buffer.getByteBuffer(), x, y, channels);
            if (result2) {
                ImageFileDetails imageFileDetails = new ImageFileDetails(x.get(), y.get(), channels.get());
                return imageFileDetails;
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally(autoCloseable, throwable);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public ImageData loadImage(@NotNull String fileOrUrl, @Nullable ImageFileFormat formatHint) {
        ImageData imageData;
        Object object;
        Intrinsics.checkNotNullParameter(fileOrUrl, "fileOrUrl");
        if (StringsKt.startsWith$default(fileOrUrl, "data:", false, 2, null)) {
            Base64.Decoder decoder = Base64.getDecoder();
            int commaIndex = StringsKt.indexOf$default((CharSequence)fileOrUrl, ",", 0, false, 6, null);
            String base64Data = StringsKt.replace$default(StringsKt.drop(fileOrUrl, commaIndex + 1), "\n", "", false, 4, null);
            byte[] decoded = decoder.decode(base64Data);
            ByteBuffer buffer = ByteBuffer.allocateDirect(decoded.length);
            buffer.put(decoded);
            Intrinsics.checkNotNull(buffer, "null cannot be cast to non-null type java.nio.Buffer");
            ((Buffer)buffer).rewind();
            return this.loadImage(new MPPBuffer(buffer), "data-url", formatHint);
        }
        try {
            object = new URL(fileOrUrl);
        }
        catch (MalformedURLException e) {
            object = null;
        }
        URL url = object;
        if (url != null) {
            object = url.openStream();
            Throwable e = null;
            try {
                ImageData imageData2;
                AutoCloseable it = (InputStream)object;
                boolean bl = false;
                byte[] byteArray = TextStreamsKt.readBytes(url);
                if (byteArray.length == 0) {
                    throw new IllegalStateException(("read 0 bytes from stream " + fileOrUrl).toString());
                }
                ByteBuffer buffer = MemoryUtil.memAlloc(byteArray.length);
                buffer.put(byteArray);
                buffer.flip();
                try {
                    Intrinsics.checkNotNull(buffer);
                    imageData2 = this.loadImage(new MPPBuffer(buffer), fileOrUrl, formatHint);
                }
                finally {
                    MemoryUtil.memFree(buffer);
                }
                it = imageData2;
            }
            catch (Throwable it) {
                e = it;
                throw it;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, e);
            }
            return it;
        }
        Path path = Path.of(fileOrUrl, new String[0]);
        Intrinsics.checkNotNullExpressionValue(path, "of(...)");
        object = path;
        LinkOption[] e = new LinkOption[]{};
        if (!Files.exists((Path)object, Arrays.copyOf(e, e.length))) {
            boolean bl = false;
            String string = fileOrUrl + " not found";
            throw new IllegalArgumentException(string.toString());
        }
        object = FileChannel.open(Path.of(fileOrUrl, new String[0]), new OpenOption[0]);
        Throwable throwable = null;
        try {
            ImageData imageData3;
            FileChannel channel = (FileChannel)object;
            boolean bl = false;
            ByteBuffer buffer = MemoryUtil.memAlloc((int)channel.size());
            channel.read(buffer);
            buffer.flip();
            try {
                Intrinsics.checkNotNull(buffer);
                imageData3 = this.loadImage(new MPPBuffer(buffer), fileOrUrl, formatHint);
            }
            finally {
                MemoryUtil.memFree(buffer);
            }
            imageData = imageData3;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, throwable);
        }
        return imageData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Override
    @NotNull
    public ImageData loadImage(@NotNull MPPBuffer buffer, @Nullable String name, @Nullable ImageFileFormat formatHint) {
        Intrinsics.checkNotNullParameter(buffer, "buffer");
        assumedFormat = ImageFileFormat.PNG;
        inputIsDirect = buffer.getByteBuffer().isDirect();
        if (inputIsDirect) {
            v0 = buffer.getByteBuffer();
        } else {
            it = var7_6 = MemoryUtil.memAlloc(buffer.getByteBuffer().remaining());
            $i$a$-also-ImageDriverStbImage$loadImage$buffer$1 = false;
            it.put(buffer.getByteBuffer());
            it.rewind();
            v0 = var7_6;
        }
        buffer = v0;
        try {
            if (formatHint != null) {
                assumedFormat = formatHint;
            }
            buffer.mark();
            switch (WhenMappings.$EnumSwitchMapping$1[assumedFormat.ordinal()]) {
                case 1: 
                case 2: {
                    wa = new int[1];
                    ha = new int[1];
                    ca = new int[1];
                    STBImage.stbi_set_flip_vertically_on_load(true);
                    STBImage.stbi_set_unpremultiply_on_load(false);
                    bitsPerChannel = assumedFormat == ImageFileFormat.PNG ? (STBImage.stbi_is_16_bit_from_memory(buffer) ? 16 : 8) : 8;
                    buffer.reset();
                    targetType = null;
                    mask = 0;
                    alphaOffset = 3;
                    redOffset = 0;
                    greenOffset = 1;
                    blueOffset = 2;
                    switch (bitsPerChannel) {
                        case 8: {
                            targetType = ColorType.UINT8;
                            mask = 255;
                            v1 = Unit.INSTANCE;
                            break;
                        }
                        case 16: {
                            targetType = ColorType.UINT16;
                            mask = 65535;
                            v1 = Unit.INSTANCE;
                            break;
                        }
                        default: {
                            throw new IllegalStateException(("unsupported bits per channel: " + bitsPerChannel).toString());
                        }
                    }
                    switch (bitsPerChannel) {
                        case 8: {
                            v2 = STBImage.stbi_load_from_memory(buffer, wa, ha, ca, 0);
                            if (v2 == null) {
                                throw new IllegalStateException("stbi_load returned null".toString());
                            }
                            v3 = new Pair<ByteBuffer, Object>(v2, null);
                            break;
                        }
                        case 16: {
                            v4 = STBImage.stbi_load_16_from_memory(buffer, wa, ha, ca, 0);
                            if (v4 == null) {
                                throw new IllegalStateException("stdi_load returned null".toString());
                            }
                            v3 = new Pair<Object, ShortBuffer>(null, v4);
                            break;
                        }
                        default: {
                            throw new IllegalStateException(("unsupported bits per channel: " + bitsPerChannel).toString());
                        }
                    }
                    var19_54 = v3;
                    tdata8 = var19_54.component1();
                    tdata16 = var19_54.component2();
                    if (tdata8 != null) {
                        offset = 0;
                        if (ca[0] == 4) {
                            var24_67 = ha[0];
                            for (y = 0; y < var24_67; ++y) {
                                var26_77 = wa[0];
                                for (x = 0; x < var26_77; ++x) {
                                    a = (double)(tdata8.get(offset + alphaOffset) & mask) / (double)mask;
                                    r = (double)(tdata8.get(offset + redOffset) & mask) * a;
                                    g = (double)(tdata8.get(offset + greenOffset) & mask) * a;
                                    b = (double)(tdata8.get(offset + blueOffset) & mask) * a;
                                    tdata8.put(offset + redOffset, (byte)r);
                                    tdata8.put(offset + greenOffset, (byte)g);
                                    tdata8.put(offset + blueOffset, (byte)b);
                                    offset += 4;
                                }
                            }
                        }
                    }
                    v5 = tdata8;
                    if (v5 != null) {
                        it = v5;
                        $i$a$-let-ImageDriverStbImage$loadImage$data8$1 = 0;
                        if (ca[0] == 1) {
                            roffset = 0;
                            woffset = 0;
                            data8 = ByteBuffer.allocateDirect(tdata8.capacity() * 3);
                            var30_120 = ha[0];
                            for (y = 0; y < var30_120; ++y) {
                                var32_129 = wa[0];
                                for (x = 0; x < var32_129; ++x) {
                                    r = tdata8.get(roffset);
                                    data8.put(woffset + 0, r);
                                    data8.put(woffset + 1, r);
                                    data8.put(woffset + 2, r);
                                    ++roffset;
                                    woffset += 3;
                                }
                            }
                            v6 = data8;
                        } else {
                            v6 = tdata8;
                        }
                    } else {
                        v6 = data8 = null;
                    }
                    if (tdata16 != null) {
                        offset = 0;
                        if (ca[0] == 4) {
                            $i$a$-let-ImageDriverStbImage$loadImage$data8$1 = ha[0];
                            for (y = 0; y < $i$a$-let-ImageDriverStbImage$loadImage$data8$1; ++y) {
                                woffset = wa[0];
                                for (x = 0; x < woffset; ++x) {
                                    a = (double)(tdata16.get(offset + alphaOffset) & mask) / (double)mask;
                                    r = (double)(tdata16.get(offset + redOffset) & mask) * a;
                                    g = (double)(tdata16.get(offset + greenOffset) & mask) * a;
                                    b = (double)(tdata16.get(offset + blueOffset) & mask) * a;
                                    tdata16.put(offset + redOffset, (short)r);
                                    tdata16.put(offset + greenOffset, (short)g);
                                    tdata16.put(offset + blueOffset, (short)b);
                                    offset += 4;
                                }
                            }
                        }
                    }
                    data16 = tdata16;
                    v7 = data8;
                    if (v7 == null) ** GOTO lbl148
                    it = v7;
                    $i$a$-let-ImageDriverStbImage$loadImage$copyData$1 = false;
                    v8 = MemoryUtil.memAlloc(it.capacity());
                    v7 = v8;
                    if (v8 != null) ** GOTO lbl159
lbl148:
                    // 2 sources

                    v9 = data16;
                    if (v9 != null) {
                        it = v9;
                        $i$a$-let-ImageDriverStbImage$loadImage$copyData$2 = false;
                        v10 = MemoryUtil.memAlloc(it.capacity() * 2);
                    } else {
                        v10 = v7 = null;
                    }
                    if (v10 == null) {
                        throw new IllegalStateException(("alloc failed, data8: " + data8 + ", data16: " + data16 + ", " + assumedFormat + ", " + bitsPerChannel).toString());
                    }
lbl159:
                    // 3 sources

                    copyData = v7;
                    v11 = data8;
                    if (v11 != null) {
                        it /* !! */  = v11;
                        $i$a$-let-ImageDriverStbImage$loadImage$source$1 = false;
                        v12 = MemoryUtil.memAddress(it /* !! */ );
                    } else {
                        v13 = data16;
                        if (v13 != null) {
                            it /* !! */  = v13;
                            $i$a$-let-ImageDriverStbImage$loadImage$source$2 = false;
                            v12 = MemoryUtil.memAddress((ShortBuffer)it /* !! */ );
                        } else {
                            throw new IllegalStateException("get address failed".toString());
                        }
                    }
                    source = v12;
                    dest = MemoryUtil.memAddress(copyData);
                    MemoryUtil.memCopy(source, dest, copyData.capacity());
                    v14 = tdata8;
                    if (v14 != null) {
                        it /* !! */  = v14;
                        $i$a$-let-ImageDriverStbImage$loadImage$4 = false;
                        STBImage.stbi_image_free(it /* !! */ );
                        v15 = Unit.INSTANCE;
                    } else {
                        v15 = null;
                    }
                    v16 = tdata16;
                    if (v16 != null) {
                        it /* !! */  = v16;
                        $i$a$-let-ImageDriverStbImage$loadImage$5 = false;
                        STBImage.stbi_image_free((ShortBuffer)it /* !! */ );
                        v17 = Unit.INSTANCE;
                    } else {
                        v17 = null;
                    }
                    v18 = wa[0];
                    v19 = ha[0];
                    switch (ca[0]) {
                        case 1: {
                            if (tdata16 != null) {
                                v20 = ColorFormat.R;
                                break;
                            }
                            v20 = ColorFormat.RGB;
                            break;
                        }
                        case 2: {
                            v20 = ColorFormat.RG;
                            break;
                        }
                        case 3: {
                            v20 = ColorFormat.RGB;
                            break;
                        }
                        case 4: {
                            v20 = ColorFormat.RGBa;
                            break;
                        }
                        default: {
                            throw new IllegalStateException(("invalid component count " + ca[0]).toString());
                        }
                    }
                    $i$a$-let-ImageDriverStbImage$loadImage$copyData$2 = new ImageDataStb(v18, v19, v20, targetType, false, new MPPBuffer(copyData), null, 64, null);
                    return $i$a$-let-ImageDriverStbImage$loadImage$copyData$2;
                }
                case 3: {
                    STBImage.stbi_set_flip_vertically_on_load(true);
                    wa = MemoryStack.stackPush();
                    ha = null;
                    try {
                        stack /* !! */  = (MemoryStack)wa;
                        $i$a$-use-ImageDriverStbImage$loadImage$6 = false;
                        if (!STBImage.stbi_is_hdr_from_memory(buffer)) {
                            $i$a$-require-ImageDriverStbImage$loadImage$6$1 = false;
                            $i$a$-require-ImageDriverStbImage$loadImage$6$1 = name + " does not contain HDR content";
                            throw new IllegalArgumentException($i$a$-require-ImageDriverStbImage$loadImage$6$1.toString());
                        }
                        sx = stack /* !! */ .mallocInt(1);
                        floats = STBImage.stbi_loadf_from_memory(buffer, sx, sy = stack /* !! */ .mallocInt(1), sc = stack /* !! */ .mallocInt(1), 3);
                        if (!(floats != null)) {
                            $i$a$-require-ImageDriverStbImage$loadImage$6$2 = false;
                            $i$a$-require-ImageDriverStbImage$loadImage$6$2 = "load from .hdr failed (" + name + ")";
                            throw new IllegalArgumentException($i$a$-require-ImageDriverStbImage$loadImage$6$2.toString());
                        }
                        copy = MemoryUtil.memAllocFloat(sx.get(0) * sy.get(0) * sc.get(0));
                        MemoryUtil.memCopy(floats, copy);
                        STBImage.stbi_image_free(floats);
                        v21 = sx.get(0);
                        v22 = sy.get(0);
                        v23 = MemoryUtil.memByteBuffer(copy);
                        Intrinsics.checkNotNullExpressionValue(v23, "memByteBuffer(...)");
                        stack /* !! */  = new ImageDataStb(v21, v22, ColorFormat.RGB, ColorType.FLOAT32, false, new MPPBuffer(v23), null, 64, null);
                    }
                    catch (Throwable stack) {
                        ha = stack;
                        throw stack;
                    }
                    finally {
                        AutoCloseableKt.closeFinally(wa, ha);
                    }
                    wa = (ImageData)stack /* !! */ ;
                    return wa;
                }
                case 4: {
                    Intrinsics.checkNotNull(buffer);
                    data = DDSReaderFunctions.loadDDS(buffer);
                    readBuffer = data.image(0);
                    if (!(readBuffer.remaining() > 0)) {
                        $i$a$-require-ImageDriverStbImage$loadImage$7 = false;
                        $i$a$-require-ImageDriverStbImage$loadImage$7 = "image buffer " + readBuffer + " has no remaining bytes";
                        throw new IllegalArgumentException($i$a$-require-ImageDriverStbImage$loadImage$7.toString());
                    }
                    stack = new ImageDataDds(data.width(), data.height(), data.format(), data.type(), data.flipV(), data.image(0), null, 64, null);
                    return stack;
                }
                case 5: {
                    exrHeader = EXRHeader.create();
                    exrVersion = EXRVersion.create();
                    versionResult = TinyEXR.ParseEXRVersionFromMemory(exrVersion, buffer);
                    buffer.rewind();
                    if (versionResult != 0) {
                        throw new IllegalStateException("failed to get version".toString());
                    }
                    errors = PointerBuffer.allocateDirect(1);
                    parseResult = TinyEXR.ParseEXRHeaderFromMemory(exrHeader, exrVersion, buffer, errors);
                    if (parseResult != 0) {
                        throw new IllegalStateException("failed to parse file".toString());
                    }
                    sc = exrHeader.num_channels();
                    for (i = 0; i < sc; ++i) {
                        exrHeader.requested_pixel_types().put(i, exrHeader.pixel_types().get(i));
                    }
                    exrImage = EXRImage.create();
                    TinyEXR.InitEXRImage(exrImage);
                    TinyEXR.LoadEXRImageFromMemory(exrImage, exrHeader, buffer, errors);
                    c = exrImage.num_channels();
                    switch (c) {
                        case 1: {
                            v24 = ColorFormat.R;
                            break;
                        }
                        case 3: {
                            v24 = ColorFormat.RGB;
                            break;
                        }
                        case 4: {
                            v24 = ColorFormat.RGBa;
                            break;
                        }
                        default: {
                            throw new IllegalStateException(("unsupported number of channels " + c).toString());
                        }
                    }
                    format = v24;
                    t = exrHeader.requested_pixel_types().get(0);
                    switch (t) {
                        case 1: {
                            v25 = ColorType.FLOAT16;
                            break;
                        }
                        case 2: {
                            v25 = ColorType.FLOAT32;
                            break;
                        }
                        default: {
                            throw new IllegalStateException(("unsupported pixel type [type=" + t + "]").toString());
                        }
                    }
                    type = v25;
                    height = exrImage.height();
                    width = exrImage.width();
                    channels = exrImage.num_channels();
                    data = MemoryUtil.memAlloc(format.getComponentCount() * type.getComponentSize() * exrImage.width() * exrImage.height());
                    $this$map$iv = RangesKt.until(0, exrHeader.num_channels());
                    $i$f$map = false;
                    copyData = $this$map$iv;
                    destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                    $i$f$mapTo = false;
                    dest = $this$mapTo$iv$iv.iterator();
                    while (dest.hasNext()) {
                        $i$a$-let-ImageDriverStbImage$loadImage$copyData$2 = item$iv$iv = ((IntIterator)dest).nextInt();
                        var36_137 = destination$iv$iv;
                        $i$a$-map-ImageDriverStbImage$loadImage$channelNames$1 = false;
                        var36_137.add(((EXRChannelInfo)exrHeader.channels().get((int)it)).nameString());
                    }
                    channelNames = (List)destination$iv$iv;
                    v26 = exrImage.images();
                    Intrinsics.checkNotNull(v26);
                    images = v26;
                    $this$map$iv = RangesKt.until(0, exrHeader.num_channels());
                    $i$f$map = false;
                    $i$f$mapTo = $this$map$iv;
                    destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                    $i$f$mapTo = false;
                    it /* !! */  = $this$mapTo$iv$iv.iterator();
                    while (it /* !! */ .hasNext()) {
                        $i$a$-let-ImageDriverStbImage$loadImage$5 = item$iv$iv = ((IntIterator)it /* !! */ ).nextInt();
                        var36_137 = destination$iv$iv;
                        $i$a$-map-ImageDriverStbImage$loadImage$channelImages$1 = false;
                        var36_137.add(images.getByteBuffer((int)it, width * height * type.getComponentSize()));
                    }
                    channelImages = (List)destination$iv$iv;
                    switch (WhenMappings.$EnumSwitchMapping$0[format.ordinal()]) {
                        case 1: {
                            $this$map$iv = CollectionsKt.listOf("R");
                            $i$f$map = false;
                            it /* !! */  = $this$map$iv;
                            destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                            $i$f$mapTo = false;
                            $i$a$-map-ImageDriverStbImage$loadImage$channelImages$1 = $this$mapTo$iv$iv.iterator();
                            while ($i$a$-map-ImageDriverStbImage$loadImage$channelImages$1.hasNext()) {
                                item$iv$iv = $i$a$-map-ImageDriverStbImage$loadImage$channelImages$1.next();
                                b = (String)item$iv$iv;
                                var36_137 = destination$iv$iv;
                                $i$a$-map-ImageDriverStbImage$loadImage$order$1 = false;
                                var36_137.add(channelNames.indexOf(it));
                            }
                            v27 = (List)destination$iv$iv;
                            break;
                        }
                        case 2: {
                            $this$map$iv = new String[]{"B", "G", "R"};
                            $this$map$iv = CollectionsKt.listOf($this$map$iv);
                            $i$f$map = false;
                            $this$mapTo$iv$iv = $this$map$iv;
                            destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                            $i$f$mapTo = false;
                            $i$a$-map-ImageDriverStbImage$loadImage$channelImages$1 = $this$mapTo$iv$iv.iterator();
                            while ($i$a$-map-ImageDriverStbImage$loadImage$channelImages$1.hasNext()) {
                                item$iv$iv = $i$a$-map-ImageDriverStbImage$loadImage$channelImages$1.next();
                                it = (String)item$iv$iv;
                                var36_137 = destination$iv$iv;
                                $i$a$-map-ImageDriverStbImage$loadImage$order$2 = false;
                                var36_137.add(channelNames.indexOf(it));
                            }
                            v27 = (List)destination$iv$iv;
                            break;
                        }
                        case 3: {
                            $this$map$iv = new String[]{"B", "G", "R", "A"};
                            $this$map$iv = CollectionsKt.listOf($this$map$iv);
                            $i$f$map = false;
                            $this$mapTo$iv$iv = $this$map$iv;
                            destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                            $i$f$mapTo = false;
                            $i$a$-map-ImageDriverStbImage$loadImage$channelImages$1 = $this$mapTo$iv$iv.iterator();
                            while ($i$a$-map-ImageDriverStbImage$loadImage$channelImages$1.hasNext()) {
                                item$iv$iv = $i$a$-map-ImageDriverStbImage$loadImage$channelImages$1.next();
                                it = (String)item$iv$iv;
                                var36_137 = destination$iv$iv;
                                $i$a$-map-ImageDriverStbImage$loadImage$order$3 = false;
                                var36_137.add(channelNames.indexOf(it));
                            }
                            v27 = (List)destination$iv$iv;
                            break;
                        }
                        default: {
                            throw new IllegalStateException("unsupported channel layout".toString());
                        }
                    }
                    order = v27;
                    $this$none$iv = order;
                    $i$f$none = false;
                    if (!($this$none$iv instanceof Collection) || !((Collection)$this$none$iv).isEmpty()) ** GOTO lbl410
                    v28 = true;
                    ** GOTO lbl417
lbl410:
                    // 2 sources

                    for (E element$iv : $this$none$iv) {
                        it = ((Number)element$iv).intValue();
                        $i$a$-none-ImageDriverStbImage$loadImage$8 = false;
                        if (!(it == -1)) continue;
                        v28 = false;
                        ** GOTO lbl417
                    }
                    v28 = true;
lbl417:
                    // 3 sources

                    if (!v28) {
                        $i$a$-require-ImageDriverStbImage$loadImage$9 = false;
                        $i$a$-require-ImageDriverStbImage$loadImage$9 = "some channels are not found";
                        throw new IllegalArgumentException($i$a$-require-ImageDriverStbImage$loadImage$9.toString());
                    }
                    $this$map$iv = order;
                    $i$f$map = false;
                    element$iv = $this$map$iv;
                    destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                    $i$f$mapTo = false;
                    $i$f$mapTo = $this$mapTo$iv$iv.iterator();
                    while ($i$f$mapTo.hasNext()) {
                        item$iv$iv = $i$f$mapTo.next();
                        item$iv$iv = ((Number)item$iv$iv).intValue();
                        var36_137 = destination$iv$iv;
                        $i$a$-map-ImageDriverStbImage$loadImage$orderedImages$1 = false;
                        var36_137.add((ByteBuffer)channelImages.get((int)it));
                    }
                    orderedImages = (List)destination$iv$iv;
                    $this$forEach$iv = orderedImages;
                    $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        it = (ByteBuffer)element$iv;
                        $i$a$-forEach-ImageDriverStbImage$loadImage$10 = false;
                        Intrinsics.checkNotNull(it, "null cannot be cast to non-null type java.nio.Buffer");
                        ((Buffer)it).rewind();
                    }
                    var27_91 = exrImage.height();
                    for (y = 0; y < var27_91; ++y) {
                        offset = (height - 1 - y) * format.getComponentCount() * type.getComponentSize() * width;
                        Intrinsics.checkNotNull(data, "null cannot be cast to non-null type java.nio.Buffer");
                        ((Buffer)data).position(offset);
                        var30_128 = exrImage.width();
                        for (x = 0; x < var30_128; ++x) {
                            for (c = 0; c < channels; ++c) {
                                var33_112 = type.getComponentSize();
                                for (i = 0; i < var33_112; ++i) {
                                    data.put(((ByteBuffer)orderedImages.get(c)).get());
                                }
                            }
                        }
                    }
                    Intrinsics.checkNotNull(data, "null cannot be cast to non-null type java.nio.Buffer");
                    ((Buffer)data).rewind();
                    TinyEXR.FreeEXRHeader(exrHeader);
                    TinyEXR.FreeEXRImage(exrImage);
                    var26_84 = new ImageDataStb(exrImage.width(), exrImage.height(), format, type, false, new MPPBuffer(data), null, 64, null);
                    return var26_84;
                }
            }
            throw new IllegalStateException("format not supported".toString());
        }
        finally {
            if (!inputIsDirect) {
                MemoryUtil.memFree(buffer);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void saveImage(@NotNull ImageData imageData, @NotNull String filename, @Nullable ImageFileFormat formatHint) {
        Intrinsics.checkNotNullParameter(imageData, "imageData");
        Intrinsics.checkNotNullParameter(filename, "filename");
        ImageFileFormat imageFileFormat = formatHint;
        if (imageFileFormat == null) {
            imageFileFormat = ImageFileFormat.PNG;
        }
        ImageFileFormat format = imageFileFormat;
        switch (WhenMappings.$EnumSwitchMapping$1[format.ordinal()]) {
            case 1: {
                Object object = imageData.getData();
                if (object == null || (object = ((MPPBuffer)object).getByteBuffer()) == null) {
                    throw new IllegalStateException("no data".toString());
                }
                ByteBuffer buffer = ImageDriverStbImage.saveImage$flipImage(imageData, (ByteBuffer)object);
                Pair<ColorFormat, ColorType> pair = new Pair<ColorFormat, ColorType>(imageData.getFormat(), imageData.getType());
                if (Intrinsics.areEqual(pair, new Pair<ColorFormat, ColorType>(ColorFormat.R, ColorType.UINT8)) || Intrinsics.areEqual(pair, new Pair<ColorFormat, ColorType>(ColorFormat.RGB, ColorType.UINT8)) || Intrinsics.areEqual(pair, new Pair<ColorFormat, ColorType>(ColorFormat.RGBa, ColorType.UINT8))) {
                    if (!STBImageWrite.stbi_write_png(filename, imageData.getWidth(), imageData.getHeight(), imageData.getFormat().getComponentCount(), buffer, imageData.getWidth() * imageData.getFormat().getComponentCount())) {
                        boolean $i$a$-require-ImageDriverStbImage$saveImage$52 = false;
                        String $i$a$-require-ImageDriverStbImage$saveImage$52 = "write to png failed";
                        throw new IllegalArgumentException($i$a$-require-ImageDriverStbImage$saveImage$52.toString());
                    }
                } else {
                    throw new IllegalStateException(("unsupported input for PNG (" + imageData.getType() + "/" + imageData.getType()).toString());
                }
                if (imageData.getFlipV()) break;
                MemoryUtil.memFree(buffer);
                break;
            }
            case 2: {
                Object object = imageData.getData();
                if (object == null || (object = ((MPPBuffer)object).getByteBuffer()) == null) {
                    throw new IllegalStateException("no data".toString());
                }
                ByteBuffer buffer = ImageDriverStbImage.saveImage$flipImage(imageData, (ByteBuffer)object);
                Pair<ColorFormat, ColorType> pair = new Pair<ColorFormat, ColorType>(imageData.getFormat(), imageData.getType());
                if (Intrinsics.areEqual(pair, new Pair<ColorFormat, ColorType>(ColorFormat.R, ColorType.UINT8)) || Intrinsics.areEqual(pair, new Pair<ColorFormat, ColorType>(ColorFormat.RGB, ColorType.UINT8)) || Intrinsics.areEqual(pair, new Pair<ColorFormat, ColorType>(ColorFormat.RGBa, ColorType.UINT8))) {
                    if (!STBImageWrite.stbi_write_jpg(filename, imageData.getWidth(), imageData.getHeight(), imageData.getFormat().getComponentCount(), buffer, imageData.getWidth() * imageData.getFormat().getComponentCount())) {
                        boolean $i$a$-require-ImageDriverStbImage$saveImage$62 = false;
                        String $i$a$-require-ImageDriverStbImage$saveImage$62 = "write to jpg failed";
                        throw new IllegalArgumentException($i$a$-require-ImageDriverStbImage$saveImage$62.toString());
                    }
                } else {
                    throw new IllegalStateException(("unsupported input for JPG (" + imageData.getType() + "/" + imageData.getType()).toString());
                }
                if (imageData.getFlipV()) break;
                MemoryUtil.memFree(buffer);
                break;
            }
            case 3: {
                if (Intrinsics.areEqual(new Pair<ColorFormat, ColorType>(imageData.getFormat(), imageData.getType()), new Pair<ColorFormat, ColorType>(ColorFormat.RGB, ColorType.FLOAT32))) {
                    Object object = imageData.getData();
                    if (object == null || (object = ((MPPBuffer)object).getByteBuffer()) == null || (object = ((ByteBuffer)object).asFloatBuffer()) == null) {
                        throw new IllegalStateException("no data".toString());
                    }
                    if (STBImageWrite.stbi_write_hdr((CharSequence)filename, imageData.getWidth(), imageData.getHeight(), imageData.getFormat().getComponentCount(), (FloatBuffer)object)) break;
                    boolean $i$a$-require-ImageDriverStbImage$saveImage$72 = false;
                    String $i$a$-require-ImageDriverStbImage$saveImage$72 = "write to hdr failed";
                    throw new IllegalArgumentException($i$a$-require-ImageDriverStbImage$saveImage$72.toString());
                }
                throw new IllegalStateException(("unsupported input for JPG (" + imageData.getType() + "/" + imageData.getType()).toString());
            }
            case 5: {
                IntBuffer intBuffer;
                void $this$saveImage_u24lambda_u2436;
                ByteBuffer $this$saveImage_u24lambda_u2435;
                ByteBuffer $this$saveImage_u24lambda_u2434;
                ByteBuffer byteBuffer;
                if (!(imageData.getFormat() == ColorFormat.RGB || imageData.getFormat() == ColorFormat.RGBa)) {
                    boolean $i$a$-require-ImageDriverStbImage$saveImage$92 = false;
                    String $i$a$-require-ImageDriverStbImage$saveImage$92 = "can only save RGB and RGBa formats in EXR format";
                    throw new IllegalArgumentException($i$a$-require-ImageDriverStbImage$saveImage$92.toString());
                }
                int exrType = imageData.getType() == ColorType.FLOAT16 ? 1 : 2;
                EXRImage exrImage = EXRImage.create();
                TinyEXR.InitEXRImage(exrImage);
                EXRHeader exrHeader = EXRHeader.create();
                TinyEXR.InitEXRHeader(exrHeader);
                exrHeader.num_channels(3);
                EXRChannelInfo.Buffer exrChannels = EXRChannelInfo.calloc(3);
                ByteBuffer byteBuffer2 = byteBuffer = ByteBuffer.allocateDirect(2);
                EXRChannelInfo eXRChannelInfo = (EXRChannelInfo)exrChannels.get(0);
                boolean bl = false;
                $this$saveImage_u24lambda_u2434.put((byte)66);
                $this$saveImage_u24lambda_u2434.put((byte)0);
                Intrinsics.checkNotNull($this$saveImage_u24lambda_u2434, "null cannot be cast to non-null type java.nio.Buffer");
                ((Buffer)$this$saveImage_u24lambda_u2434).rewind();
                eXRChannelInfo.name(byteBuffer);
                $this$saveImage_u24lambda_u2434 = byteBuffer = ByteBuffer.allocateDirect(2);
                eXRChannelInfo = (EXRChannelInfo)exrChannels.get(1);
                boolean bl2 = false;
                $this$saveImage_u24lambda_u2435.put((byte)71);
                $this$saveImage_u24lambda_u2435.put((byte)0);
                Intrinsics.checkNotNull($this$saveImage_u24lambda_u2435, "null cannot be cast to non-null type java.nio.Buffer");
                ((Buffer)$this$saveImage_u24lambda_u2435).rewind();
                eXRChannelInfo.name(byteBuffer);
                $this$saveImage_u24lambda_u2435 = byteBuffer = ByteBuffer.allocateDirect(2);
                eXRChannelInfo = (EXRChannelInfo)exrChannels.get(2);
                boolean bl3 = false;
                $this$saveImage_u24lambda_u2436.put((byte)82);
                $this$saveImage_u24lambda_u2436.put((byte)0);
                Intrinsics.checkNotNull($this$saveImage_u24lambda_u2436, "null cannot be cast to non-null type java.nio.Buffer");
                ((Buffer)$this$saveImage_u24lambda_u2436).rewind();
                eXRChannelInfo.name(byteBuffer);
                exrHeader.channels(exrChannels);
                ByteBuffer bBuffer = ByteBuffer.allocateDirect(imageData.getWidth() * imageData.getHeight() * 4).order(ByteOrder.nativeOrder());
                ByteBuffer gBuffer = ByteBuffer.allocateDirect(imageData.getWidth() * imageData.getHeight() * 4).order(ByteOrder.nativeOrder());
                ByteBuffer rBuffer = ByteBuffer.allocateDirect(imageData.getWidth() * imageData.getHeight() * 4).order(ByteOrder.nativeOrder());
                Object object = imageData.getData();
                if (object == null || (object = ((MPPBuffer)object).getByteBuffer()) == null) {
                    throw new IllegalStateException("no buffer".toString());
                }
                Object data = object;
                int n = imageData.getHeight();
                for (int y = 0; y < n; ++y) {
                    int row = !imageData.getFlipV() ? imageData.getHeight() - 1 - y : y;
                    int offset = row * imageData.getWidth() * imageData.getType().getComponentSize() * 3;
                    ((Buffer)data).position(offset);
                    int n2 = imageData.getWidth();
                    for (int x = 0; x < n2; ++x) {
                        int i;
                        int n3 = imageData.getType().getComponentSize();
                        for (i = 0; i < n3; ++i) {
                            byte b = ((ByteBuffer)data).get();
                            bBuffer.put(b);
                        }
                        n3 = imageData.getType().getComponentSize();
                        for (i = 0; i < n3; ++i) {
                            byte g = ((ByteBuffer)data).get();
                            gBuffer.put(g);
                        }
                        n3 = imageData.getType().getComponentSize();
                        for (i = 0; i < n3; ++i) {
                            byte r = ((ByteBuffer)data).get();
                            rBuffer.put(r);
                        }
                    }
                }
                Intrinsics.checkNotNull(bBuffer, "null cannot be cast to non-null type java.nio.Buffer");
                ((Buffer)bBuffer).rewind();
                Intrinsics.checkNotNull(gBuffer, "null cannot be cast to non-null type java.nio.Buffer");
                ((Buffer)gBuffer).rewind();
                Intrinsics.checkNotNull(rBuffer, "null cannot be cast to non-null type java.nio.Buffer");
                ((Buffer)rBuffer).rewind();
                IntBuffer $this$saveImage_u24lambda_u2437 = intBuffer = BufferUtils.createIntBuffer(12);
                boolean bl4 = false;
                $this$saveImage_u24lambda_u2437.put(exrType);
                $this$saveImage_u24lambda_u2437.put(exrType);
                $this$saveImage_u24lambda_u2437.put(exrType);
                Intrinsics.checkNotNull($this$saveImage_u24lambda_u2437, "null cannot be cast to non-null type java.nio.Buffer");
                ((Buffer)$this$saveImage_u24lambda_u2437).rewind();
                IntBuffer pixelTypes = intBuffer;
                exrHeader.pixel_types(pixelTypes);
                Intrinsics.checkNotNull(pixelTypes, "null cannot be cast to non-null type java.nio.Buffer");
                ((Buffer)pixelTypes).rewind();
                exrHeader.requested_pixel_types(pixelTypes);
                exrImage.width(imageData.getWidth());
                exrImage.height(imageData.getHeight());
                exrImage.num_channels(3);
                PointerBuffer images = PointerBuffer.allocateDirect(3);
                images.put(0, bBuffer);
                images.put(1, gBuffer);
                images.put(2, rBuffer);
                images.rewind();
                exrImage.images(images);
                PointerBuffer errors = PointerBuffer.allocateDirect(1);
                int result2 = TinyEXR.SaveEXRImageToFile(exrImage, exrHeader, filename, errors);
                if (!(result2 == 0)) {
                    boolean bl5 = false;
                    String string = "failed to save EXR to " + filename + ", [result=" + result2 + "]";
                    throw new IllegalArgumentException(string.toString());
                }
                exrImage.images(null);
                TinyEXR.FreeEXRImage(exrImage);
                break;
            }
            default: {
                throw new IllegalStateException(("unsupported file format " + format).toString());
            }
        }
    }

    @Override
    @NotNull
    public String imageToDataUrl(@NotNull ImageData imageData, @Nullable ImageFileFormat formatHint) {
        Intrinsics.checkNotNullParameter(imageData, "imageData");
        ImageFileFormat imageFileFormat = formatHint;
        if (imageFileFormat == null) {
            imageFileFormat = ImageFileFormat.JPG;
        }
        ImageFileFormat imageFileFormat2 = imageFileFormat;
        ByteBuffer saveBuffer = ByteBuffer.allocate(0x200000);
        STBIWriteCallback writeFunc2 = new STBIWriteCallback(saveBuffer){
            final /* synthetic */ ByteBuffer $saveBuffer;
            {
                this.$saveBuffer = $saveBuffer;
            }

            public void invoke(long context, long data, int size) {
                block0: {
                    ByteBuffer sourceBuffer = MemoryUtil.memByteBuffer(data, size);
                    ByteBuffer byteBuffer = this.$saveBuffer;
                    if (byteBuffer == null) break block0;
                    byteBuffer.put(sourceBuffer);
                }
            }
        };
        MPPBuffer mPPBuffer = imageData.getData();
        Intrinsics.checkNotNull(mPPBuffer);
        ByteBuffer pixels = mPPBuffer.getByteBuffer();
        if (!imageData.getFlipV()) {
            ByteBuffer flippedPixels = BufferUtils.createByteBuffer(imageData.getWidth() * imageData.getHeight() * imageData.getFormat().getComponentCount());
            Intrinsics.checkNotNull(flippedPixels, "null cannot be cast to non-null type java.nio.Buffer");
            ((Buffer)flippedPixels).rewind();
            int stride = imageData.getWidth() * imageData.getFormat().getComponentCount();
            byte[] row = new byte[stride];
            int n = imageData.getHeight();
            for (int y = 0; y < n; ++y) {
                MPPBuffer mPPBuffer2 = imageData.getData();
                Intrinsics.checkNotNull(mPPBuffer2);
                mPPBuffer2.getByteBuffer().position((imageData.getHeight() - y - 1) * stride);
                MPPBuffer mPPBuffer3 = imageData.getData();
                Intrinsics.checkNotNull(mPPBuffer3);
                mPPBuffer3.getByteBuffer().get(row);
                flippedPixels.put(row);
            }
            flippedPixels.rewind();
            pixels = flippedPixels;
        }
        switch (WhenMappings.$EnumSwitchMapping$1[imageFileFormat2.ordinal()]) {
            case 2: {
                STBImageWrite.stbi_write_jpg_to_func(writeFunc2, 0L, imageData.getWidth(), imageData.getHeight(), imageData.getFormat().getComponentCount(), pixels, 90);
                break;
            }
            case 1: {
                STBImageWrite.stbi_write_png_to_func(writeFunc2, 0L, imageData.getWidth(), imageData.getHeight(), imageData.getFormat().getComponentCount(), pixels, imageData.getWidth() * imageData.getFormat().getComponentCount());
                break;
            }
            default: {
                throw new IllegalStateException(("format not supported " + imageFileFormat2).toString());
            }
        }
        Intrinsics.checkNotNull(saveBuffer, "null cannot be cast to non-null type java.nio.Buffer");
        byte[] byteArray = new byte[((Buffer)saveBuffer).position()];
        ((Buffer)saveBuffer).rewind();
        saveBuffer.get(byteArray);
        String base64Data = Base64.getEncoder().encodeToString(byteArray);
        return "data:" + imageFileFormat2.getMimeType() + ";base64," + base64Data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public CubemapImageData loadCubemapImage(@NotNull String fileOrUrl, @Nullable ImageFileFormat formatHint) {
        CubemapImageData cubemapImageData;
        Intrinsics.checkNotNullParameter(fileOrUrl, "fileOrUrl");
        Pair<File, URL> pair = TextFromURLKt.resolveFileOrUrl(fileOrUrl);
        File file = pair.component1();
        URL url = pair.component2();
        Path path = Path.of(fileOrUrl, new String[0]);
        Intrinsics.checkNotNullExpressionValue(path, "of(...)");
        Object object = path;
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.exists((Path)object, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            boolean $i$a$-require-ImageDriverStbImage$loadCubemapImage$22 = false;
            String $i$a$-require-ImageDriverStbImage$loadCubemapImage$22 = fileOrUrl + " not found";
            throw new IllegalArgumentException($i$a$-require-ImageDriverStbImage$loadCubemapImage$22.toString());
        }
        if (file != null) {
            object = FileChannel.open(Path.of(fileOrUrl, new String[0]), new OpenOption[0]);
            Throwable $i$a$-require-ImageDriverStbImage$loadCubemapImage$22 = null;
            try {
                CubemapImageData cubemapImageData2;
                FileChannel channel = (FileChannel)object;
                boolean bl = false;
                ByteBuffer buffer = MemoryUtil.memAlloc((int)channel.size());
                channel.read(buffer);
                buffer.flip();
                try {
                    Intrinsics.checkNotNull(buffer);
                    cubemapImageData2 = this.loadCubemapImage(new MPPBuffer(buffer), fileOrUrl, formatHint);
                }
                finally {
                    MemoryUtil.memFree(buffer);
                }
                CubemapImageData cubemapImageData3 = cubemapImageData2;
                cubemapImageData = cubemapImageData3;
            }
            catch (Throwable throwable) {
                $i$a$-require-ImageDriverStbImage$loadCubemapImage$22 = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, $i$a$-require-ImageDriverStbImage$loadCubemapImage$22);
            }
        }
        if (url != null) {
            CubemapImageData cubemapImageData4;
            byte[] byteArray = TextStreamsKt.readBytes(url);
            if (byteArray.length == 0) {
                throw new IllegalStateException(("read 0 bytes from stream " + fileOrUrl).toString());
            }
            ByteBuffer buffer = MemoryUtil.memAlloc(byteArray.length);
            buffer.put(byteArray);
            buffer.flip();
            try {
                Intrinsics.checkNotNull(buffer);
                cubemapImageData4 = this.loadCubemapImage(new MPPBuffer(buffer), fileOrUrl, formatHint);
            }
            finally {
                MemoryUtil.memFree(buffer);
            }
            cubemapImageData = cubemapImageData4;
        } else {
            throw new IllegalStateException(("can't resolve " + fileOrUrl).toString());
        }
        return cubemapImageData;
    }

    @Override
    @NotNull
    public CubemapImageData loadCubemapImage(@NotNull MPPBuffer buffer, @Nullable String name, @Nullable ImageFileFormat formatHint) {
        Intrinsics.checkNotNullParameter(buffer, "buffer");
        DDSData ddsData = DDSReaderKt.loadDDS$default(buffer, false, 2, null);
        if (!ddsData.cubeMap()) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (!(ddsData.width() == ddsData.height())) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        return new CubemapImageDataDds(ddsData.width(), ddsData.height(), ddsData.format(), ddsData.type(), ddsData.mipmaps(), ddsData.bdata(), ddsData.bdata2());
    }

    /*
     * WARNING - void declaration
     */
    private static final ByteBuffer saveImage$flipImage(ImageData $imageData, ByteBuffer inputBuffer) {
        ByteBuffer byteBuffer;
        if ($imageData.getFlipV()) {
            byteBuffer = inputBuffer;
        } else {
            void var3_2;
            ByteBuffer flippedPixels = MemoryUtil.memAlloc($imageData.getWidth() * $imageData.getHeight() * $imageData.getFormat().getComponentCount() * $imageData.getType().getComponentSize());
            int stride = $imageData.getWidth() * $imageData.getFormat().getComponentCount();
            byte[] row = new byte[stride];
            flippedPixels.rewind();
            int n = $imageData.getHeight();
            for (int y = 0; y < n; ++y) {
                inputBuffer.position(($imageData.getHeight() - y - 1) * stride);
                inputBuffer.get(row);
                flippedPixels.put(row);
            }
            inputBuffer.rewind();
            inputBuffer.put(flippedPixels);
            inputBuffer.rewind();
            flippedPixels.rewind();
            void var2_7 = var3_2;
            Intrinsics.checkNotNull(var2_7);
            byteBuffer = var2_7;
        }
        return byteBuffer;
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[ColorFormat.values().length];
            try {
                nArray[ColorFormat.R.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ColorFormat.RGB.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ColorFormat.RGBa.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[ImageFileFormat.values().length];
            try {
                nArray[ImageFileFormat.PNG.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ImageFileFormat.JPG.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ImageFileFormat.HDR.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ImageFileFormat.DDS.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ImageFileFormat.EXR.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

