/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.internal.gl3;

import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL33C;
import org.lwjgl.opengl.GL44C;
import org.lwjgl.opengl.GL45C;
import org.lwjgl.opengles.GLES32;
import org.openrndr.draw.IndexBuffer;
import org.openrndr.draw.IndexType;
import org.openrndr.internal.Driver;
import org.openrndr.internal.gl3.DriverGL3;
import org.openrndr.internal.gl3.DriverGL3Configuration;
import org.openrndr.internal.gl3.DriverGL3Kt;
import org.openrndr.internal.gl3.DriverTypeGL;
import org.openrndr.internal.gl3.DriverVersionGL;
import org.openrndr.internal.gl3.GL3Exception;
import org.openrndr.internal.gl3.GLGLESKt;
import org.openrndr.internal.gl3.IndexBufferGL3Kt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0006\u0010\u0010\u001a\u00020\u0011J\u0006\u0010\u0012\u001a\u00020\u0011J\u0018\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0003H\u0016J\u0018\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0003H\u0016J\b\u0010\u0018\u001a\u00020\u0011H\u0016J!\u0010\u0019\u001a\u00020\u00112\u0017\u0010\u001a\u001a\u0013\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u00110\u001b\u00a2\u0006\u0002\b\u001cH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0004\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/openrndr/internal/gl3/IndexBufferGL3;", "Lorg/openrndr/draw/IndexBuffer;", "buffer", "", "indexCount", "type", "Lorg/openrndr/draw/IndexType;", "<init>", "(IILorg/openrndr/draw/IndexType;)V", "getBuffer", "()I", "getIndexCount", "getType", "()Lorg/openrndr/draw/IndexType;", "isDestroyed", "", "bind", "", "unbind", "write", "data", "Ljava/nio/ByteBuffer;", "offset", "read", "destroy", "bound", "f", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "Companion", "openrndr-gl3"})
@SourceDebugExtension(value={"SMAP\nIndexBufferGL3.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IndexBufferGL3.kt\norg/openrndr/internal/gl3/IndexBufferGL3\n+ 2 GLGLES.kt\norg/openrndr/internal/gl3/GLGLESKt\n+ 3 ErrorGL3.kt\norg/openrndr/internal/gl3/ErrorGL3Kt\n+ 4 ErrorGL3.kt\norg/openrndr/internal/gl3/ErrorGL3Kt$debugGLErrors$1\n+ 5 ErrorGL3.kt\norg/openrndr/internal/gl3/ErrorGL3Kt$checkGLErrors$1\n*L\n1#1,89:1\n40#2,3:90\n40#2,3:117\n75#2,3:176\n68#3,3:93\n52#3,13:96\n66#3,7:110\n68#3,3:120\n52#3,13:123\n66#3,7:137\n51#3,14:144\n66#3:159\n51#3,14:160\n66#3:175\n68#4:109\n68#4:136\n51#5:158\n51#5:174\n*S KotlinDebug\n*F\n+ 1 IndexBufferGL3.kt\norg/openrndr/internal/gl3/IndexBufferGL3\n*L\n43#1:90,3\n49#1:117,3\n55#1:176,3\n44#1:93,3\n44#1:96,13\n44#1:110,7\n50#1:120,3\n50#1:123,13\n50#1:137,7\n57#1:144,14\n57#1:159\n69#1:160,14\n69#1:175\n44#1:109\n50#1:136\n57#1:158\n69#1:174\n*E\n"})
public final class IndexBufferGL3
implements IndexBuffer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int buffer;
    private final int indexCount;
    @NotNull
    private final IndexType type;
    private boolean isDestroyed;

    public IndexBufferGL3(int buffer, int indexCount, @NotNull IndexType type) {
        Intrinsics.checkNotNullParameter((Object)type, "type");
        this.buffer = buffer;
        this.indexCount = indexCount;
        this.type = type;
    }

    public final int getBuffer() {
        return this.buffer;
    }

    @Override
    public int getIndexCount() {
        return this.indexCount;
    }

    @Override
    @NotNull
    public IndexType getType() {
        return this.type;
    }

    /*
     * WARNING - void declaration
     */
    public final void bind() {
        if (this.isDestroyed) {
            throw new IllegalStateException("buffer is destroyed");
        }
        IndexBufferGL3Kt.access$getLogger$p().trace(() -> IndexBufferGL3.bind$lambda$0(this));
        int n = 34963;
        int buffer$iv = this.buffer;
        boolean $i$f$glBindBuffer = false;
        switch (GLGLESKt.WhenMappings.$EnumSwitchMapping$0[GLGLESKt.getDriverType().ordinal()]) {
            case 1: {
                void target$iv;
                GL45C.glBindBuffer((int)target$iv, buffer$iv);
                break;
            }
            case 2: {
                void target$iv;
                GLES32.glBindBuffer((int)target$iv, buffer$iv);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        boolean $i$f$debugGLErrors = false;
        if (DriverGL3Configuration.INSTANCE.getUseDebugContext()) {
            boolean $i$f$checkGLErrors = false;
            int error$iv$iv = GLGLESKt.glGetError();
            if (error$iv$iv != 0) {
                Object message$iv$iv = switch (error$iv$iv) {
                    case 1282 -> "GL_INVALID_OPERATION";
                    case 1281 -> "GL_INVALID_VALUE";
                    case 1280 -> "GL_INVALID_ENUM";
                    case 1286 -> "GL_INVALID_FRAMEBUFFER_OPERATION";
                    case 1285 -> "GL_OUT_OF_MEMORY";
                    case 1284 -> "GL_STACK_UNDERFLOW";
                    case 1283 -> "GL_STACK_OVERFLOW";
                    default -> "<untranslated: " + error$iv$iv + ">";
                };
                int n2 = error$iv$iv;
                Object object = message$iv$iv;
                long l = Driver.Companion.getInstance().getContextID();
                boolean bl = false;
                int it = n2;
                Object var11_10 = null;
                String string = "[context=" + l + "] GL ERROR: " + (String)object + " " + var11_10;
                throw new GL3Exception(string);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void unbind() {
        IndexBufferGL3Kt.access$getLogger$p().trace(IndexBufferGL3::unbind$lambda$1);
        int n = 34963;
        int buffer$iv = 0;
        boolean $i$f$glBindBuffer = false;
        switch (GLGLESKt.WhenMappings.$EnumSwitchMapping$0[GLGLESKt.getDriverType().ordinal()]) {
            case 1: {
                void target$iv;
                GL45C.glBindBuffer((int)target$iv, buffer$iv);
                break;
            }
            case 2: {
                void target$iv;
                GLES32.glBindBuffer((int)target$iv, buffer$iv);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        boolean $i$f$debugGLErrors = false;
        if (DriverGL3Configuration.INSTANCE.getUseDebugContext()) {
            boolean $i$f$checkGLErrors = false;
            int error$iv$iv = GLGLESKt.glGetError();
            if (error$iv$iv != 0) {
                Object message$iv$iv = switch (error$iv$iv) {
                    case 1282 -> "GL_INVALID_OPERATION";
                    case 1281 -> "GL_INVALID_VALUE";
                    case 1280 -> "GL_INVALID_ENUM";
                    case 1286 -> "GL_INVALID_FRAMEBUFFER_OPERATION";
                    case 1285 -> "GL_OUT_OF_MEMORY";
                    case 1284 -> "GL_STACK_UNDERFLOW";
                    case 1283 -> "GL_STACK_OVERFLOW";
                    default -> "<untranslated: " + error$iv$iv + ">";
                };
                int n2 = error$iv$iv;
                Object object = message$iv$iv;
                long l = Driver.Companion.getInstance().getContextID();
                boolean bl = false;
                int it = n2;
                Object var11_10 = null;
                String string = "[context=" + l + "] GL ERROR: " + (String)object + " " + var11_10;
                throw new GL3Exception(string);
            }
        }
    }

    @Override
    public void write(@NotNull ByteBuffer data, int offset) {
        Intrinsics.checkNotNullParameter(data, "data");
        this.bound(arg_0 -> IndexBufferGL3.write$lambda$2(offset, data, arg_0));
        boolean $i$f$checkGLErrors = false;
        int error$iv = GLGLESKt.glGetError();
        if (error$iv != 0) {
            Object message$iv = switch (error$iv) {
                case 1282 -> "GL_INVALID_OPERATION";
                case 1281 -> "GL_INVALID_VALUE";
                case 1280 -> "GL_INVALID_ENUM";
                case 1286 -> "GL_INVALID_FRAMEBUFFER_OPERATION";
                case 1285 -> "GL_OUT_OF_MEMORY";
                case 1284 -> "GL_STACK_UNDERFLOW";
                case 1283 -> "GL_STACK_OVERFLOW";
                default -> "<untranslated: " + error$iv + ">";
            };
            int n = error$iv;
            Object object = message$iv;
            long l = Driver.Companion.getInstance().getContextID();
            boolean bl = false;
            int it = n;
            Object var11_10 = null;
            String string = "[context=" + l + "] GL ERROR: " + (String)object + " " + var11_10;
            throw new GL3Exception(string);
        }
    }

    @Override
    public void read(@NotNull ByteBuffer data, int offset) {
        Intrinsics.checkNotNullParameter(data, "data");
        if (this.isDestroyed) {
            throw new IllegalStateException("buffer is destroyed");
        }
        if (data.isDirect()) {
            this.bound(arg_0 -> IndexBufferGL3.read$lambda$3(offset, data, arg_0));
            boolean $i$f$checkGLErrors = false;
            int error$iv = GLGLESKt.glGetError();
            if (error$iv != 0) {
                Object message$iv = switch (error$iv) {
                    case 1282 -> "GL_INVALID_OPERATION";
                    case 1281 -> "GL_INVALID_VALUE";
                    case 1280 -> "GL_INVALID_ENUM";
                    case 1286 -> "GL_INVALID_FRAMEBUFFER_OPERATION";
                    case 1285 -> "GL_OUT_OF_MEMORY";
                    case 1284 -> "GL_STACK_UNDERFLOW";
                    case 1283 -> "GL_STACK_OVERFLOW";
                    default -> "<untranslated: " + error$iv + ">";
                };
                int n = error$iv;
                Object object = message$iv;
                long l = Driver.Companion.getInstance().getContextID();
                boolean bl = false;
                int it = n;
                Object var12_10 = null;
                String string = "[context=" + l + "] GL ERROR: " + (String)object + " " + var12_10;
                throw new GL3Exception(string);
            }
        } else {
            ByteBuffer temp = BufferUtils.createByteBuffer(data.capacity());
            Intrinsics.checkNotNull(temp);
            this.read(temp, offset);
            data.put(temp);
        }
    }

    @Override
    public void destroy() {
        GLGLESKt.glDeleteBuffers(this.buffer);
        this.isDestroyed = true;
    }

    private final void bound(Function1<? super IndexBufferGL3, Unit> f) {
        this.bind();
        f.invoke(this);
        this.unbind();
    }

    private static final Object bind$lambda$0(IndexBufferGL3 this$0) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        return "binding vertex buffer " + this$0.buffer;
    }

    private static final Object unbind$lambda$1() {
        return "unbinding vertex buffer";
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit write$lambda$2(int $offset, ByteBuffer $data, IndexBufferGL3 $this$bound) {
        Intrinsics.checkNotNullParameter($data, "$data");
        Intrinsics.checkNotNullParameter($this$bound, "$this$bound");
        int n = 34963;
        long offset$iv = $offset;
        boolean $i$f$glBufferSubData = false;
        switch (GLGLESKt.WhenMappings.$EnumSwitchMapping$0[GLGLESKt.getDriverType().ordinal()]) {
            case 1: {
                void target$iv;
                GL45C.glBufferSubData((int)target$iv, offset$iv, $data);
                break;
            }
            case 2: {
                void target$iv;
                GLES32.glBufferSubData((int)target$iv, offset$iv, $data);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return Unit.INSTANCE;
    }

    private static final Unit read$lambda$3(int $offset, ByteBuffer $data, IndexBufferGL3 $this$bound) {
        Intrinsics.checkNotNullParameter($data, "$data");
        Intrinsics.checkNotNullParameter($this$bound, "$this$bound");
        GL33C.glGetBufferSubData(34963, (long)$offset, $data);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"Lorg/openrndr/internal/gl3/IndexBufferGL3$Companion;", "", "<init>", "()V", "create", "Lorg/openrndr/internal/gl3/IndexBufferGL3;", "elementCount", "", "type", "Lorg/openrndr/draw/IndexType;", "openrndr-gl3"})
    @SourceDebugExtension(value={"SMAP\nIndexBufferGL3.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IndexBufferGL3.kt\norg/openrndr/internal/gl3/IndexBufferGL3$Companion\n+ 2 GLGLES.kt\norg/openrndr/internal/gl3/GLGLESKt\n+ 3 ErrorGL3.kt\norg/openrndr/internal/gl3/ErrorGL3Kt\n+ 4 ErrorGL3.kt\norg/openrndr/internal/gl3/ErrorGL3Kt$checkGLErrors$1\n*L\n1#1,89:1\n61#2,3:90\n33#2,3:93\n40#2,3:96\n47#2,3:115\n40#2,3:134\n51#3,14:99\n66#3:114\n51#3,14:118\n66#3:133\n51#4:113\n51#4:132\n*S KotlinDebug\n*F\n+ 1 IndexBufferGL3.kt\norg/openrndr/internal/gl3/IndexBufferGL3$Companion\n*L\n21#1:90,3\n22#1:93,3\n23#1:96,3\n30#1:115,3\n33#1:134,3\n24#1:99,14\n24#1:114\n32#1:118,14\n32#1:133\n24#1:113\n32#1:132\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final IndexBufferGL3 create(int elementCount, @NotNull IndexType type) {
            int target$iv;
            int $i$f$glBufferData;
            boolean useBufferStorage;
            Intrinsics.checkNotNullParameter((Object)type, "type");
            int pname$iv = 34965;
            boolean $i$f$glGetInteger = false;
            int cb = switch (GLGLESKt.WhenMappings.$EnumSwitchMapping$0[GLGLESKt.getDriverType().ordinal()]) {
                case 1 -> GL45C.glGetInteger(pname$iv);
                case 2 -> GLES32.glGetInteger(pname$iv);
                default -> throw new NoWhenBranchMatchedException();
            };
            boolean $i$f$glGenBuffers = false;
            int buffer = switch (GLGLESKt.WhenMappings.$EnumSwitchMapping$0[GLGLESKt.getDriverType().ordinal()]) {
                case 1 -> GL45C.glGenBuffers();
                case 2 -> GLES32.glGenBuffers();
                default -> throw new NoWhenBranchMatchedException();
            };
            int target$iv2 = 34963;
            boolean $i$f$glBindBuffer = false;
            switch (GLGLESKt.WhenMappings.$EnumSwitchMapping$0[GLGLESKt.getDriverType().ordinal()]) {
                case 1: {
                    GL45C.glBindBuffer(target$iv2, buffer);
                    break;
                }
                case 2: {
                    GLES32.glBindBuffer(target$iv2, buffer);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            boolean $i$f$checkGLErrors = false;
            int error$iv = GLGLESKt.glGetError();
            if (error$iv != 0) {
                Object message$iv = switch (error$iv) {
                    case 1282 -> "GL_INVALID_OPERATION";
                    case 1281 -> "GL_INVALID_VALUE";
                    case 1280 -> "GL_INVALID_ENUM";
                    case 1286 -> "GL_INVALID_FRAMEBUFFER_OPERATION";
                    case 1285 -> "GL_OUT_OF_MEMORY";
                    case 1284 -> "GL_STACK_UNDERFLOW";
                    case 1283 -> "GL_STACK_OVERFLOW";
                    default -> "<untranslated: " + error$iv + ">";
                };
                int n = error$iv;
                Object object = message$iv;
                long l = Driver.Companion.getInstance().getContextID();
                boolean bl = false;
                int it = n;
                Object var16_20 = null;
                String string = "[context=" + l + "] GL ERROR: " + (String)object + " " + var16_20;
                throw new GL3Exception(string);
            }
            int sizeInBytes = type.getSizeInBytes() * elementCount;
            Driver driver = Driver.Companion.getInstance();
            Intrinsics.checkNotNull(driver, "null cannot be cast to non-null type org.openrndr.internal.gl3.DriverGL3");
            boolean bl = useBufferStorage = ((DriverGL3)driver).getVersion().compareTo((Enum)DriverVersionGL.GL_VERSION_4_4) >= 0 && DriverGL3Kt.getGlVersion(Driver.Companion).getType() == DriverTypeGL.GL;
            if (useBufferStorage) {
                GL44C.glBufferStorage(34963, sizeInBytes, 256);
            } else {
                error$iv = 34963;
                long message$iv = sizeInBytes;
                int usage$iv = 35048;
                $i$f$glBufferData = 0;
                switch (GLGLESKt.WhenMappings.$EnumSwitchMapping$0[GLGLESKt.getDriverType().ordinal()]) {
                    case 1: {
                        void size$iv;
                        GL45C.glBufferData(target$iv, (long)size$iv, usage$iv);
                        break;
                    }
                    case 2: {
                        void size$iv;
                        GLES32.glBufferData(target$iv, (long)size$iv, usage$iv);
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
            }
            boolean $i$f$checkGLErrors2 = false;
            int error$iv2 = GLGLESKt.glGetError();
            if (error$iv2 != 0) {
                Object message$iv = switch (error$iv2) {
                    case 1282 -> "GL_INVALID_OPERATION";
                    case 1281 -> "GL_INVALID_VALUE";
                    case 1280 -> "GL_INVALID_ENUM";
                    case 1286 -> "GL_INVALID_FRAMEBUFFER_OPERATION";
                    case 1285 -> "GL_OUT_OF_MEMORY";
                    case 1284 -> "GL_STACK_UNDERFLOW";
                    case 1283 -> "GL_STACK_OVERFLOW";
                    default -> "<untranslated: " + error$iv2 + ">";
                };
                $i$f$glBufferData = error$iv2;
                Object object = message$iv;
                long l = Driver.Companion.getInstance().getContextID();
                boolean bl2 = false;
                int it = $i$f$glBufferData;
                Object var16_21 = null;
                String string = "[context=" + l + "] GL ERROR: " + (String)object + " " + var16_21;
                throw new GL3Exception(string);
            }
            target$iv = 34963;
            boolean $i$f$glBindBuffer2 = false;
            switch (GLGLESKt.WhenMappings.$EnumSwitchMapping$0[GLGLESKt.getDriverType().ordinal()]) {
                case 1: {
                    GL45C.glBindBuffer(target$iv, cb);
                    break;
                }
                case 2: {
                    GLES32.glBindBuffer(target$iv, cb);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return new IndexBufferGL3(buffer, elementCount, type);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

