/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.internal.gl3;

import java.nio.Buffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL45C;
import org.lwjgl.opengles.GLES32;
import org.openrndr.color.ColorRGBa;
import org.openrndr.draw.AtomicCounterBuffer;
import org.openrndr.draw.ImageBinding;
import org.openrndr.draw.Session;
import org.openrndr.draw.Shader;
import org.openrndr.draw.ShaderStorageBuffer;
import org.openrndr.draw.ShaderType;
import org.openrndr.draw.UniformBlock;
import org.openrndr.draw.UniformBlockLayout;
import org.openrndr.draw.UniformDescription;
import org.openrndr.draw.VertexBuffer;
import org.openrndr.internal.Driver;
import org.openrndr.internal.gl3.DriverGL3;
import org.openrndr.internal.gl3.DriverGL3Configuration;
import org.openrndr.internal.gl3.DriverGL3Kt;
import org.openrndr.internal.gl3.DriverTypeGL;
import org.openrndr.internal.gl3.DriverVersionGL;
import org.openrndr.internal.gl3.FragmentShaderGL3;
import org.openrndr.internal.gl3.GL3Exception;
import org.openrndr.internal.gl3.GLGLESKt;
import org.openrndr.internal.gl3.GeometryShaderGL3;
import org.openrndr.internal.gl3.ShaderBufferBindingsGL3;
import org.openrndr.internal.gl3.ShaderGL3Kt;
import org.openrndr.internal.gl3.ShaderImageBindingsGL43;
import org.openrndr.internal.gl3.ShaderUniformsGL3;
import org.openrndr.internal.gl3.TessellationControlShaderGL3;
import org.openrndr.internal.gl3.TessellationEvaluationShaderGL3;
import org.openrndr.internal.gl3.UniformBlockGL3;
import org.openrndr.internal.gl3.VertexShaderGL3;
import org.openrndr.math.BooleanVector2;
import org.openrndr.math.BooleanVector3;
import org.openrndr.math.BooleanVector4;
import org.openrndr.math.IntVector2;
import org.openrndr.math.IntVector3;
import org.openrndr.math.IntVector4;
import org.openrndr.math.Matrix33;
import org.openrndr.math.Matrix44;
import org.openrndr.math.Vector2;
import org.openrndr.math.Vector3;
import org.openrndr.math.Vector4;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010%\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\u0018\u0000 C2\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u0004:\u0001CBO\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\f\u0012\b\u0010\r\u001a\u0004\u0018\u00010\u000e\u0012\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u0012\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0010\u00106\u001a\u00020$2\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0012\u00107\u001a\u0004\u0018\u0001082\u0006\u00109\u001a\u00020\bH\u0016J\u0012\u0010:\u001a\u0004\u0018\u00010;2\u0006\u00109\u001a\u00020\bH\u0016J\u0018\u0010<\u001a\u00020=2\u0006\u00109\u001a\u00020\b2\u0006\u0010<\u001a\u000208H\u0016J\u000e\u0010>\u001a\u00020\u00062\u0006\u0010<\u001a\u00020\bJ\b\u0010?\u001a\u00020=H\u0016J\b\u0010@\u001a\u00020=H\u0016J\u000e\u0010A\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\b\u0010B\u001a\u00020=H\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0016\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0014\u0010\u001d\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u0018R \u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00060 X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0014\u0010#\u001a\u00020$X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u001a\u0010'\u001a\b\u0012\u0004\u0012\u00020)0(X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010+R\u000e\u0010,\u001a\u00020$X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010-\u001a\u00020$X\u0082\u000e\u00a2\u0006\u0002\n\u0000R&\u0010.\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00060 X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b/\u0010\"\"\u0004\b0\u00101R\u001a\u00102\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00060 X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u00103\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u000604X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u00105\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00060 X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006D"}, d2={"Lorg/openrndr/internal/gl3/ShaderGL3;", "Lorg/openrndr/draw/Shader;", "Lorg/openrndr/internal/gl3/ShaderUniformsGL3;", "Lorg/openrndr/internal/gl3/ShaderBufferBindingsGL3;", "Lorg/openrndr/internal/gl3/ShaderImageBindingsGL43;", "programObject", "", "name", "", "vertexShader", "Lorg/openrndr/internal/gl3/VertexShaderGL3;", "tessellationControlShader", "Lorg/openrndr/internal/gl3/TessellationControlShaderGL3;", "tessellationEvaluationShader", "Lorg/openrndr/internal/gl3/TessellationEvaluationShaderGL3;", "geometryShader", "Lorg/openrndr/internal/gl3/GeometryShaderGL3;", "fragmentShader", "Lorg/openrndr/internal/gl3/FragmentShaderGL3;", "session", "Lorg/openrndr/draw/Session;", "<init>", "(ILjava/lang/String;Lorg/openrndr/internal/gl3/VertexShaderGL3;Lorg/openrndr/internal/gl3/TessellationControlShaderGL3;Lorg/openrndr/internal/gl3/TessellationEvaluationShaderGL3;Lorg/openrndr/internal/gl3/GeometryShaderGL3;Lorg/openrndr/internal/gl3/FragmentShaderGL3;Lorg/openrndr/draw/Session;)V", "getProgramObject", "()I", "getName", "()Ljava/lang/String;", "getSession", "()Lorg/openrndr/draw/Session;", "ssbo", "getSsbo", "ssboResourceIndices", "", "getSsboResourceIndices", "()Ljava/util/Map;", "useProgramUniform", "", "getUseProgramUniform", "()Z", "types", "", "Lorg/openrndr/draw/ShaderType;", "getTypes", "()Ljava/util/Set;", "destroyed", "running", "uniforms", "getUniforms", "setUniforms", "(Ljava/util/Map;)V", "attributes", "blockBindings", "Ljava/util/HashMap;", "blocks", "hasUniform", "createBlock", "Lorg/openrndr/draw/UniformBlock;", "blockName", "blockLayout", "Lorg/openrndr/draw/UniformBlockLayout;", "block", "", "blockIndex", "begin", "end", "attributeIndex", "destroy", "Companion", "openrndr-gl3"})
@SourceDebugExtension(value={"SMAP\nShaderGL3.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ShaderGL3.kt\norg/openrndr/internal/gl3/ShaderGL3\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 ErrorGL3.kt\norg/openrndr/internal/gl3/ErrorGL3Kt\n+ 4 ErrorGL3.kt\norg/openrndr/internal/gl3/ErrorGL3Kt$checkGLErrors$1\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 6 GLGLES.kt\norg/openrndr/internal/gl3/GLGLESKt\n+ 7 ErrorGL3.kt\norg/openrndr/internal/gl3/ErrorGL3Kt$debugGLErrors$1\n+ 8 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,380:1\n11132#2:381\n11467#2,3:382\n51#3,14:385\n66#3:400\n68#3,3:414\n52#3,13:417\n66#3,7:431\n69#3,2:454\n52#3,21:456\n68#3,3:480\n52#3,13:483\n66#3,7:497\n68#3,3:510\n52#3,13:513\n66#3,7:527\n51#4:399\n1557#5:401\n1628#5,3:402\n1202#5,2:405\n1230#5,4:407\n345#6,3:411\n315#6,3:441\n40#6,3:448\n305#6,3:451\n305#6,3:477\n325#6,3:507\n333#6,3:538\n68#7:430\n68#7:496\n68#7:526\n381#8,3:438\n384#8,4:444\n381#8,3:504\n384#8,4:534\n*S KotlinDebug\n*F\n+ 1 ShaderGL3.kt\norg/openrndr/internal/gl3/ShaderGL3\n*L\n269#1:381\n269#1:382,3\n273#1:385,14\n273#1:400\n305#1:414,3\n305#1:417,13\n305#1:431,7\n327#1:454,2\n327#1:456,21\n341#1:480,3\n341#1:483,13\n341#1:497,7\n348#1:510,3\n348#1:513,13\n348#1:527,7\n273#1:399\n275#1:401\n275#1:402,3\n283#1:405,2\n283#1:407,4\n304#1:411,3\n313#1:441,3\n320#1:448,3\n325#1:451,3\n339#1:477,3\n347#1:507,3\n355#1:538,3\n305#1:430\n341#1:496\n348#1:526\n312#1:438,3\n312#1:444,4\n346#1:504,3\n346#1:534,4\n*E\n"})
public final class ShaderGL3
implements Shader,
ShaderUniformsGL3,
ShaderBufferBindingsGL3,
ShaderImageBindingsGL43 {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int programObject;
    @NotNull
    private final String name;
    @Nullable
    private final Session session;
    private final int ssbo;
    @NotNull
    private final Map<String, Integer> ssboResourceIndices;
    private final boolean useProgramUniform;
    @NotNull
    private final Set<ShaderType> types;
    private boolean destroyed;
    private boolean running;
    @NotNull
    private Map<String, Integer> uniforms;
    @NotNull
    private Map<String, Integer> attributes;
    @NotNull
    private HashMap<String, Integer> blockBindings;
    @NotNull
    private final Map<String, Integer> blocks;

    public ShaderGL3(int programObject, @NotNull String name, @NotNull VertexShaderGL3 vertexShader, @Nullable TessellationControlShaderGL3 tessellationControlShader, @Nullable TessellationEvaluationShaderGL3 tessellationEvaluationShader, @Nullable GeometryShaderGL3 geometryShader, @NotNull FragmentShaderGL3 fragmentShader, @Nullable Session session) {
        Set<ShaderType> set;
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(vertexShader, "vertexShader");
        Intrinsics.checkNotNullParameter(fragmentShader, "fragmentShader");
        this.programObject = programObject;
        this.name = name;
        this.session = session;
        this.ssbo = this.createSSBO();
        this.ssboResourceIndices = new LinkedHashMap();
        boolean bl = this.useProgramUniform = DriverGL3Kt.getGlVersion(Driver.Companion).compareTo((Enum)DriverVersionGL.GL_VERSION_4_2) >= 0 && DriverGL3Kt.getGlVersion(Driver.Companion).getType() == DriverTypeGL.GL;
        if (geometryShader != null) {
            ShaderType[] shaderTypeArray = new ShaderType[]{ShaderType.VERTEX, ShaderType.GEOMETRY, ShaderType.FRAGMENT};
            set = SetsKt.setOf(shaderTypeArray);
        } else {
            ShaderType[] shaderTypeArray = new ShaderType[]{ShaderType.VERTEX, ShaderType.FRAGMENT};
            set = SetsKt.setOf(shaderTypeArray);
        }
        this.types = set;
        this.uniforms = new HashMap();
        this.attributes = new HashMap();
        this.blockBindings = new HashMap();
        this.blocks = new HashMap();
    }

    @Override
    public int getProgramObject() {
        return this.programObject;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @Nullable
    public Session getSession() {
        return this.session;
    }

    @Override
    public int getSsbo() {
        return this.ssbo;
    }

    @Override
    @NotNull
    public Map<String, Integer> getSsboResourceIndices() {
        return this.ssboResourceIndices;
    }

    @Override
    public boolean getUseProgramUniform() {
        return this.useProgramUniform;
    }

    @Override
    @NotNull
    public Set<ShaderType> getTypes() {
        return this.types;
    }

    @Override
    @NotNull
    public Map<String, Integer> getUniforms() {
        return this.uniforms;
    }

    public void setUniforms(@NotNull Map<String, Integer> map2) {
        Intrinsics.checkNotNullParameter(map2, "<set-?>");
        this.uniforms = map2;
    }

    @Override
    public boolean hasUniform(@NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        return this.uniformIndex(name, true) != -1;
    }

    @Override
    @Nullable
    public UniformBlock createBlock(@NotNull String blockName) {
        Intrinsics.checkNotNullParameter(blockName, "blockName");
        UniformBlockLayout layout = this.blockLayout(blockName);
        return layout != null ? (UniformBlock)UniformBlockGL3.Companion.create(layout) : null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public UniformBlockLayout blockLayout(@NotNull String blockName) {
        Intrinsics.checkNotNullParameter(blockName, "blockName");
        int blockIndex = this.blockIndex(blockName);
        if (blockIndex == -1) {
            return null;
        }
        ShaderGL3 $this$blockLayout_u24lambda_u240 = this;
        boolean bl = false;
        IntBuffer blockSizeBuffer = BufferUtils.createIntBuffer(1);
        int n = $this$blockLayout_u24lambda_u240.getProgramObject();
        Intrinsics.checkNotNull(blockSizeBuffer);
        GLGLESKt.glGetActiveUniformBlockiv(n, blockIndex, 35392, blockSizeBuffer);
        int blockSize = blockSizeBuffer.get(0);
        if (blockSize != 0) {
            void $this$associateByTo$iv$iv;
            void $this$associateBy$iv;
            Object object;
            void $this$mapTo$iv$iv;
            void $this$mapTo$iv$iv2;
            ShaderGL3 $this$blockLayout_u24lambda_u241 = this;
            boolean bl2 = false;
            IntBuffer uniformCountBuffer = BufferUtils.createIntBuffer(1);
            int n2 = $this$blockLayout_u24lambda_u241.getProgramObject();
            Intrinsics.checkNotNull(uniformCountBuffer);
            GLGLESKt.glGetActiveUniformBlockiv(n2, blockIndex, 35394, uniformCountBuffer);
            int uniformCount = uniformCountBuffer.get(0);
            IntBuffer uniformIndicesBuffer = BufferUtils.createIntBuffer(uniformCount);
            ShaderGL3 $this$blockLayout_u24lambda_u242 = this;
            boolean bl3 = false;
            int n3 = $this$blockLayout_u24lambda_u242.getProgramObject();
            Intrinsics.checkNotNull(uniformIndicesBuffer);
            GLGLESKt.glGetActiveUniformBlockiv(n3, blockIndex, 35395, uniformIndicesBuffer);
            ((Buffer)uniformIndicesBuffer).rewind();
            int[] array = new int[uniformCount];
            uniformIndicesBuffer.get(array);
            int[] uniformIndices = array;
            ((Buffer)uniformIndicesBuffer).rewind();
            ShaderGL3 $this$blockLayout_u24lambda_u243 = this;
            boolean bl4 = false;
            IntBuffer buffer = BufferUtils.createIntBuffer(uniformCount);
            int n4 = $this$blockLayout_u24lambda_u243.getProgramObject();
            Intrinsics.checkNotNull(buffer);
            GLGLESKt.glGetActiveUniformsiv(n4, uniformIndicesBuffer, 35383, buffer);
            ((Buffer)buffer).rewind();
            int[] array2 = new int[uniformCount];
            buffer.get(array2);
            int[] uniformTypes = array2;
            ShaderGL3 $this$blockLayout_u24lambda_u244 = this;
            boolean bl5 = false;
            IntBuffer buffer2 = BufferUtils.createIntBuffer(uniformCount);
            int n5 = $this$blockLayout_u24lambda_u244.getProgramObject();
            Intrinsics.checkNotNull(buffer2);
            GLGLESKt.glGetActiveUniformsiv(n5, uniformIndicesBuffer, 35384, buffer2);
            ((Buffer)buffer2).rewind();
            int[] array3 = new int[uniformCount];
            buffer2.get(array3);
            int[] uniformSizes = array3;
            ShaderGL3 $this$blockLayout_u24lambda_u245 = this;
            boolean bl6 = false;
            IntBuffer buffer3 = BufferUtils.createIntBuffer(uniformCount);
            int n6 = $this$blockLayout_u24lambda_u245.getProgramObject();
            Intrinsics.checkNotNull(buffer3);
            GLGLESKt.glGetActiveUniformsiv(n6, uniformIndicesBuffer, 35387, buffer3);
            ((Buffer)buffer3).rewind();
            int[] array4 = new int[uniformCount];
            buffer3.get(array4);
            int[] uniformOffsets = array4;
            ShaderGL3 $this$blockLayout_u24lambda_u246 = this;
            boolean bl7 = false;
            Object buffer4 = BufferUtils.createIntBuffer(uniformCount);
            int n7 = $this$blockLayout_u24lambda_u246.getProgramObject();
            Intrinsics.checkNotNull(buffer4);
            GLGLESKt.glGetActiveUniformsiv(n7, uniformIndicesBuffer, 35388, (IntBuffer)buffer4);
            ((Buffer)buffer4).rewind();
            int[] array5 = new int[uniformCount];
            ((IntBuffer)buffer4).get(array5);
            int[] uniformStrides = array5;
            Object $this$map$iv = uniformIndices;
            boolean $i$f$map = false;
            buffer4 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(((int[])$this$map$iv).length);
            int $i$f$mapTo = 0;
            for (int item$iv$iv2 : $this$mapTo$iv$iv2) {
                void it;
                void var20_39 = item$iv$iv2;
                Collection collection = destination$iv$iv;
                boolean bl8 = false;
                collection.add(GLGLESKt.glGetActiveUniformName(this.getProgramObject(), (int)it, 128));
            }
            List uniformNames = (List)destination$iv$iv;
            boolean $i$f$checkGLErrors = false;
            int error$iv22 = GLGLESKt.glGetError();
            if (error$iv22 != 0) {
                Object message$iv = switch (error$iv22) {
                    case 1282 -> "GL_INVALID_OPERATION";
                    case 1281 -> "GL_INVALID_VALUE";
                    case 1280 -> "GL_INVALID_ENUM";
                    case 1286 -> "GL_INVALID_FRAMEBUFFER_OPERATION";
                    case 1285 -> "GL_OUT_OF_MEMORY";
                    case 1284 -> "GL_STACK_UNDERFLOW";
                    case 1283 -> "GL_STACK_OVERFLOW";
                    default -> "<untranslated: " + error$iv22 + ">";
                };
                $i$f$mapTo = error$iv22;
                Object object2 = message$iv;
                long l = Driver.Companion.getInstance().getContextID();
                boolean bl9 = false;
                int it = $i$f$mapTo;
                Object var28_48 = null;
                String string = "[context=" + l + "] GL ERROR: " + (String)object2 + " " + var28_48;
                throw new GL3Exception(string);
            }
            $this$map$iv = RangesKt.until(0, uniformCount);
            int n8 = blockSize;
            $i$f$map = false;
            Object error$iv22 = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            $i$f$mapTo = 0;
            Iterator bl9 = $this$mapTo$iv$iv.iterator();
            while (bl9.hasNext()) {
                void it;
                int item$iv$iv;
                int item$iv$iv2;
                item$iv$iv2 = item$iv$iv = ((IntIterator)bl9).nextInt();
                object = destination$iv$iv;
                boolean bl10 = false;
                CharSequence bl8 = (CharSequence)uniformNames.get((int)it);
                Regex regex = new Regex("\\[.*\\]");
                String string = "";
                object.add(new UniformDescription(regex.replace(bl8, string), ShaderGL3Kt.access$toUniformType(uniformTypes[it]), uniformSizes[it], uniformOffsets[it], uniformStrides[it]));
            }
            object = (List)destination$iv$iv;
            $this$map$iv = (Iterable)object;
            boolean $i$f$associateBy = false;
            int capacity$iv = RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($this$associateBy$iv, 10)), 16);
            destination$iv$iv = $this$associateBy$iv;
            Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv : $this$associateByTo$iv$iv) {
                void it;
                UniformDescription bl10 = (UniformDescription)element$iv$iv;
                object = destination$iv$iv2;
                boolean bl11 = false;
                object.put(it.getName(), element$iv$iv);
            }
            Object object3 = object = destination$iv$iv2;
            int n9 = n8;
            return new UniformBlockLayout(n9, (Map<String, UniformDescription>)object3);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void block(@NotNull String blockName, @NotNull UniformBlock block) {
        Intrinsics.checkNotNullParameter(blockName, "blockName");
        Intrinsics.checkNotNullParameter(block, "block");
        if (!Intrinsics.areEqual(Thread.currentThread(), ((UniformBlockGL3)block).getThread$openrndr_gl3())) {
            throw new IllegalStateException("block is created on " + ((UniformBlockGL3)block).getThread$openrndr_gl3() + " and is now used on " + Thread.currentThread());
        }
        if (!this.running) {
            throw new IllegalStateException("use begin() before setting blocks");
        }
        int blockIndex = this.blockIndex(blockName);
        if (blockIndex != -1) {
            Integer n = this.blockBindings.get(blockName);
            int n2 = ((UniformBlockGL3)block).getBlockBinding();
            if (n == null || n != n2) {
                n2 = this.getProgramObject();
                int uniformBlockBinding$iv = ((UniformBlockGL3)block).getBlockBinding();
                boolean $i$f$glUniformBlockBinding = false;
                switch (GLGLESKt.WhenMappings.$EnumSwitchMapping$0[GLGLESKt.getDriverType().ordinal()]) {
                    case 1: {
                        void program$iv;
                        GL45C.glUniformBlockBinding((int)program$iv, blockIndex, uniformBlockBinding$iv);
                        break;
                    }
                    case 2: {
                        void program$iv;
                        GLES32.glUniformBlockBinding((int)program$iv, blockIndex, uniformBlockBinding$iv);
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                boolean $i$f$debugGLErrors = false;
                if (DriverGL3Configuration.INSTANCE.getUseDebugContext()) {
                    boolean $i$f$checkGLErrors = false;
                    int error$iv$iv = GLGLESKt.glGetError();
                    if (error$iv$iv != 0) {
                        Object message$iv$iv = switch (error$iv$iv) {
                            case 1282 -> "GL_INVALID_OPERATION";
                            case 1281 -> "GL_INVALID_VALUE";
                            case 1280 -> "GL_INVALID_ENUM";
                            case 1286 -> "GL_INVALID_FRAMEBUFFER_OPERATION";
                            case 1285 -> "GL_OUT_OF_MEMORY";
                            case 1284 -> "GL_STACK_UNDERFLOW";
                            case 1283 -> "GL_STACK_OVERFLOW";
                            default -> "<untranslated: " + error$iv$iv + ">";
                        };
                        int n3 = error$iv$iv;
                        Object object = message$iv$iv;
                        long l = Driver.Companion.getInstance().getContextID();
                        boolean bl = false;
                        int it = n3;
                        Object var14_13 = null;
                        String string = "[context=" + l + "] GL ERROR: " + (String)object + " " + var14_13;
                        throw new GL3Exception(string);
                    }
                }
                ((Map)this.blockBindings).put(blockName, ((UniformBlockGL3)block).getBlockBinding());
            }
        }
    }

    public final int blockIndex(@NotNull String block) {
        Integer n;
        Intrinsics.checkNotNullParameter(block, "block");
        Map<String, Integer> $this$getOrPut$iv = this.blocks;
        boolean $i$f$getOrPut = false;
        Integer value$iv = $this$getOrPut$iv.get(block);
        if (value$iv == null) {
            boolean bl = false;
            int program$iv = this.getProgramObject();
            boolean $i$f$glGetUniformBlockIndex = false;
            Integer answer$iv = switch (GLGLESKt.WhenMappings.$EnumSwitchMapping$0[GLGLESKt.getDriverType().ordinal()]) {
                case 1 -> GL45C.glGetUniformBlockIndex(program$iv, block);
                case 2 -> GLES32.glGetUniformBlockIndex(program$iv, block);
                default -> throw new NoWhenBranchMatchedException();
            };
            $this$getOrPut$iv.put(block, answer$iv);
            n = answer$iv;
        } else {
            n = value$iv;
        }
        return ((Number)n).intValue();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void begin() {
        if (this.getSsbo() != -1) {
            int n = 37074;
            int buffer$iv = this.getSsbo();
            boolean $i$f$glBindBuffer = false;
            switch (GLGLESKt.WhenMappings.$EnumSwitchMapping$0[GLGLESKt.getDriverType().ordinal()]) {
                case 1: {
                    void target$iv;
                    GL45C.glBindBuffer((int)target$iv, buffer$iv);
                    break;
                }
                case 2: {
                    void target$iv;
                    GLES32.glBindBuffer((int)target$iv, buffer$iv);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }
        ShaderGL3Kt.access$getLogger$p().trace(() -> ShaderGL3.begin$lambda$11(this));
        this.running = true;
        int program$iv = this.getProgramObject();
        boolean $i$f$glUseProgram = false;
        switch (GLGLESKt.WhenMappings.$EnumSwitchMapping$0[GLGLESKt.getDriverType().ordinal()]) {
            case 1: {
                GL45C.glUseProgram(program$iv);
                break;
            }
            case 2: {
                GLES32.glUseProgram(program$iv);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        boolean $i$f$debugGLErrors = false;
        if (DriverGL3Configuration.INSTANCE.getUseDebugContext()) {
            boolean $i$f$checkGLErrors = false;
            int error$iv$iv = GLGLESKt.glGetError();
            if (error$iv$iv != 0) {
                Object object;
                void it;
                Object message$iv$iv = switch (error$iv$iv) {
                    case 1282 -> "GL_INVALID_OPERATION";
                    case 1281 -> "GL_INVALID_VALUE";
                    case 1280 -> "GL_INVALID_ENUM";
                    case 1286 -> "GL_INVALID_FRAMEBUFFER_OPERATION";
                    case 1285 -> "GL_OUT_OF_MEMORY";
                    case 1284 -> "GL_STACK_UNDERFLOW";
                    case 1283 -> "GL_STACK_OVERFLOW";
                    default -> "<untranslated: " + error$iv$iv + ">";
                };
                int n = error$iv$iv;
                Object object2 = message$iv$iv;
                long l = Driver.Companion.getInstance().getContextID();
                boolean bl = false;
                switch (it) {
                    case 1281: {
                        object = "program is neither 0 nor a value generated by OpenGL";
                        break;
                    }
                    case 1282: {
                        object = "program (" + this.getProgramObject() + ") is not a program object / program could not be made part of current state / transform feedback mode is active.";
                        break;
                    }
                    default: {
                        object = null;
                    }
                }
                Object object3 = object;
                String string = "[context=" + l + "] GL ERROR: " + (String)object2 + " " + object3;
                throw new GL3Exception(string);
            }
        }
    }

    @Override
    public void end() {
        ShaderGL3Kt.access$getLogger$p().trace(() -> ShaderGL3.end$lambda$13(this));
        int program$iv = 0;
        boolean $i$f$glUseProgram = false;
        switch (GLGLESKt.WhenMappings.$EnumSwitchMapping$0[GLGLESKt.getDriverType().ordinal()]) {
            case 1: {
                GL45C.glUseProgram(program$iv);
                break;
            }
            case 2: {
                GLES32.glUseProgram(program$iv);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        boolean $i$f$debugGLErrors = false;
        if (DriverGL3Configuration.INSTANCE.getUseDebugContext()) {
            boolean $i$f$checkGLErrors = false;
            int error$iv$iv = GLGLESKt.glGetError();
            if (error$iv$iv != 0) {
                Object message$iv$iv = switch (error$iv$iv) {
                    case 1282 -> "GL_INVALID_OPERATION";
                    case 1281 -> "GL_INVALID_VALUE";
                    case 1280 -> "GL_INVALID_ENUM";
                    case 1286 -> "GL_INVALID_FRAMEBUFFER_OPERATION";
                    case 1285 -> "GL_OUT_OF_MEMORY";
                    case 1284 -> "GL_STACK_UNDERFLOW";
                    case 1283 -> "GL_STACK_OVERFLOW";
                    default -> "<untranslated: " + error$iv$iv + ">";
                };
                int n = error$iv$iv;
                Object object = message$iv$iv;
                long l = Driver.Companion.getInstance().getContextID();
                boolean bl = false;
                int it = n;
                Object var11_10 = null;
                String string = "[context=" + l + "] GL ERROR: " + (String)object + " " + var11_10;
                throw new GL3Exception(string);
            }
        }
        this.running = false;
    }

    public final int attributeIndex(@NotNull String name) {
        Integer n;
        Intrinsics.checkNotNullParameter(name, "name");
        Map<String, Integer> $this$getOrPut$iv = this.attributes;
        boolean $i$f$getOrPut = false;
        Integer value$iv = $this$getOrPut$iv.get(name);
        if (value$iv == null) {
            boolean bl = false;
            int program$iv = this.getProgramObject();
            boolean $i$f$glGetAttribLocation = false;
            int location = switch (GLGLESKt.WhenMappings.$EnumSwitchMapping$0[GLGLESKt.getDriverType().ordinal()]) {
                case 1 -> GL45C.glGetAttribLocation(program$iv, name);
                case 2 -> GLES32.glGetAttribLocation(program$iv, name);
                default -> throw new NoWhenBranchMatchedException();
            };
            boolean $i$f$debugGLErrors = false;
            if (DriverGL3Configuration.INSTANCE.getUseDebugContext()) {
                boolean $i$f$checkGLErrors = false;
                int error$iv$iv = GLGLESKt.glGetError();
                if (error$iv$iv != 0) {
                    Object message$iv$iv = switch (error$iv$iv) {
                        case 1282 -> "GL_INVALID_OPERATION";
                        case 1281 -> "GL_INVALID_VALUE";
                        case 1280 -> "GL_INVALID_ENUM";
                        case 1286 -> "GL_INVALID_FRAMEBUFFER_OPERATION";
                        case 1285 -> "GL_OUT_OF_MEMORY";
                        case 1284 -> "GL_STACK_UNDERFLOW";
                        case 1283 -> "GL_STACK_OVERFLOW";
                        default -> "<untranslated: " + error$iv$iv + ">";
                    };
                    int n2 = error$iv$iv;
                    Object object = message$iv$iv;
                    long l = Driver.Companion.getInstance().getContextID();
                    boolean bl2 = false;
                    int it = n2;
                    Object var17_16 = null;
                    String string = "[context=" + l + "] GL ERROR: " + (String)object + " " + var17_16;
                    throw new GL3Exception(string);
                }
            }
            Integer answer$iv = location;
            $this$getOrPut$iv.put(name, answer$iv);
            n = answer$iv;
        } else {
            n = value$iv;
        }
        return ((Number)n).intValue();
    }

    @Override
    public void destroy() {
        if (!this.destroyed) {
            Session session = this.getSession();
            if (session != null) {
                session.untrack(this);
            }
            int program$iv = this.getProgramObject();
            boolean $i$f$glDeleteProgram = false;
            switch (GLGLESKt.WhenMappings.$EnumSwitchMapping$0[GLGLESKt.getDriverType().ordinal()]) {
                case 1: {
                    GL45C.glDeleteProgram(program$iv);
                    break;
                }
                case 2: {
                    GLES32.glDeleteProgram(program$iv);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            this.destroyed = true;
            Driver driver = Driver.Companion.getInstance();
            Intrinsics.checkNotNull(driver, "null cannot be cast to non-null type org.openrndr.internal.gl3.DriverGL3");
            ((DriverGL3)driver).destroyVAOsForShader(this);
            Session.Companion.getActive().untrack(this);
        }
    }

    @Override
    public void image(@NotNull String name, int image, @NotNull ImageBinding imageBinding) {
        ShaderImageBindingsGL43.DefaultImpls.image((ShaderImageBindingsGL43)this, name, image, imageBinding);
    }

    @Override
    public void image(@NotNull String name, int image, @NotNull ImageBinding[] imageBinding) {
        ShaderImageBindingsGL43.DefaultImpls.image((ShaderImageBindingsGL43)this, name, image, imageBinding);
    }

    @Override
    public void uniform(@NotNull String name, @NotNull Matrix33 value2) {
        ShaderUniformsGL3.DefaultImpls.uniform((ShaderUniformsGL3)this, name, value2);
    }

    @Override
    public void uniform(@NotNull String name, @NotNull Matrix44 value2) {
        ShaderUniformsGL3.DefaultImpls.uniform((ShaderUniformsGL3)this, name, value2);
    }

    @Override
    public void uniform(@NotNull String name, @NotNull ColorRGBa value2) {
        ShaderUniformsGL3.DefaultImpls.uniform((ShaderUniformsGL3)this, name, value2);
    }

    @Override
    public void uniform(@NotNull String name, @NotNull Vector4 value2) {
        ShaderUniformsGL3.DefaultImpls.uniform((ShaderUniformsGL3)this, name, value2);
    }

    @Override
    public void uniform(@NotNull String name, @NotNull Vector3 value2) {
        ShaderUniformsGL3.DefaultImpls.uniform((ShaderUniformsGL3)this, name, value2);
    }

    @Override
    public void uniform(@NotNull String name, @NotNull Vector2 value2) {
        ShaderUniformsGL3.DefaultImpls.uniform((ShaderUniformsGL3)this, name, value2);
    }

    @Override
    public void uniform(@NotNull String name, @NotNull IntVector2 value2) {
        ShaderUniformsGL3.DefaultImpls.uniform((ShaderUniformsGL3)this, name, value2);
    }

    @Override
    public void uniform(@NotNull String name, @NotNull IntVector3 value2) {
        ShaderUniformsGL3.DefaultImpls.uniform((ShaderUniformsGL3)this, name, value2);
    }

    @Override
    public void uniform(@NotNull String name, @NotNull IntVector4 value2) {
        ShaderUniformsGL3.DefaultImpls.uniform((ShaderUniformsGL3)this, name, value2);
    }

    @Override
    public void uniform(@NotNull String name, @NotNull BooleanVector2 value2) {
        ShaderUniformsGL3.DefaultImpls.uniform((ShaderUniformsGL3)this, name, value2);
    }

    @Override
    public void uniform(@NotNull String name, @NotNull BooleanVector3 value2) {
        ShaderUniformsGL3.DefaultImpls.uniform((ShaderUniformsGL3)this, name, value2);
    }

    @Override
    public void uniform(@NotNull String name, @NotNull BooleanVector4 value2) {
        ShaderUniformsGL3.DefaultImpls.uniform((ShaderUniformsGL3)this, name, value2);
    }

    @Override
    public void uniform(@NotNull String name, float x, float y, float z, float w) {
        ShaderUniformsGL3.DefaultImpls.uniform(this, name, x, y, z, w);
    }

    @Override
    public void uniform(@NotNull String name, float x, float y, float z) {
        ShaderUniformsGL3.DefaultImpls.uniform(this, name, x, y, z);
    }

    @Override
    public void uniform(@NotNull String name, float x, float y) {
        ShaderUniformsGL3.DefaultImpls.uniform(this, name, x, y);
    }

    @Override
    public void uniform(@NotNull String name, double value2) {
        ShaderUniformsGL3.DefaultImpls.uniform((ShaderUniformsGL3)this, name, value2);
    }

    @Override
    public void uniform(@NotNull String name, float value2) {
        ShaderUniformsGL3.DefaultImpls.uniform((ShaderUniformsGL3)this, name, value2);
    }

    @Override
    public void uniform(@NotNull String name, int value2) {
        ShaderUniformsGL3.DefaultImpls.uniform((ShaderUniformsGL3)this, name, value2);
    }

    @Override
    public void uniform(@NotNull String name, boolean value2) {
        ShaderUniformsGL3.DefaultImpls.uniform((ShaderUniformsGL3)this, name, value2);
    }

    @Override
    public void uniform(@NotNull String name, @NotNull IntVector4[] value2) {
        ShaderUniformsGL3.DefaultImpls.uniform((ShaderUniformsGL3)this, name, value2);
    }

    @Override
    public void uniform(@NotNull String name, @NotNull IntVector3[] value2) {
        ShaderUniformsGL3.DefaultImpls.uniform((ShaderUniformsGL3)this, name, value2);
    }

    @Override
    public void uniform(@NotNull String name, @NotNull IntVector2[] value2) {
        ShaderUniformsGL3.DefaultImpls.uniform((ShaderUniformsGL3)this, name, value2);
    }

    @Override
    public void uniform(@NotNull String name, @NotNull Vector4[] value2) {
        ShaderUniformsGL3.DefaultImpls.uniform((ShaderUniformsGL3)this, name, value2);
    }

    @Override
    public void uniform(@NotNull String name, @NotNull Vector3[] value2) {
        ShaderUniformsGL3.DefaultImpls.uniform((ShaderUniformsGL3)this, name, value2);
    }

    @Override
    public void uniform(@NotNull String name, @NotNull Vector2[] value2) {
        ShaderUniformsGL3.DefaultImpls.uniform((ShaderUniformsGL3)this, name, value2);
    }

    @Override
    public void uniform(@NotNull String name, @NotNull float[] value2) {
        ShaderUniformsGL3.DefaultImpls.uniform((ShaderUniformsGL3)this, name, value2);
    }

    @Override
    public void uniform(@NotNull String name, @NotNull int[] value2) {
        ShaderUniformsGL3.DefaultImpls.uniform((ShaderUniformsGL3)this, name, value2);
    }

    @Override
    public void uniform(@NotNull String name, @NotNull ColorRGBa[] value2) {
        ShaderUniformsGL3.DefaultImpls.uniform((ShaderUniformsGL3)this, name, value2);
    }

    @Override
    public void uniform(@NotNull String name, @NotNull Double[] value2) {
        ShaderUniformsGL3.DefaultImpls.uniform((ShaderUniformsGL3)this, name, value2);
    }

    @Override
    public void uniform(@NotNull String name, @NotNull Matrix44[] value2) {
        ShaderUniformsGL3.DefaultImpls.uniform((ShaderUniformsGL3)this, name, value2);
    }

    @Override
    public void buffer(@NotNull String name, @NotNull VertexBuffer vertexBuffer) {
        ShaderBufferBindingsGL3.DefaultImpls.buffer((ShaderBufferBindingsGL3)this, name, vertexBuffer);
    }

    @Override
    public void buffer(@NotNull String name, @NotNull ShaderStorageBuffer shaderStorageBuffer) {
        ShaderBufferBindingsGL3.DefaultImpls.buffer((ShaderBufferBindingsGL3)this, name, shaderStorageBuffer);
    }

    @Override
    public void buffer(@NotNull String name, @NotNull AtomicCounterBuffer counterBuffer) {
        ShaderBufferBindingsGL3.DefaultImpls.buffer((ShaderBufferBindingsGL3)this, name, counterBuffer);
    }

    @Override
    public void bound(@NotNull Function0<Unit> f) {
        ShaderUniformsGL3.DefaultImpls.bound(this, f);
    }

    @Override
    public int uniformIndex(@NotNull String uniform, boolean query) {
        return ShaderUniformsGL3.DefaultImpls.uniformIndex(this, uniform, query);
    }

    @Override
    public int resourceIndex(@NotNull String name) {
        return ShaderBufferBindingsGL3.DefaultImpls.resourceIndex(this, name);
    }

    @Override
    public int createSSBO() {
        return ShaderBufferBindingsGL3.DefaultImpls.createSSBO(this);
    }

    private static final Object begin$lambda$11(ShaderGL3 this$0) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        return "shader begin " + this$0.getName();
    }

    private static final Object end$lambda$13(ShaderGL3 this$0) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        return "shader end " + this$0.getName();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003JF\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013\u00a8\u0006\u0014"}, d2={"Lorg/openrndr/internal/gl3/ShaderGL3$Companion;", "", "<init>", "()V", "create", "Lorg/openrndr/internal/gl3/ShaderGL3;", "vertexShader", "Lorg/openrndr/internal/gl3/VertexShaderGL3;", "tessellationControlShader", "Lorg/openrndr/internal/gl3/TessellationControlShaderGL3;", "tessellationEvaluationShader", "Lorg/openrndr/internal/gl3/TessellationEvaluationShaderGL3;", "geometryShader", "Lorg/openrndr/internal/gl3/GeometryShaderGL3;", "fragmentShader", "Lorg/openrndr/internal/gl3/FragmentShaderGL3;", "name", "", "session", "Lorg/openrndr/draw/Session;", "openrndr-gl3"})
    @SourceDebugExtension(value={"SMAP\nShaderGL3.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ShaderGL3.kt\norg/openrndr/internal/gl3/ShaderGL3$Companion\n+ 2 ErrorGL3.kt\norg/openrndr/internal/gl3/ErrorGL3Kt\n+ 3 ErrorGL3.kt\norg/openrndr/internal/gl3/ErrorGL3Kt$debugGLErrors$1\n+ 4 GLGLES.kt\norg/openrndr/internal/gl3/GLGLESKt\n*L\n1#1,380:1\n68#2,3:381\n52#2,13:384\n66#2,7:398\n68#2,3:405\n52#2,13:408\n66#2,7:422\n68#2,3:429\n52#2,13:432\n66#2,7:446\n68#2,3:453\n52#2,13:456\n66#2,7:470\n68#2,3:477\n52#2,13:480\n66#2,7:494\n68#2,3:501\n52#2,13:504\n66#2,7:518\n68#2,3:525\n52#2,13:528\n66#2,7:542\n68#2,3:549\n52#2,13:552\n66#2,7:566\n68#2,3:573\n52#2,13:576\n66#2,7:590\n68#3:397\n68#3:421\n68#3:445\n68#3:469\n68#3:493\n68#3:517\n68#3:541\n68#3:565\n68#3:589\n297#4,3:597\n*S KotlinDebug\n*F\n+ 1 ShaderGL3.kt\norg/openrndr/internal/gl3/ShaderGL3$Companion\n*L\n129#1:381,3\n129#1:384,13\n129#1:398,7\n132#1:405,3\n132#1:408,13\n132#1:422,7\n135#1:429,3\n135#1:432,13\n135#1:446,7\n139#1:453,3\n139#1:456,13\n139#1:470,7\n144#1:477,3\n144#1:480,13\n144#1:494,7\n149#1:501,3\n149#1:504,13\n149#1:518,7\n154#1:525,3\n154#1:528,13\n154#1:542,7\n157#1:549,3\n157#1:552,13\n157#1:566,7\n161#1:573,3\n161#1:576,13\n161#1:590,7\n129#1:397\n132#1:421\n135#1:445\n139#1:469\n144#1:493\n149#1:517\n154#1:541\n157#1:565\n161#1:589\n166#1:597,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public final ShaderGL3 create(@NotNull VertexShaderGL3 vertexShader, @Nullable TessellationControlShaderGL3 tessellationControlShader, @Nullable TessellationEvaluationShaderGL3 tessellationEvaluationShader, @Nullable GeometryShaderGL3 geometryShader, @NotNull FragmentShaderGL3 fragmentShader, @NotNull String name, @Nullable Session session) {
            Intrinsics.checkNotNullParameter(vertexShader, "vertexShader");
            Intrinsics.checkNotNullParameter(fragmentShader, "fragmentShader");
            Intrinsics.checkNotNullParameter(name, "name");
            Driver driver = Driver.Companion.getInstance();
            synchronized (driver) {
                int it;
                int error$iv$iv;
                boolean $i$f$checkGLErrors;
                boolean $i$f$debugGLErrors;
                int error$iv$iv2;
                boolean $i$f$checkGLErrors2;
                boolean bl = false;
                boolean $i$f$debugGLErrors2 = false;
                if (DriverGL3Configuration.INSTANCE.getUseDebugContext()) {
                    boolean $i$f$checkGLErrors3 = false;
                    int error$iv$iv3 = GLGLESKt.glGetError();
                    if (error$iv$iv3 != 0) {
                        Object message$iv$iv = switch (error$iv$iv3) {
                            case 1282 -> "GL_INVALID_OPERATION";
                            case 1281 -> "GL_INVALID_VALUE";
                            case 1280 -> "GL_INVALID_ENUM";
                            case 1286 -> "GL_INVALID_FRAMEBUFFER_OPERATION";
                            case 1285 -> "GL_OUT_OF_MEMORY";
                            case 1284 -> "GL_STACK_UNDERFLOW";
                            case 1283 -> "GL_STACK_OVERFLOW";
                            default -> "<untranslated: " + error$iv$iv3 + ">";
                        };
                        int n = error$iv$iv3;
                        Object object = message$iv$iv;
                        long l = Driver.Companion.getInstance().getContextID();
                        boolean bl2 = false;
                        int it2 = n;
                        Object var19_44 = null;
                        String string = "[context=" + l + "] GL ERROR: " + (String)object + " " + var19_44;
                        throw new GL3Exception(string);
                    }
                }
                int program2 = GLGLESKt.glCreateProgram();
                boolean $i$f$debugGLErrors3 = false;
                if (DriverGL3Configuration.INSTANCE.getUseDebugContext()) {
                    $i$f$checkGLErrors2 = false;
                    error$iv$iv2 = GLGLESKt.glGetError();
                    if (error$iv$iv2 != 0) {
                        Object message$iv$iv = switch (error$iv$iv2) {
                            case 1282 -> "GL_INVALID_OPERATION";
                            case 1281 -> "GL_INVALID_VALUE";
                            case 1280 -> "GL_INVALID_ENUM";
                            case 1286 -> "GL_INVALID_FRAMEBUFFER_OPERATION";
                            case 1285 -> "GL_OUT_OF_MEMORY";
                            case 1284 -> "GL_STACK_UNDERFLOW";
                            case 1283 -> "GL_STACK_OVERFLOW";
                            default -> "<untranslated: " + error$iv$iv2 + ">";
                        };
                        int bl2 = error$iv$iv2;
                        Object object = message$iv$iv;
                        long l = Driver.Companion.getInstance().getContextID();
                        boolean $i$a$-debugGLErrors-ErrorGL3Kt$debugGLErrors$2 = false;
                        int it3 = bl2;
                        Object var19_45 = null;
                        String string = "[context=" + l + "] GL ERROR: " + (String)object + " " + var19_45;
                        throw new GL3Exception(string);
                    }
                }
                GLGLESKt.glAttachShader(program2, vertexShader.getShaderObject());
                $i$f$debugGLErrors3 = false;
                if (DriverGL3Configuration.INSTANCE.getUseDebugContext()) {
                    $i$f$checkGLErrors2 = false;
                    error$iv$iv2 = GLGLESKt.glGetError();
                    if (error$iv$iv2 != 0) {
                        Object message$iv$iv = switch (error$iv$iv2) {
                            case 1282 -> "GL_INVALID_OPERATION";
                            case 1281 -> "GL_INVALID_VALUE";
                            case 1280 -> "GL_INVALID_ENUM";
                            case 1286 -> "GL_INVALID_FRAMEBUFFER_OPERATION";
                            case 1285 -> "GL_OUT_OF_MEMORY";
                            case 1284 -> "GL_STACK_UNDERFLOW";
                            case 1283 -> "GL_STACK_OVERFLOW";
                            default -> "<untranslated: " + error$iv$iv2 + ">";
                        };
                        int it3 = error$iv$iv2;
                        Object object = message$iv$iv;
                        long l = Driver.Companion.getInstance().getContextID();
                        boolean $i$a$-debugGLErrors-ErrorGL3Kt$debugGLErrors$3 = false;
                        Object var19_46 = null;
                        String string = "[context=" + l + "] GL ERROR: " + (String)object + " " + var19_46;
                        throw new GL3Exception(string);
                    }
                }
                TessellationControlShaderGL3 tessellationControlShaderGL3 = tessellationControlShader;
                if (tessellationControlShaderGL3 != null) {
                    TessellationControlShaderGL3 it4 = tessellationControlShaderGL3;
                    boolean bl3 = false;
                    GLGLESKt.glAttachShader(program2, it4.getShaderObject());
                    $i$f$debugGLErrors = false;
                    if (DriverGL3Configuration.INSTANCE.getUseDebugContext()) {
                        $i$f$checkGLErrors = false;
                        error$iv$iv = GLGLESKt.glGetError();
                        if (error$iv$iv != 0) {
                            Object message$iv$iv = switch (error$iv$iv) {
                                case 1282 -> "GL_INVALID_OPERATION";
                                case 1281 -> "GL_INVALID_VALUE";
                                case 1280 -> "GL_INVALID_ENUM";
                                case 1286 -> "GL_INVALID_FRAMEBUFFER_OPERATION";
                                case 1285 -> "GL_OUT_OF_MEMORY";
                                case 1284 -> "GL_STACK_UNDERFLOW";
                                case 1283 -> "GL_STACK_OVERFLOW";
                                default -> "<untranslated: " + error$iv$iv + ">";
                            };
                            int n = error$iv$iv;
                            Object object = message$iv$iv;
                            long l = Driver.Companion.getInstance().getContextID();
                            boolean bl4 = false;
                            int it5 = n;
                            Object var27_75 = null;
                            String string = "[context=" + l + "] GL ERROR: " + (String)object + " " + var27_75;
                            throw new GL3Exception(string);
                        }
                    }
                }
                TessellationEvaluationShaderGL3 tessellationEvaluationShaderGL3 = tessellationEvaluationShader;
                if (tessellationEvaluationShaderGL3 != null) {
                    TessellationEvaluationShaderGL3 it6 = tessellationEvaluationShaderGL3;
                    boolean bl5 = false;
                    GLGLESKt.glAttachShader(program2, it6.getShaderObject());
                    $i$f$debugGLErrors = false;
                    if (DriverGL3Configuration.INSTANCE.getUseDebugContext()) {
                        $i$f$checkGLErrors = false;
                        error$iv$iv = GLGLESKt.glGetError();
                        if (error$iv$iv != 0) {
                            Object message$iv$iv = switch (error$iv$iv) {
                                case 1282 -> "GL_INVALID_OPERATION";
                                case 1281 -> "GL_INVALID_VALUE";
                                case 1280 -> "GL_INVALID_ENUM";
                                case 1286 -> "GL_INVALID_FRAMEBUFFER_OPERATION";
                                case 1285 -> "GL_OUT_OF_MEMORY";
                                case 1284 -> "GL_STACK_UNDERFLOW";
                                case 1283 -> "GL_STACK_OVERFLOW";
                                default -> "<untranslated: " + error$iv$iv + ">";
                            };
                            int it5 = error$iv$iv;
                            Object object = message$iv$iv;
                            long l = Driver.Companion.getInstance().getContextID();
                            boolean bl6 = false;
                            Object var27_76 = null;
                            String string = "[context=" + l + "] GL ERROR: " + (String)object + " " + var27_76;
                            throw new GL3Exception(string);
                        }
                    }
                }
                GeometryShaderGL3 geometryShaderGL3 = geometryShader;
                if (geometryShaderGL3 != null) {
                    GeometryShaderGL3 it7 = geometryShaderGL3;
                    boolean bl7 = false;
                    GLGLESKt.glAttachShader(program2, it7.getShaderObject());
                    $i$f$debugGLErrors = false;
                    if (DriverGL3Configuration.INSTANCE.getUseDebugContext()) {
                        $i$f$checkGLErrors = false;
                        error$iv$iv = GLGLESKt.glGetError();
                        if (error$iv$iv != 0) {
                            Object message$iv$iv = switch (error$iv$iv) {
                                case 1282 -> "GL_INVALID_OPERATION";
                                case 1281 -> "GL_INVALID_VALUE";
                                case 1280 -> "GL_INVALID_ENUM";
                                case 1286 -> "GL_INVALID_FRAMEBUFFER_OPERATION";
                                case 1285 -> "GL_OUT_OF_MEMORY";
                                case 1284 -> "GL_STACK_UNDERFLOW";
                                case 1283 -> "GL_STACK_OVERFLOW";
                                default -> "<untranslated: " + error$iv$iv + ">";
                            };
                            int it8 = error$iv$iv;
                            Object object = message$iv$iv;
                            long l = Driver.Companion.getInstance().getContextID();
                            boolean bl8 = false;
                            Object var27_77 = null;
                            String string = "[context=" + l + "] GL ERROR: " + (String)object + " " + var27_77;
                            throw new GL3Exception(string);
                        }
                    }
                }
                GLGLESKt.glAttachShader(program2, fragmentShader.getShaderObject());
                $i$f$debugGLErrors = false;
                if (DriverGL3Configuration.INSTANCE.getUseDebugContext()) {
                    $i$f$checkGLErrors2 = false;
                    error$iv$iv2 = GLGLESKt.glGetError();
                    if (error$iv$iv2 != 0) {
                        Object message$iv$iv = switch (error$iv$iv2) {
                            case 1282 -> "GL_INVALID_OPERATION";
                            case 1281 -> "GL_INVALID_VALUE";
                            case 1280 -> "GL_INVALID_ENUM";
                            case 1286 -> "GL_INVALID_FRAMEBUFFER_OPERATION";
                            case 1285 -> "GL_OUT_OF_MEMORY";
                            case 1284 -> "GL_STACK_UNDERFLOW";
                            case 1283 -> "GL_STACK_OVERFLOW";
                            default -> "<untranslated: " + error$iv$iv2 + ">";
                        };
                        error$iv$iv = error$iv$iv2;
                        Object object = message$iv$iv;
                        long l = Driver.Companion.getInstance().getContextID();
                        boolean bl9 = false;
                        it = error$iv$iv;
                        Object var19_47 = null;
                        String string = "[context=" + l + "] GL ERROR: " + (String)object + " " + var19_47;
                        throw new GL3Exception(string);
                    }
                }
                GLGLESKt.glLinkProgram(program2);
                $i$f$debugGLErrors = false;
                if (DriverGL3Configuration.INSTANCE.getUseDebugContext()) {
                    $i$f$checkGLErrors2 = false;
                    error$iv$iv2 = GLGLESKt.glGetError();
                    if (error$iv$iv2 != 0) {
                        Object message$iv$iv = switch (error$iv$iv2) {
                            case 1282 -> "GL_INVALID_OPERATION";
                            case 1281 -> "GL_INVALID_VALUE";
                            case 1280 -> "GL_INVALID_ENUM";
                            case 1286 -> "GL_INVALID_FRAMEBUFFER_OPERATION";
                            case 1285 -> "GL_OUT_OF_MEMORY";
                            case 1284 -> "GL_STACK_UNDERFLOW";
                            case 1283 -> "GL_STACK_OVERFLOW";
                            default -> "<untranslated: " + error$iv$iv2 + ">";
                        };
                        it = error$iv$iv2;
                        Object object = message$iv$iv;
                        long l = Driver.Companion.getInstance().getContextID();
                        boolean bl10 = false;
                        Object var19_48 = null;
                        String string = "[context=" + l + "] GL ERROR: " + (String)object + " " + var19_48;
                        throw new GL3Exception(string);
                    }
                }
                int[] linkStatus = new int[1];
                GLGLESKt.glGetProgramiv(program2, 35714, linkStatus);
                boolean $i$f$debugGLErrors4 = false;
                if (DriverGL3Configuration.INSTANCE.getUseDebugContext()) {
                    boolean $i$f$checkGLErrors4 = false;
                    int error$iv$iv4 = GLGLESKt.glGetError();
                    if (error$iv$iv4 != 0) {
                        Object message$iv$iv = switch (error$iv$iv4) {
                            case 1282 -> "GL_INVALID_OPERATION";
                            case 1281 -> "GL_INVALID_VALUE";
                            case 1280 -> "GL_INVALID_ENUM";
                            case 1286 -> "GL_INVALID_FRAMEBUFFER_OPERATION";
                            case 1285 -> "GL_OUT_OF_MEMORY";
                            case 1284 -> "GL_STACK_UNDERFLOW";
                            case 1283 -> "GL_STACK_OVERFLOW";
                            default -> "<untranslated: " + error$iv$iv4 + ">";
                        };
                        int bl10 = error$iv$iv4;
                        Object object = message$iv$iv;
                        long l = Driver.Companion.getInstance().getContextID();
                        boolean $i$a$-debugGLErrors-ErrorGL3Kt$debugGLErrors$4 = false;
                        int it9 = bl10;
                        Object var19_49 = null;
                        String string = "[context=" + l + "] GL ERROR: " + (String)object + " " + var19_49;
                        throw new GL3Exception(string);
                    }
                }
                if (linkStatus[0] != 1) {
                    ShaderGL3Kt.checkProgramInfoLog(program2, "noname");
                }
                boolean $i$f$glFinish = false;
                switch (GLGLESKt.WhenMappings.$EnumSwitchMapping$0[GLGLESKt.getDriverType().ordinal()]) {
                    case 1: {
                        GL45C.glFinish();
                        break;
                    }
                    case 2: {
                        GLES32.glFinish();
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                ShaderGL3 shaderGL3 = new ShaderGL3(program2, name, vertexShader, tessellationControlShader, tessellationEvaluationShader, geometryShader, fragmentShader, session);
                return shaderGL3;
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

