/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.internal.gl3;

import io.github.oshai.kotlinlogging.KLogger;
import io.github.oshai.kotlinlogging.KotlinLogging;
import java.io.Closeable;
import java.io.File;
import java.io.FileWriter;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.time.LocalDateTime;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL33C;
import org.openrndr.draw.UniformType;
import org.openrndr.internal.gl3.GLGLESKt;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u001a \u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0000\u001a\u0016\u0010\t\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u0007\u001a\f\u0010\n\u001a\u00020\u000b*\u00020\u0005H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"logger", "Lio/github/oshai/kotlinlogging/KLogger;", "checkShaderInfoLog", "", "object", "", "code", "", "sourceFile", "checkProgramInfoLog", "toUniformType", "Lorg/openrndr/draw/UniformType;", "openrndr-gl3"})
public final class ShaderGL3Kt {
    @NotNull
    private static final KLogger logger = KotlinLogging.INSTANCE.logger(ShaderGL3Kt::logger$lambda$0);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void checkShaderInfoLog(int object, @NotNull String code, @NotNull String sourceFile) {
        Intrinsics.checkNotNullParameter(code, "code");
        Intrinsics.checkNotNullParameter(sourceFile, "sourceFile");
        logger.debug(ShaderGL3Kt::checkShaderInfoLog$lambda$1);
        int[] logLength = new int[1];
        GLGLESKt.glGetShaderiv(object, 35716, logLength);
        logger.debug(() -> ShaderGL3Kt.checkShaderInfoLog$lambda$2(logLength));
        if (logLength[0] > 0) {
            logger.debug(ShaderGL3Kt::checkShaderInfoLog$lambda$3);
            ByteBuffer infoLog = BufferUtils.createByteBuffer(logLength[0]);
            Intrinsics.checkNotNull(infoLog, "null cannot be cast to non-null type java.nio.Buffer");
            ((Buffer)infoLog).rewind();
            GLGLESKt.glGetShaderInfoLog(object, logLength, infoLog);
            byte[] infoBytes = new byte[logLength[0]];
            Regex errorLinePattern = new Regex("\\d+[:(](\\d+)[ 0-9()]*?:");
            infoLog.get(infoBytes);
            String infoString = new String(infoBytes, Charsets.UTF_8);
            System.out.println((Object)("GLSL compilation problems in\n " + infoString));
            MatchResult errorLineMatches = Regex.find$default(errorLinePattern, infoString, 0, 2, null);
            Integer n = errorLineMatches != null ? StringsKt.toIntOrNull(errorLineMatches.getGroupValues().get(1)) : Integer.valueOf(1);
            int firstErrorLine = n != null ? n : 1;
            File errorLogFile = new File("ShaderError.glsl");
            if (errorLogFile.exists()) {
                if (!errorLogFile.canWrite()) {
                    errorLogFile.setWritable(true);
                }
                errorLogFile.delete();
            }
            Closeable closeable = new FileWriter(errorLogFile);
            Throwable throwable = null;
            try {
                FileWriter it = (FileWriter)closeable;
                boolean bl = false;
                it.write(code);
                it.write("// -------------\n");
                it.write("// " + sourceFile + "\n");
                it.write("// created " + LocalDateTime.now() + "\n");
                it.write("/*\n");
                it.write(infoString);
                it.write("*/\n");
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally(closeable, throwable);
            }
            errorLogFile.setReadOnly();
            System.err.println("click.to.see.shader.code(ShaderError.glsl:" + firstErrorLine + ")");
            logger.error(() -> ShaderGL3Kt.checkShaderInfoLog$lambda$5(sourceFile));
            throw new Exception("Shader error: " + sourceFile);
        }
    }

    public static final void checkProgramInfoLog(int object, @NotNull String sourceFile) {
        Intrinsics.checkNotNullParameter(sourceFile, "sourceFile");
        int[] logLength = new int[1];
        GLGLESKt.glGetProgramiv(object, 35716, logLength);
        if (logLength[0] > 1) {
            ByteBuffer infoLog = BufferUtils.createByteBuffer(logLength[0]);
            GL33C.glGetProgramInfoLog(object, logLength, infoLog);
            byte[] linkInfoBytes = new byte[logLength[0]];
            infoLog.get(linkInfoBytes);
            String string = "GLSL link problems in\n " + new String(linkInfoBytes, Charsets.UTF_8);
            System.out.println((Object)string);
            logger.warn(() -> ShaderGL3Kt.checkProgramInfoLog$lambda$6(logLength, infoLog));
            throw new Exception("Shader error: " + sourceFile);
        }
    }

    private static final UniformType toUniformType(int $this$toUniformType) {
        return switch ($this$toUniformType) {
            case 5126 -> UniformType.FLOAT32;
            case 35664 -> UniformType.VECTOR2_FLOAT32;
            case 35665 -> UniformType.VECTOR3_FLOAT32;
            case 35666 -> UniformType.VECTOR4_FLOAT32;
            case 5124 -> UniformType.INT32;
            case 35667 -> UniformType.VECTOR2_INT32;
            case 35668 -> UniformType.VECTOR3_INT32;
            case 35669 -> UniformType.VECTOR4_INT32;
            case 35676 -> UniformType.MATRIX44_FLOAT32;
            case 35675 -> UniformType.MATRIX33_FLOAT32;
            case 35674 -> UniformType.MATRIX22_FLOAT32;
            default -> throw new RuntimeException("unsupported uniform type " + $this$toUniformType);
        };
    }

    private static final Unit logger$lambda$0() {
        return Unit.INSTANCE;
    }

    private static final Object checkShaderInfoLog$lambda$1() {
        return "getting shader info log";
    }

    private static final Object checkShaderInfoLog$lambda$2(int[] $logLength) {
        Intrinsics.checkNotNullParameter($logLength, "$logLength");
        return "log length: " + $logLength[0];
    }

    private static final Object checkShaderInfoLog$lambda$3() {
        return "getting log";
    }

    private static final Object checkShaderInfoLog$lambda$5(String $sourceFile) {
        Intrinsics.checkNotNullParameter($sourceFile, "$sourceFile");
        return "GLSL shader compilation failed for " + $sourceFile;
    }

    private static final Object checkProgramInfoLog$lambda$6(int[] $logLength, ByteBuffer $infoLog) {
        Intrinsics.checkNotNullParameter($logLength, "$logLength");
        byte[] infoBytes = new byte[$logLength[0]];
        $infoLog.get(infoBytes);
        return "GLSL link problems in\n " + new String(infoBytes, Charsets.UTF_8);
    }

    public static final /* synthetic */ KLogger access$getLogger$p() {
        return logger;
    }

    public static final /* synthetic */ UniformType access$toUniformType(int $receiver) {
        return ShaderGL3Kt.toUniformType($receiver);
    }
}

